/*
 * Decompiled with CFR 0.152.
 */
package coins.ssa;

import coins.backend.Function;
import coins.backend.ana.LiveVariableAnalysis;
import coins.backend.ana.LiveVariableSlotwise;
import coins.backend.cfg.BasicBlk;
import coins.backend.lir.LirNode;
import coins.backend.lir.LirSymRef;
import coins.backend.sym.Symbol;
import coins.backend.util.BiLink;
import coins.backend.util.BiList;
import coins.ssa.SsaEnvironment;
import coins.ssa.Util;
import java.util.Stack;

class AggregateInstructions {
    private SsaEnvironment env;
    private Util util;
    public static final int THR = 2000;
    private Function f;

    AggregateInstructions(SsaEnvironment e, Function func) {
        this.env = e;
        this.f = func;
        this.util = new Util(this.env, this.f);
        BiLink p = this.f.flowGraph().basicBlkList.first();
        while (!p.atEnd()) {
            BasicBlk blk = (BasicBlk)p.elem();
            LiveVariableAnalysis liveAna = (LiveVariableAnalysis)this.f.require(LiveVariableSlotwise.analyzer);
            BiList removeList = new BiList();
            BiLink q = blk.instrList().first();
            while (!q.atEnd()) {
                BiList mem;
                LirNode node = (LirNode)q.elem();
                if (node.opCode == 48 && node.kid((int)0).opCode == 6 && !liveAna.isLiveAtExit(((LirSymRef)node.kid((int)0)).symbol, blk) && this.search(q, (mem = this.util.findTargetLir(node.kid(1), 47, new BiList())).length() != 0)) {
                    removeList.add(q);
                }
                q = q.next();
            }
            q = removeList.first();
            while (!q.atEnd()) {
                BiLink link = (BiLink)q.elem();
                this.env.println("AGGI : remove " + link.elem(), 2000);
                link.unlink();
                q = q.next();
            }
            this.f.touch();
            p = p.next();
        }
    }

    private boolean search(BiLink root, boolean withMem) {
        Symbol s = ((LirSymRef)((LirNode)root.elem()).kid((int)0)).symbol;
        BiList candidate = new BiList();
        BiLink p = root.next();
        while (!p.atEnd()) {
            LirNode node = (LirNode)p.elem();
            BiList list = this.util.findTargetLir(node, 6, new BiList());
            BiLink q = list.first();
            while (!q.atEnd()) {
                LirSymRef reg = (LirSymRef)q.elem();
                if (reg.symbol == s) {
                    candidate.add(node);
                }
                q = q.next();
            }
            p = p.next();
        }
        if (candidate.length() == 1) {
            LirNode node = (LirNode)candidate.first().elem();
            if (withMem && node.opCode == 53) {
                BiList list = this.util.findTargetLir(node.kid(2), 47, new BiList());
                BiLink p2 = list.first();
                while (!p2.atEnd()) {
                    LirNode mem = (LirNode)p2.elem();
                    BiList list2 = this.util.findTargetLir(mem, 6, new BiList());
                    BiLink q = list2.first();
                    while (!q.atEnd()) {
                        LirNode reg = (LirNode)q.elem();
                        if (((LirSymRef)reg).symbol == s) {
                            return false;
                        }
                        q = q.next();
                    }
                    p2 = p2.next();
                }
            }
            if (withMem) {
                LirNode n;
                BiLink p3 = root.next();
                while (!p3.atEnd() && !(n = (LirNode)p3.elem()).equals(node)) {
                    switch (n.opCode) {
                        case 53: {
                            return false;
                        }
                        case 48: {
                            if (n.kid((int)0).opCode == 6) break;
                            return false;
                        }
                    }
                    p3 = p3.next();
                }
            }
            this.env.println("AGGI : put " + root.elem() + " into " + node, 2000);
            this.replace((LirNode)root.elem(), node);
            return true;
        }
        return false;
    }

    private void replace(LirNode src, LirNode dst) {
        Symbol s = ((LirSymRef)src.kid((int)0)).symbol;
        Stack<LirNode> stack = new Stack<LirNode>();
        stack.push(dst);
        block0: while (!stack.empty()) {
            LirNode node = (LirNode)stack.pop();
            for (int i = 0; i < node.nKids(); ++i) {
                if (node.kid((int)i).opCode == 6 && ((LirSymRef)node.kid((int)i)).symbol == s) {
                    node.setKid(i, src.kid(1).makeCopy(this.env.lir));
                    stack.clear();
                    continue block0;
                }
                stack.push(node.kid(i));
            }
        }
    }
}

