/*
 * Decompiled with CFR 0.152.
 */
package coins.ssa;

import coins.backend.Data;
import coins.backend.Function;
import coins.backend.LocalTransformer;
import coins.backend.ana.Dominators;
import coins.backend.cfg.BasicBlk;
import coins.backend.lir.LirNode;
import coins.backend.lir.LirSymRef;
import coins.backend.sym.Symbol;
import coins.backend.util.BiLink;
import coins.backend.util.BiList;
import coins.backend.util.ImList;
import coins.ssa.MemoryAliasAnalyze;
import coins.ssa.SsaEnvironment;
import coins.ssa.Util;
import java.util.Hashtable;
import java.util.Stack;

class CommonSubexpressionElimination
implements LocalTransformer {
    private SsaEnvironment env;
    public static final int THR = 2000;
    private Util util;
    private Dominators dom;
    private BiList expList;
    private BiList phiList;
    private Hashtable expMap;
    private Hashtable copyMap;
    private Function f;
    private boolean withMem;

    public boolean doIt(Data data, ImList args) {
        return true;
    }

    public String name() {
        return "CommonSubexpressionElimination";
    }

    public String subject() {
        return "Common subexpression elimination on SSA form.";
    }

    public CommonSubexpressionElimination(SsaEnvironment e) {
        this.env = e;
        boolean bl = this.withMem = !this.env.opt.isSet("ssa-no-memory-analysis");
        if (this.withMem) {
            this.env.println("  Common Subexpression Elimination With Memory on SSA form", 100);
        } else {
            this.env.println("  Common Subexpression Elimination Without Memory on SSA form", 100);
        }
    }

    public boolean doIt(Function function, ImList args) {
        MemoryAliasAnalyze alias = null;
        if (this.withMem) {
            this.env.println("****************** doing CSE with memory to " + function.symbol.name, 1000);
            alias = new MemoryAliasAnalyze(this.env, function);
        } else {
            this.env.println("****************** doing CSE without memory to " + function.symbol.name, 1000);
        }
        this.phiList = new BiList();
        this.expList = new BiList();
        this.expMap = new Hashtable();
        this.copyMap = new Hashtable();
        this.dom = (Dominators)function.require(Dominators.analyzer);
        this.f = function;
        this.util = new Util(this.env, this.f);
        this.cse(this.f.flowGraph().entryBlk());
        if (this.withMem) {
            alias.annul();
        }
        this.env.println("", 2000);
        return true;
    }

    private void cse(BasicBlk blk) {
        BiLink expSplit = this.expList.last();
        BiLink phiSplit = this.phiList.last();
        BiLink p = blk.instrList().first();
        while (!p.atEnd()) {
            LirNode node = (LirNode)p.elem();
            switch (node.opCode) {
                case 59: {
                    boolean contain = false;
                    BiLink q = this.phiList.first();
                    while (!q.atEnd()) {
                        LirNode phiNode = (LirNode)q.elem();
                        if (phiNode.nKids() == node.nKids()) {
                            contain = true;
                            for (int i = 1; i < phiNode.nKids(); ++i) {
                                if (node.kid(i).equals(phiNode.kid(i))) continue;
                                contain = false;
                                break;
                            }
                            if (contain) {
                                Symbol dst = ((LirSymRef)node.kid((int)0)).symbol;
                                Symbol ss = ((LirSymRef)phiNode.kid((int)0)).symbol;
                                this.env.println("CSE : replace phi node into copy assign ---> " + node + " in block " + blk.id, 2000);
                                this.setCopyIntoMap(dst, ss, blk, p);
                                break;
                            }
                        }
                        q = q.next();
                    }
                    if (!contain) {
                        contain = true;
                        LirNode replesent = null;
                        for (int i = 1; i < node.nKids(); ++i) {
                            if (replesent == null) {
                                replesent = node.kid(i).kid(0);
                                continue;
                            }
                            if (replesent.equals(node.kid(i).kid(0))) continue;
                            contain = false;
                            break;
                        }
                        if (contain) {
                            if (replesent.opCode == 6) {
                                Symbol dst = ((LirSymRef)node.kid((int)0)).symbol;
                                Symbol ss = ((LirSymRef)replesent).symbol;
                                this.env.println("CSE : replace phi node into copy assign ---> " + node + " in block " + blk.id, 2000);
                                this.setCopyIntoMap(dst, ss, blk, p);
                                break;
                            }
                            if (replesent.opCode == 2 || replesent.opCode == 3) {
                                LirNode dst = node.kid(0).makeCopy(this.env.lir);
                                LirNode src = replesent.makeCopy(this.env.lir);
                                LirNode assignOp = this.env.lir.operator(48, dst.type, dst, src, ImList.Empty);
                                BiLink q2 = blk.instrList().first();
                                while (!q2.atEnd()) {
                                    LirNode n = (LirNode)q2.elem();
                                    if (n.opCode != 59) {
                                        q2.addBefore(assignOp);
                                        p.unlink();
                                        this.env.println("CSE : replace phi node into assign constant ---> " + node + " in block " + blk.id, 2000);
                                        break;
                                    }
                                    q2 = q2.next();
                                }
                            }
                        }
                    }
                    if (contain) break;
                    this.phiList.add(node);
                    break;
                }
                case 48: {
                    BiList list;
                    this.replaceCopiedSymbol(node, blk);
                    this.replaceExpIntoSym(node, blk);
                    if (node.kid((int)0).opCode == 6 && node.kid((int)1).opCode == 6) {
                        Symbol dst = ((LirSymRef)node.kid((int)0)).symbol;
                        Symbol src = ((LirSymRef)node.kid((int)1)).symbol;
                        this.setCopyIntoMap(dst, src, blk, p);
                        break;
                    }
                    if (node.kid((int)0).opCode != 6 || node.kid((int)1).opCode == 2 || node.kid((int)1).opCode == 3 || node.kid((int)1).opCode == 6 || node.kid((int)1).opCode == 57 || node.kid((int)1).opCode == 58 || (list = this.util.findTargetLir(node.kid(1), 47, new BiList())).length() != 0 && !this.withMem) break;
                    Symbol dst = ((LirSymRef)node.kid((int)0)).symbol;
                    this.expList.add(node.kid(1));
                    this.expMap.put(node.kid(1), dst);
                    this.env.println("CSE : put " + dst + " = " + node.kid(1) + " into the map", 2000);
                    break;
                }
                case 53: {
                    this.replaceCopiedSymbol(node, blk);
                    this.replaceExpIntoSym(node.kid(1), blk);
                    break;
                }
                default: {
                    this.replaceCopiedSymbol(node, blk);
                    this.replaceExpIntoSym(node, blk);
                }
            }
            p = p.next();
        }
        p = blk.succList().first();
        while (!p.atEnd()) {
            BasicBlk succ = (BasicBlk)p.elem();
            BiLink q = succ.instrList().first();
            while (!q.atEnd()) {
                LirNode succNode = (LirNode)q.elem();
                if (succNode.opCode != 59) break;
                this.replaceCopiedSymbol(succNode, succ);
                q = q.next();
            }
            p = p.next();
        }
        p = this.dom.kids[blk.id].first();
        while (!p.atEnd()) {
            this.cse((BasicBlk)p.elem());
            p = p.next();
        }
        if (!expSplit.atEnd()) {
            this.expList.split(expSplit.next());
        } else {
            this.expList.clear();
        }
        if (!phiSplit.atEnd()) {
            this.phiList.split(phiSplit.next());
        } else {
            this.phiList.clear();
        }
    }

    private void setCopyIntoMap(Symbol dst, Symbol src, BasicBlk blk, BiLink p) {
        Symbol s;
        if (dst == src) {
            return;
        }
        while ((s = (Symbol)this.copyMap.get(src)) != null) {
            src = s;
        }
        this.copyMap.put(dst, src);
        p.unlink();
        this.f.flowGraph().touch();
        this.env.println("CSE : remove copy assign ---> " + dst + " = " + src + " in block " + blk.id, 2000);
    }

    private void replaceCopiedSymbol(LirNode node, BasicBlk blk) {
        Stack<LirNode> stack = new Stack<LirNode>();
        stack.push(node);
        while (!stack.empty()) {
            LirNode n = (LirNode)stack.pop();
            for (int i = 0; i < n.nKids(); ++i) {
                if (n.kid((int)i).opCode == 6) {
                    Symbol s = (Symbol)this.copyMap.get(((LirSymRef)n.kid((int)i)).symbol);
                    if (s == null) continue;
                    this.env.println("CSE : replace symbol " + ((LirSymRef)n.kid((int)i)).symbol + " --> " + s + " in block " + blk.id, 2000);
                    LirNode newReg = this.env.lir.symRef(6, n.kid((int)i).type, s, ImList.Empty);
                    n.setKid(i, newReg);
                    this.f.flowGraph().touch();
                    continue;
                }
                stack.push(n.kid(i));
            }
        }
    }

    private void replaceExpIntoSym(LirNode node, BasicBlk blk) {
        Stack<LirNode> stack = new Stack<LirNode>();
        stack.push(node);
        while (!stack.empty()) {
            LirNode tempNode = (LirNode)stack.pop();
            for (int i = 0; i < tempNode.nKids(); ++i) {
                boolean match = false;
                BiLink p = this.expList.first();
                while (!p.atEnd()) {
                    LirNode listElem = (LirNode)p.elem();
                    if (tempNode.kid(i).equals(listElem)) {
                        Symbol s = (Symbol)this.expMap.get(listElem);
                        this.env.print("CSE : reconstruct the expression " + node + " ---> ", 2000);
                        LirNode newReg = this.env.lir.symRef(6, listElem.type, s, ImList.Empty);
                        tempNode.setKid(i, newReg);
                        this.env.println(node + " in block " + blk.id, 2000);
                        match = true;
                        break;
                    }
                    p = p.next();
                }
                if (match) continue;
                stack.push(tempNode.kid(i));
            }
        }
    }
}

