/*
 * Decompiled with CFR 0.152.
 */
package coins.ssa;

import coins.backend.Data;
import coins.backend.Function;
import coins.backend.LocalTransformer;
import coins.backend.ana.DFST;
import coins.backend.ana.Dominators;
import coins.backend.ana.Postdominators;
import coins.backend.cfg.BasicBlk;
import coins.backend.lir.LirFconst;
import coins.backend.lir.LirIconst;
import coins.backend.lir.LirLabelRef;
import coins.backend.lir.LirNode;
import coins.backend.lir.LirSymRef;
import coins.backend.sym.Symbol;
import coins.backend.util.BiLink;
import coins.backend.util.BiList;
import coins.backend.util.ImList;
import coins.ssa.CopyPropagation;
import coins.ssa.DDCopyPropagation;
import coins.ssa.MemoryAliasAnalyze;
import coins.ssa.RankTable;
import coins.ssa.SsaEnvironment;
import coins.ssa.SsaSymTab;
import coins.ssa.Util;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;

public class PREQP
implements LocalTransformer {
    private boolean debugFlag;
    private int mode;
    private Util util;
    private String tmpSymName = "_preqp";
    public static final int THR = 2000;
    public static final int THR2 = 10000;
    private SsaEnvironment env;
    private SsaSymTab sstab;
    private Function f;
    private LirNode[] pVisited;
    private Stack stack;
    int[] rank;
    private Hashtable insertCpy;
    private Hashtable insert_out;
    private Hashtable insert_in;
    private BiList initVariables;
    StackElem unavailVar = new StackElem();
    private Dominators dom;
    private Postdominators pDom;
    private DFST dfst;
    private DDCopyPropagation cpy;
    private CopyPropagation cpyp;
    private Vector[] rankArray;
    Hashtable occurMap;
    Hashtable modMap;
    Hashtable phiMap;
    Hashtable rPhiMap;
    private Hashtable antMap;
    private Hashtable availMap;
    private Symbol invalidSym;
    private Hashtable cpMap;
    private Hashtable rCpMap;
    private boolean isHoistable = true;
    MemoryAliasAnalyze alias;
    Vector[] vPreds;
    Vector[] vSuccs;
    BasicBlk[] vParent;
    int[] rankCheckTarget;
    Vector backEdges;
    private Vector[] loopUpEdges;
    private Vector[] generators;
    private BasicBlk[] loopParent;
    BasicBlk[] vec;
    char[] loopKind;
    RankTable expRankMap;
    RankTable modRankMap;
    RankTable phiRankMap;
    int rankSize = 0;

    public boolean doIt(Data data, ImList args) {
        return true;
    }

    public String name() {
        return "PREQP";
    }

    public String subject() {
        return "Optimizatin with efficient question propagation.";
    }

    public PREQP(SsaEnvironment e, SsaSymTab tab, int m) {
        this.env = e;
        this.sstab = tab;
        this.mode = m;
        this.invalidSym = this.sstab.newSsaSymbol(this.tmpSymName + "@", 2);
    }

    private BasicBlk commonDominator(BasicBlk z, BasicBlk b) {
        if (this.dom.dominates(b, z)) {
            return b;
        }
        while (!this.dom.dominates(z, b)) {
            z = this.dom.immDominator(z);
        }
        return z;
    }

    private void findLoop(BasicBlk b) {
        BasicBlk z = b;
        char kind = 'B';
        Vector<BasicBlk> loop = new Vector<BasicBlk>();
        int backEdgeCount = 0;
        BiLink ps = b.predList().first();
        while (!ps.atEnd()) {
            BasicBlk p = (BasicBlk)ps.elem();
            if (this.isCfgUpEdge(p, b)) {
                ++backEdgeCount;
                this.loopKind[b.id] = kind = 'S';
                z = this.commonDominator(z, p);
                if (!loop.contains(p) && p != b) {
                    loop.add(p);
                    if (this.loopUpEdges[z.id] == null) {
                        this.loopUpEdges[z.id] = new Vector();
                    }
                    this.loopUpEdges[z.id].add(p);
                }
            }
            ps = ps.next();
        }
        if (z != b) {
            this.loopKind[z.id] = 77;
            if (this.generators[z.id] == null) {
                this.generators[z.id] = loop;
            } else {
                this.generators[z.id].addAll(loop);
            }
        } else {
            if (b.predList().length() - backEdgeCount == 1) {
                this.vParent[b.id] = this.dom.immDominator(b);
                Object[] pair = new Object[]{b, this.loopUpEdges[b.id]};
                this.backEdges.add(pair);
            }
            this.findBody(loop, z, kind);
        }
    }

    private BasicBlk loopAncestor(BasicBlk b) {
        while (this.loopParent[b.id] != null && this.loopParent[b.id] != b) {
            b = this.loopParent[b.id];
        }
        return b;
    }

    private void findBody(Vector generators, BasicBlk head, char kind) {
        BasicBlk b;
        Vector<BasicBlk> loop = new Vector<BasicBlk>();
        Enumeration gEnum = generators.elements();
        Vector<BasicBlk> queue = new Vector<BasicBlk>();
        while (gEnum.hasMoreElements()) {
            b = (BasicBlk)gEnum.nextElement();
            BasicBlk l = this.loopAncestor(b);
            if (loop.contains(l)) continue;
            loop.add(l);
            queue.add(l);
        }
        if (kind == 'S') {
            this.vParent[head.id] = null;
        }
        while (!queue.isEmpty()) {
            b = (BasicBlk)queue.remove(0);
            if (this.loopKind[b.id] != 'S' && b != head && kind == 'R') {
                if (kind == 'M') {
                    BasicBlk target = this.dom.immDominator(b);
                    BasicBlk pred = null;
                    while (target != head) {
                        pred = target;
                        target = this.dom.immDominator(target);
                    }
                    if (this.pDom.dominates(b, pred)) {
                        this.vParent[b.id] = pred;
                        this.rankCheckTarget[b.id] = pred.id;
                    }
                } else if (kind == 'R') {
                    this.vParent[b.id] = head;
                } else if (this.pDom.dominates(b, head)) {
                    this.vParent[b.id] = head;
                    this.rankCheckTarget[b.id] = head.id;
                }
            }
            BiLink ps = b.predList().first();
            while (!ps.atEnd()) {
                BasicBlk p = (BasicBlk)ps.elem();
                if (p != head) {
                    BasicBlk l = this.loopAncestor(p);
                    if (this.loopUpEdges[l.id] != null && l != b) {
                        Enumeration upEnum = this.loopUpEdges[l.id].elements();
                        while (upEnum.hasMoreElements()) {
                            BasicBlk tail = (BasicBlk)upEnum.nextElement();
                            if (this.vPreds[b.id] == null) {
                                this.vPreds[b.id] = new Vector();
                            }
                            if (this.vSuccs[tail.id] == null) {
                                this.vSuccs[tail.id] = new Vector();
                            }
                            this.vPreds[b.id].add(tail);
                            this.vSuccs[tail.id].add(b);
                        }
                    }
                    if (!loop.contains(l)) {
                        queue.add(l);
                        loop.add(l);
                    }
                }
                ps = ps.next();
            }
        }
        loop.add(head);
        Enumeration lEnum = loop.elements();
        while (lEnum.hasMoreElements()) {
            BasicBlk b2 = (BasicBlk)lEnum.nextElement();
            this.loopParent[b2.id] = head;
        }
    }

    private void calculateLoopTree() {
        int i;
        this.generators = new Vector[this.f.flowGraph().idBound()];
        this.loopParent = new BasicBlk[this.f.flowGraph().idBound()];
        this.loopUpEdges = new Vector[this.f.flowGraph().idBound()];
        this.loopKind = new char[this.f.flowGraph().idBound()];
        for (i = 0; i < this.f.flowGraph().idBound(); ++i) {
            this.loopKind[i] = 66;
        }
        for (i = this.vec.length - 1; i >= 0; --i) {
            BasicBlk b = this.vec[i];
            if (b == null) continue;
            if (this.generators[b.id] != null) {
                this.findBody(this.generators[b.id], b, 'M');
            }
            this.findLoop(b);
        }
        Vector<BasicBlk> loop = new Vector<BasicBlk>();
        loop.add(this.f.flowGraph().exitBlk());
        this.findBody(loop, this.f.flowGraph().entryBlk(), 'R');
    }

    void setRankCheckTarget() {
        Enumeration e = this.backEdges.elements();
        while (e.hasMoreElements()) {
            Object[] pair = (Object[])e.nextElement();
            if (pair[1] == null) continue;
            BasicBlk dst = (BasicBlk)pair[0];
            Enumeration e2 = ((Vector)pair[1]).elements();
            int max = 0;
            BasicBlk maxSrc = null;
            while (e2.hasMoreElements()) {
                BasicBlk src = (BasicBlk)e2.nextElement();
                if (this.rank[src.id] <= max) continue;
                max = this.rank[src.id];
                maxSrc = src;
            }
            this.rankCheckTarget[dst.id] = maxSrc.id;
        }
    }

    private void makeRank(BasicBlk blk) {
        int max = -1;
        if (this.rank[blk.id] != -1) {
            return;
        }
        BiLink p = blk.predList().first();
        while (!p.atEnd()) {
            BasicBlk pred = (BasicBlk)p.elem();
            if (!this.isCfgUpEdge(pred, blk)) {
                if (this.rank[pred.id] == -1) {
                    return;
                }
                if (this.rank[pred.id] > max) {
                    max = this.rank[pred.id];
                }
            }
            p = p.next();
        }
        if (this.vPreds[blk.id] != null) {
            Enumeration vPs = this.vPreds[blk.id].elements();
            while (vPs.hasMoreElements()) {
                BasicBlk pp = (BasicBlk)vPs.nextElement();
                if (this.rank[pp.id] == -1) {
                    return;
                }
                if (this.rank[pp.id] <= max) continue;
                max = this.rank[pp.id];
            }
        }
        int r = max != -1 ? max + 1 : 0;
        this.rank[blk.id] = r;
        if (r > this.rankSize) {
            this.rankSize = r;
        }
        BiLink ss = blk.succList().last();
        while (!ss.atEnd()) {
            BasicBlk succ = (BasicBlk)ss.elem();
            if (!this.isCfgUpEdge(blk, succ)) {
                this.makeRank(succ);
            }
            ss = ss.prev();
        }
        if (this.vSuccs[blk.id] != null) {
            Enumeration vSs = this.vSuccs[blk.id].elements();
            while (vSs.hasMoreElements()) {
                BasicBlk ss2 = (BasicBlk)vSs.nextElement();
                this.makeRank(ss2);
            }
        }
    }

    boolean propagate(LirNode e, BasicBlk v, LirNode[] visited) {
        visited[v.id] = e;
        if (!this.modPhi(e, v)) {
            BasicBlk parent = this.vParent[v.id];
            int upper = this.rank[v.id];
            int lower = this.rank[this.rankCheckTarget[v.id]];
            if (upper < lower) {
                int tmp = lower;
                lower = upper;
                upper = tmp;
            }
            if (parent != null && !this.rankCheck(e, lower, upper)) {
                if (this.eqp(e, parent, v, visited)) {
                    StackElem stackElem = (StackElem)this.stack.peek();
                    this.replaceBottom(v, stackElem.lirNode());
                    this.availMap.put(this.makeLocalKey(v, e), stackElem);
                    return true;
                }
                this.availMap.put(this.makeLocalKey(v, e), this.unavailVar);
                this.invalidateSym((Vector)this.insertCpy.get(v));
                this.insertCpy.remove(v);
                return false;
            }
            int pNum = 0;
            Vector<Object[]> tmpInsert = new Vector<Object[]>();
            int predN = v.predList().length();
            BiLink pp = v.predList().first();
            while (!pp.atEnd()) {
                BasicBlk p = (BasicBlk)pp.elem();
                if (this.eqp(e, p, v, visited)) {
                    if (predN == 1) {
                        StackElem stackElem = (StackElem)this.stack.peek();
                        this.replaceBottom(v, stackElem.lirNode());
                        this.availMap.put(this.makeLocalKey(v, e), stackElem);
                        return true;
                    }
                    StackElem elem = (StackElem)this.stack.pop();
                    elem.blk = p;
                    this.stack.push(elem);
                } else {
                    this.pVisited = new LirNode[this.f.flowGraph().idBound()];
                    boolean canPutHere = this.isHoistable;
                    if (e.opCode == 47) {
                        boolean bl = canPutHere = canPutHere && this.memIsHoistable(p, e);
                    }
                    if (canPutHere && this.postEqp(e, v)) {
                        LirNode src = e.makeCopy(this.env.lir);
                        Object[] pair = new Object[3];
                        Symbol sym = this.sstab.newSsaSymbol(this.tmpSymName, src.type);
                        pair[0] = sym;
                        pair[1] = src;
                        pair[2] = p;
                        tmpInsert.add(pair);
                        this.stack.push(new StackElem(sym, p, false, false));
                    } else {
                        while (pNum > 0) {
                            this.stack.pop();
                            --pNum;
                        }
                        this.availMap.put(this.makeLocalKey(v, e), this.unavailVar);
                        this.invalidateSym((Vector)this.insertCpy.get(v));
                        this.insertCpy.remove(v);
                        return false;
                    }
                }
                pp = pp.next();
                ++pNum;
            }
            if (this.createPhi(v, tmpInsert)) {
                StackElem stackElem = (StackElem)this.stack.peek();
                this.replaceBottom(v, stackElem.lirNode());
                this.availMap.put(this.makeLocalKey(v, e), stackElem.makeCopy());
                return true;
            }
            this.availMap.put(this.makeLocalKey(v, e), this.unavailVar);
            this.invalidateSym((Vector)this.insertCpy.get(v));
            this.insertCpy.remove(v);
            return false;
        }
        int pNum = 0;
        Vector<Object[]> tmpInsert = new Vector<Object[]>();
        int predN = v.predList().length();
        BiLink pp = v.predList().first();
        while (!pp.atEnd()) {
            BasicBlk p = (BasicBlk)pp.elem();
            LirNode ep = this.transPhi(e, v, pNum + 1);
            if (this.eqp(ep, p, v, visited)) {
                StackElem elem = (StackElem)this.stack.pop();
                elem.blk = p;
                this.stack.push(elem);
            } else {
                this.pVisited = new LirNode[this.f.flowGraph().idBound()];
                boolean canPutHere = this.isHoistable;
                if (e.opCode == 47) {
                    boolean bl = canPutHere = canPutHere && this.memIsHoistable(p, ep);
                }
                if (canPutHere && this.postEqp(e, v)) {
                    LirNode src = ep.makeCopy(this.env.lir);
                    Object[] pair = new Object[3];
                    Symbol sym = this.sstab.newSsaSymbol(this.tmpSymName, src.type);
                    pair[0] = sym;
                    pair[1] = src;
                    pair[2] = p;
                    tmpInsert.add(pair);
                    this.stack.push(new StackElem(sym, p, false, false));
                } else {
                    while (pNum > 0) {
                        this.stack.pop();
                        --pNum;
                    }
                    this.availMap.put(this.makeLocalKey(v, e), this.unavailVar);
                    this.invalidateSym((Vector)this.insertCpy.get(v));
                    this.insertCpy.remove(v);
                    return false;
                }
            }
            pp = pp.next();
            ++pNum;
        }
        if (this.createPhi(v, tmpInsert)) {
            StackElem stackElem = (StackElem)this.stack.peek();
            this.replaceBottom(v, stackElem.lirNode());
            this.availMap.put(this.makeLocalKey(v, e), stackElem.makeCopy());
            return true;
        }
        this.availMap.put(this.makeLocalKey(v, e), this.unavailVar);
        this.invalidateSym((Vector)this.insertCpy.get(v));
        this.insertCpy.remove(v);
        return false;
    }

    boolean eqp(LirNode e, BasicBlk v, BasicBlk s, LirNode[] visited) {
        this.env.println("EQP : question about " + e + " goes into block " + v.id, 10000);
        if (this.isOccurWithStackPush(e, v)) {
            StackElem stackElem = (StackElem)this.stack.peek();
            this.replaceBottom(v, stackElem.lirNode());
            this.availMap.put(this.makeLocalKey(v, e), stackElem.makeCopy());
            return true;
        }
        BiList operands = this.util.findTargetLir(e, 6, new BiList());
        boolean modCheck = false;
        BiLink q = operands.first();
        while (!q.atEnd()) {
            BiLink tq = (BiLink)this.modMap.get(this.makeLocalKey(v, (LirNode)q.elem()));
            if (tq != null) {
                if ((this.mode & 2) != 0 || e.opCode != 12 || !this.isHoistable) {
                    return false;
                }
                modCheck = true;
                if (this.osr(tq, e, v, visited)) {
                    return true;
                }
            }
            q = q.next();
        }
        if (modCheck) {
            return false;
        }
        if (visited[v.id] == e) {
            StackElem sElem = (StackElem)this.availMap.get(this.makeLocalKey(v, e));
            if (sElem == null) {
                LirNode src = e.makeCopy(this.env.lir);
                Symbol sym = this.sstab.newSsaSymbol(this.tmpSymName, src.type);
                sElem = new StackElem(sym, s, false, true);
                LirNode dst = this.env.lir.symRef(6, src.type, sym, ImList.Empty);
                InsertElem elem = new InsertElem(48, dst, null, s);
                Vector<InsertElem> insV = (Vector<InsertElem>)this.insertCpy.get(v);
                if (insV == null) {
                    insV = new Vector<InsertElem>();
                    this.insertCpy.put(v, insV);
                }
                insV.add(elem);
            } else {
                if (!sElem.isAv && !sElem.isWAv) {
                    return false;
                }
                if (sElem.s != null && this.isInvalidSym(sElem.s)) {
                    return false;
                }
            }
            this.stack.push(sElem.makeCopy());
            this.env.println("EQP : question returns TRUE from block " + v.id + " at section 1", 10000);
            return true;
        }
        if (this.f.flowGraph().entryBlk() == v || visited[v.id] != null) {
            this.env.println("EQP : question returns FALSE from block " + v.id + " at section 2", 10000);
            return false;
        }
        return this.propagate(e, v, visited);
    }

    private void replaceBottom(BasicBlk v, LirNode node) {
        Vector inss = (Vector)this.insertCpy.get(v);
        if (inss == null) {
            return;
        }
        Enumeration insE = inss.elements();
        while (insE.hasMoreElements()) {
            InsertElem elem = (InsertElem)insE.nextElement();
            if (elem.src != null) continue;
            elem.src = node.makeCopy(this.env.lir);
        }
    }

    private boolean rankCheck(LirNode e, int lower, int upper) {
        if (!this.expRankMap.check(this.makeExpKey(e), lower, upper)) {
            BiList operands = this.util.findTargetLir(e, 6, new BiList());
            if (e.opCode == 47) {
                if (this.expRankMap.check(this.makeExpKey(e) + "=", lower, upper)) {
                    return true;
                }
            } else {
                BiLink pp = operands.first();
                while (!pp.atEnd()) {
                    LirNode ref = (LirNode)pp.elem();
                    if (ref.opCode == 6 && this.phiRankMap.check(((LirSymRef)ref).symbol.name, lower, upper)) {
                        return true;
                    }
                    pp = pp.next();
                }
            }
            return false;
        }
        return true;
    }

    private boolean isOccur(LirNode e, BasicBlk v) {
        LirNode node = (LirNode)this.occurMap.get(this.makeLocalKey(v, e));
        return node != null;
    }

    private boolean isOccurWithStackPush(LirNode e, BasicBlk v) {
        LirNode node = (LirNode)this.occurMap.get(this.makeLocalKey(v, e));
        if (node != null) {
            this.stack.push(new StackElem(node.kid(0), v, true, true));
            this.env.println("EQP : stack push " + ((LirSymRef)node.kid((int)0)).symbol + " " + v.id, 10000);
            return true;
        }
        if (e.opCode == 47 && (node = (LirNode)this.occurMap.get(this.makeLocalKey(v, e) + "=")) != null) {
            this.stack.push(new StackElem(node.kid(1), v, true, true));
            return true;
        }
        return false;
    }

    private boolean createPhi(BasicBlk v, Vector ins) {
        StackElem[] args = new StackElem[v.predList().length()];
        int type = -1;
        boolean isAvail = false;
        boolean isWAvail = true;
        for (int i = v.predList().length() - 1; i >= 0; --i) {
            args[i] = (StackElem)this.stack.pop();
            isAvail = isAvail || args[i].isAv;
            boolean bl = isWAvail = isWAvail && args[i].isWAv;
            if (args[i] == null || args[i].node.opCode != 6) continue;
            if (type == -1) {
                type = args[i].s.type;
                continue;
            }
            if (type == args[i].s.type) continue;
            System.err.println("Phi instruction has several types of variable");
            System.exit(1);
        }
        boolean bl = isWAvail = isWAvail || isAvail;
        if (!isAvail && !isWAvail) {
            return false;
        }
        Enumeration e = ins.elements();
        while (e.hasMoreElements()) {
            Object[] pair = (Object[])e.nextElement();
            Symbol dstSym = (Symbol)pair[0];
            LirNode src = (LirNode)pair[1];
            LirNode dst = this.env.lir.symRef(6, src.type, dstSym, ImList.Empty);
            this.insert_out.put(pair[2], new InsertElem(48, dst, src, (BasicBlk)pair[2]));
        }
        boolean allSameArgs = true;
        String firstSym = args[0].node.toString();
        if (firstSym == null) {
            System.err.println("Inserted phi is not complete");
            System.exit(1);
        }
        for (int i = 1; i < args.length; ++i) {
            if (args[i] == null) {
                System.err.println("Inserted phi is not complete");
                System.exit(1);
            }
            if (firstSym.equals(args[i].node.toString())) continue;
            allSameArgs = false;
            break;
        }
        if (allSameArgs) {
            this.stack.push(new StackElem(args[0].node, v, isAvail, isWAvail));
            return true;
        }
        if (type == -1) {
            System.err.println("Phi instruction has no valid arguments");
            System.exit(1);
        }
        Symbol sym = this.sstab.newSsaSymbol(this.tmpSymName, type);
        LirNode phi = this.util.makePhiInst(sym, v);
        for (int i = 0; i < args.length; ++i) {
            if (args[i] == null) continue;
            phi.kid(i + 1).setKid(0, args[i].lirNode());
        }
        LirNode phiDst = phi.kid(0);
        LirNode oldPhi = null;
        String key = this.makeLocalKey(v, phi);
        if (key != null) {
            oldPhi = (LirNode)this.occurMap.get(key);
        }
        if (oldPhi == null) {
            this.stack.push(new StackElem(sym, v, isAvail, isWAvail));
            InsertElem elem = new InsertElem(59, null, phi, v);
            this.insert_in.put(v, elem);
        } else {
            phiDst = oldPhi.kid(0);
            this.stack.push(new StackElem(((LirSymRef)oldPhi.kid((int)0)).symbol, v, isAvail, isWAvail));
        }
        for (int i = 1; i < phi.nKids(); ++i) {
            if (phi.kid((int)i).opCode != 6) continue;
            this.rCpMap.put(((LirSymRef)phi.kid((int)i)).symbol.name, ((LirSymRef)phiDst).symbol);
        }
        return true;
    }

    private boolean isMod(LirNode e, BasicBlk v) {
        BiList operands = this.util.findTargetLir(e, 6, new BiList());
        BiLink q = operands.first();
        while (!q.atEnd()) {
            if (this.modMap.get(this.makeLocalKey(v, (LirNode)q.elem())) != null) {
                return true;
            }
            q = q.next();
        }
        return false;
    }

    private boolean modPhi(LirNode e, BasicBlk v) {
        BiList operands = this.util.findTargetLir(e, 6, new BiList());
        BiLink q = operands.first();
        while (!q.atEnd()) {
            if (this.phiMap.get(this.makeLocalKey(v, (LirNode)q.elem())) != null) {
                return true;
            }
            q = q.next();
        }
        return false;
    }

    private LirNode transPhi(LirNode e, BasicBlk v, int p) {
        LirNode result = e.makeCopy(this.env.lir);
        if (e == result) {
            System.err.println("e == result");
            System.exit(1);
        }
        Stack<LirNode> stk = new Stack<LirNode>();
        stk.push(result);
        boolean mod = false;
        while (!stk.empty()) {
            LirNode n = (LirNode)stk.pop();
            for (int i = 0; i < n.nKids(); ++i) {
                if (n.kid((int)i).opCode == 6) {
                    LirNode phi = (LirNode)this.phiMap.get(this.makeLocalKey(v, n.kid(i)));
                    if (phi == null) continue;
                    n.setKid(i, phi.kid(p).kid(0).makeCopy(this.env.lir));
                    continue;
                }
                stk.push(n.kid(i));
            }
        }
        return result;
    }

    private LirNode rTransPhi(LirNode e, BasicBlk v, BasicBlk s) {
        LirNode result = e.makeCopy(this.env.lir);
        Stack<LirNode> stk = new Stack<LirNode>();
        stk.push(result);
        boolean mod = false;
        while (!stk.empty()) {
            LirNode n = (LirNode)stk.pop();
            for (int i = 0; i < n.nKids(); ++i) {
                if (n.kid((int)i).opCode == 6) {
                    LirNode phi = (LirNode)this.rPhiMap.get(this.makeLocalKey2(v, s, n.kid(i)));
                    if (phi == null) continue;
                    mod = true;
                    n.setKid(i, phi.kid(0).makeCopy(this.env.lir));
                    continue;
                }
                stk.push(n.kid(i));
            }
        }
        if (mod) {
            return result;
        }
        return e;
    }

    private boolean isBackEdge(BasicBlk from, BasicBlk to) {
        return this.dom.dominates(to, from);
    }

    private boolean isCfgUpEdge(BasicBlk from, BasicBlk to) {
        return this.dfst.isAncestorOf(to, from);
    }

    private boolean isUpEdgeDst(BasicBlk v) {
        BiLink p = v.predList().first();
        while (!p.atEnd()) {
            BasicBlk pred = (BasicBlk)p.elem();
            if (this.isCfgUpEdge(pred, v)) {
                return true;
            }
            p = p.next();
        }
        return false;
    }

    LirNode stackTop() {
        StackElem stackElem = (StackElem)this.stack.peek();
        return stackElem.lirNode();
    }

    private void initRankSet() {
        this.expRankMap = new RankTable(this.rankSize);
        this.phiRankMap = new RankTable(this.rankSize);
        BiLink p = this.f.flowGraph().basicBlkList.first();
        while (!p.atEnd()) {
            BasicBlk blk = (BasicBlk)p.elem();
            BiLink pi = blk.instrList().first();
            while (!pi.atEnd()) {
                LirNode node = (LirNode)pi.elem();
                switch (node.opCode) {
                    case 48: {
                        if (node.kid((int)0).opCode == 47 && (node.kid((int)1).opCode == 6 || node.kid((int)1).opCode == 2 || node.kid((int)1).opCode == 3)) {
                            this.expRankMap.insert(this.makeExpKey(node.kid(0)) + "=", this.rank[blk.id]);
                        }
                        if (node.kid((int)0).opCode != 6 || node.kid((int)1).opCode == 2 || node.kid((int)1).opCode == 3 || node.kid((int)1).opCode == 6 || node.kid((int)1).opCode == 53 || node.kid((int)1).opCode == 57 || node.kid((int)1).opCode == 58) break;
                        this.expRankMap.insert(this.makeExpKey(node.kid(1)), this.rank[blk.id]);
                        break;
                    }
                    case 59: {
                        this.phiRankMap.insert(((LirSymRef)node.kid((int)0)).symbol.name, this.rank[blk.id]);
                    }
                }
                pi = pi.next();
            }
            p = p.next();
        }
    }

    private void sortPhiArgs() {
        BiLink b = this.f.flowGraph().basicBlkList.first();
        while (!b.atEnd()) {
            BasicBlk blk = (BasicBlk)b.elem();
            BiLink inst = blk.instrList().first();
            while (!inst.atEnd()) {
                LirNode node = (LirNode)inst.elem();
                if (node.opCode != 59) break;
                LirNode[] args = new LirNode[node.nKids()];
                int i = 0;
                int argN = 1;
                BiLink p = blk.predList().first();
                while (!p.atEnd()) {
                    BasicBlk pred = (BasicBlk)p.elem();
                    while (true) {
                        LirLabelRef nLab = (LirLabelRef)node.kid(i + 1).kid(1);
                        BasicBlk phiPred = nLab.label.basicBlk();
                        if (phiPred == pred) {
                            args[argN] = node.kid(i + 1);
                            ++i;
                            i %= node.nKids() - 1;
                            break;
                        }
                        ++i;
                        i %= node.nKids() - 1;
                    }
                    p = p.next();
                    ++argN;
                }
                for (argN = 1; argN < node.nKids(); ++argN) {
                    node.setKid(argN, args[argN].makeCopy(this.env.lir));
                }
                this.occurMap.put(this.makeLocalKey(blk, node), node);
                inst = inst.next();
            }
            b = b.next();
        }
    }

    String makeLocalKey(BasicBlk blk, LirNode n) {
        String key = blk.id + "";
        switch (n.opCode) {
            case 59: {
                key = key + ":PHI";
                for (int i = 1; i < n.nKids(); ++i) {
                    key = key + "," + n.kid(i).kid(0).toString();
                }
                return key;
            }
            case 61: {
                return key + "," + ((LirSymRef)n.kid((int)0)).symbol.name;
            }
            case 6: {
                return key + "," + ((LirSymRef)n).symbol.name;
            }
        }
        return key + this.makeExpKey(n);
    }

    String makeLocalKey2(BasicBlk blk, BasicBlk succ, LirNode n) {
        switch (n.opCode) {
            case 61: {
                n = n.kid(0);
                break;
            }
            case 6: {
                break;
            }
            default: {
                return null;
            }
        }
        return blk.id + "," + succ.id + ((LirSymRef)n).symbol.name;
    }

    String makeExpKey(LirNode n) {
        if ((this.mode & 4) == 0) {
            switch (n.opCode) {
                case 10: 
                case 12: {
                    n = n.makeCopy(this.env.lir);
                    if (n.kid((int)0).opCode != 6 && n.kid((int)1).opCode != 6) break;
                    if (n.kid((int)0).opCode == 2 || n.kid((int)0).opCode == 3) {
                        LirNode tmp = n.kid(1);
                        n.setKid(1, n.kid(0));
                        n.setKid(0, tmp);
                        break;
                    }
                    if (n.kid((int)0).opCode != 6 || n.kid((int)1).opCode != 6 || ((LirSymRef)n.kid((int)0)).symbol.id <= ((LirSymRef)n.kid((int)1)).symbol.id) break;
                    LirNode tmp = n.kid(1);
                    n.setKid(1, n.kid(0));
                    n.setKid(0, tmp);
                }
            }
        }
        return n.toString();
    }

    void applyCfg() {
        BiLink q;
        LirNode node;
        InsertElem elem;
        Enumeration e = this.insertCpy.elements();
        while (e.hasMoreElements()) {
            Vector v = (Vector)e.nextElement();
            Enumeration ve = v.elements();
            while (ve.hasMoreElements()) {
                InsertElem elem2 = (InsertElem)ve.nextElement();
                LirNode cpSrc = elem2.src;
                LirNode cpDst = elem2.dst;
                Enumeration en = this.insert_in.elements();
                while (en.hasMoreElements()) {
                    InsertElem elem22 = (InsertElem)en.nextElement();
                    LirNode node2 = elem22.src;
                    Stack<LirNode> stack = new Stack<LirNode>();
                    stack.push(node2);
                    while (!stack.empty()) {
                        LirNode n = (LirNode)stack.pop();
                        for (int i = 0; i < n.nKids(); ++i) {
                            if (n.kid((int)i).opCode == 6) {
                                Symbol ref = ((LirSymRef)n.kid((int)i)).symbol;
                                if (ref != ((LirSymRef)cpDst).symbol) continue;
                                if (cpSrc == null) {
                                    System.out.println("cpSrc==null at " + elem2.blk.id);
                                    System.exit(1);
                                }
                                n.setKid(i, this.env.lir.symRef(cpSrc.opCode, cpSrc.type, ((LirSymRef)cpSrc).symbol, ImList.Empty));
                                continue;
                            }
                            stack.push(n.kid(i));
                        }
                    }
                }
            }
        }
        e = this.insert_in.elements();
        block5: while (e.hasMoreElements()) {
            elem = (InsertElem)e.nextElement();
            if (this.cpMap.get(((LirSymRef)elem.src.kid((int)0)).symbol.name) == this.invalidSym) continue;
            node = elem.lirNode();
            q = elem.blk.instrList().first();
            while (!q.atEnd()) {
                LirNode n = (LirNode)q.elem();
                if (n.opCode != 59) {
                    q.addBefore(node);
                    this.env.println("EQP : insert " + node + " at just after the last phi " + "instructions in block " + elem.blk.id, 10000);
                    this.maintainTableInsertPhi(q.prev(), node, elem.blk);
                    continue block5;
                }
                q = q.next();
            }
        }
        e = this.insert_out.elements();
        while (e.hasMoreElements()) {
            elem = (InsertElem)e.nextElement();
            node = elem.lirNode();
            q = elem.blk.instrList().last();
            q.addBefore(node);
            this.maintainTableInsertExp(q.prev(), node, elem.blk);
            this.env.println("EQP : insert " + node + " at just before jump expression " + " in block " + elem.blk.id, 10000);
        }
    }

    boolean postEqp(LirNode e, BasicBlk v) {
        this.env.println("POSTEQP : question about " + e + " goes into block " + v.id, 10000);
        if (this.antMap.get(this.makeLocalKey(v, e)) != null) {
            return true;
        }
        if (this.pVisited[v.id] == e) {
            this.env.println("POSTEQP : question returns TRUE from block " + v.id + " at section 1", 10000);
            return true;
        }
        if (this.f.flowGraph().exitBlk() == v || this.isMod(e, v)) {
            this.env.println("POSTEQP : question returns FALSE from block " + v.id + " at section 2", 10000);
            return false;
        }
        if (this.isOccur(e, v)) {
            this.antMap.put(this.makeLocalKey(v, e), Boolean.TRUE);
            return true;
        }
        if (this.pVisited[v.id] != null) {
            return false;
        }
        this.pVisited[v.id] = e;
        BiLink ss = v.succList().first();
        while (!ss.atEnd()) {
            BasicBlk s = (BasicBlk)ss.elem();
            LirNode ep = this.rTransPhi(e, v, s);
            if (!this.postEqp(ep, s)) {
                return false;
            }
            ss = ss.next();
        }
        this.antMap.put(this.makeLocalKey(v, e), Boolean.TRUE);
        return true;
    }

    void maintainTableInsertExp(BiLink q, LirNode node, BasicBlk b) {
        if (q.elem() != node) {
            System.err.println("Element of BiLink is not node");
            System.exit(1);
        }
        this.occurMap.put(this.makeLocalKey(b, node.kid(1)), node);
        this.expRankMap.insert(this.makeExpKey(node.kid(1)), this.rank[b.id]);
        Symbol s = ((LirSymRef)node.kid((int)0)).symbol;
        this.modMap.put(this.makeLocalKey(b, node.kid(0)), q);
        BiList operands = this.util.findTargetLir(node.kid(1), 6, new BiList());
        BiLink op = operands.first();
        while (!op.atEnd()) {
            String bNKey;
            String str = ((LirSymRef)op.elem()).symbol.name;
            Hashtable<String, Object[]> h = (Hashtable<String, Object[]>)this.cpy.variableMap.get(str);
            if (h == null) {
                h = new Hashtable<String, Object[]>();
                this.cpy.variableMap.put(str, h);
            }
            if (h.get(bNKey = this.cpy.makeBNKey(b, node)) == null) {
                Object[] pair = new Object[]{b, q};
                h.put(bNKey, pair);
            }
            op = op.next();
        }
    }

    void maintainTableInsertPhi(BiLink q, LirNode node, BasicBlk b) {
        this.occurMap.put(this.makeLocalKey(b, node), node);
        this.phiRankMap.insert(((LirSymRef)node.kid((int)0)).symbol.name, this.rank[b.id]);
        this.phiMap.put(this.makeLocalKey(b, node.kid(0)), node);
        int argN = 1;
        BiLink p = b.predList().first();
        while (!p.atEnd()) {
            BasicBlk pred = (BasicBlk)p.elem();
            LirNode snode = node.kid(argN);
            if (snode.kid((int)0).opCode == 6) {
                String key = this.makeLocalKey2(pred, b, snode);
                this.rPhiMap.put(key, node);
                Hashtable<String, Object[]> h = (Hashtable<String, Object[]>)this.cpy.variableMap.get(((LirSymRef)snode.kid((int)0)).symbol.name);
                if (h == null) {
                    h = new Hashtable<String, Object[]>();
                    this.cpy.variableMap.put(((LirSymRef)snode.kid((int)0)).symbol.name, h);
                }
                if (h.get(this.cpy.makeBNKey(b, node)) == null) {
                    Object[] pair = new Object[]{b, q};
                    h.put(this.cpy.makeBNKey(b, node), pair);
                }
            }
            p = p.next();
            ++argN;
        }
    }

    void maintainTableDeleteExp(LirNode node, BasicBlk b) {
        this.expRankMap.remove(this.makeExpKey(node.kid(1)), this.rank[b.id]);
        String eKey = this.makeLocalKey(b, node.kid(1));
        this.occurMap.remove(eKey);
        BiList operands = this.util.findTargetLir(node.kid(1), 6, new BiList());
        BiLink q = operands.first();
        while (!q.atEnd()) {
            Hashtable h;
            LirNode n = (LirNode)q.elem();
            if (n.opCode == 6 && (h = (Hashtable)this.cpy.variableMap.get(((LirSymRef)n).symbol.name)) != null) {
                h.remove(this.cpy.makeBNKey(b, node));
            }
            q = q.next();
        }
        this.modMap.remove(this.makeLocalKey(b, node.kid(0)));
    }

    void maintainTableReplaceExp(LirNode old, LirNode newN, BasicBlk b) {
        String expKey = this.makeLocalKey(b, old.kid(1));
        String expKey2 = this.makeLocalKey(b, newN.kid(1));
        if (this.occurMap.get(expKey) != null) {
            this.occurMap.remove(expKey);
        }
        this.occurMap.put(expKey2, newN);
        this.expRankMap.remove(this.makeExpKey(old.kid(1)), this.rank[b.id]);
        this.expRankMap.insert(this.makeExpKey(newN.kid(1)), this.rank[b.id]);
        if (old.kid((int)0).opCode == 47 && (old.kid((int)0).opCode == 6 || old.kid((int)0).opCode == 2 || old.kid((int)0).opCode == 3)) {
            expKey = expKey + "=";
            expKey2 = expKey2 + "=";
            if (this.occurMap.get(expKey) != null) {
                this.occurMap.remove(expKey);
            }
            this.occurMap.put(expKey2, newN);
            this.expRankMap.remove(this.makeExpKey(old.kid(0)) + "=", this.rank[b.id]);
            this.expRankMap.insert(this.makeExpKey(newN.kid(0)) + "=", this.rank[b.id]);
        }
    }

    void maintainTableDeletePhi(LirNode node, LirNode orgNode, BasicBlk b) {
        this.occurMap.remove(this.makeLocalKey(b, node));
        this.phiMap.remove(this.makeLocalKey(b, node.kid(0)));
        BiLink ps = b.predList().first();
        int i = 1;
        while (i < node.nKids() && !ps.atEnd()) {
            BasicBlk p = (BasicBlk)ps.elem();
            this.rPhiMap.remove(this.makeLocalKey2(p, b, node.kid(i)));
            Hashtable h = (Hashtable)this.cpy.variableMap.get(((LirSymRef)node.kid((int)i).kid((int)0)).symbol.name);
            if (h != null) {
                h.remove(this.cpy.makeBNKey(b, orgNode));
            }
            ++i;
            ps = ps.next();
        }
        this.phiRankMap.remove(((LirSymRef)node.kid((int)0)).symbol.name, this.rank[b.id]);
    }

    void maintainTableReplacePhi(LirNode old, LirNode newN, BasicBlk b) {
        String expKey = this.makeLocalKey(b, old);
        String expKey2 = this.makeLocalKey(b, newN);
        if (this.occurMap.get(expKey) != null) {
            this.occurMap.remove(expKey);
        }
        this.occurMap.put(expKey2, newN);
        BiLink ps = b.predList().first();
        int i = 1;
        while (i < newN.nKids() && !ps.atEnd()) {
            BasicBlk p = (BasicBlk)ps.elem();
            LirNode oldSrc = old.kid(i);
            LirNode newNSrc = newN.kid(i);
            if (oldSrc.kid((int)0).opCode == 6) {
                this.rPhiMap.remove(this.makeLocalKey2(p, b, oldSrc));
            }
            if (newNSrc.kid((int)0).opCode == 6) {
                this.rPhiMap.put(this.makeLocalKey2(p, b, newNSrc), newN);
            }
            ++i;
            ps = ps.next();
        }
    }

    void debugPrint() {
        int i;
        BasicBlk b;
        BasicBlk[] rankSort = new BasicBlk[this.rankSize];
        BiLink bs = this.f.flowGraph().basicBlkList.first();
        while (!bs.atEnd()) {
            b = (BasicBlk)bs.elem();
            if (this.rank[b.id] == -1) {
                System.err.println("make rank error at blk:" + b.id + ", From:" + this.f.flowGraph().entryBlk().id + " To:" + this.f.flowGraph().exitBlk().id);
            }
            rankSort[this.rank[b.id]] = b;
            bs = bs.next();
        }
        this.f.flowGraph().printIt(new PrintWriter(System.out, true));
        for (i = 0; i < this.f.flowGraph().idBound(); ++i) {
            if (this.vSuccs[i] == null) continue;
            Enumeration sEnum = this.vSuccs[i].elements();
            while (sEnum.hasMoreElements()) {
                BasicBlk ss = (BasicBlk)sEnum.nextElement();
                System.out.println("From:" + i + " To:" + ss.id);
            }
        }
        for (i = 0; i < this.rankSize; ++i) {
            System.out.print("b:" + rankSort[i].id + " ");
        }
        System.out.print("\n");
        bs = this.f.flowGraph().basicBlkList.first();
        while (!bs.atEnd()) {
            b = (BasicBlk)bs.elem();
            if (this.vParent[b.id] != null) {
                System.out.print("[" + b.id + "]->[" + this.vParent[b.id].id + "] ");
            }
            bs = bs.next();
        }
        System.out.print("\n");
    }

    void debugDefine() {
        BiLink b = this.f.flowGraph().basicBlkList.first();
        while (!b.atEnd()) {
            BasicBlk blk = (BasicBlk)b.elem();
            BiLink inst = blk.instrList().first();
            while (!inst.atEnd()) {
                LirNode node = (LirNode)inst.elem();
                int defKid = node.nKids();
                if (node.opCode == 59) {
                    defKid = 0;
                }
                if (node.opCode == 48) {
                    defKid = 0;
                }
                if (node.opCode == 53) {
                    defKid = 2;
                }
                for (int k = 0; k < node.nKids(); ++k) {
                    if (k == defKid) continue;
                    BiList operands = this.util.findTargetLir(node.kid(k), 6, new BiList());
                    BiLink op = operands.first();
                    while (!op.atEnd()) {
                        Symbol useSym = ((LirSymRef)op.elem()).symbol;
                        boolean defOk = false;
                        BiLink inst2 = inst;
                        while (!inst2.atEnd() && !defOk) {
                            LirNode target = (LirNode)inst2.elem();
                            block0 : switch (target.opCode) {
                                case 48: {
                                    if (target.kid((int)0).opCode != 6 || ((LirSymRef)target.kid((int)0)).symbol != useSym) break;
                                    defOk = true;
                                    break;
                                }
                                case 59: {
                                    if (target.kid((int)0).opCode != 6 || ((LirSymRef)target.kid((int)0)).symbol != useSym) break;
                                    defOk = true;
                                    break;
                                }
                                case 53: {
                                    if (target.kid(2).nKids() <= 0 || target.kid((int)2).kid((int)0).opCode != 6 || ((LirSymRef)target.kid((int)2).kid((int)0)).symbol != useSym) break;
                                    defOk = true;
                                    break;
                                }
                                case 54: {
                                    BiList args = this.util.findTargetLir(target, 6, new BiList());
                                    BiLink op2 = operands.first();
                                    while (!op2.atEnd()) {
                                        Symbol defSym = ((LirSymRef)op2.elem()).symbol;
                                        if (defSym == useSym) {
                                            defOk = true;
                                            break block0;
                                        }
                                        op2 = op2.next();
                                    }
                                    break;
                                }
                            }
                            inst2 = inst2.prev();
                        }
                        BasicBlk parent = this.dom.immDominator(blk);
                        if (node.opCode == 59) {
                            parent = ((LirLabelRef)node.kid((int)k).kid((int)1)).label.basicBlk();
                        }
                        while (parent != null && !defOk) {
                            BiLink inst3 = parent.instrList().last();
                            while (!inst3.atEnd() && !defOk) {
                                LirNode target2 = (LirNode)inst3.elem();
                                block6 : switch (target2.opCode) {
                                    case 48: {
                                        if (target2.kid((int)0).opCode != 6 || ((LirSymRef)target2.kid((int)0)).symbol != useSym) break;
                                        defOk = true;
                                        break;
                                    }
                                    case 59: {
                                        if (target2.kid((int)0).opCode != 6 || ((LirSymRef)target2.kid((int)0)).symbol != useSym) break;
                                        defOk = true;
                                        break;
                                    }
                                    case 53: {
                                        if (target2.kid(2).nKids() <= 0 || target2.kid((int)2).kid((int)0).opCode != 6 || ((LirSymRef)target2.kid((int)2).kid((int)0)).symbol != useSym) break;
                                        defOk = true;
                                        break;
                                    }
                                    case 54: {
                                        BiList args2 = this.util.findTargetLir(target2, 6, new BiList());
                                        BiLink op3 = operands.first();
                                        while (!op3.atEnd()) {
                                            Symbol defSym = ((LirSymRef)op3.elem()).symbol;
                                            if (defSym == useSym) {
                                                defOk = true;
                                                break block6;
                                            }
                                            op3 = op3.next();
                                        }
                                        break;
                                    }
                                }
                                inst3 = inst3.prev();
                            }
                            parent = this.dom.immDominator(parent);
                        }
                        if (!defOk) {
                            System.out.println(this.f.toString() + ":[" + blk.id + "]:(" + useSym.name + ") " + node.toString());
                        }
                        op = op.next();
                    }
                }
                inst = inst.next();
            }
            b = b.next();
        }
    }

    boolean memIsHoistable(BasicBlk target, LirNode e) {
        return this.alias.blkRank(target) == ((LirIconst)e.kid((int)1)).value;
    }

    void invalidateSym(Vector vec) {
        if (vec == null) {
            return;
        }
        Enumeration e = vec.elements();
        while (e.hasMoreElements()) {
            InsertElem elem = (InsertElem)e.nextElement();
            Symbol sym = ((LirSymRef)elem.dst).symbol;
            while (sym != null && this.cpMap.get(sym.name) != this.invalidSym) {
                this.cpMap.put(sym.name, this.invalidSym);
                sym = (Symbol)this.rCpMap.get(sym.name);
            }
        }
    }

    boolean isInvalidSym(Symbol s) {
        Symbol sym = s;
        while (s != null && s != this.invalidSym) {
            s = (Symbol)this.cpMap.get(s.name);
        }
        return s != null;
    }

    boolean osr(BiLink q, LirNode e, BasicBlk v, LirNode[] visited) {
        LirNode mod = (LirNode)q.elem();
        if (mod.opCode != 48) {
            return false;
        }
        LirNode e2 = mod.kid(1);
        LirNode dst = mod.kid(0);
        if ((e2.opCode == 10 || e2.opCode == 11) && e.opCode == 12) {
            for (int i = 0; i < e.nKids(); ++i) {
                boolean isAv2;
                boolean isAv;
                if (e.kid((int)i).opCode != 6 || ((LirSymRef)e.kid((int)i)).symbol != ((LirSymRef)dst).symbol) continue;
                LirNode newExp0 = e.makeCopy(this.env.lir);
                LirNode newExp1 = e.makeCopy(this.env.lir);
                newExp0.setKid(i, e2.kid(0).makeCopy(this.env.lir));
                newExp1.setKid(i, e2.kid(1).makeCopy(this.env.lir));
                if (newExp0.kid((int)0).opCode == 2 && ((LirIconst)newExp0.kid((int)0)).value == 0L) {
                    isAv = true;
                    this.stack.push(new StackElem(this.env.lir.iconst(newExp0.kid((int)0).type, 0L, ImList.Empty), v, true, true));
                } else if (newExp0.kid((int)1).opCode == 2 && ((LirIconst)newExp0.kid((int)1)).value == 0L) {
                    isAv = true;
                    this.stack.push(new StackElem(this.env.lir.iconst(newExp0.kid((int)1).type, 0L, ImList.Empty), v, true, true));
                } else if (newExp0.kid((int)0).opCode == 2 && ((LirIconst)newExp0.kid((int)0)).value == 1L) {
                    isAv = true;
                    this.stack.push(new StackElem(newExp0.kid(1), v, true, true));
                } else if (newExp0.kid((int)1).opCode == 2 && ((LirIconst)newExp0.kid((int)1)).value == 1L) {
                    isAv = true;
                    this.stack.push(new StackElem(newExp0.kid(0), v, true, true));
                } else if (newExp0.kid((int)0).opCode == 2 && newExp0.kid((int)1).opCode == 2) {
                    isAv = true;
                    long value = ((LirIconst)newExp0.kid((int)0)).value * ((LirIconst)newExp0.kid((int)1)).value;
                    this.stack.push(new StackElem(this.env.lir.iconst(newExp0.kid((int)0).type, value, ImList.Empty), v, true, true));
                } else if (newExp0.kid((int)0).opCode == 3 && newExp0.kid((int)1).opCode == 3) {
                    isAv = true;
                    double value = ((LirFconst)newExp0.kid((int)0)).value * ((LirFconst)newExp0.kid((int)1)).value;
                    this.stack.push(new StackElem(this.env.lir.fconst(newExp0.kid((int)0).type, value, ImList.Empty), v, true, true));
                } else {
                    this.isHoistable = false;
                    isAv = this.eqp(newExp0, v, v, visited);
                    this.isHoistable = true;
                }
                if (!isAv) continue;
                StackElem tmp0 = (StackElem)this.stack.pop();
                if (newExp1.kid((int)0).opCode == 2 && ((LirIconst)newExp1.kid((int)0)).value == 0L) {
                    isAv2 = true;
                    this.stack.push(new StackElem(this.env.lir.iconst(newExp1.kid((int)0).type, 0L, ImList.Empty), v, true, true));
                } else if (newExp1.kid((int)1).opCode == 2 && ((LirIconst)newExp1.kid((int)1)).value == 0L) {
                    isAv2 = true;
                    this.stack.push(new StackElem(this.env.lir.iconst(newExp1.kid((int)1).type, 0L, ImList.Empty), v, true, true));
                } else if (newExp1.kid((int)0).opCode == 2 && ((LirIconst)newExp1.kid((int)0)).value == 1L) {
                    isAv2 = true;
                    this.stack.push(new StackElem(newExp1.kid(1), v, true, true));
                } else if (newExp1.kid((int)1).opCode == 2 && ((LirIconst)newExp1.kid((int)1)).value == 1L) {
                    isAv2 = true;
                    this.stack.push(new StackElem(newExp1.kid(0), v, true, true));
                } else if (newExp1.kid((int)0).opCode == 2 && newExp1.kid((int)1).opCode == 2) {
                    isAv2 = true;
                    long value = ((LirIconst)newExp1.kid((int)0)).value * ((LirIconst)newExp1.kid((int)1)).value;
                    this.stack.push(new StackElem(this.env.lir.iconst(newExp1.kid((int)0).type, value, ImList.Empty), v, true, true));
                } else if (newExp1.kid((int)0).opCode == 3 && newExp1.kid((int)1).opCode == 3) {
                    isAv2 = true;
                    double value = ((LirFconst)newExp1.kid((int)0)).value * ((LirFconst)newExp1.kid((int)1)).value;
                    this.stack.push(new StackElem(this.env.lir.fconst(newExp1.kid((int)0).type, value, ImList.Empty), v, true, true));
                } else {
                    this.isHoistable = false;
                    isAv2 = this.eqp(newExp1, v, v, visited);
                    this.isHoistable = true;
                }
                if (!isAv2) continue;
                StackElem tmp1 = (StackElem)this.stack.pop();
                LirNode newExp = e2.makeCopy(this.env.lir);
                newExp.setKid(0, tmp0.lirNode());
                newExp.setKid(1, tmp1.lirNode());
                Symbol sym = this.sstab.newSsaSymbol(this.tmpSymName, newExp.type);
                LirNode newDst = this.env.lir.symRef(6, newExp.type, sym, ImList.Empty);
                LirNode newSet = this.env.lir.operator(48, newExp.type, newDst, newExp, ImList.Empty);
                this.isHoistable = false;
                boolean isAv3 = this.eqp(newExp, v, v, visited);
                this.isHoistable = true;
                if (!isAv3) {
                    q.addBefore(newSet);
                    BiLink insQ = q.prev();
                    this.maintainTableInsertExp(insQ, newSet, v);
                    this.stack.push(new StackElem(newDst, v, true, true));
                }
                return true;
            }
        }
        return false;
    }

    void invoke() {
        this.cpy = new DDCopyPropagation(this.env, this.f, this);
        this.antMap = new Hashtable();
        this.rankArray = new Vector[this.rankSize];
        BiLink p = this.f.flowGraph().basicBlkList.last();
        while (!p.atEnd()) {
            BasicBlk blk = (BasicBlk)p.elem();
            if (this.rank[blk.id] != -1) {
                if (this.rankArray[this.rank[blk.id]] == null) {
                    this.rankArray[this.rank[blk.id]] = new Vector();
                }
                this.rankArray[this.rank[blk.id]].addElement(blk);
            }
            p = p.prev();
        }
        for (int r = 0; r < this.rankSize; ++r) {
            Vector blkV = this.rankArray[r];
            if (blkV == null) continue;
            Enumeration e = blkV.elements();
            while (e.hasMoreElements()) {
                BasicBlk b = (BasicBlk)e.nextElement();
                Hashtable<String, LirNode> map = new Hashtable<String, LirNode>();
                BiLink pi = b.instrList().first();
                while (!pi.atEnd()) {
                    LirNode node = (LirNode)pi.elem();
                    this.isHoistable = (this.mode & 1) == 0;
                    switch (node.opCode) {
                        case 48: {
                            if (node.kid((int)0).opCode == 47 && (node.kid((int)1).opCode == 6 || node.kid((int)1).opCode == 2 || node.kid((int)1).opCode == 3)) {
                                map.put(this.makeExpKey(node.kid(0)), node.kid(1));
                            }
                            if (node.kid((int)0).opCode != 6 || node.kid((int)1).opCode == 2 || node.kid((int)1).opCode == 3 || node.kid((int)1).opCode == 6 || node.kid((int)1).opCode == 53 || node.kid((int)1).opCode == 57 || node.kid((int)1).opCode == 58) break;
                            LirNode ref = (LirNode)map.get(this.makeExpKey(node.kid(1)));
                            if (ref != null) {
                                LirNode newReg = ref.makeCopy(this.env.lir);
                                this.expRankMap.remove(this.makeExpKey(node.kid(1)), this.rank[b.id]);
                                this.modMap.remove(this.makeLocalKey(b, node.kid(0)));
                                node.setKid(1, newReg);
                                this.cpy.doIt(b, node.makeCopy(this.env.lir));
                                pi.unlink();
                                break;
                            }
                            this.insertCpy = new Hashtable();
                            this.insert_in = new Hashtable();
                            this.insert_out = new Hashtable();
                            this.stack = new Stack();
                            this.availMap = new Hashtable();
                            this.cpMap = new Hashtable();
                            this.rCpMap = new Hashtable();
                            String expStr = this.makeExpKey(node.kid(1));
                            if (!this.isMod(node.kid(1), b) && b != this.f.flowGraph().entryBlk() && this.propagate(node.kid(1), b, new LirNode[this.f.flowGraph().idBound()])) {
                                this.maintainTableDeleteExp(node, b);
                                this.applyCfg();
                                StackElem elem = (StackElem)this.stack.pop();
                                LirNode newReg = elem.lirNode();
                                node.setKid(1, newReg);
                                map.put(expStr, newReg);
                                this.cpy.doIt(b, node.makeCopy(this.env.lir));
                                pi.unlink();
                                break;
                            }
                            map.put(expStr, node.kid(0));
                        }
                    }
                    pi = pi.next();
                }
            }
        }
    }

    public boolean doIt(Function function, ImList args) {
        this.f = function;
        this.util = new Util(this.env, this.f);
        this.env.println("****************** doing PREQP to " + this.f.symbol.name, 1000);
        this.alias = new MemoryAliasAnalyze(this.env, this.f);
        this.initVariables = new BiList();
        this.f.flowGraph().touch();
        this.dom = (Dominators)this.f.require(Dominators.analyzer);
        this.pDom = (Postdominators)this.f.require(Postdominators.analyzer);
        this.dfst = (DFST)this.f.require(DFST.analyzer);
        this.vec = this.dfst.blkVectorByRPost();
        this.vPreds = new Vector[this.f.flowGraph().idBound()];
        this.vSuccs = new Vector[this.f.flowGraph().idBound()];
        this.vParent = new BasicBlk[this.f.flowGraph().idBound()];
        this.rankCheckTarget = new int[this.f.flowGraph().idBound()];
        this.backEdges = new Vector();
        this.calculateLoopTree();
        this.rank = new int[this.f.flowGraph().idBound()];
        for (int i = 0; i < this.f.flowGraph().idBound(); ++i) {
            this.rank[i] = -1;
        }
        this.makeRank(this.f.flowGraph().entryBlk());
        ++this.rankSize;
        this.initRankSet();
        this.setRankCheckTarget();
        this.modMap = new Hashtable();
        this.phiMap = new Hashtable();
        this.rPhiMap = new Hashtable();
        this.occurMap = new Hashtable();
        this.sortPhiArgs();
        BiLink pp = this.f.flowGraph().basicBlkList.first();
        while (!pp.atEnd()) {
            BasicBlk v = (BasicBlk)pp.elem();
            BiLink p = v.instrList().first();
            while (!p.atEnd()) {
                LirNode node = (LirNode)p.elem();
                switch (node.opCode) {
                    case 48: {
                        String key;
                        if (node.kid((int)0).opCode == 47 && (node.kid((int)1).opCode == 6 || node.kid((int)1).opCode == 2 || node.kid((int)1).opCode == 3)) {
                            this.occurMap.put(this.makeLocalKey(v, node.kid(0)) + "=", node);
                        }
                        if (node.kid((int)0).opCode == 6) {
                            Symbol s = ((LirSymRef)node.kid((int)0)).symbol;
                            this.modMap.put(this.makeLocalKey(v, node.kid(0)), p);
                        }
                        if (node.kid((int)0).opCode != 6 || node.kid((int)1).opCode == 2 || node.kid((int)1).opCode == 3 || node.kid((int)1).opCode == 6 || node.kid((int)1).opCode == 53 || node.kid((int)1).opCode == 57 || node.kid((int)1).opCode == 58 || this.occurMap.get(key = this.makeLocalKey(v, node.kid(1))) != null) break;
                        this.occurMap.put(key, node);
                        break;
                    }
                    case 53: {
                        if (node.kid(2).nKids() <= 0 || node.kid((int)2).kid((int)0).opCode != 6) break;
                        Symbol s = ((LirSymRef)node.kid((int)2).kid((int)0)).symbol;
                        this.modMap.put(this.makeLocalKey(v, node.kid(2).kid(0)), p);
                        break;
                    }
                    case 59: {
                        this.phiMap.put(this.makeLocalKey(v, node.kid(0)), node);
                        int argN = 1;
                        BiLink pr = v.predList().first();
                        while (!pr.atEnd()) {
                            BasicBlk pred = (BasicBlk)pr.elem();
                            if (node.kid((int)argN).kid((int)0).opCode == 6) {
                                this.rPhiMap.put(this.makeLocalKey2(pred, v, node.kid(argN)), node);
                            }
                            pr = pr.next();
                            ++argN;
                        }
                        break;
                    }
                }
                p = p.next();
            }
            pp = pp.next();
        }
        this.invoke();
        this.alias.annul();
        return true;
    }

    private class InsertElem {
        int opCode;
        BasicBlk blk;
        LirNode src;
        LirNode dst;

        InsertElem(int op, LirNode d, LirNode s, BasicBlk b) {
            this.opCode = op;
            this.blk = b;
            this.src = s;
            this.dst = d;
        }

        LirNode lirNode() {
            switch (this.opCode) {
                case 48: {
                    LirNode node = ((PREQP)PREQP.this).env.lir.operator(48, this.dst.type, this.dst, this.src.makeCopy(((PREQP)PREQP.this).env.lir), ImList.Empty);
                    return node;
                }
                case 59: {
                    return this.src.makeCopy(((PREQP)PREQP.this).env.lir);
                }
            }
            System.err.println("Can't happen");
            System.exit(1);
            return null;
        }
    }

    private class StackElem {
        Symbol s;
        BasicBlk blk;
        LirNode node;
        boolean isAv;
        boolean isWAv;

        StackElem() {
            this.s = null;
            this.node = null;
            this.blk = null;
            this.isAv = false;
            this.isWAv = false;
        }

        StackElem(Symbol sym, BasicBlk block, boolean isAvail, boolean isWeakAvail) {
            this.s = sym;
            this.node = ((PREQP)PREQP.this).env.lir.symRef(6, this.s.type, this.s, ImList.Empty);
            this.blk = block;
            this.isAv = isAvail;
            this.isWAv = isWeakAvail;
        }

        StackElem(LirNode n, BasicBlk block, boolean isAvail, boolean isWeakAvail) {
            this.s = n.opCode == 6 ? ((LirSymRef)n).symbol : null;
            this.node = n.makeCopy(((PREQP)PREQP.this).env.lir);
            this.blk = block;
            this.isAv = isAvail;
            this.isWAv = isWeakAvail;
        }

        LirNode lirNode() {
            return this.node;
        }

        StackElem makeCopy() {
            return new StackElem(this.node, this.blk, this.isAv, this.isWAv);
        }
    }
}

