/*
 * Decompiled with CFR 0.152.
 */
package coins.ssa;

import coins.backend.Data;
import coins.backend.Function;
import coins.backend.LocalTransformer;
import coins.backend.Type;
import coins.backend.ana.DominanceFrontiers;
import coins.backend.ana.Dominators;
import coins.backend.ana.LiveVariableAnalysis;
import coins.backend.ana.LiveVariableSlotwise;
import coins.backend.cfg.BasicBlk;
import coins.backend.cfg.FlowGraph;
import coins.backend.lir.LirLabelRef;
import coins.backend.lir.LirNode;
import coins.backend.lir.LirSymRef;
import coins.backend.sym.Symbol;
import coins.backend.util.BiLink;
import coins.backend.util.BiList;
import coins.backend.util.ImList;
import coins.ssa.SsaEnvironment;
import coins.ssa.SsaSymTab;
import coins.ssa.Util;

public class TranslateToSsa
implements LocalTransformer {
    public static final int MINIMAL = 0;
    public static final int SEMI_PRUNED = 1;
    public static final int PRUNED = 2;
    private final int type;
    private final boolean withCopyFold;
    private SsaEnvironment env;
    public static final int THR = 1500;
    public static final int THR2 = 2000;
    private SsaSymTab sstab;
    private Dominators dom;
    private BiListAsStack[] stack;
    private Function f;
    private int orgSymtabMax;
    private BiList initVariables;

    public boolean doIt(Data data, ImList args) {
        return true;
    }

    public String name() {
        return "TranslateToSsa";
    }

    public String subject() {
        return "Translate into SSA form.";
    }

    TranslateToSsa(SsaEnvironment e, SsaSymTab stab, int howToTranslate, boolean withCopyFolding) {
        this.sstab = stab;
        this.env = e;
        this.type = howToTranslate;
        this.withCopyFold = withCopyFolding;
        int msg = 100;
        this.env.print("  SSA translation : ", msg);
        switch (this.type) {
            case 0: {
                this.env.print("MINIMAL", msg);
                break;
            }
            case 1: {
                this.env.print("SEMI_PRUNED", msg);
                break;
            }
            case 2: {
                this.env.print("PRUNED", msg);
            }
        }
        if (this.withCopyFold) {
            this.env.println(" with Copy Folding.", msg);
        } else {
            this.env.println(" without Copy Folding.", msg);
        }
    }

    public boolean doIt(Function function, ImList args) {
        this.env.println("****************** Translate into SSA form to " + function.symbol.name, 1000);
        this.f = function;
        this.orgSymtabMax = this.f.localSymtab.idBound();
        Util util = new Util(this.env, this.f);
        util.changeLabelRef(true);
        this.insertPhiInstruction();
        this.dom = (Dominators)this.f.require(Dominators.analyzer);
        this.stack = new BiListAsStack[this.f.localSymtab.idBound()];
        this.initVariables = new BiList();
        this.renameVariables(this.f.flowGraph().entryBlk());
        this.makeInitStmts();
        this.env.println("", 1500);
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void insertPhiInstruction() {
        FlowGraph g = this.f.flowGraph();
        BiList[] inserted = new BiList[g.idBound()];
        BiList[] defsites = new BiList[this.f.localSymtab.idBound()];
        BiList nonLocal = null;
        if (this.type == 1) {
            nonLocal = this.findNonLocal(g);
        }
        Symbol[] syms = new Symbol[this.f.localSymtab.idBound()];
        DominanceFrontiers df = (DominanceFrontiers)this.f.require(DominanceFrontiers.analyzer);
        BiLink p = g.basicBlkList.first();
        while (true) {
            if (p.atEnd()) break;
            BasicBlk blk = (BasicBlk)p.elem();
            BiLink bp = blk.instrList().first();
            while (!bp.atEnd()) {
                LirNode node = (LirNode)bp.elem();
                switch (node.opCode) {
                    case 48: {
                        switch (node.kid((int)0).opCode) {
                            case 7: {
                                if (node.kid((int)0).kid((int)0).opCode != 6) break;
                                Symbol s = ((LirSymRef)node.kid((int)0).kid((int)0)).symbol;
                                if (defsites[s.id] == null) {
                                    defsites[s.id] = new BiList();
                                }
                                defsites[s.id].addNew(blk);
                                syms[s.id] = s;
                                break;
                            }
                            case 6: {
                                Symbol s = ((LirSymRef)node.kid((int)0)).symbol;
                                if (defsites[s.id] == null) {
                                    defsites[s.id] = new BiList();
                                }
                                defsites[s.id].addNew(blk);
                                syms[s.id] = s;
                                break;
                            }
                        }
                        break;
                    }
                    case 53: {
                        block32: for (int i = 0; i < node.kid(2).nKids(); ++i) {
                            switch (node.kid((int)2).kid((int)i).opCode) {
                                case 7: {
                                    if (node.kid((int)2).kid((int)i).kid((int)0).opCode != 6) continue block32;
                                    Symbol s = ((LirSymRef)node.kid((int)2).kid((int)i).kid((int)0)).symbol;
                                    if (defsites[s.id] == null) {
                                        defsites[s.id] = new BiList();
                                    }
                                    defsites[s.id].addNew(blk);
                                    syms[s.id] = s;
                                    continue block32;
                                }
                                case 6: {
                                    Symbol s = ((LirSymRef)node.kid((int)2).kid((int)i)).symbol;
                                    if (defsites[s.id] == null) {
                                        defsites[s.id] = new BiList();
                                    }
                                    defsites[s.id].addNew(blk);
                                    syms[s.id] = s;
                                    continue block32;
                                }
                            }
                        }
                        break;
                    }
                    case 56: {
                        block33: for (int i = 0; i < node.nKids(); ++i) {
                            LirNode child = node.kid(i);
                            switch (child.opCode) {
                                case 48: {
                                    switch (child.kid((int)0).opCode) {
                                        case 7: {
                                            if (child.kid((int)0).kid((int)0).opCode != 6) break;
                                            Symbol s = ((LirSymRef)child.kid((int)0).kid((int)0)).symbol;
                                            if (defsites[s.id] == null) {
                                                defsites[s.id] = new BiList();
                                            }
                                            defsites[s.id].addNew(blk);
                                            syms[s.id] = s;
                                            break;
                                        }
                                        case 6: {
                                            Symbol s = ((LirSymRef)child.kid((int)0)).symbol;
                                            if (defsites[s.id] == null) {
                                                defsites[s.id] = new BiList();
                                            }
                                            defsites[s.id].addNew(blk);
                                            syms[s.id] = s;
                                            break;
                                        }
                                    }
                                    continue block33;
                                }
                                case 53: {
                                    block34: for (int j = 0; j < child.kid(2).nKids(); ++j) {
                                        switch (child.kid((int)2).kid((int)j).opCode) {
                                            case 7: {
                                                if (child.kid((int)2).kid((int)j).kid((int)0).opCode != 6) continue block34;
                                                Symbol s = ((LirSymRef)child.kid((int)2).kid((int)j).kid((int)0)).symbol;
                                                if (defsites[s.id] == null) {
                                                    defsites[s.id] = new BiList();
                                                }
                                                defsites[s.id].addNew(blk);
                                                syms[s.id] = s;
                                                continue block34;
                                            }
                                            case 6: {
                                                Symbol s = ((LirSymRef)child.kid((int)2).kid((int)j)).symbol;
                                                if (defsites[s.id] == null) {
                                                    defsites[s.id] = new BiList();
                                                }
                                                defsites[s.id].addNew(blk);
                                                syms[s.id] = s;
                                                continue block34;
                                            }
                                        }
                                    }
                                    continue block33;
                                }
                                case 57: 
                                case 58: {
                                    switch (child.kid((int)0).opCode) {
                                        case 6: {
                                            Symbol s = ((LirSymRef)child.kid((int)0)).symbol;
                                            if (defsites[s.id] == null) {
                                                defsites[s.id] = new BiList();
                                            }
                                            defsites[s.id].addNew(blk);
                                            syms[s.id] = s;
                                            break;
                                        }
                                        case 7: {
                                            if (child.kid((int)0).kid((int)0).opCode != 6) break;
                                            Symbol s = ((LirSymRef)child.kid((int)0).kid((int)0)).symbol;
                                            if (defsites[s.id] == null) {
                                                defsites[s.id] = new BiList();
                                            }
                                            defsites[s.id].addNew(blk);
                                            syms[s.id] = s;
                                            break;
                                        }
                                    }
                                    continue block33;
                                }
                            }
                        }
                        break;
                    }
                }
                bp = bp.next();
            }
            p = p.next();
        }
        Util util = new Util(this.env, this.f);
        int i = 0;
        while (true) {
            block58: {
                if (i >= this.f.localSymtab.idBound()) {
                    return;
                }
                if (defsites[i] == null) break block58;
                BiLink p2 = defsites[i].first();
                while (!p2.atEnd()) {
                    BasicBlk blk = (BasicBlk)p2.elem();
                    BiLink q = df.frontiers[blk.id].first();
                    while (!q.atEnd()) {
                        block60: {
                            LirNode phi;
                            BasicBlk frontier;
                            block61: {
                                block59: {
                                    frontier = (BasicBlk)q.elem();
                                    if (this.type != 2) break block59;
                                    LiveVariableAnalysis liveAna = (LiveVariableAnalysis)this.f.require(LiveVariableSlotwise.analyzer);
                                    BiList live = liveAna.liveIn(frontier);
                                    if (live.contains(syms[i])) {
                                        if (inserted[frontier.id] == null) {
                                            inserted[frontier.id] = new BiList();
                                        }
                                        if (!inserted[frontier.id].contains(syms[i])) {
                                            LirNode phi2 = util.makePhiInst(syms[i], frontier);
                                            frontier.instrList().addFirst(phi2);
                                            this.env.println("Insert PHI : " + frontier.instrList().first().elem() + " in block " + frontier.id, 1500);
                                            g.touch();
                                            inserted[frontier.id].addNew(syms[i]);
                                            defsites[i].addNew(frontier);
                                        }
                                    }
                                    break block60;
                                }
                                if (this.type != 1) break block61;
                                if (nonLocal.contains(syms[i])) {
                                    if (inserted[frontier.id] == null) {
                                        inserted[frontier.id] = new BiList();
                                    }
                                    if (!inserted[frontier.id].contains(syms[i])) {
                                        phi = util.makePhiInst(syms[i], frontier);
                                        frontier.instrList().addFirst(phi);
                                        this.env.println("Insert PHI : " + frontier.instrList().first().elem() + " in block " + frontier.id, 1500);
                                        g.touch();
                                        inserted[frontier.id].addNew(syms[i]);
                                        defsites[i].addNew(frontier);
                                    }
                                }
                                break block60;
                            }
                            if (inserted[frontier.id] == null) {
                                inserted[frontier.id] = new BiList();
                            }
                            if (!inserted[frontier.id].contains(syms[i])) {
                                phi = util.makePhiInst(syms[i], frontier);
                                frontier.instrList().addFirst(phi);
                                this.env.println("Insert PHI : " + frontier.instrList().first().elem() + " in block " + frontier.id, 1500);
                                g.touch();
                                inserted[frontier.id].addNew(syms[i]);
                                defsites[i].addNew(frontier);
                            }
                        }
                        q = q.next();
                    }
                    p2 = p2.next();
                }
            }
            ++i;
        }
    }

    private BiList findNonLocal(FlowGraph g) {
        Util util = new Util(this.env, this.f);
        BiList nonlocals = new BiList();
        BiLink p = g.basicBlkList.first();
        while (!p.atEnd()) {
            BasicBlk blk = (BasicBlk)p.elem();
            BiList kill = new BiList();
            BiLink q = blk.instrList().first();
            while (!q.atEnd()) {
                LirNode node = (LirNode)q.elem();
                BiList localDef = new BiList();
                BiList regs = new BiList();
                block0 : switch (node.opCode) {
                    case 48: {
                        regs = util.findTargetLir(node.kid(1), 6, new BiList());
                        switch (node.kid((int)0).opCode) {
                            case 6: {
                                localDef.addNew(((LirSymRef)node.kid((int)0)).symbol);
                                break block0;
                            }
                            case 7: {
                                if (node.kid((int)0).kid((int)0).opCode != 6) break;
                                localDef.addNew(((LirSymRef)node.kid((int)0).kid((int)0)).symbol);
                                break block0;
                            }
                        }
                        regs = util.findTargetLir(node.kid(0), 6, regs);
                        break;
                    }
                    case 53: {
                        regs = util.findTargetLir(node.kid(0), 6, new BiList());
                        regs = util.findTargetLir(node.kid(1), 6, regs);
                        block32: for (int i = 0; i < node.kid(2).nKids(); ++i) {
                            switch (node.kid((int)2).kid((int)i).opCode) {
                                case 6: {
                                    localDef.addNew(((LirSymRef)node.kid((int)2).kid((int)i)).symbol);
                                    continue block32;
                                }
                                case 7: {
                                    if (node.kid((int)2).kid((int)i).kid((int)0).opCode == 6) {
                                        Symbol s = ((LirSymRef)node.kid((int)2).kid((int)i).kid((int)0)).symbol;
                                        localDef.addNew(s);
                                        continue block32;
                                    }
                                }
                                default: {
                                    regs = util.findTargetLir(node.kid(2).kid(i), 6, regs);
                                }
                            }
                        }
                        break;
                    }
                    case 56: {
                        block33: for (int i = 0; i < node.nKids(); ++i) {
                            LirNode child = node.kid(i);
                            switch (child.opCode) {
                                case 48: {
                                    Symbol s;
                                    regs = util.findTargetLir(child.kid(1), 6, regs);
                                    switch (child.kid((int)0).opCode) {
                                        case 6: {
                                            localDef.addNew(((LirSymRef)child.kid((int)0)).symbol);
                                            continue block33;
                                        }
                                        case 7: {
                                            if (child.kid((int)0).kid((int)0).opCode != 6) break;
                                            s = ((LirSymRef)child.kid((int)0).kid((int)0)).symbol;
                                            localDef.addNew(s);
                                            continue block33;
                                        }
                                    }
                                    regs = util.findTargetLir(child.kid(0), 6, regs);
                                    continue block33;
                                }
                                case 53: {
                                    regs = util.findTargetLir(child.kid(0), 6, regs);
                                    regs = util.findTargetLir(child.kid(1), 6, regs);
                                    block34: for (int j = 0; j < child.kid(2).nKids(); ++j) {
                                        switch (child.kid((int)2).kid((int)j).opCode) {
                                            case 6: {
                                                Symbol s = ((LirSymRef)child.kid((int)2).kid((int)j)).symbol;
                                                localDef.addNew(s);
                                                continue block34;
                                            }
                                            case 7: {
                                                Symbol s;
                                                if (child.kid((int)2).kid((int)j).kid((int)0).opCode == 6) {
                                                    s = ((LirSymRef)child.kid((int)2).kid((int)j).kid((int)0)).symbol;
                                                    localDef.addNew(s);
                                                    continue block34;
                                                }
                                            }
                                            default: {
                                                regs = util.findTargetLir(child.kid(2).kid(j), 6, regs);
                                            }
                                        }
                                    }
                                    continue block33;
                                }
                                case 57: 
                                case 58: {
                                    Symbol s;
                                    switch (child.kid((int)0).opCode) {
                                        case 6: {
                                            s = ((LirSymRef)child.kid((int)0)).symbol;
                                            localDef.addNew(s);
                                            continue block33;
                                        }
                                        case 7: {
                                            if (child.kid((int)0).kid((int)0).opCode != 6) break;
                                            s = ((LirSymRef)child.kid((int)0).kid((int)0)).symbol;
                                            localDef.addNew(s);
                                            continue block33;
                                        }
                                    }
                                    regs = util.findTargetLir(child, 6, regs);
                                }
                            }
                        }
                        break;
                    }
                    default: {
                        regs = util.findTargetLir(node, 6, new BiList());
                    }
                }
                BiLink r = regs.first();
                while (!r.atEnd()) {
                    LirSymRef regNode = (LirSymRef)r.elem();
                    if (!kill.contains(regNode.symbol)) {
                        nonlocals.addNew(regNode.symbol);
                    }
                    r = r.next();
                }
                r = localDef.first();
                while (!r.atEnd()) {
                    kill.addNew((Symbol)r.elem());
                    r = r.next();
                }
                q = q.next();
            }
            p = p.next();
        }
        return nonlocals;
    }

    private void renameVariables(BasicBlk blk) {
        int[] count = new int[this.orgSymtabMax];
        for (int i = 0; i < this.orgSymtabMax; ++i) {
            count[i] = 0;
        }
        BiLink p = blk.instrList().first();
        while (!p.atEnd()) {
            LirNode node = (LirNode)p.elem();
            if (node.opCode != 59 && node.opCode != 54) {
                this.renameSymbolToStackTop(node);
            }
            if (node.opCode == 48 && node.kid((int)0).opCode == 6 || node.opCode == 59 || node.opCode == 54 || node.opCode == 53 && node.kid(2).nKids() > 0 && node.kid((int)2).kid((int)0).opCode == 6) {
                if (this.withCopyFold && node.opCode == 48 && node.kid((int)0).opCode == 6 && node.kid((int)1).opCode == 6) {
                    LirSymRef symRefDst = (LirSymRef)node.kid(0);
                    int num = symRefDst.symbol.id;
                    if (this.stack[num] == null) {
                        this.makeNewStack(num, symRefDst.symbol);
                    }
                    this.stack[num].push(((LirSymRef)node.kid((int)1)).symbol);
                    int n = num;
                    count[n] = count[n] + 1;
                    this.env.println("Copy Folding : remove " + node + " in block " + blk.id, 2000);
                    p.unlink();
                    this.f.flowGraph().touch();
                } else if (node.opCode == 48 && node.kid((int)0).opCode == 6 || node.opCode == 59) {
                    LirSymRef symRef = (LirSymRef)node.kid(0);
                    node.setKid(0, this.makeNewReg(symRef, count));
                    this.f.flowGraph().touch();
                } else if (node.opCode == 54) {
                    for (int i = 0; i < node.nKids(); ++i) {
                        if (node.kid((int)i).opCode != 6) continue;
                        LirSymRef symRef = (LirSymRef)node.kid(i);
                        node.setKid(i, this.makeNewReg(symRef, count));
                        this.f.flowGraph().touch();
                    }
                } else {
                    LirSymRef symRef = (LirSymRef)node.kid(2).kid(0);
                    node.kid(2).setKid(0, this.makeNewReg(symRef, count));
                    this.f.flowGraph().touch();
                }
            }
            p = p.next();
        }
        p = blk.succList().first();
        while (!p.atEnd()) {
            BasicBlk succ = (BasicBlk)p.elem();
            BiLink q = succ.instrList().first();
            while (!q.atEnd()) {
                LirNode node = (LirNode)q.elem();
                if (node.opCode != 59) break;
                for (int i = 1; i < node.nKids(); ++i) {
                    if (blk.label().basicBlk() != ((LirLabelRef)node.kid((int)i).kid((int)1)).label.basicBlk()) continue;
                    LirSymRef symRef = (LirSymRef)node.kid(i).kid(0);
                    int num = symRef.symbol.id;
                    if (this.stack[num] == null) {
                        this.makeNewStack(num, symRef.symbol);
                    }
                    Symbol sym = (Symbol)this.stack[num].peek();
                    LirSymRef newSymRef = (LirSymRef)this.env.lir.symRef(6, sym.type, sym, ImList.Empty);
                    node.kid(i).setKid(0, newSymRef);
                    this.f.flowGraph().touch();
                }
                q = q.next();
            }
            p = p.next();
        }
        p = this.dom.kids[blk.id].first();
        while (!p.atEnd()) {
            this.renameVariables((BasicBlk)p.elem());
            p = p.next();
        }
        for (int i = 0; i < this.orgSymtabMax; ++i) {
            if (count[i] <= 0) continue;
            for (int j = 0; j < count[i]; ++j) {
                this.stack[i].pop();
            }
        }
    }

    private void makeNewStack(int num, Symbol symbol) {
        this.stack[num] = new BiListAsStack();
        Symbol s = this.sstab.newSsaSymbol(symbol);
        this.stack[num].push(s);
        this.initVariables.add(s);
    }

    private void makeInitStmts() {
        BasicBlk entryBlk = this.f.flowGraph().entryBlk();
        BiLink lastStmt = entryBlk.instrList().last();
        BiLink p = this.initVariables.first();
        while (!p.atEnd()) {
            Symbol s = (Symbol)p.elem();
            LirNode regNode = this.env.lir.symRef(s);
            LirNode zeroNode = null;
            if (Type.tag(s.type) == 2) {
                zeroNode = this.env.lir.iconst(s.type, 0L, ImList.Empty);
            } else if (Type.tag(s.type) == 4) {
                zeroNode = this.env.lir.fconst(s.type, 0.0, ImList.Empty);
            }
            LirNode setNode = this.env.lir.operator(48, s.type, regNode, zeroNode, ImList.Empty);
            lastStmt.addBefore(setNode);
            p = p.next();
        }
    }

    private void renameSymbolToStackTop(LirNode node) {
        int i = 0;
        int end = 0;
        end = node.opCode == 53 && node.kid(2).nKids() > 0 && node.kid((int)2).kid((int)0).opCode == 6 ? 2 : node.nKids();
        for (i = node.opCode == 48 && node.kid((int)0).opCode == 6 ? 1 : 0; i < end; ++i) {
            if (node.kid((int)i).opCode == 6) {
                LirSymRef symRef = (LirSymRef)node.kid(i);
                int num = symRef.symbol.id;
                if (this.stack[num] == null) {
                    this.makeNewStack(num, symRef.symbol);
                }
                Symbol sym = (Symbol)this.stack[num].peek();
                LirSymRef newSymRef = (LirSymRef)this.env.lir.symRef(6, sym.type, sym, ImList.Empty);
                node.setKid(i, newSymRef);
                this.f.flowGraph().touch();
                continue;
            }
            this.renameSymbolToStackTop(node.kid(i));
        }
    }

    private LirSymRef makeNewReg(LirSymRef symRef, int[] count) {
        int num = symRef.symbol.id;
        if (this.stack[num] == null) {
            this.makeNewStack(num, symRef.symbol);
        }
        this.stack[num].push(this.sstab.newSsaSymbol(symRef.symbol));
        int n = num;
        count[n] = count[n] + 1;
        Symbol sym = (Symbol)this.stack[num].peek();
        LirSymRef newSymRef = (LirSymRef)this.env.lir.symRef(6, sym.type, sym, ImList.Empty);
        return newSymRef;
    }

    private class BiListAsStack {
        private BiList list = new BiList();

        BiListAsStack() {
        }

        Object pop() {
            return this.list.takeFirst();
        }

        void push(Object o) {
            this.list.addFirst(o);
        }

        Object peek() {
            return this.list.first().elem();
        }
    }
}

