/*
 * Decompiled with CFR 0.152.
 */
package coins.sym;

import coins.SymRoot;
import coins.ir.IrList;
import coins.sym.Elem;
import coins.sym.Sym;
import coins.sym.SymImpl;
import coins.sym.SymTable;
import coins.sym.Type;
import coins.sym.TypeImpl;
import coins.sym.UnionType;
import java.util.ListIterator;

public class UnionTypeImpl
extends TypeImpl
implements UnionType {
    protected IrList fElemList = null;
    protected SymTable fLocalSymTable;
    protected Sym fTag;
    protected int fAlignment;

    public UnionTypeImpl(SymRoot pSymRoot, String pTypeName, IrList pElemList) {
        super(pSymRoot);
        this.fKind = 13;
        this.fType = this;
        this.fTypeKind = 25;
        this.fAlignment = Type.KIND_ALIGNMENT[25];
        if (pElemList == null) {
            this.fElemList = this.symRoot.getHirRoot().hir.irList(null);
            this.setFlag(11, true);
            this.fCompleteType = null;
        } else {
            this.fElemList = pElemList;
        }
        this.fName = pTypeName;
        if (pElemList != null) {
            this.finishUnionType(false);
        } else {
            this.setFlag(12, false);
        }
    }

    public SymTable getSymTable() {
        return this.fLocalSymTable;
    }

    public void setSymTable(SymTable pSymTable) {
        this.fLocalSymTable = pSymTable;
    }

    public IrList getElemList() {
        return this.fElemList;
    }

    public void addElem(Elem pElem) {
        if (this.fElemList == null) {
            this.fElemList = this.symRoot.getHirRoot().hir.irList();
        }
        this.fElemList.add(pElem);
        pElem.setDisplacement(0L);
        pElem.setDispExp(this.symRoot.getHirRoot().hir.constNode(this.symRoot.intConst0));
    }

    public void finishUnionType(boolean pSeparately) {
        long lResidue;
        Type lMaxSizeType = null;
        String lName = this.symRoot.sym.makeStructUnionTypeName(false, this.fElemList);
        if (this.fDbgLevel > 3) {
            this.symRoot.ioRoot.dbgSym.print(4, "finishUnionType", this.getName());
        }
        long lMaxSize = 0L;
        int lAlignment = 0;
        int lAlignmentGap = 0;
        boolean lIncomplete = false;
        boolean lSizeIsSet = true;
        boolean lUniformSize = true;
        ListIterator lElemIterator = this.fElemList.iterator();
        while (lElemIterator.hasNext()) {
            Elem lElem = (Elem)lElemIterator.next();
            if (lElem == null) continue;
            Type lElemType = lElem.getSymType();
            lElem.setDisplacement(0L);
            lElem.setDispExp(this.symRoot.getHirRoot().hir.constNode(this.symRoot.intConst0));
            long lSize = lElemType.getSizeValue();
            int lElemAlignment = lElemType.getAlignment();
            if (lElemAlignment > lAlignment) {
                lAlignment = lElemAlignment;
            }
            if (lElemType.getFlag(11)) {
                lIncomplete = true;
                lUniformSize = false;
            }
            if (!lElemType.getFlag(12)) {
                lUniformSize = false;
            }
            if (!lElemType.isSizeEvaluable()) {
                lSizeIsSet = false;
            }
            if (lSize > lMaxSize) {
                lMaxSize = lSize;
                lMaxSizeType = lElemType;
            }
            if (lElemType.isConst()) {
                this.fConst = true;
            }
            if (lElemType.isVolatile()) {
                this.fVolatile = true;
            }
            if (lElemType.getFlag(17)) {
                this.symRoot.ioRoot.msgWarning.put("Union " + this.getName() + " has unfixed size element " + lElem.getName());
                this.setFlag(17, true);
            }
            if (this.fDbgLevel <= 3) continue;
            this.symRoot.ioRoot.dbgSym.print(4, " elem " + lElem.getName() + " size " + lSize + " incomp " + lElemType.getFlag(11));
        }
        if (lMaxSizeType != null && (lResidue = lMaxSize % (long)lAlignment) != 0L) {
            lAlignmentGap = (int)((long)lAlignment - lResidue);
        }
        this.setSizeValue(lMaxSize += (long)lAlignmentGap);
        lName = this.symRoot.sym.makeStructUnionTypeName(false, this.fElemList);
        if (pSeparately) {
            if (this.fOrigin == null) {
                this.fOrigin = ((SymImpl)this.symRoot.sym).unionType(lName, this.fElemList, null);
            }
        } else if (this.fOrigin == null) {
            this.fOrigin = this;
        }
        if (lIncomplete) {
            this.fCompleteType = null;
            lUniformSize = false;
        } else {
            this.fCompleteType = this.fOrigin != null ? this.fOrigin : this;
        }
        this.fAlignment = lAlignment;
        this.setFlag(11, lIncomplete);
        this.setFlag(12, lUniformSize);
    }

    public int getAlignment() {
        return this.fAlignment;
    }

    public Sym getTag() {
        return this.fTag;
    }

    public void setTag(Sym pTag) {
        this.fTag = pTag;
    }

    public boolean isCompatibleWith(Type pType) {
        if (pType == this) {
            return true;
        }
        if (pType == null || !(pType instanceof UnionType)) {
            return false;
        }
        if (pType.isConst() == this.isConst() && pType.isVolatile() == this.isVolatile() && this.getOrigin() != null) {
            if (this.getOrigin() == this || ((UnionType)pType).getOrigin() == this) {
                return true;
            }
            if (this.getFinalOrigin().isCompatibleWith(((UnionType)pType).getFinalOrigin())) {
                return true;
            }
        }
        return false;
    }

    public Type getCompleteType() {
        if (this.getFlag(11)) {
            if (this.getOrigin() != null) {
                return this.getOrigin().getCompleteType();
            }
            return null;
        }
        return this;
    }

    public void setAlignment(int pAlignment) {
        this.fAlignment = pAlignment;
    }

    public String toStringDetail() {
        String symString = super.toStringDetail();
        symString = this.fTag != null ? symString + " tag " + this.fTag.getName() : symString + " tag null";
        return symString;
    }
}

