/*
 * Decompiled with CFR 0.152.
 */
package coins.sym;

import coins.SymRoot;
import coins.ir.hir.ConstNode;
import coins.ir.hir.Exp;
import coins.sym.Type;
import coins.sym.TypeImpl;
import coins.sym.VectorType;

public class VectorTypeImpl
extends TypeImpl
implements VectorType {
    Type fElemType = null;
    long fElemCount = 0L;
    Exp fElemCountExp = null;
    long fLowerBound = 0L;
    Exp fLowerBoundExp = null;
    int fDimension = 0;
    int fAlignment;

    public VectorTypeImpl(SymRoot pSymRoot, String pTypeName, Type pElemType, long pElemCount) {
        super(pSymRoot);
        this.setVectorTypeFields(pTypeName, pElemType, pElemCount, null, 0L, null);
    }

    public VectorTypeImpl(SymRoot pSymRoot, String pTypeName, Type pElemType, long pElemCount, Exp pElemCountExp, long pLowerBound, Exp pLowerBoundExp) {
        super(pSymRoot);
        this.setVectorTypeFields(pTypeName, pElemType, pElemCount, pElemCountExp, pLowerBound, pLowerBoundExp);
    }

    public VectorTypeImpl(SymRoot pSymRoot, Type pElemType, long pElemCount) {
        super(pSymRoot);
        this.setVectorTypeFields(null, pElemType, pElemCount, null, 0L, null);
    }

    protected void setVectorTypeFields(String pTypeName, Type pElemType, long pElemCount, Exp pElemCountExp, long pLowerBound, Exp pLowerBoundExp) {
        long lSize = 0L;
        this.fKind = 13;
        this.fType = this;
        this.fTypeKind = 23;
        this.fElemType = pElemType;
        if (pElemType.getFlag(17) || pElemType instanceof VectorType && ((VectorType)pElemType).getElemCount() <= 0L && ((VectorType)pElemType).getElemCountExp() == null) {
            this.symRoot.ioRoot.msgWarning.put("Element type of VectorType is unfixed length type " + pTypeName);
        }
        if (pElemCountExp != null) {
            this.fElemCountExp = pElemCountExp;
            if (pElemCountExp.isEvaluable()) {
                this.fElemCount = pElemCountExp.evaluateAsInt();
            }
        } else {
            this.fElemCount = pElemCount;
            this.fElemCountExp = pElemCount > 0L ? this.symRoot.getHirRoot().hir.intConstNode(pElemCount) : this.symRoot.getHirRoot().hir.intConstNode(0);
        }
        if (pElemCount > 0L) {
            this.setFlag(12, pElemType.getFlag(12));
        } else {
            this.setFlag(12, false);
        }
        if (pLowerBoundExp != null) {
            this.fLowerBoundExp = pLowerBoundExp;
            if (pLowerBoundExp.isEvaluable()) {
                this.fLowerBound = pLowerBoundExp.evaluateAsInt();
            }
        } else {
            this.fLowerBound = pLowerBound;
            this.fLowerBoundExp = this.symRoot.getHirRoot().hir.intConstNode(pLowerBound);
        }
        this.fDimension = pElemType != null ? pElemType.getDimension() + 1 : 1;
        this.fName = pTypeName != null ? pTypeName : this.makeVectorTypeName(pElemType, this.fElemCountExp, this.fElemCount, this.fLowerBoundExp, this.fLowerBound);
        if (this.fElemCountExp != null) {
            if (!this.fElemCountExp.isEvaluable() || pElemType.getSizeValue() <= 0L) {
                this.setSizeExp(this.symRoot.getHirRoot().hir.exp(41, (Exp)pElemType.getSizeExp().copyWithOperands(), (Exp)this.fElemCountExp.copyWithOperands()));
            } else {
                this.setSizeValue(pElemType.getSizeValue() * this.fElemCount);
            }
        } else if (pElemType.getSizeExp() != null) {
            this.setSizeExp(this.symRoot.getHirRoot().hir.exp(41, (Exp)pElemType.getSizeExp().copyWithOperands(), this.symRoot.getHirRoot().hir.offsetConstNode(pElemCount)));
        } else {
            this.setSizeValue(pElemType.getSizeValue() * this.fElemCount);
        }
        if (this.fElemCount <= 0L) {
            this.setFlag(11, true);
            this.setFlag(12, false);
            if (this.fElemCountExp == null) {
                this.setFlag(17, true);
            }
        }
        if (pElemType.getFlag(17)) {
            this.setFlag(17, true);
        }
        this.fAlignment = pElemType.getAlignment();
        if (this.fDbgLevel > 2) {
            this.symRoot.ioRoot.dbgSym.print(3, "\n VectorType " + this.fName + " size " + this.getSizeValue() + " " + " count " + this.fElemCount + " LB " + this.fLowerBound);
        }
        if (this.getSizeExp() != null && this.fDbgLevel > 2) {
            this.symRoot.ioRoot.dbgSym.print(3, " sizeExp " + this.getSizeExp().toStringWithChildren());
        }
    }

    public int getDimension() {
        return this.fDimension;
    }

    public Type getElemType() {
        return this.fElemType;
    }

    public long getElemCount() {
        return this.fElemCount;
    }

    public Exp getElemCountExp() {
        return this.fElemCountExp;
    }

    public long getLowerBound() {
        return this.fLowerBound;
    }

    public Exp getLowerBoundExp() {
        return this.fLowerBoundExp;
    }

    public boolean isCompatibleWith(Type pType) {
        Type lElemType;
        if (pType == this) {
            return true;
        }
        if (pType.getTypeKind() == 23 && (lElemType = ((VectorType)pType).getElemType()).isCompatibleWith(this.fElemType) && pType.isConst() == this.isConst() && pType.isVolatile() == this.isVolatile()) {
            if (pType.getFlag(11)) {
                return true;
            }
            if (((VectorType)pType).getElemCount() == this.fElemCount) {
                return true;
            }
        }
        return false;
    }

    public boolean isRectangularArray() {
        return this.getFlag(12);
    }

    public int getAlignment() {
        return this.fAlignment;
    }

    public void setAlignment(int pAlignment) {
        this.fAlignment = pAlignment;
    }

    public String toString() {
        String lSymString = super.toStringShort();
        if (this.getSizeValue() > 0L) {
            lSymString = lSymString + " size " + this.getSizeValue();
        } else if (this.getSizeExp() != null) {
            lSymString = lSymString + " sizeExp " + this.getSizeExp().toStringWithChildren();
        }
        lSymString = lSymString + " elemCount ";
        lSymString = this.fElemCount > 0L ? lSymString + this.getElemCount() : (this.fElemCountExp != null ? lSymString + this.makeExpString(this.getElemCountExp()) : lSymString + "unfixed");
        lSymString = this.fLowerBoundExp != null && !(this.fLowerBoundExp instanceof ConstNode) ? lSymString + " lowerBound " + this.makeExpString(this.getLowerBoundExp()) : lSymString + " lowerBound " + this.getLowerBound();
        return lSymString;
    }

    public String toStringDetail() {
        String lSymString = this.getSymKindName() + " " + super.toStringShort();
        if (!this.fFlagBox.allFalse()) {
            lSymString = lSymString + ((Object)this.fFlagBox).toString();
        }
        if (this.getSizeValue() > 0L) {
            lSymString = lSymString + " size " + this.getSizeValue();
        } else if (this.getSizeExp() != null) {
            lSymString = lSymString + " sizeExp " + this.getSizeExp().toStringWithChildren();
        }
        if (this.getFlag(17)) {
            lSymString = lSymString + " unfixedSize";
        }
        if (this.fElemCount > 0L) {
            lSymString = lSymString + " elemCount " + this.getElemCount();
        } else if (this.fElemCountExp != null) {
            lSymString = lSymString + " elemCount " + this.getElemCountExp().toStringWithChildren();
        }
        lSymString = this.fLowerBoundExp != null && !(this.fLowerBoundExp instanceof ConstNode) ? lSymString + " lowerBound " + this.getLowerBoundExp().toStringWithChildren() : lSymString + " lowerBound " + this.getLowerBound();
        return lSymString;
    }
}

