/*
 * Decompiled with CFR 0.152.
 */
package coins.util;

import coins.util.IntConst;
import java.math.BigDecimal;
import java.math.BigInteger;

public abstract class FloatConst {
    public static final FloatConst F32_0 = F.F32_0;
    public static final FloatConst F32_1 = F.F32_1;
    public static final FloatConst F64_0 = D.F64_0;
    public static final FloatConst F64_1 = D.F64_1;
    private static final int M_MIN = 3;
    private static final int M_MAX = 0x3FFFFFFF;
    private static final int E_MIN = 2;
    private static final int E_MAX = 30;
    public static final RoundingMode ROUND_NEAREST = new RoundingMode(){

        long toLong(double d) {
            return (long)StrictMath.rint(d);
        }

        BigInteger round(BigInteger b, boolean s, int rs) {
            if (rs > 2 || rs == 2 && b.testBit(0)) {
                b = b.add(BigInteger.ONE);
            }
            return b;
        }
    };
    public static final RoundingMode ROUND_MINUS = new RoundingMode(){

        long toLong(double d) {
            return (long)StrictMath.floor(d);
        }

        BigInteger round(BigInteger b, boolean s, int rs) {
            if (s && rs != 0) {
                b = b.add(BigInteger.ONE);
            }
            return b;
        }
    };
    public static final RoundingMode ROUND_PLUS = new RoundingMode(){

        long toLong(double d) {
            return (long)StrictMath.ceil(d);
        }

        BigInteger round(BigInteger b, boolean s, int rs) {
            if (!s && rs != 0) {
                b = b.add(BigInteger.ONE);
            }
            return b;
        }
    };
    public static final RoundingMode ROUND_ZERO = new RoundingMode(){

        long toLong(double d) {
            return (long)d;
        }

        BigInteger round(BigInteger b, boolean s, int rs) {
            return b;
        }
    };

    private FloatConst() {
    }

    public static FloatConst valueOf(int msize, int esize, double val) {
        int rs;
        BigInteger m;
        boolean s;
        if (msize == 24 && esize == 8) {
            return F.valueOf((float)val);
        }
        if (msize == 53 && esize == 11) {
            return D.valueOf(val);
        }
        if (msize < 3 || msize > 0x3FFFFFFF) {
            throw new IllegalArgumentException(msize + "+" + esize);
        }
        if (esize < 2 || esize > 30) {
            throw new IllegalArgumentException(msize + "+" + esize);
        }
        long l = Double.doubleToLongBits(val);
        int e1 = (int)(l >> 52) & 0x7FF;
        long m1 = l & 0xFFFFFFFFFFFFFL;
        boolean bl = s = l < 0L;
        if (e1 > FloatConst.emax(11)) {
            if (m1 == 0L) {
                return G.infinity(msize, esize, s);
            }
            return G.nan(msize, esize, BigInteger.valueOf(m1).shiftLeft(msize - 53), s);
        }
        int e = e1 - FloatConst.bias(11) + FloatConst.bias(esize);
        if (e1 == 0) {
            if (m1 == 0L) {
                return G.zero(msize, esize, s);
            }
            ++e;
            do {
                --e;
            } while ((m1 <<= 1) < 0x10000000000000L);
        } else {
            m1 |= 0x10000000000000L;
        }
        if (msize >= 53) {
            m = BigInteger.valueOf(m1).shiftLeft(msize - 53);
            rs = 0;
        } else {
            int i = 53 - msize;
            m = BigInteger.valueOf(m1 >> i);
            long t = 1L << i - 1;
            rs = ((m1 & t - 1L) != 0L ? 1 : 0) + ((m1 & t) != 0L ? 2 : 0);
        }
        return G.number(msize, esize, m, e, s, rs);
    }

    public static FloatConst valueOf(int msize, int esize, BigDecimal val) {
        int e;
        BigInteger b;
        if (msize == 24 && esize == 8) {
            return new F(val.floatValue());
        }
        if (msize == 53 && esize == 11) {
            return new D(val.doubleValue());
        }
        if (msize < 3 || msize > 0x3FFFFFFF) {
            throw new IllegalArgumentException(msize + "+" + esize);
        }
        if (esize < 2 || esize > 30) {
            throw new IllegalArgumentException(msize + "+" + esize);
        }
        if (val.signum() == 0) {
            return G.zero(msize, esize, false);
        }
        if (val.scale() == 0) {
            return FloatConst.valueOf(msize, esize, val.toBigInteger());
        }
        boolean s = false;
        if (val.signum() < 0) {
            val = val.negate();
            boolean bl = s = !s;
        }
        if (val.compareTo(FloatConst.fromBigIntegerBits(msize + 1, esize, b = BigInteger.ONE).toBigDecimal()) <= 0) {
            return G.zero(msize, esize, s);
        }
        int k = 0;
        int i = msize + 1 - 1 + esize;
        while (i > 1) {
            BigInteger b1;
            BigDecimal bd;
            if ((k = val.compareTo(bd = FloatConst.fromBigIntegerBits(msize + 1, esize, b1 = b.setBit(--i)).toBigDecimal())) >= 0) {
                b = b1;
            }
            if (k != 0) continue;
            break;
        }
        b = b.add(BigInteger.ONE).shiftRight(1);
        if (k == 0 && b.testBit(0)) {
            b = b.subtract(BigInteger.ONE);
        }
        if ((e = b.shiftRight(msize - 1).intValue() & (1 << esize) - 1) > FloatConst.emax(esize)) {
            return G.infinity(msize, esize, s);
        }
        FloatConst c = FloatConst.fromBigIntegerBits(msize, esize, b);
        return s ? c.neg() : c;
    }

    public static FloatConst valueOf(int msize, int esize, long val) {
        if (msize == 24 && esize == 8) {
            return F.valueOf(val);
        }
        if (msize == 53 && esize == 11) {
            return D.valueOf(val);
        }
        return FloatConst.valueOf(msize, esize, BigInteger.valueOf(val));
    }

    public static FloatConst valueOf(int msize, int esize, BigInteger val) {
        if (msize == 24 && esize == 8) {
            return F.valueOf(val.floatValue());
        }
        if (msize == 53 && esize == 11) {
            return D.valueOf(val.doubleValue());
        }
        if (msize < 3 || msize > 0x3FFFFFFF) {
            throw new IllegalArgumentException(msize + "+" + esize);
        }
        if (esize < 2 || esize > 30) {
            throw new IllegalArgumentException(msize + "+" + esize);
        }
        if (val.signum() == 0) {
            return G.zero(msize, esize, false);
        }
        boolean s = false;
        if (val.signum() < 0) {
            val = val.negate();
            s = true;
        }
        int j = val.bitLength();
        int e = j - 1 + FloatConst.bias(esize);
        BigInteger m = val.shiftRight(j -= msize);
        int rs = 0;
        if (j > 0) {
            rs = (val.and(FloatConst.mask(j - 1)).signum() != 0 ? 1 : 0) + (val.testBit(j - 1) ? 2 : 0);
        }
        return G.number(msize, esize, m, e, s, rs);
    }

    public static FloatConst fromBigIntegerBits(int msize, int esize, BigInteger bits) {
        if (msize == 24 && esize == 8) {
            return F.valueOf(Float.intBitsToFloat(bits.intValue()));
        }
        if (msize == 53 && esize == 11) {
            return D.valueOf(Double.longBitsToDouble(bits.longValue()));
        }
        BigInteger m = bits.and(FloatConst.mask(msize - 1));
        int e = bits.shiftRight(msize - 1).intValue() & (1 << esize) - 1;
        if (e > FloatConst.emax(esize) && m.signum() != 0) {
            m = m.or(BigInteger.ONE.shiftLeft(msize - 2));
        }
        if (e != 0) {
            m = m.or(BigInteger.ONE.shiftLeft(msize - 1));
        }
        boolean s = bits.testBit(msize - 1 + esize);
        return G.valueOf(msize, esize, m, e, s);
    }

    public static FloatConst fromExplicitBigIntegerBits(int msize, int esize, BigInteger bits) {
        BigInteger m = bits.and(FloatConst.mask(msize));
        int e = bits.shiftRight(msize).intValue() & (1 << esize) - 1;
        if (e > FloatConst.emax(esize)) {
            if (m.signum() != 0) {
                m = m.or(BigInteger.ONE.shiftLeft(msize - 2));
            }
            m = m.or(BigInteger.ONE.shiftLeft(msize - 1));
        } else if (e == 0) {
            if (m.testBit(msize - 1)) {
                e = 1;
            }
        } else if (!m.testBit(msize - 1)) {
            int j = msize - m.bitLength();
            if (j == 0) {
                e = 0;
            } else {
                if (j > e - 1) {
                    j = e - 1;
                    --e;
                }
                m = m.shiftLeft(j);
                e -= j;
            }
        }
        boolean s = bits.testBit(msize + esize);
        if (msize == 24 && esize == 8) {
            return F.valueOf(m, e, s);
        }
        if (msize == 53 && esize == 11) {
            return D.valueOf(m, e, s);
        }
        return G.valueOf(msize, esize, m, e, s);
    }

    public abstract int msize();

    public abstract int esize();

    public abstract FloatConst add(FloatConst var1);

    public abstract FloatConst sub(FloatConst var1);

    public abstract FloatConst mul(FloatConst var1);

    public abstract FloatConst div(FloatConst var1);

    public abstract FloatConst neg();

    public abstract IntConst tsteq(FloatConst var1, int var2);

    public abstract IntConst tstne(FloatConst var1, int var2);

    public abstract IntConst tstlts(FloatConst var1, int var2);

    public abstract IntConst tstgts(FloatConst var1, int var2);

    public abstract IntConst tstles(FloatConst var1, int var2);

    public abstract IntConst tstges(FloatConst var1, int var2);

    public abstract FloatConst convfx(int var1, int var2);

    public abstract FloatConst convft(int var1, int var2);

    public abstract IntConst convfi(int var1, RoundingMode var2);

    public abstract float floatValue();

    public abstract double doubleValue();

    public abstract BigDecimal toBigDecimal();

    public abstract BigInteger toBigInteger(RoundingMode var1);

    public abstract BigInteger toBigIntegerBits();

    public abstract BigInteger toExplicitBigIntegerBits();

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    public abstract String toString();

    public abstract String toDecimalString();

    private static int bias(int esize) {
        return (1 << esize - 1) - 1;
    }

    private static int emax(int esize) {
        return (1 << esize) - 2;
    }

    private static BigInteger mask(int i) {
        return BigInteger.ONE.shiftLeft(i).subtract(BigInteger.ONE);
    }

    private static final class G
    extends FloatConst {
        private final int msize;
        private final int esize;
        private final BigInteger m;
        private final int e;
        private final boolean s;

        private G(int msize, int esize, BigInteger man, int exp, boolean sign) {
            this.msize = msize;
            this.esize = esize;
            this.m = man;
            this.e = exp;
            this.s = sign;
        }

        static G valueOf(int msize, int esize, BigInteger m, int e, boolean s) {
            return new G(msize, esize, m, e, s);
        }

        static G number(int msize, int esize, BigInteger m, int e, boolean s, int rs) {
            if (m.testBit(msize)) {
                rs = (rs != 0 ? 1 : 0) + (m.testBit(0) ? 2 : 0);
                m = m.shiftRight(1);
                ++e;
            }
            if (e <= 0) {
                if (e < -msize) {
                    e = -msize;
                }
                rs = (rs != 0 || m.and(FloatConst.mask(-e)).signum() != 0 ? 1 : 0) + (m.testBit(-e) ? 2 : 0);
                m = m.shiftRight(1 - e);
                e = 0;
                if ((rs > 2 || rs == 2 && m.testBit(0)) && (m = m.add(BigInteger.ONE)).testBit(msize - 1)) {
                    e = 1;
                }
                return G.valueOf(msize, esize, m, e, s);
            }
            if ((rs > 2 || rs == 2 && m.testBit(0)) && (m = m.add(BigInteger.ONE)).testBit(msize)) {
                m = m.shiftRight(1);
                ++e;
            }
            if (e > FloatConst.emax(esize)) {
                return G.infinity(msize, esize, s);
            }
            return G.valueOf(msize, esize, m, e, s);
        }

        static G zero(int msize, int esize, boolean s) {
            return G.valueOf(msize, esize, BigInteger.ZERO, 0, s);
        }

        static G infinity(int msize, int esize, boolean s) {
            return G.valueOf(msize, esize, BigInteger.ONE.shiftLeft(msize - 1), FloatConst.emax(esize) + 1, s);
        }

        static G nan(int msize, int esize) {
            return G.valueOf(msize, esize, BigInteger.valueOf(3L).shiftLeft(msize - 2), FloatConst.emax(esize) + 1, false);
        }

        static G nan(int msize, int esize, BigInteger m, boolean s) {
            return G.valueOf(msize, esize, m.setBit(msize - 1).setBit(msize - 2), FloatConst.emax(esize) + 1, s);
        }

        public int msize() {
            return this.msize;
        }

        public int esize() {
            return this.esize;
        }

        public FloatConst add(FloatConst c) {
            if (c.msize() != this.msize || c.esize() != this.esize) {
                throw new IllegalArgumentException(this + " " + c);
            }
            G g = (G)c;
            return g.s == this.s ? G.add1(this.msize, this.esize, this.m, g.m, this.e, g.e, this.s) : G.sub1(this.msize, this.esize, this.m, g.m, this.e, g.e, this.s);
        }

        public FloatConst sub(FloatConst c) {
            if (c.msize() != this.msize || c.esize() != this.esize) {
                throw new IllegalArgumentException(this + " " + c);
            }
            G g = (G)c;
            return g.s == this.s ? G.sub1(this.msize, this.esize, this.m, g.m, this.e, g.e, this.s) : G.add1(this.msize, this.esize, this.m, g.m, this.e, g.e, this.s);
        }

        private static G add1(int msize, int esize, BigInteger m0, BigInteger m1, int e0, int e1, boolean s) {
            int i;
            if (e0 < e1 || e0 == e1 && m0.compareTo(m1) < 0) {
                BigInteger m = m0;
                m0 = m1;
                m1 = m;
                int e = e0;
                e0 = e1;
                e1 = e;
            }
            if (e0 > FloatConst.emax(esize)) {
                return G.valueOf(msize, esize, m0, e0, s);
            }
            if (e1 == 0) {
                if (m1.signum() == 0) {
                    return G.valueOf(msize, esize, m0, e0, s);
                }
                if (e0 == 0) {
                    int j = msize - m0.bitLength();
                    e0 = 1 - j;
                    m0 = m0.shiftLeft(j);
                }
                int j = msize - m1.bitLength();
                e1 = 1 - j;
                m1 = m1.shiftLeft(j);
            }
            if ((i = e0 - e1) > msize + 1) {
                i = msize + 1;
            }
            BigInteger m = m0.add(m1.shiftRight(i));
            int rs = (i > 1 && m1.and(FloatConst.mask(i - 1)).signum() != 0 ? 1 : 0) + (i >= 1 && m1.testBit(i - 1) ? 2 : 0);
            return G.number(msize, esize, m, e0, s, rs);
        }

        private static G sub1(int msize, int esize, BigInteger m0, BigInteger m1, int e0, int e1, boolean s) {
            int rs;
            if (e0 < e1 || e0 == e1 && m0.compareTo(m1) < 0) {
                BigInteger m = m0;
                m0 = m1;
                m1 = m;
                int e = e0;
                e0 = e1;
                e1 = e;
                boolean bl = s = !s;
            }
            if (e0 > FloatConst.emax(esize)) {
                if (e1 > FloatConst.emax(esize) && m0.and(FloatConst.mask(msize - 1)).signum() == 0) {
                    return G.nan(msize, esize);
                }
                return G.valueOf(msize, esize, m0, e0, s);
            }
            if (e1 == 0) {
                if (m1.signum() == 0) {
                    if (e0 == 0 && m0.signum() == 0) {
                        return G.zero(msize, esize, false);
                    }
                    return G.valueOf(msize, esize, m0, e0, s);
                }
                if (e0 == 0) {
                    int j = msize - m0.bitLength();
                    e0 = 1 - j;
                    m0 = m0.shiftLeft(j);
                }
                int j = msize - m1.bitLength();
                e1 = 1 - j;
                m1 = m1.shiftLeft(j);
            }
            int i = e0 - e1 - 1;
            BigInteger m = m0.shiftLeft(1).subtract(m1.shiftRight(i));
            if (m.signum() == 0) {
                return G.zero(msize, esize, false);
            }
            int e = e0 - 1;
            int j = msize - m.bitLength();
            if (j > 0) {
                m = m.shiftLeft(j);
                rs = 0;
                e -= j;
            } else {
                rs = (i > 1 && m1.and(FloatConst.mask(i - 1)).signum() != 0 ? 1 : 0) + (i >= 1 && m1.testBit(i - 1) ? 2 : 0);
                if (rs != 0) {
                    m = m.subtract(BigInteger.ONE);
                }
            }
            return G.number(msize, esize, m, e, s, rs);
        }

        public FloatConst mul(FloatConst c) {
            BigInteger m2;
            if (c.msize() != this.msize || c.esize() != this.esize) {
                throw new IllegalArgumentException(this + " " + c);
            }
            G g = (G)c;
            BigInteger m0 = this.m;
            BigInteger m1 = g.m;
            int e0 = this.e;
            int e1 = g.e;
            boolean s0 = this.s;
            boolean s2 = this.s ^ g.s;
            if (e0 < e1 || e0 == e1 && m0.compareTo(m1) < 0) {
                BigInteger m = m0;
                m0 = m1;
                m1 = m;
                int e = e0;
                e0 = e1;
                e1 = e;
                s0 = g.s;
            }
            if (e0 > FloatConst.emax(this.esize)) {
                if (m0.and(FloatConst.mask(this.msize - 1)).signum() != 0) {
                    return G.valueOf(this.msize, this.esize, m0, e0, s0);
                }
                if (e1 == 0 && m1.signum() == 0) {
                    return G.nan(this.msize, this.esize);
                }
                return G.infinity(this.msize, this.esize, s2);
            }
            if (e1 == 0) {
                if (m1.signum() == 0) {
                    return G.zero(this.msize, this.esize, s2);
                }
                if (e0 == 0) {
                    int j = this.msize - m0.bitLength();
                    e0 = 1 - j;
                    m0 = m0.shiftLeft(j);
                }
                int j = this.msize - m1.bitLength();
                e1 = 1 - j;
                m1 = m1.shiftLeft(j);
            }
            int rs = ((m2 = m0.multiply(m1)).and(FloatConst.mask(this.msize - 2)).signum() != 0 ? 1 : 0) + (m2.testBit(this.msize - 2) ? 2 : 0);
            return G.number(this.msize, this.esize, m2.shiftRight(this.msize - 1), e0 - FloatConst.bias(this.esize) + e1, s2, rs);
        }

        public FloatConst div(FloatConst c) {
            int j;
            if (c.msize() != this.msize || c.esize() != this.esize) {
                throw new IllegalArgumentException(this + " " + c);
            }
            G g = (G)c;
            BigInteger m0 = this.m;
            BigInteger m1 = g.m;
            int e0 = this.e;
            int e1 = g.e;
            boolean s2 = this.s ^ g.s;
            if (e0 > FloatConst.emax(this.esize) && m0.and(FloatConst.mask(this.msize - 1)).signum() != 0) {
                return this;
            }
            if (e1 > FloatConst.emax(this.esize) && m1.and(FloatConst.mask(this.msize - 1)).signum() != 0) {
                return g;
            }
            if (e0 > FloatConst.emax(this.esize)) {
                if (e1 > FloatConst.emax(this.esize)) {
                    return G.nan(this.msize, this.esize);
                }
                return G.infinity(this.msize, this.esize, s2);
            }
            if (e1 > FloatConst.emax(this.esize)) {
                return G.zero(this.msize, this.esize, s2);
            }
            if (e0 == 0) {
                if (m0.signum() == 0) {
                    if (e1 == 0 && m1.signum() == 0) {
                        return G.nan(this.msize, this.esize);
                    }
                    return G.zero(this.msize, this.esize, s2);
                }
                j = this.msize - m0.bitLength();
                e0 = 1 - j;
                m0 = m0.shiftLeft(j);
            }
            if (e1 == 0) {
                if (m1.signum() == 0) {
                    return G.infinity(this.msize, this.esize, s2);
                }
                j = this.msize - m1.bitLength();
                e1 = 1 - j;
                m1 = m1.shiftLeft(j);
            }
            BigInteger[] qr = m0.shiftLeft(this.msize).divideAndRemainder(m1);
            int rs = 0;
            if (qr[1].signum() != 0) {
                rs = qr[1].shiftLeft(1).compareTo(m1) + 2;
            }
            return G.number(this.msize, this.esize, qr[0], e0 - 1 - e1 + FloatConst.bias(this.esize), s2, rs);
        }

        public FloatConst neg() {
            return G.valueOf(this.msize, this.esize, this.m, this.e, !this.s);
        }

        public IntConst tsteq(FloatConst c, int size) {
            return IntConst.valueOf(size, this.tst(c) == 0 ? 1L : 0L);
        }

        public IntConst tstne(FloatConst c, int size) {
            return IntConst.valueOf(size, this.tst(c) != 0 ? 1L : 0L);
        }

        public IntConst tstlts(FloatConst c, int size) {
            return IntConst.valueOf(size, this.tst(c) == -1 ? 1L : 0L);
        }

        public IntConst tstgts(FloatConst c, int size) {
            return IntConst.valueOf(size, this.tst(c) == 1 ? 1L : 0L);
        }

        public IntConst tstles(FloatConst c, int size) {
            return IntConst.valueOf(size, this.tst(c) <= 0 ? 1L : 0L);
        }

        public IntConst tstges(FloatConst c, int size) {
            return IntConst.valueOf(size, (this.tst(c) & 0xFFFFFFFE) == 0 ? 1L : 0L);
        }

        private int tst(FloatConst c) {
            if (c.msize() != this.msize || c.esize() != this.esize) {
                throw new IllegalArgumentException(this + " " + c);
            }
            G g = (G)c;
            if (this.e > FloatConst.emax(this.esize) && this.m.and(FloatConst.mask(this.msize - 1)).signum() != 0) {
                return 2;
            }
            if (g.e > FloatConst.emax(this.esize) && g.m.and(FloatConst.mask(this.msize - 1)).signum() != 0) {
                return 2;
            }
            if (this.e == 0 && g.e == 0 && this.m.signum() == 0 && g.m.signum() == 0) {
                return 0;
            }
            if (this.s) {
                if (!g.s) {
                    return -1;
                }
                if (g.e == this.e) {
                    return g.m.compareTo(this.m);
                }
                return g.e < this.e ? -1 : 1;
            }
            if (g.s) {
                return 1;
            }
            if (this.e == g.e) {
                return this.m.compareTo(g.m);
            }
            return this.e < g.e ? -1 : 1;
        }

        public FloatConst convfx(int msize, int esize) {
            if (msize < this.msize) {
                throw new IllegalArgumentException(this + " " + msize + '+' + esize);
            }
            if (esize < this.esize) {
                throw new IllegalArgumentException(this + " " + msize + '+' + esize);
            }
            BigInteger m2 = this.m.shiftLeft(msize - this.msize);
            int i = FloatConst.bias(esize) - FloatConst.bias(this.esize);
            int e2 = this.e + i;
            if (this.e > FloatConst.emax(this.esize)) {
                e2 = FloatConst.emax(esize) + 1;
            } else if (this.e == 0) {
                if (this.m.signum() == 0) {
                    m2 = this.m;
                    e2 = 0;
                } else {
                    int j = msize - m2.bitLength();
                    if (j < i + 1) {
                        m2 = m2.shiftLeft(j);
                        e2 = i + 1 - j;
                    } else {
                        m2 = m2.shiftLeft(i);
                        e2 = 0;
                    }
                }
            }
            if (msize == 24 && esize == 8) {
                return F.valueOf(m2, e2, this.s);
            }
            if (msize == 53 && esize == 11) {
                return D.valueOf(m2, e2, this.s);
            }
            return G.valueOf(msize, esize, m2, e2, this.s);
        }

        /*
         * Unable to fully structure code
         */
        public FloatConst convft(int msize, int esize) {
            block7: {
                block6: {
                    if (msize > this.msize) {
                        throw new IllegalArgumentException(this + " " + msize + '+' + esize);
                    }
                    if (esize > this.esize) {
                        throw new IllegalArgumentException(this + " " + msize + '+' + esize);
                    }
                    m0 = this.m;
                    e0 = this.e;
                    i = this.msize - msize;
                    if (e0 <= FloatConst.access$100(this.esize)) break block6;
                    c2 = m0.and(FloatConst.access$300(this.msize - 1)).signum() != 0 ? G.nan(msize, esize, m0.shiftRight(i), this.s) : G.infinity(msize, esize, this.s);
                    break block7;
                }
                if (e0 != 0) ** GOTO lbl19
                if (m0.signum() == 0) {
                    c2 = G.zero(msize, esize, this.s);
                } else {
                    j = this.msize - m0.bitLength();
                    e0 = 1 - j;
                    m0 = m0.shiftLeft(j);
lbl19:
                    // 2 sources

                    m2 = m0.shiftRight(i);
                    rs = (i > 1 && m0.and(FloatConst.access$300(i - 1)).signum() != 0 ? 1 : 0) + (i >= 1 && m0.testBit(i - 1) != false ? 2 : 0);
                    e2 = e0 - FloatConst.access$200(this.esize) + FloatConst.access$200(esize);
                    c2 = G.number(msize, esize, m2, e2, this.s, rs);
                }
            }
            if (msize == 24 && esize == 8) {
                return F.valueOf(c2.m, c2.e, c2.s);
            }
            if (msize == 53 && esize == 11) {
                return D.valueOf(c2.m, c2.e, c2.s);
            }
            return c2;
        }

        public IntConst convfi(int size, RoundingMode r) {
            return IntConst.valueOf(size, this.toBigInteger(r));
        }

        public float floatValue() {
            FloatConst c = this.msize > 24 ? (this.esize >= 8 ? this.convft(24, 8) : this.convfx(this.msize, 8).convft(24, 8)) : (this.msize < 24 ? (this.esize <= 8 ? this.convfx(24, 8) : this.convfx(24, this.esize).convft(24, 8)) : (this.esize > 8 ? this.convft(24, 8) : this.convfx(24, 8)));
            return c.floatValue();
        }

        public double doubleValue() {
            FloatConst c = this.msize > 53 ? (this.esize >= 11 ? this.convft(53, 11) : this.convfx(this.msize, 11).convft(53, 11)) : (this.msize < 53 ? (this.esize <= 11 ? this.convfx(53, 11) : this.convfx(53, this.esize).convft(53, 11)) : (this.esize > 11 ? this.convft(53, 11) : this.convfx(53, 11)));
            return c.doubleValue();
        }

        public BigDecimal toBigDecimal() {
            BigDecimal bd;
            if (this.e > FloatConst.emax(this.esize)) {
                throw new IllegalArgumentException(this.toString());
            }
            if (this.e == 0 && this.m.signum() == 0) {
                bd = new BigDecimal(0);
            } else {
                int i = (this.e == 0 ? 1 : this.e) - FloatConst.bias(this.esize) - this.msize + 1;
                if (i >= 0) {
                    bd = new BigDecimal(this.m.shiftLeft(i));
                } else {
                    i = -i;
                    int j = this.m.getLowestSetBit();
                    if (j > i) {
                        j = i;
                    }
                    BigDecimal bdm = new BigDecimal(this.m.shiftRight(j));
                    BigDecimal bde = new BigDecimal(BigInteger.ONE.shiftLeft(i - j));
                    bd = bdm.divide(bde, i - j, 7);
                }
            }
            return this.s ? bd.negate() : bd;
        }

        public BigInteger toBigInteger(RoundingMode r) {
            if (this.e > FloatConst.emax(this.esize)) {
                throw new IllegalArgumentException(this.toString());
            }
            int i = FloatConst.bias(this.esize) + this.msize - 1 - (this.e == 0 ? 1 : this.e);
            if (i > this.msize + 1) {
                i = this.msize + 1;
            }
            BigInteger b = this.m.shiftRight(i);
            int rs = 0;
            if (i > 0) {
                rs = (this.m.and(FloatConst.mask(i - 1)).signum() != 0 ? 1 : 0) + (this.m.testBit(i - 1) ? 2 : 0);
            }
            b = r.round(b, this.s, rs);
            return this.s ? b.negate() : b;
        }

        public BigInteger toBigIntegerBits() {
            int i = ((this.s ? -1 : 0) << this.esize) + this.e;
            return BigInteger.valueOf(i).shiftLeft(this.msize - 1).add(this.m.and(FloatConst.mask(this.msize - 1)));
        }

        public BigInteger toExplicitBigIntegerBits() {
            int i = ((this.s ? -1 : 0) << this.esize) + this.e;
            return BigInteger.valueOf(i).shiftLeft(this.msize).add(this.m);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof G)) {
                return false;
            }
            G g = (G)o;
            return this.s == g.s && this.e == g.e && this.m.equals(g.m);
        }

        public int hashCode() {
            return (this.msize * 37 + this.e) * 37 + this.m.hashCode();
        }

        public String toString() {
            return "(FloatConst F" + this.msize + '+' + this.esize + ' ' + this.toDecimalString() + ')';
        }

        public String toDecimalString() {
            if (this.e <= FloatConst.emax(this.esize)) {
                return this.toBigDecimal().toString();
            }
            if (this.m.and(FloatConst.mask(this.msize - 1)).signum() == 0) {
                return this.s ? "-Infinity" : "Infinity";
            }
            return "NaN";
        }
    }

    private strictfp static final class D
    extends FloatConst {
        private final double d;
        static final int msize = 53;
        static final int esize = 11;
        static final D F64_0 = new D(0.0);
        static final D F64_1 = new D(1.0);
        private static final long MIN_LONG = Integer.MIN_VALUE;
        private static final long MAX_LONG = 9223372036854773760L;

        private D(double val) {
            this.d = val;
        }

        static D valueOf(double val) {
            if (Double.doubleToLongBits(val) == 0L) {
                return F64_0;
            }
            if (val == 1.0) {
                return F64_1;
            }
            return new D(val);
        }

        static D valueOf(BigInteger m, int e, boolean s) {
            long l = ((s ? -1L : 0L) << 11) + (long)e;
            l = (l << 52) + (m.longValue() & 0xFFFFFFFFFFFFFL);
            return D.valueOf(Double.longBitsToDouble(l));
        }

        public int msize() {
            return 53;
        }

        public int esize() {
            return 11;
        }

        public FloatConst add(FloatConst c) {
            if (!(c instanceof D)) {
                throw new IllegalArgumentException(this + " " + c);
            }
            return D.valueOf(this.d + ((D)c).d);
        }

        public FloatConst sub(FloatConst c) {
            if (!(c instanceof D)) {
                throw new IllegalArgumentException(this + " " + c);
            }
            return D.valueOf(this.d - ((D)c).d);
        }

        public FloatConst mul(FloatConst c) {
            if (!(c instanceof D)) {
                throw new IllegalArgumentException(this + " " + c);
            }
            return D.valueOf(this.d * ((D)c).d);
        }

        public FloatConst div(FloatConst c) {
            if (!(c instanceof D)) {
                throw new IllegalArgumentException(this + " " + c);
            }
            return D.valueOf(this.d / ((D)c).d);
        }

        public FloatConst neg() {
            return D.valueOf(-this.d);
        }

        public IntConst tsteq(FloatConst c, int size) {
            if (!(c instanceof D)) {
                throw new IllegalArgumentException(this + " " + c);
            }
            return IntConst.valueOf(size, this.d == ((D)c).d ? 1L : 0L);
        }

        public IntConst tstne(FloatConst c, int size) {
            if (!(c instanceof D)) {
                throw new IllegalArgumentException(this + " " + c);
            }
            return IntConst.valueOf(size, this.d != ((D)c).d ? 1L : 0L);
        }

        public IntConst tstlts(FloatConst c, int size) {
            if (!(c instanceof D)) {
                throw new IllegalArgumentException(this + " " + c);
            }
            return IntConst.valueOf(size, this.d < ((D)c).d ? 1L : 0L);
        }

        public IntConst tstgts(FloatConst c, int size) {
            if (!(c instanceof D)) {
                throw new IllegalArgumentException(this + " " + c);
            }
            return IntConst.valueOf(size, this.d > ((D)c).d ? 1L : 0L);
        }

        public IntConst tstles(FloatConst c, int size) {
            if (!(c instanceof D)) {
                throw new IllegalArgumentException(this + " " + c);
            }
            return IntConst.valueOf(size, this.d <= ((D)c).d ? 1L : 0L);
        }

        public IntConst tstges(FloatConst c, int size) {
            if (!(c instanceof D)) {
                throw new IllegalArgumentException(this + " " + c);
            }
            return IntConst.valueOf(size, this.d >= ((D)c).d ? 1L : 0L);
        }

        public FloatConst convfx(int msize, int esize) {
            if (msize < 53) {
                throw new IllegalArgumentException(this + " " + msize + '+' + esize);
            }
            if (esize < 11) {
                throw new IllegalArgumentException(this + " " + msize + '+' + esize);
            }
            return D.valueOf(msize, esize, this.d);
        }

        public FloatConst convft(int msize, int esize) {
            if (msize > 53) {
                throw new IllegalArgumentException(this + " " + msize + '+' + esize);
            }
            if (esize > 11) {
                throw new IllegalArgumentException(this + " " + msize + '+' + esize);
            }
            return D.valueOf(msize, esize, this.d);
        }

        public IntConst convfi(int size, RoundingMode r) {
            if (size <= 64 && this.d <= 9.223372036854774E18 && this.d >= -2.147483648E9) {
                return IntConst.valueOf(size, r.toLong(this.d));
            }
            return IntConst.valueOf(size, this.toBigInteger(r));
        }

        public float floatValue() {
            return (float)this.d;
        }

        public double doubleValue() {
            return this.d;
        }

        public BigDecimal toBigDecimal() {
            return new BigDecimal(this.d);
        }

        public BigInteger toBigInteger(RoundingMode r) {
            if (this.d <= 9.223372036854774E18 && this.d >= -2.147483648E9) {
                return BigInteger.valueOf(r.toLong(this.d));
            }
            long l = Double.doubleToLongBits(this.d);
            int e = (int)(l >> 52) & 0x7FF;
            if (e > FloatConst.emax(11)) {
                throw new IllegalArgumentException(this.toString());
            }
            long m = l & 0xFFFFFFFFFFFFFL | 0x10000000000000L;
            return BigInteger.valueOf(l < 0L ? -m : m).shiftLeft(e - FloatConst.bias(11) - 53 + 1);
        }

        public BigInteger toBigIntegerBits() {
            return BigInteger.valueOf(Double.doubleToLongBits(this.d));
        }

        public BigInteger toExplicitBigIntegerBits() {
            long l = Double.doubleToLongBits(this.d);
            int e = (int)(l >> 52) & 0x7FF;
            long m = l & 0xFFFFFFFFFFFFFL;
            if (e != 0) {
                m |= 0x10000000000000L;
            }
            return BigInteger.valueOf(m).or(BigInteger.valueOf(l & 0xFFF0000000000000L).shiftLeft(1));
        }

        public boolean equals(Object o) {
            return o == this || o instanceof D && Double.doubleToRawLongBits(this.d) == Double.doubleToRawLongBits(((D)o).d);
        }

        public int hashCode() {
            long v = Double.doubleToRawLongBits(this.d);
            return 1961 + (int)(v >>> 32 ^ v);
        }

        public String toString() {
            return "(FloatConst F53+11 " + this.d + ')';
        }

        public String toDecimalString() {
            return String.valueOf(this.d);
        }
    }

    private strictfp static final class F
    extends FloatConst {
        private final float f;
        static final int msize = 24;
        static final int esize = 8;
        static final F F32_0 = new F(0.0f);
        static final F F32_1 = new F(1.0f);
        private static final long MIN_LONG = Integer.MIN_VALUE;
        private static final long MAX_LONG = 0x7FFFFF0000000000L;

        private F(float val) {
            this.f = val;
        }

        static F valueOf(float val) {
            if (Float.floatToIntBits(val) == 0) {
                return F32_0;
            }
            if (val == 1.0f) {
                return F32_1;
            }
            return new F(val);
        }

        static F valueOf(BigInteger m, int e, boolean s) {
            int i = ((s ? -1 : 0) << 8) + e;
            i = (i << 23) + (m.intValue() & 0x7FFFFF);
            return F.valueOf(Float.intBitsToFloat(i));
        }

        public int msize() {
            return 24;
        }

        public int esize() {
            return 8;
        }

        public FloatConst add(FloatConst c) {
            if (!(c instanceof F)) {
                throw new IllegalArgumentException(this + " " + c);
            }
            return F.valueOf(this.f + ((F)c).f);
        }

        public FloatConst sub(FloatConst c) {
            if (!(c instanceof F)) {
                throw new IllegalArgumentException(this + " " + c);
            }
            return F.valueOf(this.f - ((F)c).f);
        }

        public FloatConst mul(FloatConst c) {
            if (!(c instanceof F)) {
                throw new IllegalArgumentException(this + " " + c);
            }
            return F.valueOf(this.f * ((F)c).f);
        }

        public FloatConst div(FloatConst c) {
            if (!(c instanceof F)) {
                throw new IllegalArgumentException(this + " " + c);
            }
            return F.valueOf(this.f / ((F)c).f);
        }

        public FloatConst neg() {
            return F.valueOf(-this.f);
        }

        public IntConst tsteq(FloatConst c, int size) {
            if (!(c instanceof F)) {
                throw new IllegalArgumentException(this + " " + c);
            }
            return IntConst.valueOf(size, this.f == ((F)c).f ? 1L : 0L);
        }

        public IntConst tstne(FloatConst c, int size) {
            if (!(c instanceof F)) {
                throw new IllegalArgumentException(this + " " + c);
            }
            return IntConst.valueOf(size, this.f != ((F)c).f ? 1L : 0L);
        }

        public IntConst tstlts(FloatConst c, int size) {
            if (!(c instanceof F)) {
                throw new IllegalArgumentException(this + " " + c);
            }
            return IntConst.valueOf(size, this.f < ((F)c).f ? 1L : 0L);
        }

        public IntConst tstgts(FloatConst c, int size) {
            if (!(c instanceof F)) {
                throw new IllegalArgumentException(this + " " + c);
            }
            return IntConst.valueOf(size, this.f > ((F)c).f ? 1L : 0L);
        }

        public IntConst tstles(FloatConst c, int size) {
            if (!(c instanceof F)) {
                throw new IllegalArgumentException(this + " " + c);
            }
            return IntConst.valueOf(size, this.f <= ((F)c).f ? 1L : 0L);
        }

        public IntConst tstges(FloatConst c, int size) {
            if (!(c instanceof F)) {
                throw new IllegalArgumentException(this + " " + c);
            }
            return IntConst.valueOf(size, this.f >= ((F)c).f ? 1L : 0L);
        }

        public FloatConst convfx(int msize, int esize) {
            if (msize < 24) {
                throw new IllegalArgumentException(this + " " + msize + '+' + esize);
            }
            if (esize < 8) {
                throw new IllegalArgumentException(this + " " + msize + '+' + esize);
            }
            return F.valueOf(msize, esize, this.f);
        }

        public FloatConst convft(int msize, int esize) {
            if (msize > 24) {
                throw new IllegalArgumentException(this + " " + msize + '+' + esize);
            }
            if (esize > 8) {
                throw new IllegalArgumentException(this + " " + msize + '+' + esize);
            }
            return F.valueOf(msize, esize, this.f);
        }

        public IntConst convfi(int size, RoundingMode r) {
            if (size <= 64 && this.f <= 9.223371E18f && this.f >= -2.1474836E9f) {
                return IntConst.valueOf(size, r.toLong(this.f));
            }
            return IntConst.valueOf(size, this.toBigInteger(r));
        }

        public float floatValue() {
            return this.f;
        }

        public double doubleValue() {
            return this.f;
        }

        public BigDecimal toBigDecimal() {
            return new BigDecimal(this.f);
        }

        public BigInteger toBigInteger(RoundingMode r) {
            if (this.f <= 9.223371E18f && this.f >= -2.1474836E9f) {
                return BigInteger.valueOf(r.toLong(this.f));
            }
            int i = Float.floatToIntBits(this.f);
            int e = i >> 23 & 0xFF;
            if (e > FloatConst.emax(8)) {
                throw new IllegalArgumentException(this.toString());
            }
            int m = i & 0x7FFFFF | 0x800000;
            return BigInteger.valueOf(i < 0 ? (long)(-m) : (long)m).shiftLeft(e - FloatConst.bias(8) - 24 + 1);
        }

        public BigInteger toBigIntegerBits() {
            return BigInteger.valueOf(Float.floatToIntBits(this.f));
        }

        public BigInteger toExplicitBigIntegerBits() {
            int i = Float.floatToIntBits(this.f);
            int e = i >> 23 & 0xFF;
            int m = i & 0x7FFFFF;
            if (e != 0) {
                m |= 0x800000;
            }
            return BigInteger.valueOf((long)m | (long)(i & 0xFF800000) << 1);
        }

        public boolean equals(Object o) {
            return o == this || o instanceof F && Float.floatToRawIntBits(this.f) == Float.floatToRawIntBits(((F)o).f);
        }

        public int hashCode() {
            return 888 + Float.floatToRawIntBits(this.f);
        }

        public String toString() {
            return "(FloatConst F24+8 " + this.f + ')';
        }

        public String toDecimalString() {
            return String.valueOf(this.f);
        }
    }

    public static abstract class RoundingMode {
        RoundingMode() {
        }

        abstract long toLong(double var1);

        abstract BigInteger round(BigInteger var1, boolean var2, int var3);
    }
}

