/* 
 *    Copyright 2007 MICS Project
 *    Licensed under the Apache License, Version 2.0 (the "License");
 *    you may not use this file except in compliance with the License.
 *    You may obtain a copy of the License at
 * 
 *        http://www.apache.org/licenses/LICENSE-2.0
 * 
 *    Unless required by applicable law or agreed to in writing, software
 *    distributed under the License is distributed on an "AS IS" BASIS,
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *    See the License for the specific language governing permissions and
 *    limitations under the License.
 */

package net.wasamon.mics.architecturemaker;

import java.awt.Container;
import java.awt.BorderLayout;
import java.awt.GridLayout;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

import net.wasamon.mics.architecturemaker.unit.HardwareUnitPropertyTable;

@SuppressWarnings("serial")
    /**
     * @author Masayuki Morisita
     */
    public class ArchitectureMaker extends JFrame {
	public final static String VERSION = "0.1.2";
	public final static String NAME = "ArchitectureMaker " + VERSION;

	public static void main(String arg[]) {
	    ArchitectureMaker frame = new ArchitectureMaker();
	    frame.setSize(850, 700);

	    frame.addWindowListener(new WindowAdapter() {
		    public void windowClosing(WindowEvent e) {
			System.exit(0);
		    }
		});

	    frame.setVisible(true);
	}

	public ArchitectureMaker() {
	    super(NAME);

	    Container container = getContentPane();

	    // main
	    JPanel mainPanel = new JPanel();
	    container.add(mainPanel, "Center");
	    mainPanel.setLayout(new BorderLayout());

	    // menu bar
	    JMenuBar menuBar = new JMenuBar();
	    JMenu fileMenu = new JMenu("File");
	    JMenu editMenu = new JMenu("Edit");
	    JMenu viewMenu = new JMenu("View");
	    JMenu toolsMenu = new JMenu("Tools");
	    JMenu helpMenu = new JMenu("Help");

	    setJMenuBar(menuBar);
	    menuBar.add(fileMenu);
	    menuBar.add(editMenu);
	    menuBar.add(viewMenu);
	    menuBar.add(toolsMenu);
	    menuBar.add(helpMenu);

	    JMenuItem newItem = new JMenuItem("New");
	    JMenuItem openItem = new JMenuItem("Open");
	    JMenuItem saveItem = new JMenuItem("Save");
	    JMenuItem quitItem = new JMenuItem("Quit");

	    fileMenu.add(newItem);
	    fileMenu.add(openItem);
	    fileMenu.add(saveItem);
	    fileMenu.addSeparator();
	    fileMenu.add(quitItem);

	    JMenuItem undoItem = new JMenuItem("Undo");
	    JMenuItem redoItem = new JMenuItem("Redo");
	    JMenuItem cutItem = new JMenuItem("Cut");
	    JMenuItem copyItem = new JMenuItem("Copy");
	    JMenuItem pasteItem = new JMenuItem("Paste");
	    JMenuItem deleteItem = new JMenuItem("Delete");
	    JMenuItem selectItem = new JMenuItem("Select All");
	    JMenuItem disconnectItem = new JMenuItem("Disconnect to Each Other");
	    JMenuItem adjustItem = new JMenuItem("Adjust Position");
		
	    editMenu.add(undoItem);
	    editMenu.add(redoItem);
	    editMenu.addSeparator();
	    editMenu.add(disconnectItem);
	    editMenu.addSeparator();
	    editMenu.add(adjustItem);
	    editMenu.addSeparator();
	    editMenu.add(cutItem);
	    editMenu.add(copyItem);
	    editMenu.add(pasteItem);
	    editMenu.add(deleteItem);
	    editMenu.addSeparator();
	    editMenu.add(selectItem);

	    JMenuItem convertItem = new JMenuItem("Convert");
	    JMenuItem effectItem = new JMenuItem("Effect");
	    toolsMenu.add(effectItem);
	    toolsMenu.addSeparator();
	    toolsMenu.add(convertItem);

	    JMenuItem helpItem = new JMenuItem("Help Contents");
	    JMenuItem releaseItem = new JMenuItem("Release Notes");
	    JMenuItem aboutItem = new JMenuItem("About ArchitectureMaker");

	    helpMenu.add(helpItem);
	    helpMenu.add(releaseItem);
	    helpMenu.addSeparator();
	    helpMenu.add(aboutItem);


	    // action button
	    mainPanel.add(ActionButtonPanel.getInstance(), "North");

	    // unit selector & unit property
	    JPanel unitPanel = new JPanel(new GridLayout(2, 1));
	    mainPanel.add(unitPanel, "West");
	    JPanel selectorEditor = new JPanel(new BorderLayout());
	    selectorEditor.setBorder(new TitledBorder("Hardware Unit Selector"));
	    unitPanel.add(selectorEditor);

	    // //selector
	    selectorEditor.add(HardwareUnitSelector.getInstance(), "Center");

	    // //property
	    HardwareUnitPropertyTable.getInstance().setBorder(
							      new TitledBorder("Hardware Unit Property"));
	    unitPanel.add(HardwareUnitPropertyTable.getInstance());
	    ActionButtonPanel.getInstance().updateButtonsState();

	    // maker
	    final JPanel makerPanel = new JPanel(new BorderLayout());
	    makerPanel.setBorder(new TitledBorder("Architecture Maker"));
	    final JTabbedPane makerTabbedPane = new JTabbedPane();
	    JScrollPane configScrollPane = new JScrollPane(ConfigFileEditor
							   .getInstance());
	    makerTabbedPane.addTab("Architecture Canvas", CanvasViewPort.getInstance());
	    makerTabbedPane.addTab("Config File", configScrollPane);
	    makerPanel.add(makerTabbedPane, "Center");
	    mainPanel.add(makerPanel, "Center");

	    // message
	    JScrollPane messageScrollPane = new JScrollPane(OutputTextArea
							    .getInstance());
	    messageScrollPane.setBorder(new TitledBorder("Output"));
	    mainPanel.add(messageScrollPane, "South");

	    makerTabbedPane.addChangeListener(new ChangeListener() {
		    public void stateChanged(ChangeEvent e) {
			if (makerTabbedPane.getSelectedIndex() == 1) {
			    ActionButtonPanel.getInstance().updateButtonsState(false);
			}
			else {
			    ActionButtonPanel.getInstance().updateButtonsState();
			}
		    }
		});
	}
    }
