/* 
 *    Copyright 2007 MICS Project
 *    Licensed under the Apache License, Version 2.0 (the "License");
 *    you may not use this file except in compliance with the License.
 *    You may obtain a copy of the License at
 * 
 *        http://www.apache.org/licenses/LICENSE-2.0
 * 
 *    Unless required by applicable law or agreed to in writing, software
 *    distributed under the License is distributed on an "AS IS" BASIS,
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *    See the License for the specific language governing permissions and
 *    limitations under the License.
 */

package net.wasamon.mics.architecturemaker;

import java.awt.Image;
import java.awt.Point;
import java.awt.Dimension;
import java.util.ArrayList;
import java.awt.image.PixelGrabber;
import java.awt.image.MemoryImageSource;
import java.awt.Toolkit;

import net.wasamon.mics.architecturemaker.unit.HardwareUnit;
import net.wasamon.mics.architecturemaker.unit.Mediator;

/**
 * @author Masayuki Morisita
 */
public class Ghost {
	public Image image;
	public Point position;
	public Dimension size;
	public ArrayList<Point> connectingPoints;

	public Ghost(HardwareUnit unit, int alpha) {
	    image = createTransparentImage(Mediator.getInstance().getImage(unit.appearance()), alpha);
		position = new Point(unit.appearance().getX(), unit.appearance().getY());
		size = new Dimension(unit.appearance().getWidth(), unit.appearance().getHeight());
	}

	private Image createTransparentImage(Image image, int alpha) {
		int width = image.getWidth(null);
		int height = image.getHeight(null);
		int picture[] = new int[width * height];

		PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, width,
				height, picture, 0, width);
		try {
			pixelGrabber.grabPixels();
		} catch (InterruptedException e) {
			return image;
		}

		int mask = 0x00ffffff | alpha << 24;
		for (int i = 0; i < height; ++i) {
			for (int j = 0; j < width; ++j) {
				picture[i * width + j] &= mask;
			}
		}

		return Toolkit.getDefaultToolkit().createImage(
				new MemoryImageSource(width, height, picture, 0, width));
	}
}
