/* 
 *    Copyright 2007 MICS Project
 *    Licensed under the Apache License, Version 2.0 (the "License");
 *    you may not use this file except in compliance with the License.
 *    You may obtain a copy of the License at
 * 
 *        http://www.apache.org/licenses/LICENSE-2.0
 * 
 *    Unless required by applicable law or agreed to in writing, software
 *    distributed under the License is distributed on an "AS IS" BASIS,
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *    See the License for the specific language governing permissions and
 *    limitations under the License.
 */

package net.wasamon.mics.architecturemaker;

import java.awt.Point;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.HashMap;

import net.wasamon.mics.architecturemaker.unit.HardwareUnit;

/**
 * @author Masayuki Morisita
 */
public class HauntedMansion {
	HashMap<HardwareUnit, Ghost> map;
	ArrayList<HardwareUnit> bodyList;
	ArrayList<Ghost> ghostList;

	public HauntedMansion(HardwareUnit[] units, int alpha) {
		map = new HashMap<HardwareUnit, Ghost>();
		bodyList = new ArrayList<HardwareUnit>();
		ghostList = new ArrayList<Ghost>();

		for (int i = 0; i < units.length; ++i) {
			Ghost ghost = new Ghost(units[i], alpha);
			map.put(units[i], ghost);
			bodyList.add(units[i]);
			ghostList.add(ghost);
		}

		for (int i = 0; i < units.length; ++i) {
			HardwareUnit unit = units[i];
			Ghost ghost = map.get(unit);
			HardwareUnit connectedUnits[] = unit.getConnectedUnitList();
			ArrayList<Point> connectingPoints = new ArrayList<Point>();
			for (int j = 0; j < connectedUnits.length; ++j) {
				HardwareUnit connectedUnit = connectedUnits[j];
				if (map.containsKey(connectedUnit)) {
					connectingPoints.add(map.get(connectedUnit).position);
				} else {
				    connectingPoints.add(new Point(connectedUnit.appearance().getX(),
							connectedUnit.appearance().getY()));
				}
			}
			ghost.connectingPoints = connectingPoints;
		}

	}

	public void setOffset(int xOffset, int yOffset) {
		for (int i = 0; i < ghostList.size(); ++i) {
			HardwareUnit body = bodyList.get(i);
			Ghost ghost = ghostList.get(i);
			int x = body.appearance().getX() + xOffset;
			int y = body.appearance().getY() + yOffset;

			if (x < 0) {
				x = 0;
			}

			if (y < 0) {
				y = 0;
			}

			ghost.position.setLocation(x, y);
		}
	}

	public Point getPosition(HardwareUnit body) {
		if (map.containsKey(body)) {
			return map.get(body).position;
		}
		return null;
	}

	public Ghost[] getGhosts() {
		return ghostList.toArray(new Ghost[ghostList.size()]);
	}
}
