/* 
 *    Copyright 2007 MICS Project
 *    Licensed under the Apache License, Version 2.0 (the "License");
 *    you may not use this file except in compliance with the License.
 *    You may obtain a copy of the License at
 * 
 *        http://www.apache.org/licenses/LICENSE-2.0
 * 
 *    Unless required by applicable law or agreed to in writing, software
 *    distributed under the License is distributed on an "AS IS" BASIS,
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *    See the License for the specific language governing permissions and
 *    limitations under the License.
 */

package net.wasamon.mics.architecturemaker;

import java.awt.*;
import javax.swing.*;
import java.awt.geom.*;

/**
 * @author Masayuki Morisita
 */
class RoundedCornerTextField extends JTextField {
	private static final float arcwidth = 8f;
	private static final float archeight = 8f;
	protected static final int focusstroke = 0;
	protected Shape shape;
	protected Shape border;
	protected Shape base;
	private Color borderColor;

	public RoundedCornerTextField(String text) {
		super(text);
		setBackground(new Color(255, 255, 255, 0));
		borderColor = Color.gray;
		setMargin(new Insets(3, 5, 3, 5));
		initShape();
	}

	protected void initShape() {
		if (!getBounds().equals(base)) {
			base = getBounds();
			shape = new RoundRectangle2D.Float(0, 0, getWidth() - 1,
					getHeight() - 1, arcwidth, archeight);
			border = new RoundRectangle2D.Float(focusstroke, focusstroke,
					getWidth() - 1 - focusstroke * 2, getHeight() - 1
							- focusstroke * 2, arcwidth, archeight);
		}
	}

	protected void paintComponent(Graphics g) {
		Graphics2D g2 = (Graphics2D) g;

		// if(isEditable()){
		g.setColor(Color.white);
		g.fillRoundRect(0, 0, getWidth() - 1, getHeight() - 1, 8, 8);
		borderColor = Color.gray;
		// setText(getText());
		/*
		 * } else{ g.setColor(new Color(240, 240, 240)); g.fillRoundRect(0, 0,
		 * getWidth() - 1, getHeight() - 1, 8, 8); borderColor =
		 * Color.gray.brighter(); }
		 */
		super.paintComponent(g2);
	}

	protected void paintBorder(Graphics g) {
		initShape();
		Graphics2D g2 = (Graphics2D) g;
		g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING,
				RenderingHints.VALUE_ANTIALIAS_ON);
		g2.setColor(borderColor);
		g2.draw(border);
		// g2.draw(shape);
		g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING,
				RenderingHints.VALUE_ANTIALIAS_OFF);
	}

	public boolean contains(int x, int y) {
		initShape();
		return shape.contains(x, y);
	}
}

/*
 * import java.awt.*; import javax.swing.*; import java.awt.geom.*;
 * 
 * class RoundedCornerTextField extends JTextField { private static final float
 * arcwidth = 8f; private static final float archeight = 8f; protected static
 * final int focusstroke = 0; protected Shape shape; protected Shape border;
 * protected Shape base;
 * 
 * public RoundedCornerTextField(String text) { super(text); setMargin(new
 * Insets(2, 2, 2, 2)); setBackground(new Color(250, 250, 250)); initShape(); }
 * 
 * protected void initShape() { if(!getBounds().equals(base)) { base =
 * getBounds(); shape = new RoundRectangle2D.Float(0, 0, getWidth()-1,
 * getHeight()-1, arcwidth, archeight); border = new
 * RoundRectangle2D.Float(focusstroke, focusstroke, getWidth()-1-focusstroke*2,
 * getHeight()-1-focusstroke*2, arcwidth, archeight); } }
 * 
 * protected void paintComponent(Graphics g) { initShape(); Graphics2D g2 =
 * (Graphics2D)g; g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING,
 * RenderingHints.VALUE_ANTIALIAS_ON);
 * 
 * Color bgc = getBackground(); Color newCenterColor = new
 * Color((int)(bgc.getRed() * 0.9), (int)(bgc.getGreen() * 0.9),
 * (int)(bgc.getBlue() * 0.9)); g2.setPaint(new GradientPaint(0, getHeight() /
 * 2, newCenterColor, 0, getHeight(), getBackground(), true)); g2.fill(shape);
 * 
 * g2.setPaint(new GradientPaint(0, getHeight() / 2, new Color(0, 120, 180),
 * getWidth(), getHeight(), new Color(0, 100, 150), true)); g2.draw(shape);
 * 
 * g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING,
 * RenderingHints.VALUE_ANTIALIAS_OFF); g2.setColor(getBackground());
 * super.paintComponent(g2); } private void paintFocusAndRollover(Graphics2D g2,
 * Color color) {
 * 
 * //g2.setPaint(new GradientPaint(0, 0, color, getWidth()-1, getHeight()-1,
 * color.brighter(), true)); //g2.fill(shape);
 * 
 * g2.setColor(getBackground()); g2.fill(border);
 * 
 * g2.setColor(Color.BLACK); g2.draw(shape); } protected void
 * paintBorder(Graphics g) {
 * 
 * initShape(); Graphics2D g2 = (Graphics2D)g;
 * g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING,
 * RenderingHints.VALUE_ANTIALIAS_ON); g2.setColor(getForeground());
 * g2.draw(shape); g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING,
 * RenderingHints.VALUE_ANTIALIAS_OFF);
 *  } public boolean contains(int x, int y) { initShape(); return
 * shape.contains(x, y); } }
 * 
 */
