/* 
 *    Copyright 2007 Takefumi MIYOSHI
 *    Licensed under the Apache License, Version 2.0 (the "License");
 *    you may not use this file except in compliance with the License.
 *    You may obtain a copy of the License at
 * 
 *        http://www.apache.org/licenses/LICENSE-2.0
 * 
 *    Unless required by applicable law or agreed to in writing, software
 *    distributed under the License is distributed on an "AS IS" BASIS,
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *    See the License for the specific language governing permissions and
 *    limitations under the License.
 */

/**
 * MICSのエンジンおよびMICSで規定するインターフェースの定義などのパッケージ
 */
package net.wasamon.mics;

/**
 * ExecutableElementがエンジンに返す実行状態を示すクラス
 * @author Takefumi MIYOSHI
 *
 */
public class ExecInfo {

	/**
	 * すぐに終了することができるかどうかのフラグ
	 */
	private boolean terminatableFlag;

	/**
	 * 次に実行されるまでに待つ必要があるサイクル数
	 */
	private int cycle;

	/**
	 * コンストラクタ。
	 * 停止可能で、次のサイクルで再び実行可能であることを示すインスタンスを生成する
	 */
	public ExecInfo() {
		this(true, 0);
	}

	/**
	 * 指定したフラグおよび、サイクル数の実行状態のインスタンスを生成する
	 * @param flag
	 * @param cycle
	 */
	public ExecInfo(boolean flag, int cycle) {
		terminatableFlag = flag;
		this.cycle = cycle;
	}

	/**
	 * この状態の停止可能フラグを指定した値にセットする
	 * @param flag
	 */
	public void setTerminatableFlag(boolean flag) {
		terminatableFlag = flag;
	}

	/**
	 * 停止可能状態にあるかどうかを判定する。
	 * 
	 */
	public boolean isTerminatable() {
		return terminatableFlag;
	}

	/**
	 * 次に実行可能となるまでのサイクル数を返す
	 * @return
	 */
	public int getCycle() {
		return cycle;
	}

	/**
	 * 次に実行可能になるまでのサイクル数をセットする
	 * @param v
	 */
	public void setCycle(int v) {
		cycle = v;
	}

}
