/* 
 *    Copyright 2007 Takefumi MIYOSHI
 *    Licensed under the Apache License, Version 2.0 (the "License");
 *    you may not use this file except in compliance with the License.
 *    You may obtain a copy of the License at
 * 
 *        http://www.apache.org/licenses/LICENSE-2.0
 * 
 *    Unless required by applicable law or agreed to in writing, software
 *    distributed under the License is distributed on an "AS IS" BASIS,
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *    See the License for the specific language governing permissions and
 *    limitations under the License.
 */

/**
 * 新たなMICSシミュレーション要素を作成する際のユーティリティクラスのパッケージ
 */
package net.wasamon.mics.util;

import java.util.ArrayList;
import java.util.Iterator;

import net.wasamon.mics.Channel;
import net.wasamon.mics.MicsCompositeElement;
import net.wasamon.mics.MicsException;

/**
 * 複数のチャネルを有するシミュレーション要素において、それらを管理するためのユーティリティクラス
 * @author Takefumi MIYOSHi
 */
public class ChannelManager {

	public class Element {
		public String id;

		public int offset;

		public MicsCompositeElement composite;

		private Channel channelInstance;

		public Element(MicsCompositeElement composite, String id, int offset) {
			this.composite = composite;
			this.id = id;
			this.offset = offset;
		}

		public Channel getChannel() throws MicsException {
			if (channelInstance == null) {
				channelInstance = composite.getChannel(id);
			}
			return channelInstance;
		}

	}

	private ArrayList channels;

	private MicsCompositeElement composite;

	public ChannelManager(MicsCompositeElement composite) {
		this.composite = composite;
		channels = new ArrayList();
	}

	public void add(String id, int offset) {
		channels.add(new Element(composite, id, offset));
	}

	public Element[] array() {
		return (Element[]) (channels.toArray(new Element[channels.size()]));
	}

	public Element search(int offset) throws IndexOutOfBoundsException {
		Iterator i = channels.iterator();
		Element element = null;
		while (i.hasNext()) {
			Element v = (Element) (i.next());
			if (v.offset <= offset && (element == null || v.offset >= element.offset)) {
				element = v;
			}
		}
		if (element == null)
			throw new IndexOutOfBoundsException();
		return element;
	}

	public int search(Channel c) {
		Iterator i = channels.iterator();
		while (i.hasNext()) {
			Element v = (Element) (i.next());
			try {
				if (v.getChannel() == c) {
					return v.offset;
				}
			} catch (MicsException e) {

			}
		}
		return 0;
	}

	public String[] getConnectedElements() {
		String s[] = new String[channels.size()];
		for (int i = 0; i < s.length; i++) {
			s[i] = ((Element) (channels.get(i))).id;
		}
		return s;
	}

}
