/* 
 *    Copyright 2007 Takefumi MIYOSHI
 *    Licensed under the Apache License, Version 2.0 (the "License");
 *    you may not use this file except in compliance with the License.
 *    You may obtain a copy of the License at
 * 
 *        http://www.apache.org/licenses/LICENSE-2.0
 * 
 *    Unless required by applicable law or agreed to in writing, software
 *    distributed under the License is distributed on an "AS IS" BASIS,
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *    See the License for the specific language governing permissions and
 *    limitations under the License.
 */

/**
 * 新たなMICSシミュレーション要素を作成する際のユーティリティクラスのパッケージ
 */
package net.wasamon.mics.util;

import java.awt.BorderLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableModel;

/**
 * MICSTableModelを貼付けたウィンドウを作成するクラス
 * @author Takefumi MIYOSHI
 *
 */
public class MicsTablePanel implements ActionListener {

	public interface DataMode {

	}

	private JFrame frame;
	private JTable table;

	private JButton updateButton;

	public MicsTablePanel(String title, TableModel data) {
		frame = new JFrame(title);
		frame.addWindowListener(new WindowAdapter() {
			public void windowClosing(WindowEvent e) {
				frame.setVisible(false);
			}
		});
		table = new JTable(data);
		table.setFont(new Font("MonoSpaced", Font.PLAIN, 12));
		frame.setLayout(new BorderLayout());
		{
			JPanel p = new JPanel();
			updateButton = new JButton("Update");
			updateButton.addActionListener(this);
			p.add(updateButton);
			frame.getContentPane().add(p, BorderLayout.NORTH);
		}
		{
			JPanel p = new JPanel();
			p.add(new JScrollPane(table));
			frame.getContentPane().add(p, BorderLayout.CENTER);
		}
		frame.pack();
		frame.setVisible(false);
	}

	public void setVisible(boolean f) {
		frame.setVisible(f);
	}

	public void update() {
		repaint();
	}

	public void repaint() {
		table.revalidate();
		table.repaint();
		frame.pack();
		frame.repaint();
	}

	public void actionPerformed(ActionEvent e) {
		Object obj = e.getSource();
		if (obj == null) {

		} else if (obj == updateButton) {
			repaint();
		}
	}

}
