/* 
 *    Copyright 2007 Takefumi MIYOSHI
 *    Licensed under the Apache License, Version 2.0 (the "License");
 *    you may not use this file except in compliance with the License.
 *    You may obtain a copy of the License at
 * 
 *        http://www.apache.org/licenses/LICENSE-2.0
 * 
 *    Unless required by applicable law or agreed to in writing, software
 *    distributed under the License is distributed on an "AS IS" BASIS,
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *    See the License for the specific language governing permissions and
 *    limitations under the License.
 */


#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>

#include "net_wasamon_mjlib_file_UnixFile.h"

JNIEXPORT jint JNICALL Java_net_wasamon_mjlib_file_UnixFile_chown
(JNIEnv *e, jclass c, jstring path, jint uid, jint gid){
  const char *s = e->GetStringUTFChars(path, NULL);
  chown(s, uid, gid);
  e->ReleaseStringUTFChars;
  return 0;
}

JNIEXPORT jint JNICALL Java_net_wasamon_mjlib_file_UnixFile_chmod
(JNIEnv *e, jclass c, jstring path, jint mode){
  const char *s = e->GetStringUTFChars(path, NULL);
  chmod(s, mode);
  e->ReleaseStringUTFChars;
  return 0;
}

JNIEXPORT jint JNICALL Java_net_wasamon_mjlib_file_UnixFile_getUid
(JNIEnv *e, jclass c, jstring path){
  const char *s = e->GetStringUTFChars(path, NULL);
  struct stat sb;
  stat(s, &sb);
  e->ReleaseStringUTFChars;
  return sb.st_uid;
}

JNIEXPORT jint JNICALL Java_net_wasamon_mjlib_file_UnixFile_getGid
(JNIEnv *e, jclass c, jstring path){
  const char *s = e->GetStringUTFChars(path, NULL);
  struct stat sb;
  stat(s, &sb);
  e->ReleaseStringUTFChars;
  return sb.st_gid;
}

JNIEXPORT jint JNICALL Java_net_wasamon_mjlib_file_UnixFile_getMode
(JNIEnv *e, jclass c, jstring path){
  const char *s = e->GetStringUTFChars(path, NULL);
  struct stat sb;
  stat(s, &sb);
  e->ReleaseStringUTFChars;
  return sb.st_mode;
}
