/* 
 *    Copyright 2007 Takefumi MIYOSHI
 *    Licensed under the Apache License, Version 2.0 (the "License");
 *    you may not use this file except in compliance with the License.
 *    You may obtain a copy of the License at
 * 
 *        http://www.apache.org/licenses/LICENSE-2.0
 * 
 *    Unless required by applicable law or agreed to in writing, software
 *    distributed under the License is distributed on an "AS IS" BASIS,
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *    See the License for the specific language governing permissions and
 *    limitations under the License.
 */

package net.wasamon.mjlib.ui;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

import javax.swing.SwingUtilities;

public class AWTOptionPane{

	String result;
	Dialog dialog;

	public static final int TextField = 1;
	
	private AWTOptionPane(Frame parent, String title){
		dialog = new Dialog(parent, title, true);
	}
	public static String showTextFieldDialog(Frame parent, String title, String message, String defaultValue){
		return showTextFieldDialog(parent, title, message, defaultValue, 40);
	}
	
	public static String showTextFieldDialog(Frame parent, String title, String message, String defaultValue, int width){
		final AWTOptionPane pane = new AWTOptionPane(parent, title);
		pane.dialog.setLayout(new BorderLayout());
		Label l = new Label(message);
		pane.dialog.add(l, BorderLayout.NORTH);
		final TextField field = new TextField(width);
		if(defaultValue != null){
			field.setText(defaultValue.trim());
		}
		pane.dialog.addWindowListener(new WindowAdapter(){
			public void windowClosing(WindowEvent e) {
				pane.result = null;
				pane.dialog.dispose();
			}
		});
		field.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				pane.result = field.getText();
				pane.dialog.dispose();
			}
		});
		pane.dialog.add(field, BorderLayout.CENTER);
		Button bOK = new Button("OK");
		bOK.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				pane.result = field.getText();
				pane.dialog.dispose();
			}
		});
		Button bCANCEL = new Button("Cancel");
		bCANCEL.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				pane.result = null;
				pane.dialog.dispose();
			}
		});
		Panel p = new Panel();
		p.add(bOK);
		p.add(bCANCEL);
		pane.dialog.add(p, BorderLayout.SOUTH);
		pane.dialog.pack();
		pane.dialog.show();
		return pane.result;
	}
	
	public static void showErrorDialog(Frame parent, String title, String message){
		final AWTOptionPane pane = new AWTOptionPane(parent, title);
		pane.dialog.setLayout(new BorderLayout());
		Label l = new Label(message);
		pane.dialog.add(l, BorderLayout.NORTH);
		pane.dialog.addWindowListener(new WindowAdapter(){
			public void windowClosing(WindowEvent e) {
				pane.result = null;
				pane.dialog.dispose();
			}
		});
		Button bOK = new Button("OK");
		bOK.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				pane.dialog.dispose();
			}
		});
		Panel p = new Panel();
		p.add(bOK);
		pane.dialog.add(p, BorderLayout.SOUTH);
		pane.dialog.pack();
		pane.dialog.show();
	}

	
	public static void main(String args[]){
		new AWTOptionPaneTest().go();
	}

}

class AWTOptionPaneTest implements ActionListener{
	Frame frame;
	Button btn;

	private void makeGUI(){
		frame = new Frame("Test");
		frame.addWindowListener(new WindowAdapter(){
			public void windowClosing(WindowEvent e) {
				System.exit(0);
			}
		});
		btn = new Button("Test");
		btn.addActionListener(this);
		frame.add(btn);
		frame.pack();
		frame.setVisible(true);
	}

	public void actionPerformed(ActionEvent arg0) {
		String v = AWTOptionPane.showTextFieldDialog(frame, "test", "message", "fefe");
		System.out.println("actionPerformed:" + v);
	}

	public void go() {
		SwingUtilities.invokeLater(new Runnable() {
			public void run() {
				makeGUI();
			}
		});
	}

}