package net.wasamon.mjlib.ui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;

import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.filechooser.FileFilter;

public abstract class FileRequestFrame implements ActionListener {

	protected JFrame frame;
	private JButton openButton;
	private JMenuItem openMenuItem;
	private JMenuItem exitMenuItem;

	private JFileChooser chooser;

	abstract public String getFrameName();

	abstract public boolean getExitOnClose();
	
	public void showGUI(){
		frame = new JFrame(getFrameName());
		if(getExitOnClose()) frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		JPanel p = new JPanel();
		openButton = makeJButton("Open", this);
		p.add(openButton);
//		graphBox = new JComboBox();
//		graphBox.addItem("Data Flow Graph");
//		graphBox.addItem("Call Flow Graph");
//		p.add(graphBox);
		frame.getContentPane().add(p);
		frame.setVisible(false);
		frame.setJMenuBar(makeMenuBar());
		chooser = new JFileChooser();
		chooser.setFileFilter(getFileFilter());
		frame.pack();
		show();
	}
	
	abstract public FileFilter getFileFilter();
	
	private JMenuItem makeMenuItem(String label){
		JMenuItem item = new JMenuItem(label);
		item.addActionListener(this);
		return item;
	}
	
	private JMenuBar makeMenuBar(){
		JMenuBar bar = new JMenuBar();
		{
			JMenu m = new JMenu("File");
			m.add(openMenuItem = makeMenuItem("Open"));
			m.addSeparator();
			m.add(exitMenuItem = makeMenuItem("Exit"));
			bar.add(m);
		}
		return bar;
	}

	public void show() {
		frame.setVisible(true);
	}

	private JButton makeJButton(String label, ActionListener listener) {
		JButton btn = new JButton(label);
		btn.addActionListener(listener);
		return btn;
	}

	
	abstract public void doFileOpen(File f);
	
	public void doOpenFileAndView(){
		int retVal = chooser.showOpenDialog(frame);
		if(retVal == JFileChooser.APPROVE_OPTION){
			File f = chooser.getSelectedFile();
			if(f != null){
				doFileOpen(f);
			}
		}
	}

	abstract public void exit(int stat); 
	
	public void actionPerformed(ActionEvent e) {
		Object obj = e.getSource();
		if (obj == null) {
			return;
		} else if (obj == openButton || obj == openMenuItem){
			doOpenFileAndView();
		}else if(obj == exitMenuItem){
			exit(0);
		}
	}

}
