package net.wasamon.mjlib.ui;

import java.io.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;
import java.util.*;

public class JContextList implements MouseListener{

  private JFrame frame;
  private JList list;
  private JContextList.Listener listener;

  public JContextList(String title, Object[] values, JContextList.Listener listener){
    this.listener = listener;
    frame = new JFrame();
    list = new JList(values);
    list.addMouseListener(this);
    frame.getContentPane().add(list);
    frame.pack();
    frame.setVisible(false);
  }

  public void setVisible(int x, int y, boolean flag){
    Rectangle r = frame.getBounds();
    frame.setBounds(x, y, r.width, r.height);
    frame.setVisible(flag);
  }

  public void mouseClicked(MouseEvent e){
    listener.selected(list.locationToIndex(e.getPoint()));
  }

  public void mouseEntered(MouseEvent e){
  }

  public void mouseExited(MouseEvent e){
  }

  public void mousePressed(MouseEvent e){
  }

  public void mouseReleased(MouseEvent e){
  }

  public interface Listener{
    public void selected(int index);
  }

}