/* 
 *    Copyright 2007 Takefumi MIYOSHI
 *    Licensed under the Apache License, Version 2.0 (the "License");
 *    you may not use this file except in compliance with the License.
 *    You may obtain a copy of the License at
 * 
 *        http://www.apache.org/licenses/LICENSE-2.0
 * 
 *    Unless required by applicable law or agreed to in writing, software
 *    distributed under the License is distributed on an "AS IS" BASIS,
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *    See the License for the specific language governing permissions and
 *    limitations under the License.
 */

package net.wasamon.mjlib.ui;

import java.io.OutputStream;

import java.awt.TextArea;

public class TextAreaOutputStream extends OutputStream{

	protected TextArea textarea;
	private StringBuffer buf;
	
	public TextAreaOutputStream(TextArea textarea){
		this.textarea = textarea;
		buf = new StringBuffer();
	}
	
	public void close(){
		this.flush();
		buf = null;
	}
	
	public void flush(){
		textarea.append(buf.toString());
		buf = new StringBuffer();
		textarea.setCaretPosition(textarea.getText().length());
	}
	
	public void write(byte[] b){
		buf.append(new String(b));
	}
	
	public void wirte(byte[] b, int off, int len){
		buf.append(new String(b, off, len));
	}
	
	public void write(int arg0){
		buf.append((char)(arg0 & 0x000000ff));
	}

}
