package net.wasamon.mjlib.util;

import junit.framework.TestCase;

public class DataUtilTest extends TestCase {

	public void test_toInteger(){
		assertEquals(0x01020304, DataUtil.toInteger(new byte[]{0x1, 0x2, 0x3, 0x4}));
		assertEquals(0xf1f2f3f4, DataUtil.toInteger(new byte[]{(byte)0xf1, (byte)0xf2, (byte)0xf3, (byte)0xf4}));
		assertEquals(0xffffeeee, DataUtil.toInteger((char)0xffff, (char)0xeeee));
		assertEquals(0x01020304, DataUtil.toInteger((char)0x0102, (char)0x0304));
		assertEquals(255, DataUtil.toInteger((byte)0xff));
	}
	
	public void test_toChar(){
		System.out.println((int)DataUtil.toChar(new byte[]{0x1,0x2}, 0, 2));
		assertEquals((char)0x0102, DataUtil.toChar(new byte[]{0x1,0x2}, 0, 2));
		assertEquals((char)0xffee, DataUtil.toChar(new byte[]{(byte)0xff,(byte)0xee}, 0, 2));
		assertEquals((char)0x0102, DataUtil.toChar((byte)0x1,(byte)0x2));
		assertEquals((char)0xffee, DataUtil.toChar((byte)0xff,(byte)0xee));
		assertEquals((byte)0xee, DataUtil.toByteL(DataUtil.toChar((byte)0xff,(byte)0xee)));
		assertEquals((byte)0xff, DataUtil.toByteH(DataUtil.toChar((byte)0xff,(byte)0xee)));
		assertEquals((char)0x00ff, DataUtil.toChar(new byte[]{(byte)0xff},0, 1));
	}
	
	private boolean array_equals(byte[] a, byte[] b){
		if(a.length != b.length){
			return false;
		}
		for(int i = 0; i < a.length; i++){
			if(a[i] != b[i]) return false;
		}
		return true;
	}
	
	public void test_toByteArray(){
		assertTrue(array_equals(new byte[]{(byte)0xff, (byte)0xee}, DataUtil.toByteArray((char)0xffee)));
		assertTrue(array_equals(new byte[]{(byte)0x01, (byte)0x02}, DataUtil.toByteArray((char)0x0102)));
		assertTrue(array_equals(new byte[]{(byte)0xff, (byte)0xff, (byte)0xff, (byte)0xff}, DataUtil.toByteArray(-1)));
		assertTrue(array_equals(new byte[]{(byte)0xff, (byte)0xff}, DataUtil.toByteArray(-1, 2)));
		assertTrue(array_equals(new byte[]{(byte)0xff, (byte)0xff, (byte)0xff, (byte)0xfe}, DataUtil.toByteArray(-2)));
		assertTrue(array_equals(new byte[]{(byte)0x01, (byte)0x02, (byte)0x03, (byte)0x04}, DataUtil.toByteArray(0x01020304)));
		assertTrue(array_equals(new byte[]{(byte)0x03, (byte)0x04}, DataUtil.toByteArray(0x01020304, 2)));
		assertTrue(array_equals(new byte[]{(byte)0x01, (byte)0x02}, DataUtil.toByteArray(DataUtil.toChar(new byte[]{0x1,0x2}, 0, 2))));
		assertTrue(array_equals(new byte[]{(byte)0xff,(byte)0xee}, DataUtil.toByteArray(DataUtil.toChar(new byte[]{(byte)0xff,(byte)0xee}, 0, 2))));
		assertEquals(-1, DataUtil.toInteger(DataUtil.toByteArray(-1)));
		assertEquals(-2, DataUtil.toInteger(DataUtil.toByteArray(-2)));
		assertEquals(0x01020304, DataUtil.toInteger(DataUtil.toByteArray(0x01020304)));
	}

	public void test_toCharL(){
		assertEquals((char)0xffff, DataUtil.toCharL(0xffffffff));
		assertEquals((char)0xffff, DataUtil.toCharL(0x0000ffff));
		assertEquals(0xffffeeee, DataUtil.toInteger(DataUtil.toCharH(0xffffeeee), DataUtil.toCharL(0xffffeeee)));
		assertEquals(0x01020304, DataUtil.toInteger(DataUtil.toCharH(0x01020304), DataUtil.toCharL(0x01020304)));
	}

	public void test_toCharH(){
		assertEquals((char)0xffff, DataUtil.toCharH(0xffffffff));
		assertEquals((char)0x0000, DataUtil.toCharH(0x0000ffff));
	}

	private boolean string_equals(String a, String b){
		return a.equals(b);
	}
	
	public void test_toBigEndianValueString(){
		assertTrue(string_equals("0x01020304", DataUtil.toBigEndianValueString(new byte[]{0x01, 0x02, 0x03, 0x04})));
		assertTrue(string_equals("0xffffffff", DataUtil.toBigEndianValueString(new byte[]{(byte)0xff, (byte)0xff, (byte)0xff, (byte)0xff})));
	}

	public void test_toLSB8() {
		assertEquals(0xfe, DataUtil.toLSB8((char)0xfffe));
		assertEquals(0x01, DataUtil.toLSB8((char)0xff01));
	}

	public void test_toUSB8(){
		assertEquals(0xff, DataUtil.toUSB8((char)0xfffe));
		assertEquals(0x03, DataUtil.toUSB8((char)0x0301));
	}

	public void test_toSiginedInteger() {
		assertEquals(-1, DataUtil.toSiginedInteger((char)0xffff));
		assertEquals(0x1234, DataUtil.toSiginedInteger((char)0x1234));
		assertEquals(32767, DataUtil.toSiginedInteger((char)0x7fff));
		assertEquals(-32768, DataUtil.toSiginedInteger((char)0x8000));
	}

	public void test_parseInt(){
		assertEquals(-1, DataUtil.parseInt("0xffffffff"));
		assertEquals(0x01020304, DataUtil.parseInt(DataUtil.toBigEndianValueString(new byte[]{0x01, 0x02, 0x03, 0x04})));
		assertEquals(-1, DataUtil.parseInt(DataUtil.toBigEndianValueString(new byte[]{(byte)0xff, (byte)0xff, (byte)0xff, (byte)0xff})));
	}

}
