/* 
 *    Copyright 2007 Takefumi MIYOSHI
 *    Licensed under the Apache License, Version 2.0 (the "License");
 *    you may not use this file except in compliance with the License.
 *    You may obtain a copy of the License at
 * 
 *        http://www.apache.org/licenses/LICENSE-2.0
 * 
 *    Unless required by applicable law or agreed to in writing, software
 *    distributed under the License is distributed on an "AS IS" BASIS,
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *    See the License for the specific language governing permissions and
 *    limitations under the License.
 */

/**
 * 通信路に相当するシミュレーション要素のパッケージ
 */
package net.wasamon.mics.bus;

import net.wasamon.mics.Channel;
import net.wasamon.mics.ChannelConnectable;
import net.wasamon.mics.DataBuffer;
import net.wasamon.mics.MicsDataPacket;
import net.wasamon.mics.MicsElement;
import net.wasamon.mics.MicsException;
import net.wasamon.mjlib.xml.XMLParser;
import net.wasamon.mjlib.xml.XMLParserException;

import org.w3c.dom.Node;

/**
 * 複数のChannelConnectableからのアクセスを同時に独立に処理することができるバス
 * @author Takefumi MIYOSHI
 *
 */
public class MultiDataBus extends MicsElement implements Channel {

	private String dest;

	public MultiDataBus() {
	}

	public String getImagePath() {
		return "combo_bus3.png";
	}

	public void initialize(String base, Node n) throws MicsException {
		try {
			{
				Node init_var_node = n;
				String init_var_ram;
				init_var_ram = XMLParser.getAttribute(init_var_node, "ram")
						.getNodeValue();

				this.dest = init_var_ram;

			}
		} catch (NumberFormatException e) {
			throw new MicsException(
					"configuration syntax error: net.wasamon.mics.bus.MultiDataBus16");
		} catch (XMLParserException e) {
			throw new MicsException(
					"configuration syntax error: net.wasamon.mics.bus.MultiDataBus16");
		}
	}

	private DataBuffer destChannelInstance;

	private DataBuffer destDataBuffer() throws MicsException {
		if (destChannelInstance == null) {
			destChannelInstance = composite.getDataBuffer(dest);
		}
		return destChannelInstance;
	}

	public void readRequest(ChannelConnectable src, MicsDataPacket data)
			throws MicsException {
		src.writeback(this, destDataBuffer().read(data));
	}

	public void writeRequest(ChannelConnectable src, MicsDataPacket data)
			throws MicsException {
		destDataBuffer().write(data);
	}

	public String getInfo() {
		String s = "";
		s += "MultiDataBus16\n";
		s += "  CLASS: " + this.getClass().getName() + "\n";
		s += "  Dest Memory ID: " + dest;
		return s;
	}

	public String[] getConnectedElements() {
		return new String[] { dest };
	}

	public void reset(){
		
	}
	
	public String getDescription(){
		return "TODO";
	}

}
