package net.wasamon.mics.freehdl;

import org.w3c.dom.Node;

import net.wasamon.mics.Channel;
import net.wasamon.mics.ChannelConnectable;
import net.wasamon.mics.MicsDataPacket;
import net.wasamon.mics.MicsElement;
import net.wasamon.mics.MicsException;
import net.wasamon.mics.data.ByteVector;
import net.wasamon.mics.memory.RandomAccessMemoryDataPacket;
import net.wasamon.mjlib.util.DataUtil;

public class BlockRamIface extends MicsElement implements Channel, ChannelConnectable{
	
	private Channel addr;
	private Channel data;
	private Channel we;

	private String addrName;
	private String dataName;
	private String weName;
	
	private byte[] POSITIVE = new byte[]{1};
	private byte[] NEGATIVE = new byte[]{0};

	@Override
	public String[] getConnectedElements() {
		return new String[]{addrName, dataName, weName};
	}

	@Override
	public String getDescription() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public String getImagePath() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public void initialize(String base, Node node) throws MicsException {
		addrName = getAttributeAsString(node, "addr");
		dataName = getAttributeAsString(node, "data");
		weName = getAttributeAsString(node, "we");
	}
	
	private Channel addr() throws MicsException{
		if(addr == null) addr = composite.getChannel(addrName);
		return addr;
	}
	private Channel data() throws MicsException{
		if(data == null) data = composite.getChannel(dataName);
		return data;
	}
	private Channel we() throws MicsException{
		if(we == null) we = composite.getChannel(weName);
		return we;
	}

	public void readRequest(ChannelConnectable src, MicsDataPacket data)
			throws MicsException {
		if(data instanceof RandomAccessMemoryDataPacket){
			int a = ((RandomAccessMemoryDataPacket)data).addr;
			addr().writeRequest(src, new ByteVector(DataUtil.toByteArray(a)));
			we().writeRequest(src, new ByteVector(NEGATIVE));
		}else{
			throw new MicsException("Unsupported data type: " + data.getClass().getName());
		}
	}

	public void writeRequest(ChannelConnectable src, MicsDataPacket data)
			throws MicsException {
		if(data instanceof RandomAccessMemoryDataPacket){
			int a = ((RandomAccessMemoryDataPacket)data).addr;
			addr().writeRequest(src, new ByteVector(DataUtil.toByteArray(a)));
			byte[] d = ((RandomAccessMemoryDataPacket)data).data;
			data().writeRequest(src, new ByteVector(DataUtil.toByteArray(a)));
			we().writeRequest(src, new ByteVector(POSITIVE));
		}else{
			throw new MicsException("Unsupported data type: " + data.getClass().getName());
		}
	}

	public void reset() {
		// TODO Auto-generated method stub
		
	}

	public int getChannelOffset(Channel c) {
		// TODO Auto-generated method stub
		return 0;
	}

	public void writeback(Channel src, MicsDataPacket data) throws MicsException {
		// TODO Auto-generated method stub
		
	}

}
