package net.wasamon.mics.freehdl;

import java.io.*;

public class Compiler{

  String FREEHDLLIB = "/usr/share/freehdl/lib";

  public Compiler(String top, String[] module) throws IOException, InterruptedException{
    String objs = "";
    Process p;
    for(String m: module){
      p = Runtime.getRuntime().exec("cp " + m + " " + FREEHDLLIB + "/work/");
      p.waitFor();
      p = Runtime.getRuntime().exec("gvhdl -c " + m);
      p.waitFor();
      objs += " " + m.replace(".vhdl", ".o");
    }
    
    p = Runtime.getRuntime().exec("gvhdl " + top + objs + " --libieee");
    p.waitFor();
  }

  public static void main(String args[]) throws Exception{
    String[] s = new String[args.length - 1];
    for(int i = 0; i < s.length; i++){
      s[i] = args[i+1];
    }
    Compiler c = new Compiler(args[0], s);
  }
}
