package net.wasamon.mics.freehdl;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;

import net.wasamon.mics.Channel;
import net.wasamon.mics.ChannelConnectable;
import net.wasamon.mics.ExecInfo;
import net.wasamon.mics.ExecutableElement;
import net.wasamon.mics.MicsDataPacket;
import net.wasamon.mics.MicsElement;
import net.wasamon.mics.MicsException;
import net.wasamon.mics.MicsViewable;
import net.wasamon.mics.data.ByteVector;
import net.wasamon.mics.freehdl.data.Signal;
import net.wasamon.mics.freehdl.ui.wave.FreeHDLWaveFrame;

import org.w3c.dom.Node;

public class FreeHDLWrapper extends MicsElement implements ExecutableElement,	Channel, MicsViewable {

	FreeHDLProcess fhdl;

	Hashtable<String, FreeHDLOutputStream> input;
	Hashtable<String, String> output;

	private String path;
	private int _times;
	private int times;
	private String step;
	String[] nodes;
	FreeHDLWaveFrame frame;

	public void initialize(String base, Node node) throws MicsException {
		this.path = toAbsolutePath(getAttributeAsString(node, "vhdl"));
		this._times = this.times = getAttributeAsInt(node, "times");
		input = new Hashtable<String, FreeHDLOutputStream>();
		output = new Hashtable<String, String>();
		initInput(getNamedNodeArray(node, "input"));
		initOutput(getNamedNodeArray(node, "output"));
		nodes = new String[input.size() + output.size()];
		{
			Enumeration<String> k = input.keys();
			int i = 0;
			while(k.hasMoreElements()){
				nodes[i] = k.nextElement();
				i++;	
			}
		}
		{
			Enumeration<String> k = output.keys();
			int i = 0;
			while(k.hasMoreElements()){
				nodes[i+input.size()] = k.nextElement();
				i++;	
			}
		}
		
		fhdl = new FreeHDLProcess(this.path);
		System.out.println(this.step);
		try {
			fhdl.run();
		} catch (IOException e) {
			throw new MicsException(e);
		}
	}
	
	public String getDescription(){
		return fhdl.getTopModule().dump();
	}

	private void initOutput(Node[] ns) throws MicsException{
		for (Node n : ns) {
			String s = getAttributeAsString(n, "dest");
			String port = getAttributeAsString(n, "port");
			output.put(s, port);
		}
	}

	private void initInput(Node[] ns) throws MicsException{
		for (Node n : ns) {
			String s = getAttributeAsString(n, "src");
			String f = toAbsolutePath(getAttributeAsString(n, "file"));
			int w = getAttributeAsInt(n, "width");
			FreeHDLOutputStream out = null;
			try {
				File file = new File(f);
				if(!file.exists()) file.createNewFile();
				out = new FreeHDLOutputStream(file, w);
			} catch (IOException e) {
				throw new MicsException(e);
			}
			input.put(s, out);
		}
	}

	public String[] getConnectedElements() {
		return nodes;
	}

	public String getImagePath() {
		return null;
	}

	public void reset() {
		times = _times;
	}

	public ExecInfo exec_first() throws MicsException {
		if(times > 0){
			times--;
			try {
				fhdl.step();
			} catch (IOException e) {
				throw new MicsException(e);
			}
		}
		return new ExecInfo((times <= 0), 0);
	}

	public ExecInfo exec_second() throws MicsException {
		if(times > 0){
			try {
				fhdl.step();
			} catch (IOException e) {
				throw new MicsException(e);
			}
		}
		return new ExecInfo((times <= 0), 0);
	}

	public void show() {
		if (frame == null) {
			frame = new FreeHDLWaveFrame(fhdl);
			frame.reset();
		}
		frame.setVisible(true);
	}
	
	public void readRequest(ChannelConnectable src, MicsDataPacket data) throws MicsException {
		Signal signal = fhdl.getTopModule().getSignal(output.get(src.id()));
		ByteVector d = new ByteVector(signal.getValue());
		src.writeback(this, d);
	}

	/**
	 * ソースであるChannelConnectableの書き込みリクエストをリクエスト対象に通知する。
	 */
	public void writeRequest(ChannelConnectable src, MicsDataPacket data)	throws MicsException {
		if (!(data instanceof ByteVector)) {
			throw new MicsException("FreeHDLWrapper::readeRequest <Illegal Data Packet Format> "
					+ data.getClass().getName());
		}
		FreeHDLOutputStream out = input.get(src.id());
		out.write((ByteVector) data);
	}

}
