package net.wasamon.mics.freehdl;

import net.wasamon.mics.Channel;
import net.wasamon.mics.ChannelConnectable;
import net.wasamon.mics.ExecInfo;
import net.wasamon.mics.ExecutableElement;
import net.wasamon.mics.MicsDataPacket;
import net.wasamon.mics.MicsElement;
import net.wasamon.mics.MicsException;
import net.wasamon.mics.data.ByteVector;
import net.wasamon.mjlib.util.DataUtil;

import org.w3c.dom.Node;

public class SimplePortIface extends MicsElement implements ExecutableElement, Channel, ChannelConnectable{
	
	private Channel dest;
	private ChannelConnectable src;
	
	private ByteVector defVal;
	
	private boolean writeFlag;

	@Override
	public String[] getConnectedElements() {
		return new String[]{src.id(), dest.id()};
	}

	@Override
	public String getDescription() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public String getImagePath() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public void initialize(String base, Node node) throws MicsException {
		dest = composite.getChannel(getAttributeAsString(node, "dest"));
		src = composite.getChannelConnectable(getAttributeAsString(node, "src"));
		defVal = new ByteVector(DataUtil.toByteArray(getAttributeAsInt(node, "default")));
		reset();
	}
	
	public void readRequest(ChannelConnectable src, MicsDataPacket data)
			throws MicsException {
		dest.readRequest(this, data);
	}

	public void writeRequest(ChannelConnectable src, MicsDataPacket data)
			throws MicsException {
		dest.writeRequest(this, data);
		writeFlag = true;
	}

	public void reset() {
		writeFlag = false;
	}

	public int getChannelOffset(Channel c) {
		// TODO Auto-generated method stub
		return 0;
	}

	public void writeback(Channel src, MicsDataPacket data) throws MicsException {
		this.src.writeback(this, data);
	}

	public ExecInfo exec_first() throws MicsException {
		if(!writeFlag){
			dest.writeRequest(this, defVal);
		}
		return null;
	}

	public ExecInfo exec_second() throws MicsException {
		// TODO Auto-generated method stub
		return null;
	}


}
