package net.wasamon.mics.freehdl.data;

public class LogicData{

  public final int value;

  public static final int POSITIVE = 1;
  public static final int NEGATIVE = 0;
  public static final int UNKNOWN  = -1;
  public static final int DONTCARE = -2;

  public LogicData(char v){
    switch(v){
    case '1':
      value = POSITIVE;
      break;
    case '0':
      value = NEGATIVE;
      break;
    case 'U':
      value = UNKNOWN;
      break;
    case 'X':
      value = DONTCARE;
      break;
    default:
      value = UNKNOWN;
    }
  }

  public String getValueAsString(){
    switch(value){
    case POSITIVE:
      return "1";
    case NEGATIVE:
      return "0";
    case UNKNOWN:
      return "U";
    case DONTCARE:
      return "X";
    default:
      return "U";
    }
  }

  public boolean equals(LogicData data){
    if(data == null){
      return false;
    }else{
      return value == data.value;
    }
  }

}