package net.wasamon.mics.freehdl.data;


/**
 * VHDLのSignalに対応する型が継承すべき基底クラス
 */
public abstract class Signal extends FreeHDLObject {

	protected Module module;

	public static final int BINARY = 1;
	public static final int HEX = 2;
	public static final int ASCII = 3;

	protected int stringType = BINARY;

	public Signal(String longname, String name) {
		super(longname, name);
	}

	public void setModule(Module m) {
		this.module = m;
	}

	abstract public String getValueAsString();
	
	abstract public byte[] getValue();

	abstract public String getValueAsString(int index);

	abstract public void setValue(String value);

	public void setStringType(int type) {
		stringType = type;
	}

	abstract public int size();

}
