package net.wasamon.mics.freehdl.data;

import java.util.*;

public class StdLogic extends Signal{

  ArrayList<LogicData> values;
  String lastVal;

  public StdLogic(String longname, String name, String v){
    super(longname, name);
    this.values = new ArrayList<LogicData>();
    setValue(v);
  }

  public String getValueAsString(){
    return lastVal;
  }

  public String getValueAsString(int index){
    if(index > 0 && index < values.size()){
      return values.get(index).getValueAsString();
    }else{
      return "-";
    }
  }

  public Iterator<LogicData> iterator(){
    return values.iterator();
  }

  public void setValue(String v){
    this.values.add(new LogicData(v.charAt(1)));
    lastVal = v.substring(1,2);
  }

  public int size(){
    return values.size();
  }
  
  public byte[] getValue(){
  	byte[] b = new byte[1];
  	switch(values.get(values.size()-1).value){
  	case LogicData.POSITIVE:
  		b[7] = 1;
  		break;
  	case LogicData.NEGATIVE:
  		b[7] = 0;
  		break;
  	default:
  		b[7] = 0;
  	}
  	return b;
  }

}
