package net.wasamon.mics.memory;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;

import net.wasamon.mics.DataBuffer;
import net.wasamon.mics.DataBufferException;
import net.wasamon.mics.MicsDataPacket;
import net.wasamon.mics.MicsElement;
import net.wasamon.mics.MicsException;
import net.wasamon.mics.data.ByteVector;

import org.w3c.dom.Node;

/**
 * ByteVectorをファイルとして出力するMICS要素
 */
public class ByteVectorToWriter extends MicsElement implements DataBuffer{

	private PrintWriter writer;

	public String getDescription(){
		return "TODO";
	}

	public void write(ByteVector data){
    writer.println(data.toBitString());
  }

	@Override
	public String[] getConnectedElements() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public String getImagePath() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public void initialize(String base, Node node) throws MicsException {
		String type = getAttributeAsString(node, "type");
		if("file".equals(type)){
			String path = toAbsolutePath(getAttributeAsString(node, "name"));
			try{
				writer = new PrintWriter(new FileOutputStream(path, false), true);
			}catch(IOException e){
				throw new MicsException(e);
			}
		}else{
			throw new MicsException("Unsupported Type: " + type);
		}
	}

	public void reset() {
		// TODO Auto-generated method stub
		
	}

	public void dump(int offset, int len, OutputStream writer)
			throws DataBufferException {
		// TODO Auto-generated method stub
		
	}

	public MicsDataPacket read(MicsDataPacket data) throws DataBufferException {
		// TODO Auto-generated method stub
		return null;
	}

	public int size() {
		// TODO Auto-generated method stub
		return 0;
	}

	public String toString(int addr, int length) {
		// TODO Auto-generated method stub
		return null;
	}

	public void write(MicsDataPacket data) {
		write((ByteVector)data);
	}

	public void write(int offset, InputStream reader) throws DataBufferException {
		// TODO Auto-generated method stub
		
	}

}
