package net.wasamon.mics.processor.mips;

public class MipsFloatRegister implements MipsRegister {
    float value;

    public MipsFloatRegister(){
	value = 0x00000000;
    }

    public int getAsIntValue(){
	return Float.floatToIntBits(value);
    }

    public float getAsFloatValue(){
	return value;
    }

    public void reset(){
	value = 0x00000000;
    }

    public void setAsBits(int bits){
	value = Float.intBitsToFloat(bits);
    }

    public void setAsBits(float bits){
	value = bits;
    }

    public String toString(){
	return String.format("%08x", getAsIntValue());
    }

}
