--
-- kb_read_sciiѤΥƥȥ⥸塼
--
-- Written by Takefumi MIYOSHi
-- 2008.08.19
-- 
library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.STD_LOGIC_ARITH.ALL;
use IEEE.STD_LOGIC_UNSIGNED.ALL;

library work;
use work.kb_read_ascii;

library std;
use std.textio.all;

entity kb_read_ascii_test is
end kb_read_ascii_test;


architecture RTL of kb_read_ascii_test is

  component kb_read_ascii
    port (
      -- Υ⥸塼λĥ֥åإǡ񤭹िΥݡ
      iKBD_BRAM_write_ADDR : in std_logic_vector(7 downto 0);
      iKBD_BRAM_write_DATA : in std_logic_vector(7 downto 0);
      iKBD_BRAM_write_WE   : in std_logic_vector(0 downto 0);
      -- Υ⥸塼˥ꥯȤ뤿濮
      iKBD_LENGTH   : in  std_logic_vector(7 downto 0);
      iKBD_BUSY     : out std_logic;
      iKBD_REQ      : in  std_logic;
      -- ºݤΥܡɤȤ³ˤ뿮
      pKBD_DATA     : out std_logic_vector(7 downto 0);
      pKBD_INDEX    : in  std_logic_vector(17 downto 0);
      --
      pKBD_CLK      : in  std_logic;
      pKBD_RESET    : in  std_logic
      );
  end component;

  -- Υ⥸塼λĥ֥åإǡ񤭹िΥݡ
  signal iKBD_BRAM_write_ADDR : std_logic_vector(7 downto 0);
  signal iKBD_BRAM_write_DATA : std_logic_vector(7 downto 0);
  signal iKBD_BRAM_write_WE   : std_logic_vector(0 downto 0);

  signal iKBD_LENGTH   : std_logic_vector(7 downto 0);
  signal iKBD_BUSY     : std_logic;
  signal iKBD_REQ      : std_logic_vector(0 downto 0);

  signal pKBD_DATA     : std_logic_vector(7 downto 0);
  signal pKBD_INDEX    : std_logic_vector(17 downto 0);

  signal pKBD_CLK      : std_logic;
  signal pKBD_RESET    : std_logic;

  file src_iKBD_BRAM_write_ADDR : text open read_mode is "src_iKBD_BRAM_write_ADDR";
  file src_iKBD_BRAM_write_DATA : text open read_mode is "src_iKBD_BRAM_write_DATA";
  file src_iKBD_BRAM_write_WE : text open read_mode is "src_iKBD_BRAM_write_WE";
  file src_iKBD_LENGTH : text open read_mode is "src_iKBD_LENGTH";
  file src_iKBD_REQ : text open read_mode is "src_iKBD_REQ";
  file src_pKBD_INDEX : text open read_mode is "src_pKBD_INDEX";

begin

  U0 : kb_read_ascii port map (
    iKBD_BRAM_write_ADDR,
    iKBD_BRAM_write_DATA,
    iKBD_BRAM_write_WE,
    iKBD_LENGTH,
    iKBD_BUSY,
    iKBD_REQ(0),
    pKBD_DATA,
    pKBD_INDEX,
    pKBD_CLK,
    pKBD_RESET
  );

  process
  begin
    pKBD_CLK <= '0';
    wait for 20ns;
    pKBD_CLK <= '1';
    wait for 20ns;
  end process;

  process
  begin
    pKBD_RESET <= '1';
  end process;

  process
    variable line_iKBD_BRAM_write_ADDR : line;
    variable var_iKBD_BRAM_write_ADDR  : bit_vector(7 downto 0);
    variable line_iKBD_BRAM_write_DATA : line;
    variable var_iKBD_BRAM_write_DATA  : bit_vector(7 downto 0);
    variable line_iKBD_BRAM_write_WE   : line;
    variable var_iKBD_BRAM_write_WE    : bit_vector(0 downto 0);
    variable line_iKBD_LENGTH          : line;
    variable var_iKBD_LENGTH           : bit_vector(7 downto 0);
    variable line_iKBD_REQ             : line;
    variable var_iKBD_REQ              : bit_vector(0 downto 0);
    variable line_pKBD_INDEX           : line;
    variable var_pKBD_INDEX            : bit_vector(17 downto 0);
  begin
    wait until pKBD_CLK'event and pKBD_CLK = '1';
    readline(src_iKBD_BRAM_write_ADDR, line_iKBD_BRAM_write_ADDR);
    read(line_iKBD_BRAM_write_ADDR, var_iKBD_BRAM_write_ADDR);
    iKBD_BRAM_write_ADDR <= to_stdlogicvector(var_iKBD_BRAM_write_ADDR);

    readline(src_iKBD_BRAM_write_DATA, line_iKBD_BRAM_write_DATA);
    read(line_iKBD_BRAM_write_DATA, var_iKBD_BRAM_write_DATA);
    iKBD_BRAM_write_DATA <= to_stdlogicvector(var_iKBD_BRAM_write_DATA);

    readline(src_iKBD_BRAM_write_WE,   line_iKBD_BRAM_write_WE  );
    read(line_iKBD_BRAM_write_WE,   var_iKBD_BRAM_write_WE  );
    iKBD_BRAM_write_WE   <= to_stdlogicvector(var_iKBD_BRAM_write_WE);

    readline(src_iKBD_LENGTH,          line_iKBD_LENGTH         );
    read(line_iKBD_LENGTH,          var_iKBD_LENGTH         );
    iKBD_LENGTH          <= to_stdlogicvector(var_iKBD_LENGTH);

    readline(src_iKBD_REQ,             line_iKBD_REQ            );
    read(line_iKBD_REQ,             var_iKBD_REQ            );
    iKBD_REQ             <= to_stdlogicvector(var_iKBD_REQ);

    readline(src_pKBD_INDEX,           line_pKBD_INDEX          );
    read(line_pKBD_INDEX,           var_pKBD_INDEX          );
    pKBD_INDEX           <= to_stdlogicvector(var_pKBD_INDEX);
  end process;

end RTL;
