/* Copyright 2006-2007 (c) Takefumi MIYOSHI All rights reserved. */

package net.wasamon.wallet;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.FileDialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.PrintStream;
import java.util.Calendar;

import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;

import net.wasamon.mjlib.ui.JTextAreaOutputStream;

public class WalletGUI implements ActionListener {

	WalletOptionSpec walletSpec;
	
	private WalletGUI(){
		walletSpec = new WalletOptionSpec();
		walletSpec.setProcessor("simpleprocessor32");
		walletSpec.setCheckNoAlign(true);
		frame = new JFrame("Coins GUI Frontend");
		frame.addWindowListener(new WindowAdapter() {
			public void windowClosing(WindowEvent e) {
				if (standaloneFlag) {
					System.exit(0);
				} else {
					frame.setVisible(false);
				}
			}
		});
		frame.setLayout(new BorderLayout());
		{
			JPanel p = new JPanel();
			p.add(processorSelectPanel());
			p.add(outputSelectPanel());
			p.add(optionCheckPanel());
			frame.getContentPane().add(p, BorderLayout.NORTH);
		}
		{
			JPanel p = new JPanel();
			p.add(fileNameField = new JTextField(30));
			fileNameField.setEditable(false);
			p.add(openFileButton = makeJButton("Select"));
			p.add(doCompileButton = makeJButton("Compile"));
			frame.getContentPane().add(p, BorderLayout.CENTER);
		}
		logArea = new JTextArea(10, 40);
		logArea.setWrapStyleWord(true);
		logArea.setEditable(false);
		frame.getContentPane().add(new JScrollPane(logArea, JScrollPane.VERTICAL_SCROLLBAR_AS_NEEDED, JScrollPane.HORIZONTAL_SCROLLBAR_AS_NEEDED), BorderLayout.SOUTH);
		frame.pack();
		frame.setVisible(false);
	}
	private static WalletGUI instance = new WalletGUI();
	public static WalletGUI getInstance(){
		return instance;
	}
	
	private JFrame frame;

	private JComboBox processorList;

	private JRadioButton outputLIR;

	private JRadioButton outputHIR;

	private JRadioButton outputSnapShot;

	private JRadioButton outputAsm;

	private JRadioButton outputBinary;

	private JButton openFileButton;

	private JButton doCompileButton;

	private JTextField fileNameField;

	private JTextArea logArea;
	
	private JPanel processorSelectPanel() {
		JPanel p = new JPanel();
		processorList = new JComboBox();
		processorList.addItem("simpleprocessor32");
		processorList.addItem("simpleprocessor");
		processorList.addItem("sh4");
		processorList.addItem("x86");
		p.add(processorList);
		p.setBorder(new TitledBorder(new LineBorder(Color.gray, 1),
				"processor", TitledBorder.CENTER, TitledBorder.TOP));
		processorList.addActionListener(this);
		processorList.setSelectedIndex(0);
		return p;
	}

	private JRadioButton makeRadioButton(ButtonGroup g, String label) {
		JRadioButton r = new JRadioButton(label);
		r.addActionListener(this);
		r.setSelected(false);
		g.add(r);
		return r;
	}

	private JCheckBox makeCheckBox(String label) {
		JCheckBox b = new JCheckBox(label);
		b.addActionListener(this);
		b.setSelected(false);
		return b;
	}

	private JPanel outputSelectPanel() {
		JPanel p = new JPanel();
		ButtonGroup g = new ButtonGroup();
		p.add(outputLIR = makeRadioButton(g, "LIR"));
		// p.add(outputHIR = makeRadioButton(g, "HIR"));
		p.add(outputSnapShot = makeRadioButton(g, "SnapShot"));
		p.add(outputAsm = makeRadioButton(g, "Assembly"));
		p.add(outputBinary = makeRadioButton(g, "Binary"));
		outputBinary.setSelected(true);
		p.setBorder(new TitledBorder(new LineBorder(Color.gray, 1), "output",
				TitledBorder.CENTER, TitledBorder.TOP));
		return p;
	}

	JCheckBox checkNoAlign;

	private JPanel optionCheckPanel() {
		JPanel p = new JPanel();
		p.add(checkNoAlign = makeCheckBox("No Align"));
		checkNoAlign.setSelected(true);
		p.setBorder(new TitledBorder(new LineBorder(Color.gray, 1), "options",
				TitledBorder.CENTER, TitledBorder.TOP));
		return p;
	}

	private JButton makeJButton(String label) {
		JButton b = new JButton(label);
		b.addActionListener(this);
		return b;
	}

	private String openFileDialog() {
		String path = "";
		FileDialog fd = new FileDialog(frame, "Open Source File",
				FileDialog.LOAD);
		fd.setVisible(true);
		if (fd.getFile() != null) {
			path = new File(fd.getDirectory(), fd.getFile()).getAbsolutePath();
		}
		return path;
	}

	boolean standaloneFlag = false;

	public void openGUI() {
		if(standaloneFlag){
			System.setOut(new PrintStream(new JTextAreaOutputStream(logArea), true));
			System.setErr(new PrintStream(new JTextAreaOutputStream(logArea), true));
		}
		frame.setVisible(true);
	}

	public void actionPerformed(ActionEvent ev) {
		Object obj = ev.getSource();
		if (obj == null) {
		} else if (obj == processorList) {
			walletSpec.setProcessor((String) ((JComboBox) processorList).getSelectedItem());
		} else if (obj == outputLIR) {
			walletSpec.setOutputType(WalletOptionSpec.outputTypeLIR);
		} else if (obj == outputHIR) {
			walletSpec.setOutputType(WalletOptionSpec.outputTypeHIR);
		} else if (obj == outputSnapShot) {
			walletSpec.setOutputType(WalletOptionSpec.outputTypeSnapShot);
		} else if (obj == outputAsm) {
			walletSpec.setOutputType(WalletOptionSpec.outputTypeAsm);
		} else if (obj == outputBinary) {
			walletSpec.setOutputType(WalletOptionSpec.outputTypeBin);
		} else if (obj == openFileButton) {
			String filename = openFileDialog();
			fileNameField.setText(filename);
			walletSpec.setFileName(new String[]{filename});
			walletSpec.setOutputFileName(filename, "out");
		} else if (obj == doCompileButton) {
			doCompileButton.setEnabled(false);
			WalletDriver driver = new WalletDriver();
			int status = driver.doCompile(walletSpec);
			doCompileButton.setEnabled(true);
			if (status != 0) {
				System.out.println("\nCompile Failure\n");
			} else {
				System.out.println("\nCompile Success at " + Calendar.getInstance().getTime() + "\n");
			}
		} else if (obj == fileNameField) {
		} else if (obj == checkNoAlign) {
			walletSpec.setCheckNoAlign(checkNoAlign.isSelected());
		} else {
			System.out.println(ev);
		}
	}

	public static void main(String[] args) {
		WalletGUI.getInstance().standaloneFlag = true;
		WalletGUI.getInstance().openGUI();
	}

}
