/* Copyright 2006-2007 (c) Takefumi MIYOSHI All rights reserved. */
package net.wasamon.wallet.binutils;

import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;

import net.wasamon.mjlib.util.DataUtil;
import net.wasamon.mjlib.xml.XMLParser;
import net.wasamon.mjlib.xml.XMLParserException;
import net.wasamon.mjlib.xml.XMLUtil;

import org.w3c.dom.Node;

public class DataElement{
	public int offset;
	public int length;
	public int type;
	public ByteArrayOutputStream data = new ByteArrayOutputStream();
	
	public static final int TYPE_UNKNOWN = -1; 
	public static final int TYPE_INT = 0; 
	public static final int TYPE_FLOAT = 1; 
	public static final int TYPE_ARRAY = 2; 
	
	public DataElement(int offset){
		this.offset = offset;
		this.length = 4;
		this.type = TYPE_UNKNOWN;
	}

	public static DataElement inputFromXML(Node node) throws XMLParserException{
		int offset = DataUtil.parseInt(XMLParser.getAttribute(node, "offset").getNodeValue());
		DataElement data = new DataElement(offset);
		String t = XMLParser.getAttribute(node, "type").getNodeValue();
		if(t.equals("int")){
			data.type = TYPE_INT;
		}else if(t.equals("float")){
			data.type = TYPE_FLOAT;
		}else if(t.equals("array")){
			data.type = TYPE_ARRAY;
		}
		String s[] = XMLParser.getNodeText(node).split("\\s*,\\s*");
		for(int i = 0; i < s.length; i++){
			data.data.write(Byte.parseByte(s[i]));
		}
		return data;
	}

	public void outputAsXML(PrintWriter writer, String label){
		String s = "";
		byte[] d = data.toByteArray();
		for(int i = 0; i < d.length; i++){
			s += "," + d[i];
		}
		String t = "unknown";
		switch(type){
		case DataElement.TYPE_INT:
			t = "int";
			break;
		case DataElement.TYPE_FLOAT:
			t = "float";
			break;
		case DataElement.TYPE_ARRAY:
			t = "array";
			break;
		}
		writer.println(XMLUtil.toElementString("data", new String[]{"label", label, "type", t, "offset", String.valueOf(offset)}, s.substring(1)));
	}

	
	
	
}