/* Copyright 2006-2007 (c) Takefumi MIYOSHI All rights reserved. */

package net.wasamon.wallet.binutils;

import java.io.IOException;
import java.io.PrintWriter;

import net.wasamon.mjlib.xml.XMLParser;
import net.wasamon.mjlib.xml.XMLParserException;
import net.wasamon.mjlib.xml.XMLUtil;

import org.w3c.dom.Node;

public class ProgramCode {
	public String inst = null;

	public String[] args = new String[3];

	public ProgramCode(String inst, String[] args){
		this.inst = inst.toUpperCase();
		if (args != null){
			for(int i = 0; i < args.length; i++){
				this.args[i] = args[i];
			}
		}
	}
	
	public String toString(){
		String s = "";
		s += "[ProgramCode insta="+inst+", args="+args[0]+","+args[1]+","+args[2]+"]";
		return s;
	}
	
	public void outputAsXML(PrintWriter writer) throws IOException{
		String c = "";
		for(int i = 0; i < args.length; i++){
			c += XMLUtil.toElementString("args", new String[]{"value", args[i]});
			c += "\n";
		}
		writer.println(XMLUtil.toElementString("code", new String[]{"inst", inst}, c));
	}

	public static ProgramCode inputFromXML(Node node) throws XMLParserException{
		String inst = XMLParser.getAttribute(node, "inst").getNodeValue();
		Node[] argNodes = XMLParser.getNamedNodeArray(node, "args");
		String args[] = new String[argNodes.length];
		for(int i = 0; i < args.length; i++){
			String v = XMLParser.getAttribute(argNodes[i], "value").getNodeValue();
			if("null".equals(v)){
				args[i] = null;
			}else{
				args[i] = v;
			}
		}
		return new ProgramCode(inst, args);
	}
	
}
