/* Copyright 2006-2007 (c) Takefumi MIYOSHI All rights reserved. */

package net.wasamon.wallet.binutils;

import java.util.regex.Pattern;


public class SimpleAssembler implements Parser{
	
	public SimpleAssembler(){
	}

	/** 一行の空白を取りのぞくためのパターン */
	static Pattern linePattern = Pattern.compile("\\s+");
	/** 引数を,で分割するパターン */
	static Pattern argPattern = Pattern.compile(",");

	public String getLabelStr(String key) {
		return key.substring(0, key.length() - 1);
	}

	public String getSectionName(String section) {
		String[] token = linePattern.split(section);
		return token[1].substring(1, token[1].length() - 1);
	}

	public boolean isAssemblerCommand(String key) {
		return key.startsWith(".");
	}

	public boolean isLabel(String key) {
		return key.endsWith(":");
	}

	public boolean isSection(String key) {
		return key.startsWith(".section");
	}
	
	public boolean isComment(String key){
		return key.startsWith(";") || key.startsWith("/*");
	}

	public String[] getArgumentItems(String s) {
		return argPattern.split(s);
	}

	public String getLineArgument(String s) {
		return linePattern.split(s)[1];
	}
	
	public String[] getLineItems(String s){
		return linePattern.split(s);
	}
	
}
