package net.wasamon.wallet.binutils.data;
import java.util.ArrayList;
import java.util.Iterator;


public class GlobalSymbolTable implements SymbolTable{
	
	/**
	 * Section���R���N�V����
	 */
	ArrayList _sections;
	
	public GlobalSymbolTable(){
		_sections = new ArrayList();
	}
	
	public Object getValue(String key){
		Iterator i = _sections.iterator();
		while(i.hasNext()){
			Section section = (Section)(i.next());
			if(section.symtab.hasSymbol(key)){
				return section.symtab.getValue(key);
			}
		}
		return null;
	}

	public boolean hasSymbol(String key){
		Iterator i = _sections.iterator();
		while(i.hasNext()){
			Section section = (Section)(i.next());
			if(section.symtab.hasSymbol(key)){
				return true;
			}
		}
		return false;
	}

}
