package net.wasamon.wallet.preprocessor;

/**
* A syntax representation, generated by &#xAC;&lt;&gt;&lt;&#x222A;&#x222A; (notavaCC) 1.0.3.  Licensed under GPL usually.
* <p>
* A node of the tree is an instance of sub-types of {@link Node}.
* <p>
* This class and any nested classes in this class are <strong>not synchronized</strong>.
*
*/
public class PreProcessorParser {
    /**
    * Constructs a parser.
    * @since    notavaCC 1.0
    */
    public PreProcessorParser() {
    }
    
    
    /**
    * Describes the EOF.
    * @see     PreProcessorParser.Token#getSymbolID()
    * @since    notavaCC 1.0
    */
    public static final int EOF_TOKEN = 0;
    /**
    * Describes the terminal symbol <code>SPACE</code>.
    * @see     PreProcessorParser.Token#getSymbolID()
    */
    public static final int TOKEN_SPACE = 1;
    /**
    * Describes the terminal symbol <code>COMMENT</code>.
    * @see     PreProcessorParser.Token#getSymbolID()
    */
    public static final int TOKEN_COMMENT = 2;
    /**
    * Describes the terminal symbol <code>CXXCOMMENT</code>.
    * @see     PreProcessorParser.Token#getSymbolID()
    */
    public static final int TOKEN_CXXCOMMENT = 3;
    /**
    * Describes the terminal symbol <code>DIRECTIVE</code>.
    * @see     PreProcessorParser.Token#getSymbolID()
    */
    public static final int TOKEN_DIRECTIVE = 4;
    /**
    * Describes the terminal symbol <code>LEFT_PAREN</code>.
    * @see     PreProcessorParser.Token#getSymbolID()
    */
    public static final int TOKEN_LEFT_PAREN = 5;
    /**
    * Describes the terminal symbol <code>RIGHT_PAREN</code>.
    * @see     PreProcessorParser.Token#getSymbolID()
    */
    public static final int TOKEN_RIGHT_PAREN = 6;
    /**
    * Describes the terminal symbol <code>LEFT_BAREN</code>.
    * @see     PreProcessorParser.Token#getSymbolID()
    */
    public static final int TOKEN_LEFT_BAREN = 7;
    /**
    * Describes the terminal symbol <code>RIGHT_BAREN</code>.
    * @see     PreProcessorParser.Token#getSymbolID()
    */
    public static final int TOKEN_RIGHT_BAREN = 8;
    /**
    * Describes the terminal symbol <code>LEFT_BBAREN</code>.
    * @see     PreProcessorParser.Token#getSymbolID()
    */
    public static final int TOKEN_LEFT_BBAREN = 9;
    /**
    * Describes the terminal symbol <code>RIGHT_BBAREN</code>.
    * @see     PreProcessorParser.Token#getSymbolID()
    */
    public static final int TOKEN_RIGHT_BBAREN = 10;
    /**
    * Describes the terminal symbol <code>COMMA</code>.
    * @see     PreProcessorParser.Token#getSymbolID()
    */
    public static final int TOKEN_COMMA = 11;
    /**
    * Describes the terminal symbol <code>QUOTE</code>.
    * @see     PreProcessorParser.Token#getSymbolID()
    */
    public static final int TOKEN_QUOTE = 12;
    /**
    * Describes the terminal symbol <code>SEMICOLON</code>.
    * @see     PreProcessorParser.Token#getSymbolID()
    */
    public static final int TOKEN_SEMICOLON = 13;
    /**
    * Describes the terminal symbol <code>COLON</code>.
    * @see     PreProcessorParser.Token#getSymbolID()
    */
    public static final int TOKEN_COLON = 14;
    /**
    * Describes the terminal symbol <code>ASTERRISC</code>.
    * @see     PreProcessorParser.Token#getSymbolID()
    */
    public static final int TOKEN_ASTERRISC = 15;
    /**
    * Describes the terminal symbol <code>AMPARSAND</code>.
    * @see     PreProcessorParser.Token#getSymbolID()
    */
    public static final int TOKEN_AMPARSAND = 16;
    /**
    * Describes the terminal symbol <code>EQUAL</code>.
    * @see     PreProcessorParser.Token#getSymbolID()
    */
    public static final int TOKEN_EQUAL = 17;
    /**
    * Describes the terminal symbol <code>LT</code>.
    * @see     PreProcessorParser.Token#getSymbolID()
    */
    public static final int TOKEN_LT = 18;
    /**
    * Describes the terminal symbol <code>GT</code>.
    * @see     PreProcessorParser.Token#getSymbolID()
    */
    public static final int TOKEN_GT = 19;
    /**
    * Describes the terminal symbol <code>PLUS</code>.
    * @see     PreProcessorParser.Token#getSymbolID()
    */
    public static final int TOKEN_PLUS = 20;
    /**
    * Describes the terminal symbol <code>MINUS</code>.
    * @see     PreProcessorParser.Token#getSymbolID()
    */
    public static final int TOKEN_MINUS = 21;
    /**
    * Describes the terminal symbol <code>DIV</code>.
    * @see     PreProcessorParser.Token#getSymbolID()
    */
    public static final int TOKEN_DIV = 22;
    /**
    * Describes the terminal symbol <code>MOD</code>.
    * @see     PreProcessorParser.Token#getSymbolID()
    */
    public static final int TOKEN_MOD = 23;
    /**
    * Describes the terminal symbol <code>NOT</code>.
    * @see     PreProcessorParser.Token#getSymbolID()
    */
    public static final int TOKEN_NOT = 24;
    /**
    * Describes the terminal symbol <code>LOR</code>.
    * @see     PreProcessorParser.Token#getSymbolID()
    */
    public static final int TOKEN_LOR = 25;
    /**
    * Describes the terminal symbol <code>LAND</code>.
    * @see     PreProcessorParser.Token#getSymbolID()
    */
    public static final int TOKEN_LAND = 26;
    /**
    * Describes the terminal symbol <code>BOR</code>.
    * @see     PreProcessorParser.Token#getSymbolID()
    */
    public static final int TOKEN_BOR = 27;
    /**
    * Describes the terminal symbol <code>DOT</code>.
    * @see     PreProcessorParser.Token#getSymbolID()
    */
    public static final int TOKEN_DOT = 28;
    /**
    * Describes the terminal symbol <code>QUESTION</code>.
    * @see     PreProcessorParser.Token#getSymbolID()
    */
    public static final int TOKEN_QUESTION = 29;
    /**
    * Describes the terminal symbol <code>BACKSLASH</code>.
    * @see     PreProcessorParser.Token#getSymbolID()
    */
    public static final int TOKEN_BACKSLASH = 30;
    /**
    * Describes the terminal symbol <code>NUMBER</code>.
    * @see     PreProcessorParser.Token#getSymbolID()
    */
    public static final int TOKEN_NUMBER = 31;
    /**
    * Describes the terminal symbol <code>FLOATNUMBER</code>.
    * @see     PreProcessorParser.Token#getSymbolID()
    */
    public static final int TOKEN_FLOATNUMBER = 32;
    /**
    * Describes the terminal symbol <code>IDENTIFIER</code>.
    * @see     PreProcessorParser.Token#getSymbolID()
    */
    public static final int TOKEN_IDENTIFIER = 33;
    /**
    * Describes the terminal symbol <code>NEW_LINE</code>.
    * @see     PreProcessorParser.Token#getSymbolID()
    */
    public static final int TOKEN_NEW_LINE = 34;
    /**
    * Describes the terminal symbol <code>QUATED_STRING</code>.
    * @see     PreProcessorParser.Token#getSymbolID()
    */
    public static final int TOKEN_QUATED_STRING = 35;
    
    
    
    /**
    * Creates a node of an abstract syntax tree.
    * <p>
    * <p>
    * The type of the node to create is described by <code>symbolID</code> as follows.
    * <table border=1>
    * <tr><th><code>symbolID</code></th><th>type to create</th></tr>
    * </table>
    * <p>
    * The default implementation by the <code>PreProcessorParser</code> is equivalent to <code>createNode(symbolID, parameters, false)</code>.
    *
    * @param   symbolID
    *      the kind of the node to create.
    * @param   parameters
    *      the parameters to initialize the node.
    * @return
    *      a created node.
    * @throws   ParseException
    *      if the text to parse doesn't satisfy some requirements.
    * @since    notavaCC 1.0
    */
    protected Node createNode(int symbolID, NodeInitializationParameters parameters) throws ParseException {
        return createNode(symbolID, parameters, false);
    }
    
    /**
    * Creates a node of an abstract syntax tree.  The created node is a instance of a class in {@link PreProcessorParser.Default}.
    *
    * @param   symbolID
    *      the kind of the node to create.  See {@link #createNode(int, PreProcessorParser.NodeInitializationParameters)}.
    * @param   parameters
    *      the parameters to initialize the node.
    * @param   compact
    *      if <code>true</code>, the method creates a compact node, which have only labeled children.
    * @return  a created node.
    * @since   notavaCC 1.0
    */
    protected final PreProcessorParser.Default.Node createNode(int symbolID, NodeInitializationParameters parameters, boolean compact) {
        switch(symbolID) {
        }
        throw new java.lang.AssertionError("Node creation failed.");
    }
    
    
    /**
    * This method is called when an whole abstract syntax tree is built.
    * The tree this method returns is regarded as the result of parsing.
    *
    * <p>
    *
    * @param   root
    *      the root of the tree generated by {@link PreProcessorParser#createNode}.
    * @return  the result of parsing.
    * @since   notavaCC 1.0
    */
    protected Node modifyWholeTree(Node root) throws ParseException {
        return root;
    }
    
    
    /**
    * Gets the <code>java.lang.CharSequence</code> that represents the text in the given file.
    * <p>
    *
    * @param   file
    *      a file.
    * @param   charsetName
    *      the charset name of the file, or <code>null</code> for the default charset.
    * @return
    *      the <code>java.lang.CharSequence</code> that represents the text in the <code>file</code>.
    * @throws   java.io.IOException
    *      if some error is occured for the access to the <code>file</code>.
    * @since    notavaCC 1.0
    */
    protected final java.lang.CharSequence toCharSequence(java.io.File file, java.lang.String charsetName) throws java.io.IOException {
        java.io.FileInputStream fis = null;
        java.io.InputStreamReader reader = null;
        java.nio.channels.FileChannel fc = null;
        try {
            fis = new java.io.FileInputStream(file);
            if (charsetName == null)
                reader = new java.io.InputStreamReader(fis);
            else
                reader = new java.io.InputStreamReader(fis, charsetName);
            java.nio.charset.Charset charset;
            try {
                charset = java.nio.charset.Charset.forName(reader.getEncoding());
            } catch(java.nio.charset.UnsupportedCharsetException x) {
                charset = null;
            }
            if (charset != null) {
                java.nio.charset.CharsetDecoder decoder = charset.newDecoder();
                fc = fis.getChannel();
                int size = (int) fc.size();
                java.nio.MappedByteBuffer bb = fc.map(java.nio.channels.FileChannel.MapMode.READ_ONLY, 0, size);
                return decoder.decode(bb);
            } else {
                long length = file.length();
                if (length <= 0)
                    length = 1;
                else if (length > java.lang.Integer.MAX_VALUE)
                    length = java.lang.Integer.MAX_VALUE;
                java.lang.StringBuffer result = new java.lang.StringBuffer((int) length);
                char[] buffer = new char[1024];
                for(;;) {
                    int size = reader.read(buffer);
                    if (size < 0)
                        break;
                    result.append(buffer, 0, size);
                }
                return result;
            }
        } finally {
            if (fc != null)
                fc.close();
            if (reader != null)
                reader.close();
            else if (fis != null)
                fis.close();
        }
    }
    /**
    * Gets the <code>java.lang.CharSequence</code> that represents the text from the given character stream.
    * <p>
    * This method reads characters from the stream until the end of the stream has been reached, and returns the <code>java.lang.CharSequence</code> that represents the characters.
    *
    * @param   reader
    *      a character stream.  This method will not <code>close</code> it.
    * @return
    *      the <code>java.lang.CharSequence</code> that represents the text from the <code>reader</code>.
    * @throws   java.io.IOException
    *      if some error is occured for the access to the <code>reader</code>.
    * @since    notavaCC 1.0
    */
    protected final java.lang.CharSequence toCharSequence(java.io.Reader reader) throws java.io.IOException {
        java.lang.StringBuffer result = new java.lang.StringBuffer();
        char[] buffer = new char[1024];
        for (;;) {
            int size = reader.read(buffer);
            if (size < 0)
                break;
            result.append(buffer, 0, size);
        }
        return result;
    }
    
    
    /**
    * Creates a lexical analyzer.
    * <p>
    * @param   sourceName
    *      the name of the source, used only to set the result of {@link PreProcessorParser.Token#getSourceName()}.
    * @param   text
    *      the text to analyze.
    * @param   tabStop
    *      the number that the tab character advances the cursor to the next column that is a multiple of.  <code>tabStop</code> is used only to set the result of {@link PreProcessorParser.Token#getColumn()}.
    * @return
    *      the lexical analyzer that analyze the <code>text</code>.
    * @throws   ParseException
    *      if the text to parse doesn't satisfy some requirements.
    * @since    notavaCC 1.0
    */
    protected PreProcessorParser.LexicalAnalyzer createLexicalAnalyzer(java.lang.String sourceName, java.lang.CharSequence text, int tabStop) throws ParseException {
        return new PreProcessorParser.Default.LexicalAnalyzer(sourceName, text, tabStop);
    }
    
    
    /**
    * Contains <code>private</code> fields that is used in order to create a node.  The constructor is <code>private</code>.
    * <p>
    *
    * @since   notavaCC 1.0
    */
    protected static class NodeInitializationParameters {
        private NodeInitializationParameters() {
        }
        private Node[] childNodes;
        private java.util.List labelsIDList;
    }
    
    
    /**
    * A visitor.
    * <p>
    *
    * @see     PreProcessorParser.Visitor#visitAll(PreProcessorParser.Node)
    * @since   notavaCC 1.0
    */
    public static class Visitor {
        
        /**
        * Traverses a (sub-)tree.
        * <p>
        * The default implementation is as follows.  The user can override the method and change the behavior at will.
        * <pre>
        * visitNode(node);
        *
        * java.util.Iterator it = node.getChildNodes().iterator();
        * while (it.hasNext()) {
            *     PreProcessorParser.Node child = (PreProcessorParser.Node) it.next();
            *     visitAll(child);
            * }
            * </pre>
            *
            * @param   node
            *      the root of the (sub-)tree to traverse.
            * @since   notavaCC 1.0
            */
            public void visitAll(PreProcessorParser.Node node) {
                visitNode(node);
                
                java.util.Iterator it = node.getChildNodes().iterator();
                while (it.hasNext()) {
                    PreProcessorParser.Node child = (PreProcessorParser.Node) it.next();
                    visitAll(child);
                }
            }
            /**
            * Call <code>visit</code>.
            * <p>
            * The default implementation is to call all the method, that is defined in this class, whose name is <code>visit</code>, and that can take <code>node</code> as the argument.  For example, if <code>node instanceof {@link PreProcessorParser.Token}</code>, both of {@link #visit(PreProcessorParser.Node)} and {@link #visit(PreProcessorParser.Token)} is called.  The order of the call is undefined.  The user can override the method and change the behavior at will.
            *
            * @param   node
            *      a node.
            * @since   notavaCC 1.0
            */
            protected void visitNode(PreProcessorParser.Node node) {
                visit((PreProcessorParser.Node) node);
                
                if (node instanceof PreProcessorParser.Token)
                    visit((PreProcessorParser.Token) node);
            }
            
            /**
            * Called for a visited node.
            * <p>
            *
            * @param   node
            *      a visited node.
            * @see      #visitAll
            * @since    notavaCC 1.0
            */
            protected void visit(PreProcessorParser.Node node) {
            }
            /**
            * Called for a visited {@link PreProcessorParser.Token}.
            * <p>
            *
            * @param   node
            *      a visited node.
            * @see      #visitAll
            * @since    notavaCC 1.0
            */
            protected void visit(PreProcessorParser.Token node) {
            }
        }
        
        
        /**
        * A node of the abstract syntax tree that is the result of parsing.
        * <p>
        *
        * @since   notavaCC 1.0
        */
        public static interface Node {
            /**
            * Returns the list of the child nodes of <code>this</code>.
            *
            * @return  the list of the child nodes of <code>this</code>.
            * @since   notavaCC 1.0
            */
            public java.util.List getChildNodes();
            
        } // interface Node
        
        /**
        * A token, which is a fragment of a parsed text.
        * <p>
        * A token is a fragment of a parsed text (a source).  Tokens are usually constructed by {@link PreProcessorParser.LexicalAnalyzer}s.  This class introduces the methods that represent what is the source of the token and where the token is placed in the source ({@link #getSourceName}, {@link #getIndex}, {@link #getLine}, {@link #getColumn}), however, the strict specification of the returned value is defined by the generator of the token, e.g., <code>LexicalAnalyzer</code>s.  Also, these methods may be unsuported and may throw {@link java.lang.UnsupportedOperationException}.
        *
        * @since   notavaCC 1.0
        */
        public static interface Token extends Node {
            /**
            * Returns the kind of <code>this</code> token.
            * <p>
            * The result value should be one of the following:</p>
            *
            * <table border=1>
            * <tr><th>value</th><th>described token</th></tr>
            * <tr>
            *   <td>{@link PreProcessorParser#EOF_TOKEN}</td>
            *   <td><tt>&lt;EOF&gt;</tt></td>
            * </tr>
            * <tr>
            *   <td>{@link PreProcessorParser#TOKEN_SPACE}</td>
            *   <td><tt>SPACE</tt></td>
            * </tr>
            * <tr>
            *   <td>{@link PreProcessorParser#TOKEN_COMMENT}</td>
            *   <td><tt>COMMENT</tt></td>
            * </tr>
            * <tr>
            *   <td>{@link PreProcessorParser#TOKEN_CXXCOMMENT}</td>
            *   <td><tt>CXXCOMMENT</tt></td>
            * </tr>
            * <tr>
            *   <td>{@link PreProcessorParser#TOKEN_DIRECTIVE}</td>
            *   <td><tt>DIRECTIVE</tt></td>
            * </tr>
            * <tr>
            *   <td>{@link PreProcessorParser#TOKEN_LEFT_PAREN}</td>
            *   <td><tt>LEFT_PAREN</tt></td>
            * </tr>
            * <tr>
            *   <td>{@link PreProcessorParser#TOKEN_RIGHT_PAREN}</td>
            *   <td><tt>RIGHT_PAREN</tt></td>
            * </tr>
            * <tr>
            *   <td>{@link PreProcessorParser#TOKEN_LEFT_BAREN}</td>
            *   <td><tt>LEFT_BAREN</tt></td>
            * </tr>
            * <tr>
            *   <td>{@link PreProcessorParser#TOKEN_RIGHT_BAREN}</td>
            *   <td><tt>RIGHT_BAREN</tt></td>
            * </tr>
            * <tr>
            *   <td>{@link PreProcessorParser#TOKEN_LEFT_BBAREN}</td>
            *   <td><tt>LEFT_BBAREN</tt></td>
            * </tr>
            * <tr>
            *   <td>{@link PreProcessorParser#TOKEN_RIGHT_BBAREN}</td>
            *   <td><tt>RIGHT_BBAREN</tt></td>
            * </tr>
            * <tr>
            *   <td>{@link PreProcessorParser#TOKEN_COMMA}</td>
            *   <td><tt>COMMA</tt></td>
            * </tr>
            * <tr>
            *   <td>{@link PreProcessorParser#TOKEN_QUOTE}</td>
            *   <td><tt>QUOTE</tt></td>
            * </tr>
            * <tr>
            *   <td>{@link PreProcessorParser#TOKEN_SEMICOLON}</td>
            *   <td><tt>SEMICOLON</tt></td>
            * </tr>
            * <tr>
            *   <td>{@link PreProcessorParser#TOKEN_COLON}</td>
            *   <td><tt>COLON</tt></td>
            * </tr>
            * <tr>
            *   <td>{@link PreProcessorParser#TOKEN_ASTERRISC}</td>
            *   <td><tt>ASTERRISC</tt></td>
            * </tr>
            * <tr>
            *   <td>{@link PreProcessorParser#TOKEN_AMPARSAND}</td>
            *   <td><tt>AMPARSAND</tt></td>
            * </tr>
            * <tr>
            *   <td>{@link PreProcessorParser#TOKEN_EQUAL}</td>
            *   <td><tt>EQUAL</tt></td>
            * </tr>
            * <tr>
            *   <td>{@link PreProcessorParser#TOKEN_LT}</td>
            *   <td><tt>LT</tt></td>
            * </tr>
            * <tr>
            *   <td>{@link PreProcessorParser#TOKEN_GT}</td>
            *   <td><tt>GT</tt></td>
            * </tr>
            * <tr>
            *   <td>{@link PreProcessorParser#TOKEN_PLUS}</td>
            *   <td><tt>PLUS</tt></td>
            * </tr>
            * <tr>
            *   <td>{@link PreProcessorParser#TOKEN_MINUS}</td>
            *   <td><tt>MINUS</tt></td>
            * </tr>
            * <tr>
            *   <td>{@link PreProcessorParser#TOKEN_DIV}</td>
            *   <td><tt>DIV</tt></td>
            * </tr>
            * <tr>
            *   <td>{@link PreProcessorParser#TOKEN_MOD}</td>
            *   <td><tt>MOD</tt></td>
            * </tr>
            * <tr>
            *   <td>{@link PreProcessorParser#TOKEN_NOT}</td>
            *   <td><tt>NOT</tt></td>
            * </tr>
            * <tr>
            *   <td>{@link PreProcessorParser#TOKEN_LOR}</td>
            *   <td><tt>LOR</tt></td>
            * </tr>
            * <tr>
            *   <td>{@link PreProcessorParser#TOKEN_LAND}</td>
            *   <td><tt>LAND</tt></td>
            * </tr>
            * <tr>
            *   <td>{@link PreProcessorParser#TOKEN_BOR}</td>
            *   <td><tt>BOR</tt></td>
            * </tr>
            * <tr>
            *   <td>{@link PreProcessorParser#TOKEN_DOT}</td>
            *   <td><tt>DOT</tt></td>
            * </tr>
            * <tr>
            *   <td>{@link PreProcessorParser#TOKEN_QUESTION}</td>
            *   <td><tt>QUESTION</tt></td>
            * </tr>
            * <tr>
            *   <td>{@link PreProcessorParser#TOKEN_BACKSLASH}</td>
            *   <td><tt>BACKSLASH</tt></td>
            * </tr>
            * <tr>
            *   <td>{@link PreProcessorParser#TOKEN_NUMBER}</td>
            *   <td><tt>NUMBER</tt></td>
            * </tr>
            * <tr>
            *   <td>{@link PreProcessorParser#TOKEN_FLOATNUMBER}</td>
            *   <td><tt>FLOATNUMBER</tt></td>
            * </tr>
            * <tr>
            *   <td>{@link PreProcessorParser#TOKEN_IDENTIFIER}</td>
            *   <td><tt>IDENTIFIER</tt></td>
            * </tr>
            * <tr>
            *   <td>{@link PreProcessorParser#TOKEN_NEW_LINE}</td>
            *   <td><tt>NEW_LINE</tt></td>
            * </tr>
            * <tr>
            *   <td>{@link PreProcessorParser#TOKEN_QUATED_STRING}</td>
            *   <td><tt>QUATED_STRING</tt></td>
            * </tr>
            * </table>
            *
            * @return  the kind of <code>this</code> token.
            * @since   notavaCC 1.0
            */
            public int getSymbolID();
            
            /**
            * Returnds <code>true</code> if <code>this</code> is a white token.
            * <p>
            * This method returns <code>true</code> if and only if <code>getSymbolID()</code> is one of the following:
            * <ul>
            *   <td>{@link PreProcessorParser#TOKEN_SPACE}</td>
            *   <td>{@link PreProcessorParser#TOKEN_COMMENT}</td>
            *   <td>{@link PreProcessorParser#TOKEN_CXXCOMMENT}</td>
            * </ul>
            *
            * @return  <code>true</code> if <code>this</code> is a while token.
            * @since   notavaCC 1.0
            */
            public boolean isWhite();
            
            /**
            * Returns the string <code>this</code> token corresponds to.
            * <p>
            * If the string contains some meta notation like Unicode escapes, the returned value is the represented string (e.g., A) rather than the representation (e.g., \u005Cu0041).  If not, the returned value is the same as {@link #getOriginalImage()}.
            *
            * @return  the string <code>this</code> token corresponds to.
            * @see     PreProcessorParser.Token#getOriginalImage()
            * @since   notavaCC 1.0
            */
            public java.lang.String getImage();
            
            /**
            * Returns the string <code>this</code> token corresponds to.
            * <p>
            * If the string contains some meta notation like Unicode escapes, the returned value is the representation (e.g., \u005Cu0041) rather than the represented string (e.g., A).  If not, the returned value is the same as {@link #getImage()}.
            *
            * @return  the string <code>this</code> token corresponds to.
            * @see     PreProcessorParser.Token#getImage()
            * @since   notavaCC 1.0
            */
            public java.lang.String getOriginalImage();
            
            /**
            * Returns the source name <code>this</code> token coressponds to.
            *
            * @return  the source name <code>this</code> token coressponds to.
            * @throws   java.lang.UnsupportedOperationException
            *      if the method is not suported.
            * @since   notavaCC 1.0
            */
            public java.lang.String getSourceName() throws java.lang.UnsupportedOperationException;
            
            /**
            * Returns the zero-based index number in the source where <code>this</code> token begins.
            *
            * @return  the index number in the source where <code>this</code> token begins.
            * @throws   java.lang.UnsupportedOperationException
            *      if the method is not suported.
            * @since   notavaCC 1.0
            */
            public int getIndex() throws java.lang.UnsupportedOperationException;
            /**
            * Returns the one-based line number in the source where <code>this</code> token begins.
            *
            * @return  the line number in the source where <code>this</code> token begins.
            * @throws   java.lang.UnsupportedOperationException
            *      if the method is not suported.
            * @since   notavaCC 1.0
            */
            public int getLine() throws java.lang.UnsupportedOperationException;
            /**
            * Returns the one-based column number in the source where <code>this</code> token begins.
            *
            * @return  the column number in the source where <code>this</code> token begins.
            * @throws   java.lang.UnsupportedOperationException
            *      if the method is not suported.
            * @since   notavaCC 1.0
            */
            public int getColumn() throws java.lang.UnsupportedOperationException;
            
            /**
            * Returns the {@linkplain #getOriginalImage image} and the position of <code>this</code> token if supported.
            * For instance, <code>`identifier' (line 2, column 3)</code> or <code>`identifier'</code>.
            * The format is not specified strictly.
            *
            * @return  the {@linkplain #getOriginalImage image} and the parenthesized position of <code>this</code> token.
            * @since   notavaCC 1.0
            */
            public java.lang.String toString();
        } // interface Token
        
        
        
        
        /**
        * Describes a error of a text.
        *
        * @since   notavaCC 1.0
        */
        public static class ParseException extends java.lang.Exception {
            private final java.lang.String sourceName;
            private final int index;
            private final int line;
            private final int column;
            
            /**
            * Constructs an exception.
            *
            * @param   msg
            *            a message to describes the error.
            * @param   sourceName
            *            the source name where the exception is occured, or null if not supported.
            * @param   index
            *            the index number where the exception is occured, or -1 if not supported.
            * @param   line
            *            the line number where the exception is occured, or -1 if not supported.
            * @param   column
            *            the column number where the exception is occured, or -1 if not supported.
            * @since   notavaCC 1.0
            */
            public ParseException(java.lang.String msg, java.lang.String sourceName, int index, int line, int column) {
                super(msg);
                this.sourceName = sourceName;
                this.index = index;
                this.line = line;
                this.column = column;
            }
            /**
            * Constructs an exception.
            *
            * @param   msg
            *            a message to describes the error.
            * @param   position
            *            a token that describes the position of the error.
            * @since   notavaCC 1.0
            */
            public ParseException(java.lang.String msg, PreProcessorParser.Token position) {
                super(msg);
                
                java.lang.String sourceName = null;
                int index = -1;
                int line = -1;
                int column = -1;
                
                try {
                    sourceName = position.getSourceName();
                } catch (java.lang.UnsupportedOperationException x) {
                }
                try {
                    index = position.getIndex();
                } catch (java.lang.UnsupportedOperationException x) {
                }
                try {
                    line = position.getLine();
                } catch (java.lang.UnsupportedOperationException x) {
                }
                try {
                    column = position.getColumn();
                } catch (java.lang.UnsupportedOperationException x) {
                }
                
                this.sourceName = sourceName;
                this.index = index;
                this.line = line;
                this.column = column;
            }
            
            /**
            * Returns the source name where the exception is occured.
            *
            * @return  the source name where the exception is occured.
            * @throws   java.lang.UnsupportedOperationException
            *      if the method is not suported.
            * @since   notavaCC 1.0
            */
            public final java.lang.String getSourceName() throws java.lang.UnsupportedOperationException {
                if (sourceName == null)
                    throw new java.lang.UnsupportedOperationException();
                return sourceName;
            }
            
            /**
            * Returns the index number where the exception is occured.
            *
            * @return  the index number where the exception is occured.
            * @throws   java.lang.UnsupportedOperationException
            *      if the method is not suported.
            * @since   notavaCC 1.0
            */
            public final int getIndex() throws java.lang.UnsupportedOperationException {
                if (index == -1)
                    throw new java.lang.UnsupportedOperationException();
                return index;
            }
            
            /**
            * Returns the line number where the exception is occured.
            *
            * @return  the line number where the exception is occured.
            * @throws   java.lang.UnsupportedOperationException
            *      if the method is not suported.
            * @since   notavaCC 1.0
            */
            public final int getLine() throws java.lang.UnsupportedOperationException {
                if (line == -1)
                    throw new java.lang.UnsupportedOperationException();
                return line;
            }
            
            /**
            * Returns the column number where the exception is occured.
            *
            * @return  the column number where the exception is occured.
            * @throws   java.lang.UnsupportedOperationException
            *      if the method is not suported.
            * @since   notavaCC 1.0
            */
            public final int getColumn() throws java.lang.UnsupportedOperationException {
                if (column == -1)
                    throw new java.lang.UnsupportedOperationException();
                return column;
            }
            
            /**
            * Returns the GNU-Compiler-Collection-style string that describes the position of the error.
            * <p>
            * This method throws an UnsupportedOperationException if <code>getSourceName()</code> is not supported.
            * Otherwise, it returns <code>getSourceName()</code> if <code>getLine()</code> is not supported.
            * Otherwise, it returns <code>getSourceName() + ":" + getLine()</code> if <code>getColumn()</code> is not supported.
            * Otherwise, it returns <code>getSourceName() + ":" + getLine() + ":" + getColumn()</code>.
            *
            * @return
            *      the GCC-style string describing the position of the error.
            * @throws   UnsupportedOperationException
            *      getSourceName() was not suppoted.
            * @since   notavaCC 1.0
            */
            public final java.lang.String getGCCStylePositionString() throws java.lang.UnsupportedOperationException {
                if (line == -1) {
                    return getSourceName();
                } else if (column == -1) {
                    return getSourceName() + ":" + line;
                } else {
                    return getSourceName() + ":" + line + ":" + column;
                }
            }
            
            /**
            * Indicates the source of the notavaCC, which generates this Java program, has ambiguity.
            * @since   notavaCC 1.0
            */
            public static class AmbiguousGrammarError extends java.lang.AssertionError {
                public AmbiguousGrammarError(java.lang.String message) {
                    super(message);
                }
            }
        } // class ParseException
        
        
        /**
        * Generator of a sequence of {@link PreProcessorParser.Token}s.
        *
        * @since   notavaCC 1.0
        */
        public static abstract class LexicalAnalyzer {
            /**
            * Returns the next token in the sequence.
            * <p>
            * If there is no tokens, the {@linkplain PreProcessorParser.Token#getSymbolID() symbol ID} of the returned value should be {@link PreProcessorParser#EOF_TOKEN}, but the {@linkplain PreProcessorParser.Token#getImage() image} or the {@linkplain PreProcessorParser.Token#getIndex() index} etc. are not specified (may be {@linkplain java.lang.UnsupportedOperationException unsupported}).
            *
            * @return  the next token in the sequence.
            * @since   notavaCC 1.0
            */
            public abstract Token next() throws ParseException;
        } // LexicalAnalyzer
        
        
        /**
        * A namespace for the default implementations.
        *
        * @since   notavaCC 1.0
        */
        public static interface Default {
            /**
            * Provides a simple implementation of {@link PreProcessorParser.Node}.
            *
            * @since   notavaCC 1.0
            */
            public static abstract class Node implements PreProcessorParser.Node {
                
                private java.util.List childNodes;
                /**
                * Constucts an instance.
                * <p>
                * The returned list of {@link #getChildNodes()} is the <code>childNodes</code> rather than a copy of it.
                *
                * @param   childNodes
                *            a list of child nodes.
                * @since   notavaCC 1.0
                */
                public Node(java.util.List childNodes) {
                    this.childNodes = childNodes;
                    
                }
                public java.util.List getChildNodes() {
                    return this.childNodes;
                }
                
                
                /**
                * Replaces the child node <code>oldChild</code> with <code>newChild</code>.
                * <p>
                * This method
                * replaces <code>oldChild</code> in <code>getChildNodes()</code> with <code>newChild</code>.
                * Also, this method replaces the values returned by the methods that are defined in the subinterfaces of {@link PreProcessorParser.Node} and that return particular children.
                *
                * @param   oldChild
                *            a replaced child node.
                * @param   newChild
                *            a child node to replace <code>oldChild</code>.
                * @since   notavaCC 1.0
                */
                public void replaceChild(PreProcessorParser.Node oldChild, PreProcessorParser.Node newChild) {
                    __replaceAll__notavacc_reserved(getChildNodes(), oldChild, newChild);
                }
                
                
                public java.lang.String toString() {
                    java.io.StringWriter buffer = new java.io.StringWriter();
                    java.io.PrintWriter writer = new java.io.PrintWriter(buffer);
                    
                    PreProcessorParser.Node node = this;
                    while (!(node instanceof PreProcessorParser.Token)) {
                        if (node.getChildNodes().isEmpty()) {
                            node = null;
                            break;
                        }
                        node = (PreProcessorParser.Node) node.getChildNodes().get(0);
                    }
                    if (node != null) {
                        PreProcessorParser.Token token = (PreProcessorParser.Token) node;
                        try {
                            writer.print(token.getSourceName() + ":");
                            writer.print(token.getLine() + ":");
                            writer.println(token.getOriginalImage());
                        } catch (java.lang.UnsupportedOperationException x) {
                        }
                    }
                    
                    toString(this, 0, writer);
                    writer.close();
                    if (writer.checkError())
                        throw new java.lang.RuntimeException();
                    return buffer.toString();
                }
                private static void toString(PreProcessorParser.Node node, int indent, java.io.PrintWriter writer) {
                    for (int i = 0; i < indent; i++)
                        writer.print("  ");
                    
                    if (node instanceof Token) {
                        Token token = (Token) node;
                        writer.println(token);
                        //writer.println("token: " + token.getOriginalImage());
                    } else {
                        java.lang.String binaryName = node.getClass().getName();
                        binaryName = binaryName.substring(binaryName.lastIndexOf(".") + 1);
                        binaryName = binaryName.substring(binaryName.lastIndexOf("$") + 1);
                        writer.println(binaryName);
                        indent++;
                        java.util.Iterator it = node.getChildNodes().iterator();
                        while (it.hasNext()) {
                            PreProcessorParser.Node n = (PreProcessorParser.Node) it.next();
                            toString(n, indent, writer);
                        }
                    }
                }
            } // Default.Node
            
            /**
            * Provides a simple implementation of {@link PreProcessorParser.Token}.
            *
            * @since   notavaCC 1.0
            */
            public static class Token extends Default.Node implements PreProcessorParser.Token {
                private final int symbolID;
                private final java.lang.String image;
                private final java.lang.String originalImage;
                private final java.lang.String sourceName;
                private final int index;
                private final int line;
                private final int column;
                /**
                * Constructs a token.
                * <p>
                *
                * @param   symbolID
                *      the symbol ID of the token, returned by <code>getSymbolID</code>.
                * @param   image
                *      the image string, returned by <code>getImage</code> and <code>getOriginalImage</code>.
                * @since   notavaCC 1.0
                */
                public Token(int symbolID, java.lang.String image) {
                    this(symbolID, image, image, null, -1, -1, -1);
                }
                
                /**
                * Constructs a token.
                * <p>
                *
                * @param   symbolID
                *      the symbol ID of the token, returned by <code>getSymbolID</code>.
                * @param   image
                *      the image string, returned by <code>getImage</code>.
                * @param   originalImage
                *      the image string, returned by <code>getOriginalImage</code>.
                * @param   sourceName
                *      the source name returned by <code>getSourceName</code>, or <code>null</code> if not supported.
                * @param   index
                *      the index returned by <code>getIndex</code>, or <code>-1</code> if not supported.
                * @param   line
                *      the line number returned by <code>getLine</code>, or <code>-1</code> if not supported.
                * @param   column
                *      the column number returned by <code>getColumn</code>, or <code>-1</code> if not supported.
                * @since   notavaCC 1.0
                */
                public Token(int symbolID, java.lang.String image, java.lang.String originalImage, java.lang.String sourceName, int index, int line, int column) {
                    super(java.util.Collections.EMPTY_LIST);
                    this.symbolID = symbolID;
                    this.image = image;
                    this.originalImage = originalImage;
                    this.sourceName = sourceName;
                    this.index = index;
                    this.line = line;
                    this.column = column;
                }
                /**
                * Constructs a token.
                * <p>
                *
                * @param   symbolID
                *      the symbol ID of the token, returned by <code>getSymbolID</code>.
                * @param   image
                *      the image string, returned by <code>getImage</code>.
                * @param   originalImage
                *      the image string, returned by <code>getOriginalImage</code>.
                * @param   token
                *      a token that gives the returned value of <code>getSourceName</code>, <code>getIndex</code>, <code>getLine</code> and <code>getColumn</code>.
                * @since   notavaCC 1.0
                */
                public Token(int symbolID, java.lang.String image, java.lang.String originalImage, PreProcessorParser.Token token) {
                    super(java.util.Collections.EMPTY_LIST);
                    java.lang.String sourceName = null;
                    int index = -1;
                    int line = -1;
                    int column = -1;
                    try {
                        sourceName = token.getSourceName();
                    } catch (java.lang.UnsupportedOperationException x) {
                    }
                    try {
                        index = token.getIndex();
                    } catch (java.lang.UnsupportedOperationException x) {
                    }
                    try {
                        line = token.getLine();
                    } catch (java.lang.UnsupportedOperationException x) {
                    }
                    try {
                        column = token.getColumn();
                    } catch (java.lang.UnsupportedOperationException x) {
                    }
                    
                    this.symbolID = symbolID;
                    this.image = image;
                    this.originalImage = originalImage;
                    this.sourceName = sourceName;
                    this.index = index;
                    this.line = line;
                    this.column = column;
                }
                public int getSymbolID() {
                    return symbolID;
                }
                public boolean isWhite() {
                    return 1 <= symbolID && symbolID < 4;
                }
                public java.lang.String getImage() {
                    return image;
                }
                public java.lang.String getOriginalImage() {
                    return originalImage;
                }
                
                
                public java.lang.String getSourceName() throws java.lang.UnsupportedOperationException {
                    if (sourceName == null)
                        throw new java.lang.UnsupportedOperationException();
                    return sourceName;
                }
                public int getIndex() throws java.lang.UnsupportedOperationException {
                    if (index == -1)
                        throw new java.lang.UnsupportedOperationException();
                    return index;
                }
                public int getLine() throws java.lang.UnsupportedOperationException {
                    if (line == -1)
                        throw new java.lang.UnsupportedOperationException();
                    return line;
                }
                public int getColumn() throws java.lang.UnsupportedOperationException {
                    if (column == -1)
                        throw new java.lang.UnsupportedOperationException();
                    return column;
                }
                
                public java.lang.String toString() {
                    //java.lang.StringBuffer result = new java.lang.StringBuffer(__quoted__notavacc_reserved(getOriginalImage()));
                    
                    java.lang.StringBuffer result = new java.lang.StringBuffer();
                    result.append("`");
                    java.lang.String original = getOriginalImage();
                    for (int i = 0; i < original.length(); i++) {
                        char ch = original.charAt(i);
                        switch (ch) {
                        default:
                            if (ch < ' ' || ch == '\u007F') {
                                result.append("\\u").append(__toHexCode__notavacc_reserved(ch));
                            } else {
                                result.append(ch);
                            }
                            break;
                        case '\n':   result.append("\\n");      break;
                        case '\t':   result.append("\\t");      break;
                        case '\b':   result.append("\\b");      break;
                        case '\r':   result.append("\\r");      break;
                        case '\f':   result.append("\\f");      break;
                            //case '\\':   result.append("\\\\");     break;
                            //case '\'':   result.append("\\\'");     break;
                            //case '\"':   result.append("\\\"");     break;
                        }
                    }
                    result.append("'");
                    
                    if (column != -1 || line != -1) {
                        result.append(" (");
                        if (line != -1) {
                            result.append("line ");
                            result.append(getLine());
                            if (column != -1)
                                result.append(", ");
                        }
                        if (column != -1) {
                            result.append("column ");
                            result.append(getColumn());
                        }
                        result.append(")");
                    }
                    return result.toString();
                }
            } // class Default.Token
            
            /**
            * The default {@link PreProcessorParser.LexicalAnalyzer}.
            *
            * @since   notavaCC 1.0
            */
            public static class LexicalAnalyzer extends PreProcessorParser.LexicalAnalyzer {
                /**
                * The <code>sourceName</code> given to the constructor.
                *
                * @since   notavaCC 1.0
                */
                protected final java.lang.String sourceName;
                /**
                * The <code>text</code> given to the constructor.
                *
                * @since   notavaCC 1.0
                */
                protected final java.lang.CharSequence text;
                /**
                * The exclusive end index of the target {@link #text} region.
                *
                * @since   notavaCC 1.0
                */
                protected final int end;
                /**
                * The <code>tabStop</code> given to the constructor.
                *
                * @since   notavaCC 1.0
                */
                protected final int tabStop;
                /**
                * The <code>table</code> given to the constructor.
                *
                * @since   notavaCC 1.0
                */
                private final int[][] table;
                /**
                * The <code>initialState</code> given to the constructor.
                *
                * @since   notavaCC 1.0
                */
                private final int initialState;
                /**
                * The zero-based index the {@linkplain #next() next} token begins at.
                *
                * @since   notavaCC 1.0
                */
                protected int index;
                /**
                * The zero-based line number the {@linkplain #next() next} token begins at.
                *
                * @since   notavaCC 1.0
                */
                protected int line;
                /**
                * The zero-based column number the {@linkplain #next() next} token begins at.
                *
                * @since   notavaCC 1.0
                */
                protected int column;
                /**
                * Constructs a lexical analyzer.
                * <p>
                *
                * @param   sourceName
                *      the name of the source, used only to set the result of {@link PreProcessorParser.Token#getSourceName()}.
                * @param   text
                *      the text to parse.
                * @param   tabStop
                *      the number that the tab character advances the cursor to the next column that is a multiple of.  <code>tabStop</code> is used only to set the result of {@link PreProcessorParser.Token#getColumn()}.
                * @since    notavaCC 1.0
                */
                public LexicalAnalyzer(java.lang.String sourceName, java.lang.CharSequence text, int tabStop) {
                    this(sourceName, text, tabStop, 0, text.length(), 0, 0);
                }
                /**
                * Constructs a lexical analyzer that analyze a part of a text.
                * <p>
                *
                * @param   sourceName
                *      the name of the source, used only to set the result of {@link PreProcessorParser.Token#getSourceName()}.
                * @param   text
                *      the text to parse.
                * @param   tabStop
                *      the number that the tab character advances the cursor to the next column that is a multiple of.  <code>tabStop</code> is used only to set the result of {@link PreProcessorParser.Token#getColumn()}.
                * @param   start
                *      the inclusive start index of the text region to analyze.
                * @param   end
                *      the exclusive end index of the text region to analyze.
                * @param   line
                *      the zero-based line number of the <code>start</code> index.
                * @param   column
                *      the zero-based column number of the <code>start</code> index.
                * @since    notavaCC 1.0
                */
                public LexicalAnalyzer(java.lang.String sourceName, java.lang.CharSequence text, int tabStop, int start, int end, int line, int column) {
                    this(sourceName, text, tabStop, start, end, line, column, PreProcessorParser.__dfaTable__notavacc_reserved, 0);
                }
                private LexicalAnalyzer(java.lang.String sourceName, java.lang.CharSequence text, int tabStop, int start, int end, int line, int column, int[][] table, int initialState) {
                    this.sourceName = sourceName;
                    this.text = text;
                    this.end = end;
                    this.tabStop = tabStop;
                    this.table = table;
                    this.initialState = initialState;
                    this.index = start;
                    this.line = line;
                    this.column = column;
                }
                public PreProcessorParser.Token next() throws ParseException {
                    if (index >= end)
                        return new PreProcessorParser.Default.Token(EOF_TOKEN, "", "", sourceName, index, -1, -1);
                    
                    int state = initialState;
                    
                    final int startIndex = index;
                    final int startLine = line;
                    final int startColumn = column;
                    int lastHitID = -1;
                    int lastHitIndex = -1;
                    int lastHitLine = -1;
                    int lastHitColumn = -1;
                    int lastHitImageLength = 0;
                    java.lang.StringBuffer image = new java.lang.StringBuffer();
                    
                    try {
                        dfa:
                        while (index < end) {
                            char ch = nextChar();
                            image.append(ch);
                            
                            int[] map = table[state];
                            int base = 1;
                            int width = (map.length - 1) / 3;
                            while (width > 1) {
                                int halfWidth = width >> 1;
                                int mid = base + halfWidth * 3;
                                if (ch >= map[mid]) {
                                    base = mid;
                                    width -= halfWidth;
                                } else {
                                    width = halfWidth;
                                }
                            }
                            int i = 0;
                            for (;;) {
                                if (i++ >= width)
                                    break dfa;
                                if (map[base] <= ch & ch <= map[base + 1]) {
                                    state = map[base + 2];
                                    break;
                                }
                                base += 3;
                            }
                            int hitID = table[state][0];
                            if (hitID != -1) {
                                lastHitID = hitID;
                                lastHitIndex = index;
                                lastHitLine = line;
                                lastHitColumn = column;
                                lastHitImageLength = image.length();
                            }
                        }
                        
                        if (lastHitID == -1) {
                            throw new ParseException("An invalid character sequence starting with '" + text.subSequence(startIndex, index) + "' (line " + (startLine + 1) + ", column " + (startColumn + 1) + ")", sourceName, startIndex, startLine + 1, startColumn + 1);
                        }
                    } finally {
                        index = startIndex;
                        line = startLine;
                        column = startColumn;
                    }
                    
                    PreProcessorParser.Token result = new PreProcessorParser.Default.Token(lastHitID, image.substring(0, lastHitImageLength).intern(), text.subSequence(startIndex, lastHitIndex).toString().intern(), sourceName, startIndex, startLine + 1, startColumn + 1);
                    
                    index = lastHitIndex;
                    line = lastHitLine;
                    column = lastHitColumn;
                    
                    return result;
                } // next()
                /**
                * Returns the next character in the {@link #text}.
                * <p>
                * This method returns the character starting at {@link #index} in the sequence and updates {@link #index}, {@link #line}, and {@link #column} to point the next character of the returned character.  This method is overridden in order to deal with a string as a character through the input sequence like Unicode escapes of Java.
                *
                * @return  the next character in the sequence.
                * @throws  java.lang.IndexOutOfBoundsException  if <code>index >= end</code>
                * @since   notavaCC 1.0
                */
                protected char nextChar() throws ParseException, java.lang.IndexOutOfBoundsException {
                    return nextExactChar();
                }
                /**
                * Returns the next character in the {@link #text} based on the Unicode escapes.
                *
                * @return  the next character in the sequence.
                * @throws  ParseException
                *              for a illegal escape.
                * @throws  java.lang.IndexOutOfBoundsException
                *              if <code>index >= end</code>
                * @since   notavaCC 1.0
                */
                protected final char nextUnicodeEscapedChar() throws ParseException, java.lang.IndexOutOfBoundsException {
                    int startIndex = this.index;
                    int startLine = line;
                    int startColumn = column;
                    {
                        int index = startIndex;
                        if (text.charAt(index) == '\\' && index + 1 < end && text.charAt(index + 1) == 'u') {
                            int count = 0;
                            while (index >= 0 && text.charAt(index--) == '\\')
                                count++;
                            if (count % 2 == 0)
                                return nextExactChar();
                        } else {
                            return nextExactChar();
                        }
                    }
                    
                    char ch = nextExactChar();
                    assert (ch =='\\');
                    ch = nextExactChar();
                    assert (ch == 'u');
                    try {
                        do {
                            ch = nextExactChar();
                        } while (ch == 'u');
                        java.lang.StringBuffer number = new java.lang.StringBuffer(4);
                        number.append(ch);
                        number.append(nextExactChar());
                        number.append(nextExactChar());
                        number.append(nextExactChar());
                        int code = java.lang.Integer.parseInt(number.toString(), 16);
                        return (char) code;
                    } catch (java.lang.NumberFormatException x) {
                    } catch (java.lang.IndexOutOfBoundsException x) {
                    }
                    throw new ParseException("illigal Unicode escape: " + text.subSequence(startIndex, index), sourceName, startIndex, startLine, startColumn);
                }
                private final char nextExactChar() throws ParseException, java.lang.IndexOutOfBoundsException {
                    if (index >= end)
                        throw new java.lang.IndexOutOfBoundsException();
                    char ch = text.charAt(index++);
                    switch (ch) {
                    case '\r':
                        if (index < end && text.charAt(index) == '\n')
                            break;
                    case '\n':
                        line++;
                        column = 0;
                        break;
                    case '\t':
                        if (tabStop >= 1)
                            column = column - (column % tabStop) + tabStop;
                        break;
                    default:
                        column++;
                        break;
                    }
                    return ch;
                }
            } // class Default.LexicalAnalyzer
            
            
            
            
        } // Default
        
        private static class __GrpahStack__notavacc_reserved {
            public static final __GrpahStack__notavacc_reserved[] EMPTY_STACK = null;
            
            private __GrpahStack__notavacc_reserved[] previous;
            private java.lang.Object node;  // __ConcreteSyntaxTree__notavacc_reserved, Node, Token or Token[] of white tokens.
            private int state;
            private __GrpahStack__notavacc_reserved(__GrpahStack__notavacc_reserved[] previous, java.lang.Object node, int state) {
                this.previous = previous;
                this.node = node;
                this.state = state;
            }
            public static __GrpahStack__notavacc_reserved push(__GrpahStack__notavacc_reserved[] stack, java.lang.Object node, int state) {
                return new __GrpahStack__notavacc_reserved(stack, node, state);
            }
            public int topState() {
                return state;
            }
            public java.lang.Object topNode() {
                return node;
            }
            public static __GrpahStack__notavacc_reserved[] pop(__GrpahStack__notavacc_reserved stack) {
                return stack.previous;
            }
        }
        private static class __ConcreteSyntaxTree__notavacc_reserved {
            public int reductionID;
            public java.lang.Object[] children;
            public __ConcreteSyntaxTree__notavacc_reserved(int reductionID, java.lang.Object[] children) {
                this.reductionID = reductionID;
                this.children = children;
            }
        }
        /*#allocate("ConcreteSyntaxTreeList", topTypeNamespace);
        private static class $ConcreteSyntaxTreeList {
            public java.lang.Integer labels;
            public java.lang.Object node;
            public $ConcreteSyntaxTreeList next;
            
            private $ConcreteSyntaxTreeList(java.lang.Integer labels, java.lang.Object node, $ConcreteSyntaxTreeList next) {
                this.labels = labels;
                this.node = node;
                this.next = next;
            }
        }*/
        
        private Node __parse__notavacc_reserved(int[][] lrTable, int[][] reductions, int initialState, int classSymbolMaximum, LexicalAnalyzer analyzer) throws ParseException {
            final int labelWordCount = 1;
            // build subtrees
            java.util.List whiteTokens = new java.util.ArrayList();
            java.util.ArrayList states = new java.util.ArrayList();
            {
                java.util.ArrayList nextStates = new java.util.ArrayList();
                states.add(__GrpahStack__notavacc_reserved.push(__GrpahStack__notavacc_reserved.EMPTY_STACK, null, initialState));
                tokenLoop:
                for (;;) {
                    Token nextToken;
                    int nextTokenID;
                    for (;;) {
                        nextToken = analyzer.next();
                        nextTokenID = nextToken.getSymbolID();
                        if (nextToken.isWhite()) {
                            whiteTokens.add(nextToken);
                        } else {
                            break;
                        }
                    }
                    
                    if (!whiteTokens.isEmpty()) {
                        java.lang.Object whiteTokensObject;
                        if (whiteTokens.size() == 1) {
                            whiteTokensObject = whiteTokens.get(0);
                        } else {
                            whiteTokensObject = whiteTokens.toArray(new Token[whiteTokens.size()]);
                        }
                        whiteTokens.clear();
                        for (int i = 0; i < states.size(); i++) {
                            final __GrpahStack__notavacc_reserved stack = (__GrpahStack__notavacc_reserved) states.get(i);
                            states.set(i, __GrpahStack__notavacc_reserved.push(new __GrpahStack__notavacc_reserved[] { stack }, whiteTokensObject, stack.state));
                        }
                    }
                    
                    int initialStatesSize = states.size();
                    reduceLoop:
                    for (int i = 0; i < states.size(); i++) {
                        final __GrpahStack__notavacc_reserved stack = (__GrpahStack__notavacc_reserved) states.get(i);
                        final int stateID = stack.topState();
                        //System.out.print(stateID + ", ");
                        int[] tokenIDToReductionID = lrTable[stateID * 3 + 2];
                        int j = __binarySearch__notavacc_reserved(tokenIDToReductionID, nextTokenID);
                        for (; j < tokenIDToReductionID.length; j += 2) {
                            if (tokenIDToReductionID[j] > nextTokenID) {
                                break;
                            } else if (tokenIDToReductionID[j] == nextTokenID) {
                                final int reductionID = tokenIDToReductionID[j + 1];
                                final int[] reduction = reductions[reductionID];
                                
                                reduce(states, stack, nextTokenID, reductionID, reductions, lrTable, classSymbolMaximum);
                            }
                        }
                    }
                    //System.out.println();
                    
                    shiftLoop:
                    for (int i = 0; i < states.size(); i++) {
                        final __GrpahStack__notavacc_reserved stack = (__GrpahStack__notavacc_reserved) states.get(i);
                        final int stateID = stack.topState();
                        
                        final int[] tokenIDToNextState = lrTable[stateID * 3 + 0];
                        int k = __binarySearch__notavacc_reserved(tokenIDToNextState, nextTokenID);
                        for (; k < tokenIDToNextState.length; k += 2) {
                            if (tokenIDToNextState[k] > nextTokenID) {
                                break;
                            } else if (tokenIDToNextState[k] == nextTokenID) {
                                final int nextStateID = tokenIDToNextState[k + 1];
                                nextStates.add(__GrpahStack__notavacc_reserved.push(new __GrpahStack__notavacc_reserved[] { stack }, nextToken, nextStateID));
                                break;
                            }
                        }
                    }
                    
                    if (nextStates.isEmpty()) {
                        states.subList(initialStatesSize, states.size()).clear();
                        __error__notavacc_reserved(analyzer, lrTable, reductions, states, nextToken, classSymbolMaximum);
                        continue tokenLoop;
                    }
                    
                    if (nextTokenID == EOF_TOKEN) {
                        states = nextStates;
                        break tokenLoop;
                    }
                    
                    java.util.ArrayList tmp = states;
                    states = nextStates;
                    nextStates = tmp;
                    nextStates.clear();
                }
            }
            
            // build the root
            java.util.LinkedList root = new java.util.LinkedList();
            boolean ambiguous = true;
            int reductionID = -1;
            if (states.size() == 1) {
                __GrpahStack__notavacc_reserved stack = (__GrpahStack__notavacc_reserved) states.get(0);
                for (;;) {
                    java.lang.Object topNode = stack.topNode();
                    __GrpahStack__notavacc_reserved[] prevs = __GrpahStack__notavacc_reserved.pop(stack);
                    if (prevs == __GrpahStack__notavacc_reserved.EMPTY_STACK) {
                        assert (topNode == null);
                        ambiguous = false;
                        break;
                    }
                    if (topNode instanceof Token[]) {
                        root.addAll(0, java.util.Arrays.asList((Token[]) topNode));
                    } else if (topNode instanceof Token) {
                        root.add(0, topNode);
                    } else {
                        __ConcreteSyntaxTree__notavacc_reserved cst = (__ConcreteSyntaxTree__notavacc_reserved) topNode;
                        assert (reductionID == -1);
                        reductionID = cst.reductionID;
                        root.addAll(0, java.util.Arrays.asList(cst.children));
                    }
                    if (prevs.length > 1)
                        break;
                    stack = prevs[0];
                }
            }
            if (ambiguous) {
                throw new ParseException.AmbiguousGrammarError("PreProcessorParser.notavacc" + " is ambiguous.");
            }
            
            return createNode(root.subList(0, root.size() - 1).toArray(), reductionID, reductions, classSymbolMaximum);
        }
        private static int __binarySearch__notavacc_reserved(int[] table, int key) {
            // Returns the index where table[i] < key for all i < index
            int base = 0;
            int width = table.length >> 1;
            while (width > 1) {
                int halfWidth = width >> 1;
                int mid = base + width & ~1;    // base + halfWidth * 2
                if (key <= table[mid]) {
                    width = halfWidth;
                } else {
                    base = mid;
                    width -= halfWidth;
                }
            }
            return base;
        }
        
        private void reduce(java.util.List states, __GrpahStack__notavacc_reserved stack, int nextTokenID, int reductionID, int[][] reductions, int[][] lrTable, int classSymbolMaximum) throws ParseException {
            reduce(states, stack, nextTokenID, reductionID, reductions, reductions[reductionID].length - 1, null, lrTable, classSymbolMaximum);
        }
        private void reduce(java.util.List states, __GrpahStack__notavacc_reserved stack, int nextTokenID, int reductionID, int[][] reductions, int reductionSize, java.lang.Object[] tail, int[][] lrTable, int classSymbolMaximum) throws ParseException {
            while (reductionSize > 0) {
                java.lang.Object topNode = stack.topNode();
                boolean whiteToken = false;
                if (topNode instanceof Token[]) {
                    whiteToken = true;
                } else if (topNode instanceof Token) {
                    Token token = (Token) topNode;
                    if (token.isWhite())
                        whiteToken = true;
                } else if (topNode instanceof __ConcreteSyntaxTree__notavacc_reserved) {
                    __ConcreteSyntaxTree__notavacc_reserved cst = (__ConcreteSyntaxTree__notavacc_reserved) topNode;
                    if (reductions[cst.reductionID][0] <= classSymbolMaximum)
                        topNode = createNode(cst.children, cst.reductionID, reductions, classSymbolMaximum);
                }
                
                tail = new java.lang.Object[] { topNode, tail };
                if (!whiteToken) {
                    final int labelWordCount = 1;
                    reductionSize -= labelWordCount;
                }
                __GrpahStack__notavacc_reserved[] prevs = __GrpahStack__notavacc_reserved.pop(stack);
                if (prevs.length > 1) {
                    for (int i = 0; i < prevs.length; i++)
                        reduce(states, prevs[i], nextTokenID, reductionID, reductions, reductionSize, tail, lrTable, classSymbolMaximum);
                    return;
                }
                stack = prevs[0];
            }
            
            java.lang.Object last = null;
            java.util.LinkedList result = new java.util.LinkedList();
            while (tail != null) {
                result.addLast(tail[0]);
                last = tail[0];
                tail = (java.lang.Object[]) tail[1];
            }
            boolean whiteToken = false;
            if (last instanceof Token[]) {
                whiteToken = true;
            } else if (last instanceof Token) {
                Token token = (Token) last;
                if (token.isWhite())
                    whiteToken = true;
            }
            if (whiteToken)
                result.removeLast();
            __ConcreteSyntaxTree__notavacc_reserved subtree = new __ConcreteSyntaxTree__notavacc_reserved(reductionID, result.toArray());
            
            int[] reduction = reductions[reductionID];
            final int nextSymbolID = reduction[0];
            final int returnedStateID = stack.topState();
            final int[] symbolIDToNextState = lrTable[returnedStateID * 3 + 1];
            int k = __binarySearch__notavacc_reserved(symbolIDToNextState, nextSymbolID);
            for (; k < symbolIDToNextState.length; k += 2) {
                if (symbolIDToNextState[k] > nextSymbolID) {
                    break;
                } else if (symbolIDToNextState[k] == nextSymbolID) {
                    final int nextStateID = symbolIDToNextState[k + 1];
                    stack = __GrpahStack__notavacc_reserved.push(new __GrpahStack__notavacc_reserved[] { stack }, subtree, nextStateID);
                    if (whiteToken)
                        stack = __GrpahStack__notavacc_reserved.push(new __GrpahStack__notavacc_reserved[] { stack }, last, nextStateID);
                    states.add(stack);
                    break;
                }
            }
        }
        
        private Node createNode(java.lang.Object[] children, int reductionID, int[][] reductions, int classSymbolMaximum) throws ParseException {
            int[] reduction = reductions[reductionID];
            java.util.List nodeList = new java.util.LinkedList();
            java.util.List labelsIDList = new java.util.LinkedList();
            __flatNodes__notavacc_reserved(0, nodeList, labelsIDList, children, reductionID, reductions, classSymbolMaximum);
            
            Node[] childNodes = (Node[]) nodeList.toArray(new Node[nodeList.size()]);
            NodeInitializationParameters parameters = new NodeInitializationParameters();
            parameters.childNodes = childNodes;
            parameters.labelsIDList = labelsIDList;
            Node result = createNode(reductions[reductionID][0], parameters);
            return result;
        }
        private void __flatNodes__notavacc_reserved(int labels, java.util.List nodeList, java.util.List labelsIDList, java.lang.Object[] list, int reductionID, int[][] reductions, int classSymbolMaximum) throws ParseException {
            int[] reduction = reductions[reductionID];
            int reductionIndex = 1;
            for (int i = 0; i < list.length; i++) {
                java.lang.Object node = list[i];
                if (node instanceof Token[]) {
                    Token[] whiteTokens = (Token[]) node;
                    nodeList.addAll(java.util.Arrays.asList(whiteTokens));
                    for (int j = 0; j < whiteTokens.length; j++)
                        labelsIDList.add(null);
                    continue;
                }
                if (node instanceof Token) {
                    Token token = (Token) node;
                    if (token.isWhite()) {
                        nodeList.add(token);
                        labelsIDList.add(null);
                        continue;
                    }
                }
                
                int mergedLabelsID = reduction[reductionIndex++];
                if ((mergedLabelsID & 1) != 0) {
                    mergedLabelsID &= ~1;
                    mergedLabelsID |= labels;
                }
                
                if (node instanceof __ConcreteSyntaxTree__notavacc_reserved) {
                    __ConcreteSyntaxTree__notavacc_reserved cst = (__ConcreteSyntaxTree__notavacc_reserved) node;
                    java.lang.Object[] children = cst.children;
                    //cst.children = null;    // make it garbage.
                    if (reductions[cst.reductionID][0] > classSymbolMaximum) {
                        __flatNodes__notavacc_reserved(mergedLabelsID, nodeList, labelsIDList, children, cst.reductionID, reductions, classSymbolMaximum);
                        continue;
                    }
                    node = createNode(children, cst.reductionID, reductions, classSymbolMaximum);
                }
                
                nodeList.add((Node) node);
                labelsIDList.add(new java.lang.Integer(mergedLabelsID));
            }
        }
        
        private void __error__notavacc_reserved(LexicalAnalyzer analyzer, int[][] lrTable, int[][] reductions, java.util.List states, Token errorNextToken, int classSymbolMaximum) throws ParseException {
            java.util.Set candidates = new java.util.TreeSet();
            for (int i = 0; i < states.size(); i++) {
                final __GrpahStack__notavacc_reserved stack = (__GrpahStack__notavacc_reserved) states.get(i);
                final int stateID = stack.topState();
                final int[] tokenIDToNextState = lrTable[stateID * 3 + 0];
                for (int k = 0; k < tokenIDToNextState.length; k += 2)
                    candidates.add(new java.lang.Integer(tokenIDToNextState[k]));
                
                int[] tokenIDToReductionID = lrTable[stateID * 3 + 2];
                for (int j = 0; j < tokenIDToReductionID.length; j += 2)
                    candidates.add(new java.lang.Integer(tokenIDToReductionID[j]));
            }
            
            java.util.Set nextTokens = new java.util.TreeSet();
            states = new java.util.ArrayList(states);
            final int originalSize = states.size();
            java.util.Iterator it21 = candidates.iterator();
            while (it21.hasNext()) {
                java.lang.Integer candidate = (java.lang.Integer) it21.next();
                int nextTokenID = candidate.intValue();
                
                states.subList(originalSize, states.size()).clear();
                
                reduceLoop:
                for (int i = 0; i < states.size(); i++) {
                    final __GrpahStack__notavacc_reserved stack = (__GrpahStack__notavacc_reserved) states.get(i);
                    final int stateID = stack.topState();
                    //System.out.print(stateID + ", ");
                    int[] tokenIDToReductionID = lrTable[stateID * 3 + 2];
                    int j = __binarySearch__notavacc_reserved(tokenIDToReductionID, nextTokenID);
                    for (; j < tokenIDToReductionID.length; j += 2) {
                        if (tokenIDToReductionID[j] > nextTokenID) {
                            break;
                        } else if (tokenIDToReductionID[j] == nextTokenID) {
                            final int reductionID = tokenIDToReductionID[j + 1];
                            final int[] reduction = reductions[reductionID];
                            
                            reduce(states, stack, nextTokenID, reductionID, reductions, lrTable, classSymbolMaximum);
                        }
                    }
                }
                //System.out.println();
                
                shiftLoop:
                for (int i = 0; i < states.size(); i++) {
                    final __GrpahStack__notavacc_reserved stack = (__GrpahStack__notavacc_reserved) states.get(i);
                    final int stateID = stack.topState();
                    
                    final int[] tokenIDToNextState = lrTable[stateID * 3 + 0];
                    int k = __binarySearch__notavacc_reserved(tokenIDToNextState, nextTokenID);
                    for (; k < tokenIDToNextState.length; k += 2) {
                        if (tokenIDToNextState[k] > nextTokenID) {
                            break;
                        } else if (tokenIDToNextState[k] == nextTokenID) {
                            final int nextStateID = tokenIDToNextState[k + 1];
                            nextTokens.add(candidate);
                            break;
                        }
                    }
                }
            }
            
            int[] selectableTokens = new int[nextTokens.size()];
            int index = 0;
            java.util.Iterator it11 = nextTokens.iterator();
            while (it11.hasNext()) {
                java.lang.Integer i = (java.lang.Integer) it11.next();
                selectableTokens[index++] = i.intValue();
            }
            __error__notavacc_reserved(analyzer, errorNextToken, selectableTokens);
        }
        /**
        * Throws or recovers a error.
        * <p>
        * This method is called when a token is not shiftable.
        * If the error is not recoverable, this method throws ParseException.
        * To recover the error, this method dose not throw anything,
        * then syntax analyzers ignore the <code>errorNextToken</code>,
        * i.e. the last <code>analyzer.{@link PreProcessorParser.LexicalAnalyzer#next() next()}</code> call.
        * The next <code>analyzer.{@link PreProcessorParser.LexicalAnalyzer#next() next()}</code> can return a better token.
        *
        * @param   analyzer
        *      the lexical analyzer of the parsing.
        * @param   errorNextToken
        *      the unshiftable token the last <code>analyzer.{@link PreProcessorParser.LexicalAnalyzer#next() next()}</code> returned.
        * @param   selectableNextTokens
        *      the shiftable tokens at the situation.
        * @throws   ParseException
        *      if the error is not recoverable.
        * @since    notavaCC 1.0
        */
        private static void __error__notavacc_reserved(LexicalAnalyzer analyzer, Token errorNextToken, int[] selectableNextTokens) throws ParseException {
            java.io.StringWriter buffer = new java.io.StringWriter();
            java.io.PrintWriter writer = new java.io.PrintWriter(buffer);
            
            if (errorNextToken.getSymbolID() != EOF_TOKEN) {
                writer.println("The token " + errorNextToken + " should be one of the following.");
            } else {
                writer.println("The EOF should be one of the following.");
            }
            
            final java.lang.String[] tokenStrings = {
                "<EOF>",
                "SPACE",
                "COMMENT",
                "CXXCOMMENT",
                "DIRECTIVE",
                "LEFT_PAREN",
                "RIGHT_PAREN",
                "LEFT_BAREN",
                "RIGHT_BAREN",
                "LEFT_BBAREN",
                "RIGHT_BBAREN",
                "COMMA",
                "QUOTE",
                "SEMICOLON",
                "COLON",
                "ASTERRISC",
                "AMPARSAND",
                "EQUAL",
                "LT",
                "GT",
                "PLUS",
                "MINUS",
                "DIV",
                "MOD",
                "NOT",
                "LOR",
                "LAND",
                "BOR",
                "DOT",
                "QUESTION",
                "BACKSLASH",
                "NUMBER",
                "FLOATNUMBER",
                "IDENTIFIER",
                "NEW_LINE",
                "QUATED_STRING",
            };
            
            for (int i = 0; i < selectableNextTokens.length; i++) {
                int selectableNextToken = selectableNextTokens[i];
                writer.print("        ");
                writer.println(tokenStrings[selectableNextToken]);
            }
            
            writer.close();
            if (writer.checkError())
                throw new java.lang.RuntimeException();
            throw new ParseException(buffer.toString(), errorNextToken);
        }
        
        
        
        private static final int[][] __dfaTable__notavacc_reserved;
        static {
            __dfaTable__notavacc_reserved = new int[63][];
            initializeDFATable0();
            initializeDFATable50();
        }
        private static void initializeDFATable0() {
            __dfaTable__notavacc_reserved[0] = new int[] {
                -1,
                '\t', '\t', 1,
                '\n', '\n', 2,
                '\r', '\r', 3,
                ' ', ' ', 1,
                '!', '!', 4,
                '\"', '\"', 5,
                '#', '#', 7,
                '$', '$', 28,
                '%', '%', 29,
                '&', '&', 30,
                '\'', '\'', 32,
                '(', '(', 33,
                ')', ')', 34,
                '*', '*', 35,
                '+', '+', 36,
                ',', ',', 37,
                '-', '-', 38,
                '.', '.', 42,
                '/', '/', 43,
                '0', '9', 41,
                ':', ':', 50,
                ';', ';', 51,
                '<', '<', 52,
                '=', '=', 53,
                '>', '>', 54,
                '?', '?', 55,
                'A', 'Z', 28,
                '[', '[', 56,
                '\\', '\\', 57,
                ']', ']', 58,
                '_', '_', 28,
                'a', 'z', 28,
                '{', '{', 59,
                '|', '|', 60,
                '}', '}', 62,
                '\u0080', '\uFFFF', 28,
            };
            __dfaTable__notavacc_reserved[1] = new int[] {
                PreProcessorParser.TOKEN_SPACE,
                '\t', '\t', 1,
                ' ', ' ', 1,
            };
            __dfaTable__notavacc_reserved[2] = new int[] {
                PreProcessorParser.TOKEN_NEW_LINE,
            };
            __dfaTable__notavacc_reserved[3] = new int[] {
                PreProcessorParser.TOKEN_NEW_LINE,
                '\n', '\n', 2,
            };
            __dfaTable__notavacc_reserved[4] = new int[] {
                PreProcessorParser.TOKEN_NOT,
            };
            __dfaTable__notavacc_reserved[5] = new int[] {
                -1,
                '\u0000', '!', 5,
                '\"', '\"', 6,
                '#', '\uFFFF', 5,
            };
            __dfaTable__notavacc_reserved[6] = new int[] {
                PreProcessorParser.TOKEN_QUATED_STRING,
            };
            __dfaTable__notavacc_reserved[7] = new int[] {
                -1,
                '\t', '\t', 7,
                ' ', ' ', 7,
                'd', 'd', 8,
                'e', 'e', 14,
                'i', 'i', 20,
            };
            __dfaTable__notavacc_reserved[8] = new int[] {
                -1,
                'e', 'e', 9,
            };
            __dfaTable__notavacc_reserved[9] = new int[] {
                -1,
                'f', 'f', 10,
            };
            __dfaTable__notavacc_reserved[10] = new int[] {
                -1,
                'i', 'i', 11,
            };
            __dfaTable__notavacc_reserved[11] = new int[] {
                -1,
                'n', 'n', 12,
            };
            __dfaTable__notavacc_reserved[12] = new int[] {
                -1,
                'e', 'e', 13,
            };
            __dfaTable__notavacc_reserved[13] = new int[] {
                PreProcessorParser.TOKEN_DIRECTIVE,
                '\t', '\t', 13,
                ' ', ' ', 13,
            };
            __dfaTable__notavacc_reserved[14] = new int[] {
                -1,
                'l', 'l', 15,
                'n', 'n', 18,
            };
            __dfaTable__notavacc_reserved[15] = new int[] {
                -1,
                's', 's', 16,
            };
            __dfaTable__notavacc_reserved[16] = new int[] {
                -1,
                'e', 'e', 13,
                'i', 'i', 17,
            };
            __dfaTable__notavacc_reserved[17] = new int[] {
                -1,
                'f', 'f', 13,
            };
            __dfaTable__notavacc_reserved[18] = new int[] {
                -1,
                'd', 'd', 19,
            };
            __dfaTable__notavacc_reserved[19] = new int[] {
                -1,
                'i', 'i', 17,
            };
            __dfaTable__notavacc_reserved[20] = new int[] {
                -1,
                'f', 'f', 21,
                'n', 'n', 24,
            };
            __dfaTable__notavacc_reserved[21] = new int[] {
                PreProcessorParser.TOKEN_DIRECTIVE,
                '\t', '\t', 13,
                ' ', ' ', 13,
                'd', 'd', 22,
                'n', 'n', 23,
            };
            __dfaTable__notavacc_reserved[22] = new int[] {
                -1,
                'e', 'e', 17,
            };
            __dfaTable__notavacc_reserved[23] = new int[] {
                -1,
                'd', 'd', 22,
            };
            __dfaTable__notavacc_reserved[24] = new int[] {
                -1,
                'c', 'c', 25,
            };
            __dfaTable__notavacc_reserved[25] = new int[] {
                -1,
                'l', 'l', 26,
            };
            __dfaTable__notavacc_reserved[26] = new int[] {
                -1,
                'u', 'u', 27,
            };
            __dfaTable__notavacc_reserved[27] = new int[] {
                -1,
                'd', 'd', 12,
            };
            __dfaTable__notavacc_reserved[28] = new int[] {
                PreProcessorParser.TOKEN_IDENTIFIER,
                '$', '$', 28,
                '0', '9', 28,
                'A', 'Z', 28,
                '_', '_', 28,
                'a', 'z', 28,
                '\u0080', '\uFFFF', 28,
            };
            __dfaTable__notavacc_reserved[29] = new int[] {
                PreProcessorParser.TOKEN_MOD,
            };
            __dfaTable__notavacc_reserved[30] = new int[] {
                PreProcessorParser.TOKEN_AMPARSAND,
                '&', '&', 31,
            };
            __dfaTable__notavacc_reserved[31] = new int[] {
                PreProcessorParser.TOKEN_LAND,
            };
            __dfaTable__notavacc_reserved[32] = new int[] {
                PreProcessorParser.TOKEN_QUOTE,
            };
            __dfaTable__notavacc_reserved[33] = new int[] {
                PreProcessorParser.TOKEN_LEFT_PAREN,
            };
            __dfaTable__notavacc_reserved[34] = new int[] {
                PreProcessorParser.TOKEN_RIGHT_PAREN,
            };
            __dfaTable__notavacc_reserved[35] = new int[] {
                PreProcessorParser.TOKEN_ASTERRISC,
            };
            __dfaTable__notavacc_reserved[36] = new int[] {
                PreProcessorParser.TOKEN_PLUS,
            };
            __dfaTable__notavacc_reserved[37] = new int[] {
                PreProcessorParser.TOKEN_COMMA,
            };
            __dfaTable__notavacc_reserved[38] = new int[] {
                PreProcessorParser.TOKEN_MINUS,
                '.', '.', 39,
                '0', '9', 41,
            };
            __dfaTable__notavacc_reserved[39] = new int[] {
                -1,
                '0', '9', 40,
            };
            __dfaTable__notavacc_reserved[40] = new int[] {
                PreProcessorParser.TOKEN_FLOATNUMBER,
                '0', '9', 40,
            };
            __dfaTable__notavacc_reserved[41] = new int[] {
                PreProcessorParser.TOKEN_NUMBER,
                '.', '.', 39,
                '0', '9', 41,
            };
            __dfaTable__notavacc_reserved[42] = new int[] {
                PreProcessorParser.TOKEN_DOT,
                '0', '9', 40,
            };
            __dfaTable__notavacc_reserved[43] = new int[] {
                PreProcessorParser.TOKEN_DIV,
                '*', '*', 44,
                '/', '/', 47,
            };
            __dfaTable__notavacc_reserved[44] = new int[] {
                -1,
                '\u0000', ')', 44,
                '*', '*', 45,
                '+', '\uFFFF', 44,
            };
            __dfaTable__notavacc_reserved[45] = new int[] {
                -1,
                '\u0000', ')', 44,
                '*', '*', 45,
                '+', '.', 44,
                '/', '/', 46,
                '0', '\uFFFF', 44,
            };
            __dfaTable__notavacc_reserved[46] = new int[] {
                PreProcessorParser.TOKEN_COMMENT,
            };
            __dfaTable__notavacc_reserved[47] = new int[] {
                -1,
                '\u0000', '\t', 47,
                '\n', '\n', 48,
                '\u000B', '\f', 47,
                '\r', '\r', 49,
                '\u000E', '\uFFFF', 47,
            };
            __dfaTable__notavacc_reserved[48] = new int[] {
                PreProcessorParser.TOKEN_CXXCOMMENT,
            };
            __dfaTable__notavacc_reserved[49] = new int[] {
                PreProcessorParser.TOKEN_CXXCOMMENT,
                '\n', '\n', 48,
            };
        }
        private static void initializeDFATable50() {
            __dfaTable__notavacc_reserved[50] = new int[] {
                PreProcessorParser.TOKEN_COLON,
            };
            __dfaTable__notavacc_reserved[51] = new int[] {
                PreProcessorParser.TOKEN_SEMICOLON,
            };
            __dfaTable__notavacc_reserved[52] = new int[] {
                PreProcessorParser.TOKEN_LT,
            };
            __dfaTable__notavacc_reserved[53] = new int[] {
                PreProcessorParser.TOKEN_EQUAL,
            };
            __dfaTable__notavacc_reserved[54] = new int[] {
                PreProcessorParser.TOKEN_GT,
            };
            __dfaTable__notavacc_reserved[55] = new int[] {
                PreProcessorParser.TOKEN_QUESTION,
            };
            __dfaTable__notavacc_reserved[56] = new int[] {
                PreProcessorParser.TOKEN_LEFT_BBAREN,
            };
            __dfaTable__notavacc_reserved[57] = new int[] {
                PreProcessorParser.TOKEN_BACKSLASH,
            };
            __dfaTable__notavacc_reserved[58] = new int[] {
                PreProcessorParser.TOKEN_RIGHT_BBAREN,
            };
            __dfaTable__notavacc_reserved[59] = new int[] {
                PreProcessorParser.TOKEN_LEFT_BAREN,
            };
            __dfaTable__notavacc_reserved[60] = new int[] {
                PreProcessorParser.TOKEN_BOR,
                '|', '|', 61,
            };
            __dfaTable__notavacc_reserved[61] = new int[] {
                PreProcessorParser.TOKEN_LOR,
            };
            __dfaTable__notavacc_reserved[62] = new int[] {
                PreProcessorParser.TOKEN_RIGHT_BAREN,
            };
        }
        
        
        private static final int[][] __lrTable__notavacc_reserved;
        static {
            __lrTable__notavacc_reserved = new int[1 * 3][];
            initializeLRTable0();
        }
        private static void initializeLRTable0() {
            // State 0  (LRState0)
            __lrTable__notavacc_reserved[0 * 3 + 0] = new int[] {
            };
            __lrTable__notavacc_reserved[0 * 3 + 1] = new int[] {
            };
            __lrTable__notavacc_reserved[0 * 3 + 2] = new int[] {
            };
        }
        
        private static final int[][] __reductionTable__notavacc_reserved = {
        };
        
        
        private static  void __replaceAll__notavacc_reserved(java.util.List list, Node oldValue, Node newValue) {
            java.util.Collections.replaceAll(list, oldValue, newValue);
        }
        
        private static java.lang.String __toHexCode__notavacc_reserved(char ch) {
            java.lang.String hex = "000" + java.lang.Integer.toString(ch, 16).toUpperCase(java.util.Locale.ENGLISH);
            hex = hex.substring(hex.length() - 4);
            return hex;
        }
        
        /*
        private static String __quoted__notavacc_reserved(char ch) {
            StringBuffer quoted = new StringBuffer("\'");
            __quoted__notavacc_reserved(quoted, ch);
            quoted.append("\'");
            return quoted.toString();
        }
        private static String __quoted__notavacc_reserved(String str) {
            return __quoted__notavacc_reserved(str, true);
        }
        private static String __quoted__notavacc_reserved(String str, boolean quote) {
            StringBuffer quoted = new StringBuffer();
            if (quote)
                quoted.append("\"");
            for (int i = 0; i < str.length(); i++) {
                char ch = str.charAt(i);
                __quoted__notavacc_reserved(quoted, ch);
            }
            if (quote)
                quoted.append("\"");
            return quoted.toString();
        }
        private static void __quoted__notavacc_reserved(StringBuffer result, char ch) {
            switch (ch) {
            default:
                if (0x0020 <= ch && ch <= 0x007E) {
                    result.append(ch);
                } else {
                    result.append("\\u").append(__toHexCode__notavacc_reserved(ch));
                }
                break;
            case '\n':   result.append("\\n");      break;
            case '\t':   result.append("\\t");      break;
            case '\b':   result.append("\\b");      break;
            case '\r':   result.append("\\r");      break;
            case '\f':   result.append("\\f");      break;
            case '\\':   result.append("\\\\");     break;
            case '\'':   result.append("\\\'");     break;
            case '\"':   result.append("\\\"");     break;
            }
        }
        */
        
    } // class PreProcessorParser
