/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.util.ConcurrentModificationException;
import java.util.LinkedList;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

class AnoGakkiPane
extends JComponent {
    static final int INTERVAL_MS = 15;
    static final int INITIAL_COUNT = 20;
    static final double MAX_OMEGA = 0.005;
    static final int CIRCLE = 0;
    static final int LINE = 1;
    static final int SQUARE = 2;
    static final int TRIANGLE = 3;
    static final int N_SHAPES = 4;
    static final Color color = new Color(0, 255, 255, 192);
    static final Stroke stroke = new BasicStroke(5.0f);
    static final int MAX_VISIBLE_OBJECTS = 30;
    LinkedList<QueueEntry> queue = new LinkedList();
    Timer timer = new Timer(15, new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n = 0;
            try {
                for (QueueEntry queueEntry : AnoGakkiPane.this.queue) {
                    if (queueEntry.countdown-- <= 0) {
                        ++n;
                        continue;
                    }
                    queueEntry.t_ms += 15;
                    queueEntry.r = queueEntry.t_ms / 2;
                    if (queueEntry.shape != 2 && queueEntry.shape != 3) continue;
                    queueEntry.affine_transform.rotate(queueEntry.omega * Math.sqrt(queueEntry.t_ms), queueEntry.clicked_point.x, queueEntry.clicked_point.y);
                }
                while (n-- > 0) {
                    AnoGakkiPane.this.queue.poll();
                }
                if (AnoGakkiPane.this.queue.size() == 0) {
                    AnoGakkiPane.this.timer.stop();
                }
                AnoGakkiPane.this.repaint();
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                return;
            }
        }
    });
    private long prev_started_at = System.nanoTime();

    public AnoGakkiPane() {
        this.setOpaque(false);
        this.timer.setCoalesce(true);
        this.timer.setRepeats(true);
    }

    @Override
    public void paint(Graphics graphics) {
        if (this.queue.size() == 0) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        Dimension dimension = this.getSize();
        graphics2D.setStroke(stroke);
        graphics2D.setColor(color);
        try {
            for (QueueEntry queueEntry : this.queue) {
                int n = queueEntry.r;
                int n2 = queueEntry.clicked_point.x;
                int n3 = queueEntry.clicked_point.y;
                switch (queueEntry.shape) {
                    case 0: {
                        graphics2D.drawOval(n2 - n, n3 - n, 2 * n, 2 * n);
                        break;
                    }
                    case 1: {
                        graphics2D.transform(queueEntry.affine_transform);
                        graphics2D.drawLine(-dimension.width * 2, n3 - n, dimension.width * 2, n3 - n);
                        graphics2D.drawLine(-dimension.width * 2, n3 + n, dimension.width * 2, n3 + n);
                        break;
                    }
                    case 2: {
                        graphics2D.transform(queueEntry.affine_transform);
                        graphics2D.drawRect(n2 - n, n3 - n, 2 * n, 2 * n);
                        break;
                    }
                    case 3: {
                        graphics2D.transform(queueEntry.affine_transform);
                        graphics2D.drawLine(n2 - n, n3, n2 + n, n3 - n);
                        graphics2D.drawLine(n2 - n, n3, n2 + n, n3 + n);
                        graphics2D.drawLine(n2 + n, n3 - n, n2 + n, n3 + n);
                    }
                }
            }
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            return;
        }
    }

    public void start(Component component, Point point) {
        long l = System.nanoTime();
        if (l - this.prev_started_at < 750000L) {
            return;
        }
        QueueEntry queueEntry = new QueueEntry();
        queueEntry.clicked_point = SwingUtilities.convertPoint(component, point, this);
        queueEntry.shape = (int)(Math.random() * 4.0);
        if (queueEntry.shape != 0) {
            queueEntry.affine_transform = AffineTransform.getRotateInstance(Math.PI * 2 * Math.random(), queueEntry.clicked_point.x, queueEntry.clicked_point.y);
            queueEntry.omega = 0.005 * (1.0 - 2.0 * Math.random());
        }
        this.queue.offer(queueEntry);
        this.timer.start();
        this.prev_started_at = l;
    }

    class QueueEntry {
        int countdown = 20;
        int t_ms = 0;
        int shape = 0;
        Point clicked_point;
        int r = 0;
        double omega = 0.0;
        AffineTransform affine_transform = null;

        QueueEntry() {
        }
    }
}

