/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.applet.AppletContext;
import java.applet.AppletStub;
import java.applet.AudioClip;
import java.awt.Component;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Iterator;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

class AppletFrame
extends JFrame
implements AppletStub,
AppletContext {
    JLabel status_;
    ChordHelperApplet applet = null;

    public AppletFrame(ChordHelperApplet chordHelperApplet) {
        this.setTitle("MIDI Chord Helper");
        this.status_ = new JLabel();
        this.status_.setFont(this.status_.getFont().deriveFont(0));
        this.applet = chordHelperApplet;
        this.add((Component)this.applet, "Center");
        this.add((Component)this.status_, "South");
        chordHelperApplet.setStub(this);
        chordHelperApplet.init();
        this.setIconImage(chordHelperApplet.image_icon.getImage());
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                if (AppletFrame.this.applet.isConfirmedToExit()) {
                    System.exit(0);
                }
            }
        });
        chordHelperApplet.editor_dialog.seq_list_model.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent tableModelEvent) {
                if (tableModelEvent.getColumn() == 7) {
                    AppletFrame.this.setFilenameToTitle();
                }
            }
        });
        chordHelperApplet.device_manager.time_range_model.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                AppletFrame.this.setFilenameToTitle();
            }
        });
        this.pack();
        this.setLocationRelativeTo(null);
        this.setVisible(true);
        chordHelperApplet.start();
    }

    private void setFilenameToTitle() {
        MidiSequenceModel midiSequenceModel = this.applet.device_manager.time_range_model.getSequenceModel();
        String string = midiSequenceModel == null ? null : midiSequenceModel.getFilename();
        String string2 = "MIDI Chord Helper";
        if (string != null && !string.isEmpty()) {
            string2 = string + " - " + string2;
        }
        this.setTitle(string2);
    }

    @Override
    public boolean isActive() {
        return true;
    }

    @Override
    public URL getDocumentBase() {
        return null;
    }

    @Override
    public URL getCodeBase() {
        return null;
    }

    @Override
    public String getParameter(String string) {
        return null;
    }

    @Override
    public AppletContext getAppletContext() {
        return this;
    }

    @Override
    public void appletResize(int n, int n2) {
    }

    @Override
    public AudioClip getAudioClip(URL uRL) {
        return null;
    }

    @Override
    public Image getImage(URL uRL) {
        return Toolkit.getDefaultToolkit().getImage(uRL);
    }

    @Override
    public Applet getApplet(String string) {
        return null;
    }

    @Override
    public Enumeration<Applet> getApplets() {
        return null;
    }

    @Override
    public void showDocument(URL uRL) {
    }

    @Override
    public void showDocument(URL uRL, String string) {
    }

    @Override
    public void showStatus(String string) {
        this.status_.setText(string);
    }

    @Override
    public InputStream getStream(String string) {
        return null;
    }

    @Override
    public Iterator<String> getStreamKeys() {
        return null;
    }

    @Override
    public void setStream(String string, InputStream inputStream) throws IOException {
    }
}

