/*
 * Decompiled with CFR 0.152.
 */
import java.awt.FlowLayout;
import java.util.ArrayList;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

class HexTextForm
extends JPanel {
    public JTextArea text_area;
    public JLabel title_label;

    public HexTextForm(String string) {
        this(string, 1, 3);
    }

    public HexTextForm(String string, int n, int n2) {
        if (string != null) {
            this.title_label = new JLabel(string);
            this.add(this.title_label);
        }
        this.text_area = new JTextArea(n, n2);
        this.text_area.setLineWrap(true);
        JScrollPane jScrollPane = new JScrollPane(this.text_area);
        this.add(jScrollPane);
        this.setLayout(new FlowLayout());
    }

    public String getString() {
        return this.text_area.getText();
    }

    public byte[] getBytesFromString() {
        return this.getString().getBytes();
    }

    public byte[] getBytes() {
        int n;
        String[] stringArray = this.getString().trim().split(" +");
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (String string : stringArray) {
            if (string.length() == 0) continue;
            try {
                n = Integer.decode(string);
            }
            catch (NumberFormatException numberFormatException) {
                JOptionPane.showMessageDialog(this, string + " : is not a number", "MIDI Chord Helper", 0);
                return null;
            }
            arrayList.add(n);
        }
        byte[] byArray = new byte[arrayList.size()];
        n = 0;
        for (Integer n2 : arrayList) {
            byArray[n++] = (byte)(n2 & 0xFF);
        }
        return byArray;
    }

    public void setTitle(String string) {
        this.title_label.setText(string);
    }

    public void setString(String string) {
        this.text_area.setText(string);
    }

    public void setValue(int n) {
        this.text_area.setText(String.format(" 0x%02X", n));
    }

    public void setValue(byte by) {
        this.text_area.setText(String.format(" 0x%02X", by));
    }

    public void setValue(byte[] byArray) {
        String string = "";
        for (byte by : byArray) {
            string = string + String.format(" 0x%02X", by);
        }
        this.text_area.setText(string);
    }

    public void clear() {
        this.text_area.setText("");
    }
}

