/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

class InversionAndOmissionLabel
extends JLabel
implements MouseListener,
PopupMenuListener {
    JPopupMenu popup_menu;
    ButtonGroup omission_group = new ButtonGroup();
    ButtonIcon icon = new ButtonIcon(8);
    JRadioButtonMenuItem[] rb_items = new JRadioButtonMenuItem[4];
    JCheckBoxMenuItem cb_inversion;

    public InversionAndOmissionLabel() {
        this.setIcon(this.icon);
        this.popup_menu = new JPopupMenu();
        this.cb_inversion = new JCheckBoxMenuItem("Auto Inversion", true);
        this.popup_menu.add(this.cb_inversion);
        this.popup_menu.addSeparator();
        this.rb_items[0] = new JRadioButtonMenuItem("All notes", true);
        this.omission_group.add(this.rb_items[0]);
        this.popup_menu.add(this.rb_items[0]);
        this.rb_items[1] = new JRadioButtonMenuItem("Omit 5th");
        this.omission_group.add(this.rb_items[1]);
        this.popup_menu.add(this.rb_items[1]);
        this.rb_items[2] = new JRadioButtonMenuItem("Omit 3rd (Power Chord)");
        this.omission_group.add(this.rb_items[2]);
        this.popup_menu.add(this.rb_items[2]);
        this.rb_items[3] = new JRadioButtonMenuItem("Omit root");
        this.omission_group.add(this.rb_items[3]);
        this.popup_menu.add(this.rb_items[3]);
        this.addMouseListener(this);
        this.popup_menu.addPopupMenuListener(this);
        this.setToolTipText("Automatic inversion and Note omission - \u81ea\u52d5\u8ee2\u56de\u3068\u7701\u7565\u97f3\u306e\u8a2d\u5b9a");
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        Component component = mouseEvent.getComponent();
        if (component == this) {
            this.popup_menu.show(component, 0, this.getHeight());
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
        this.repaint();
    }

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
    }

    public boolean isAutoInversionMode() {
        return this.cb_inversion.isSelected();
    }

    public void setAutoInversion(boolean bl) {
        this.cb_inversion.setSelected(bl);
    }

    public int getOmissionNoteIndex() {
        if (this.rb_items[3].isSelected()) {
            return 0;
        }
        if (this.rb_items[2].isSelected()) {
            return 1;
        }
        if (this.rb_items[1].isSelected()) {
            return 2;
        }
        return -1;
    }

    public void setOmissionNoteIndex(int n) {
        switch (n) {
            case 0: {
                this.rb_items[3].setSelected(true);
                break;
            }
            case 1: {
                this.rb_items[2].setSelected(true);
                break;
            }
            case 2: {
                this.rb_items[1].setSelected(true);
                break;
            }
            default: {
                this.rb_items[0].setSelected(true);
            }
        }
    }
}

