/*
 * Decompiled with CFR 0.152.
 */
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Receiver;
import javax.sound.midi.Sequencer;
import javax.sound.midi.Transmitter;
import javax.swing.AbstractListModel;

class MidiConnecterListModel
extends AbstractListModel {
    MidiDevice device;
    List<MidiConnecterListModel> device_models;
    UnicodeConverter unicode_conv = new UnicodeConverter();

    public MidiConnecterListModel(MidiDevice midiDevice, List<MidiConnecterListModel> list) {
        this.device = midiDevice;
        this.device_models = list;
    }

    public String toString() {
        return this.unicode_conv.convertToUnicode(this.device.getDeviceInfo().toString());
    }

    @Override
    public Object getElementAt(int n) {
        int n2 = 0;
        List<Receiver> list = this.device.getReceivers();
        for (Receiver object2 : list) {
            if (n2++ != n) continue;
            return object2;
        }
        List<Transmitter> list2 = this.device.getTransmitters();
        Iterator iterator = list2.iterator();
        while (iterator.hasNext()) {
            Transmitter transmitter = (Transmitter)iterator.next();
            if (n2++ != n) continue;
            return transmitter;
        }
        return null;
    }

    @Override
    public int getSize() {
        return this.device.getReceivers().size() + this.device.getTransmitters().size();
    }

    public int indexOf(Object object) {
        int n = 0;
        List<Receiver> list = this.device.getReceivers();
        for (Receiver object22 : list) {
            if (object22 == object) {
                return n;
            }
            ++n;
        }
        List<Transmitter> list2 = this.device.getTransmitters();
        Iterator iterator = list2.iterator();
        while (iterator.hasNext()) {
            Transmitter transmitter = (Transmitter)iterator.next();
            if (transmitter == object) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public boolean hasTx() {
        return this.device.getMaxTransmitters() != 0;
    }

    public boolean hasRx() {
        return this.device.getMaxReceivers() != 0;
    }

    public void ConnectToReceiver(Transmitter transmitter) {
        List<Receiver> list = this.device.getReceivers();
        if (list.size() == 0) {
            return;
        }
        transmitter.setReceiver(list.get(0));
        this.fireContentsChanged(this, 0, this.getSize());
    }

    public Transmitter getUnconnectedTransmitter() {
        Transmitter transmitter;
        if (!this.hasTx()) {
            return null;
        }
        List<Transmitter> list = this.device.getTransmitters();
        for (Transmitter transmitter2 : list) {
            if (transmitter2.getReceiver() != null) continue;
            return transmitter2;
        }
        try {
            transmitter = this.device.getTransmitter();
        }
        catch (MidiUnavailableException midiUnavailableException) {
            midiUnavailableException.printStackTrace();
            return null;
        }
        this.fireIntervalAdded(this, 0, this.getSize());
        return transmitter;
    }

    public void closeTransmitter(Transmitter transmitter) {
        List<Transmitter> list = this.device.getTransmitters();
        boolean bl = false;
        for (Transmitter transmitter2 : list) {
            if (transmitter2 != transmitter) continue;
            bl = true;
            break;
        }
        if (!bl) {
            return;
        }
        transmitter.close();
        this.fireIntervalRemoved(this, 0, this.getSize());
    }

    public void connectToReceiverOf(MidiConnecterListModel midiConnecterListModel) {
        if (!this.hasTx() || midiConnecterListModel == null || !midiConnecterListModel.hasRx()) {
            return;
        }
        List<Receiver> list = midiConnecterListModel.device.getReceivers();
        if (list.isEmpty()) {
            return;
        }
        this.getUnconnectedTransmitter().setReceiver(list.get(0));
    }

    public void openDevice() throws MidiUnavailableException {
        this.device.open();
        if (this.hasRx() && this.device.getReceivers().size() == 0) {
            try {
                this.device.getReceiver();
            }
            catch (MidiUnavailableException midiUnavailableException) {
                // empty catch block
            }
        }
    }

    public void closeDevice() {
        if (this.hasRx()) {
            Receiver receiver = this.device.getReceivers().get(0);
            for (MidiConnecterListModel midiConnecterListModel : this.device_models) {
                if (midiConnecterListModel == this || !midiConnecterListModel.hasTx()) continue;
                for (int i = 0; i < midiConnecterListModel.getSize(); ++i) {
                    Transmitter transmitter;
                    Object object = midiConnecterListModel.getElementAt(i);
                    if (!(object instanceof Transmitter) || (transmitter = (Transmitter)object).getReceiver() != receiver) continue;
                    midiConnecterListModel.closeTransmitter(transmitter);
                }
            }
        }
        this.device.close();
    }

    public void resetMicrosecondPosition() {
        Object object;
        AutoCloseable autoCloseable22;
        if (!this.hasTx() || this.device instanceof Sequencer) {
            return;
        }
        List<Transmitter> list = this.device.getTransmitters();
        Vector<Receiver> vector = new Vector<Receiver>();
        for (AutoCloseable autoCloseable22 : list) {
            object = autoCloseable22.getReceiver();
            if (object == null) continue;
            vector.add((Receiver)object);
        }
        Object object2 = null;
        autoCloseable22 = null;
        if (this.hasRx()) {
            autoCloseable22 = this.device.getReceivers().get(0);
            object2 = new Vector();
            for (MidiConnecterListModel object3 : this.device_models) {
                if (object3 == this || !object3.hasTx()) continue;
                for (int i = 0; i < object3.getSize(); ++i) {
                    Transmitter transmitter;
                    Object object4 = object3.getElementAt(i);
                    if (!(object4 instanceof Transmitter) || (transmitter = (Transmitter)object4).getReceiver() != autoCloseable22) continue;
                    object2.add(transmitter);
                }
            }
        }
        this.device.close();
        try {
            this.device.open();
        }
        catch (MidiUnavailableException midiUnavailableException) {
            midiUnavailableException.printStackTrace();
        }
        for (Receiver receiver : vector) {
            Transmitter transmitter = this.getUnconnectedTransmitter();
            if (transmitter == null) continue;
            transmitter.setReceiver(receiver);
        }
        if (object2 != null) {
            autoCloseable22 = this.device.getReceivers().get(0);
            object = object2.iterator();
            while (object.hasNext()) {
                Transmitter transmitter = (Transmitter)((Object)object.next());
                transmitter.setReceiver((Receiver)autoCloseable22);
            }
        }
    }
}

