/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.AccessControlException;
import java.util.EventObject;
import java.util.List;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiChannel;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiEvent;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.Sequence;
import javax.sound.midi.ShortMessage;
import javax.swing.AbstractAction;
import javax.swing.AbstractCellEditor;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

class MidiEditor
extends JDialog
implements DropTargetListener,
ListSelectionListener {
    Insets zero_insets = new Insets(0, 0, 0, 0);
    MidiDeviceManager device_manager;
    SequenceListModel seq_list_model;
    JFileChooser file_chooser = null;
    Base64Dialog base64_dialog = null;
    NewSequenceDialog new_seq_dialog;
    MidiEventDialog event_dialog = new MidiEventDialog();
    MidiEvent[] copied_events = null;
    int copied_events_PPQ = 0;
    ListSelectionModel seq_selection_model;
    ListSelectionModel track_selection_model;
    ListSelectionModel event_selection_model;
    JTable sequence_table_view;
    JTable track_table_view;
    JTable event_table_view;
    JScrollPane scrollable_sequence_table;
    JScrollPane scrollable_track_table_view;
    JScrollPane scrollable_event_table_view;
    JLabel total_time_label;
    JLabel tracks_label;
    JLabel midi_events_label;
    JButton add_new_sequence_button;
    JButton delete_sequence_button;
    JButton base64_encode_button = null;
    JButton add_midi_file_button;
    JButton save_midi_file_button;
    JButton jump_sequence_button;
    JButton add_track_button;
    JButton remove_track_button;
    JButton add_event_button;
    JButton jump_event_button;
    JButton cut_event_button;
    JButton copy_event_button;
    JButton paste_event_button;
    JButton remove_event_button;
    JCheckBox pair_note_checkbox;
    JButton forward_button;
    JButton backward_button;
    JToggleButton play_pause_button;
    JSplitPane sequence_split_pane;
    JSplitPane track_split_pane;
    VirtualMidiDevice midi_device = new AbstractVirtualMidiDevice(){
        {
            this.info = new MyInfo();
            this.setMaxReceivers(0);
        }

        class MyInfo
        extends MidiDevice.Info {
            protected MyInfo() {
                super("MIDI Editor", "Unknown vendor", "MIDI sequence editor", "Ver.20090531");
            }
        }
    };
    MidiEventCellEditor event_cell_editor;
    public Action move_to_top_action = new AbstractAction(){
        {
            this.putValue("ShortDescription", "Move to top or previous song - \u66f2\u306e\u5148\u982d\u307e\u305f\u306f\u524d\u306e\u66f2\u3078\u623b\u308b");
            this.putValue("SwingLargeIconKey", new ButtonIcon(17));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (MidiEditor.this.device_manager.getSequencer().getTickPosition() <= 40L) {
                MidiEditor.this.loadNext(-1);
            }
            MidiEditor.this.device_manager.time_range_model.setValue(0);
        }
    };
    public Action move_to_bottom_action = new AbstractAction(){
        {
            this.putValue("ShortDescription", "Move to next song - \u6b21\u306e\u66f2\u3078\u9032\u3080");
            this.putValue("SwingLargeIconKey", new ButtonIcon(18));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (MidiEditor.this.loadNext(1)) {
                MidiEditor.this.device_manager.time_range_model.setValue(0);
            }
        }
    };

    public MidiEditor(MidiDeviceManager midiDeviceManager) {
        Object object;
        this.device_manager = midiDeviceManager;
        this.setTitle("MIDI Editor/Playlist - MIDI Chord Helper");
        this.setBounds(150, 200, 850, 500);
        this.setLayout(new FlowLayout());
        ButtonIcon buttonIcon = new ButtonIcon(10);
        this.total_time_label = new JLabel();
        this.add_new_sequence_button = new JButton("New");
        this.add_new_sequence_button.setToolTipText("Generate new song - \u65b0\u3057\u3044\u66f2\u3092\u751f\u6210");
        this.add_new_sequence_button.setMargin(this.zero_insets);
        this.add_new_sequence_button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MidiEditor.this.new_seq_dialog.setVisible(true);
            }
        });
        this.add_midi_file_button = new JButton("Open");
        this.add_midi_file_button.setMargin(this.zero_insets);
        this.add_midi_file_button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (MidiEditor.this.file_chooser == null || MidiEditor.this.file_chooser.showOpenDialog(MidiEditor.this) != 0) {
                    return;
                }
                MidiEditor.this.addSequenceFromMidiFile(MidiEditor.this.file_chooser.getSelectedFile());
            }
        });
        this.play_pause_button = new JToggleButton(midiDeviceManager.time_range_model.start_stop_action);
        this.backward_button = new JButton(this.move_to_top_action);
        this.backward_button.setMargin(this.zero_insets);
        this.forward_button = new JButton(this.move_to_bottom_action);
        this.forward_button.setMargin(this.zero_insets);
        this.jump_sequence_button = new JButton("Jump");
        this.jump_sequence_button.setToolTipText("Move to selected song - \u9078\u629e\u3057\u305f\u66f2\u3078\u9032\u3080");
        this.jump_sequence_button.setMargin(this.zero_insets);
        this.jump_sequence_button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MidiEditor.this.load(MidiEditor.this.seq_selection_model.getMinSelectionIndex());
            }
        });
        this.save_midi_file_button = new JButton("Save");
        this.save_midi_file_button.setMargin(this.zero_insets);
        this.save_midi_file_button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FileOutputStream fileOutputStream;
                File file;
                if (MidiEditor.this.file_chooser == null) {
                    return;
                }
                MidiSequenceModel midiSequenceModel = MidiEditor.this.seq_list_model.getSequenceModel(MidiEditor.this.seq_selection_model);
                String string = midiSequenceModel.getFilename();
                if (string != null && string != "") {
                    file = new File(string);
                    MidiEditor.this.file_chooser.setSelectedFile(file);
                }
                if (MidiEditor.this.file_chooser.showSaveDialog(MidiEditor.this) != 0) {
                    return;
                }
                file = MidiEditor.this.file_chooser.getSelectedFile();
                if (file.exists() && !MidiEditor.this.confirm("Overwrite " + file.getName() + " ?\n" + file.getName() + " \u3092\u4e0a\u66f8\u304d\u3057\u3066\u3088\u308d\u3057\u3044\u3067\u3059\u304b\uff1f")) {
                    return;
                }
                try {
                    fileOutputStream = new FileOutputStream(file);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    MidiEditor.this.showError(file.getName() + ": Cannot open to write");
                    fileNotFoundException.printStackTrace();
                    return;
                }
                try {
                    fileOutputStream.write(midiSequenceModel.getMIDIdata());
                    fileOutputStream.close();
                    midiSequenceModel.setModified(false);
                }
                catch (IOException iOException) {
                    MidiEditor.this.showError(file.getName() + ": I/O Error");
                    iOException.printStackTrace();
                }
            }
        });
        this.delete_sequence_button = new JButton("Delete", buttonIcon);
        this.delete_sequence_button.setMargin(this.zero_insets);
        this.delete_sequence_button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (MidiEditor.this.file_chooser != null && MidiEditor.this.seq_list_model.getSequenceModel(MidiEditor.this.seq_selection_model).isModified() && !MidiEditor.this.confirm("Selected MIDI sequence not saved - delete it ?\n\u9078\u629e\u3057\u305fMIDI\u30b7\u30fc\u30b1\u30f3\u30b9\u306f\u4fdd\u5b58\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u304c\u3001\u524a\u9664\u3057\u307e\u3059\u304b\uff1f")) {
                    return;
                }
                MidiEditor.this.seq_list_model.removeSequence(MidiEditor.this.seq_selection_model);
                MidiEditor.this.total_time_label.setText(MidiEditor.this.seq_list_model.getTotalLength());
            }
        });
        this.tracks_label = new JLabel("Tracks");
        this.add_track_button = new JButton("New");
        this.add_track_button.setMargin(this.zero_insets);
        this.add_track_button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MidiEditor.this.seq_list_model.getSequenceModel(MidiEditor.this.seq_selection_model).createTrack();
                int n = MidiEditor.this.seq_list_model.getSequenceModel(MidiEditor.this.seq_selection_model).getRowCount();
                if (n > 0) {
                    MidiEditor.this.track_selection_model.setSelectionInterval(n - 1, n - 1);
                }
                MidiEditor.this.seq_list_model.fireSequenceChanged(MidiEditor.this.seq_selection_model);
            }
        });
        this.remove_track_button = new JButton("Delete", buttonIcon);
        this.remove_track_button.setMargin(this.zero_insets);
        this.remove_track_button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!MidiEditor.this.confirm("Do you want to delete selected track ?\n\u9078\u629e\u3057\u305f\u30c8\u30e9\u30c3\u30af\u3092\u524a\u9664\u3057\u307e\u3059\u304b\uff1f")) {
                    return;
                }
                MidiEditor.this.seq_list_model.getSequenceModel(MidiEditor.this.seq_selection_model).deleteTracks(MidiEditor.this.track_selection_model);
                MidiEditor.this.seq_list_model.fireSequenceChanged(MidiEditor.this.seq_selection_model);
            }
        });
        JPanel jPanel = new JPanel();
        jPanel.add(this.add_track_button);
        jPanel.add(this.remove_track_button);
        this.event_cell_editor = new MidiEventCellEditor();
        this.add_event_button = new JButton(this.event_cell_editor.query_add_event_action);
        this.add_event_button.setMargin(this.zero_insets);
        this.jump_event_button = new JButton(this.event_cell_editor.query_jump_event_action);
        this.jump_event_button.setMargin(this.zero_insets);
        this.paste_event_button = new JButton(this.event_cell_editor.query_paste_event_action);
        this.paste_event_button.setMargin(this.zero_insets);
        this.remove_event_button = new JButton("Delete", buttonIcon);
        this.remove_event_button.setMargin(this.zero_insets);
        this.remove_event_button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!MidiEditor.this.confirm("Do you want to delete selected event ?\n\u9078\u629e\u3057\u305fMIDI\u30a4\u30d9\u30f3\u30c8\u3092\u524a\u9664\u3057\u307e\u3059\u304b\uff1f")) {
                    return;
                }
                ((MidiTrackModel)MidiEditor.this.event_table_view.getModel()).removeMidiEvents(MidiEditor.this.event_selection_model);
                MidiEditor.this.seq_list_model.fireSequenceChanged(MidiEditor.this.seq_selection_model);
            }
        });
        this.cut_event_button = new JButton("Cut");
        this.cut_event_button.setMargin(this.zero_insets);
        this.cut_event_button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!MidiEditor.this.confirm("Do you want to cut selected event ?\n\u9078\u629e\u3057\u305fMIDI\u30a4\u30d9\u30f3\u30c8\u3092\u5207\u308a\u53d6\u308a\u307e\u3059\u304b\uff1f")) {
                    return;
                }
                MidiTrackModel midiTrackModel = (MidiTrackModel)MidiEditor.this.event_table_view.getModel();
                MidiEditor.this.copied_events = midiTrackModel.getMidiEvents(MidiEditor.this.event_selection_model);
                MidiEditor.this.copied_events_PPQ = MidiEditor.this.seq_list_model.getSequenceModel(MidiEditor.this.seq_selection_model).getSequence().getResolution();
                midiTrackModel.removeMidiEvents(MidiEditor.this.copied_events);
                MidiEditor.this.seq_list_model.fireSequenceChanged(MidiEditor.this.seq_selection_model);
            }
        });
        this.copy_event_button = new JButton("Copy");
        this.copy_event_button.setMargin(this.zero_insets);
        this.copy_event_button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MidiEditor.this.copied_events = ((MidiTrackModel)MidiEditor.this.event_table_view.getModel()).getMidiEvents(MidiEditor.this.event_selection_model);
                MidiEditor.this.copied_events_PPQ = MidiEditor.this.seq_list_model.getSequenceModel(MidiEditor.this.seq_selection_model).getSequence().getResolution();
                MidiEditor.this.updateButtonStatus();
            }
        });
        this.pair_note_checkbox = new JCheckBox("Pair NoteON/OFF");
        this.pair_note_checkbox.setModel(this.event_cell_editor.pair_note_on_off_model);
        this.seq_list_model = new SequenceListModel(midiDeviceManager);
        MidiSequenceModel midiSequenceModel = new MidiSequenceModel(this.seq_list_model);
        this.sequence_table_view = new JTable(this.seq_list_model);
        this.track_table_view = new JTable(midiSequenceModel);
        this.event_table_view = new JTable(new MidiTrackModel());
        this.seq_list_model.sizeColumnWidthToFit(this.sequence_table_view);
        TableColumnModel tableColumnModel = this.track_table_view.getColumnModel();
        midiSequenceModel.sizeColumnWidthToFit(tableColumnModel);
        this.seq_selection_model = this.sequence_table_view.getSelectionModel();
        this.seq_selection_model.setSelectionMode(0);
        this.seq_selection_model.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
                MidiEditor.this.sequenceSelectionChanged();
                MidiEditor.this.track_selection_model.setSelectionInterval(0, 0);
            }
        });
        JScrollPane jScrollPane = new JScrollPane(this.sequence_table_view);
        this.track_selection_model = this.track_table_view.getSelectionModel();
        this.track_selection_model.setSelectionMode(2);
        this.track_selection_model.addListSelectionListener(this);
        JScrollPane jScrollPane2 = new JScrollPane(this.track_table_view);
        this.event_selection_model = this.event_table_view.getSelectionModel();
        this.event_selection_model.setSelectionMode(2);
        this.event_selection_model.addListSelectionListener(this);
        this.scrollable_event_table_view = new JScrollPane(this.event_table_view);
        this.base64_dialog = new Base64Dialog(this);
        if (this.base64_dialog.isBase64Available()) {
            this.base64_encode_button = new JButton("Base64 Encode");
            this.base64_encode_button.setMargin(this.zero_insets);
            this.base64_encode_button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    MidiSequenceModel midiSequenceModel = MidiEditor.this.seq_list_model.getSequenceModel(MidiEditor.this.seq_selection_model);
                    MidiEditor.this.base64_dialog.setMIDIData(midiSequenceModel.getMIDIdata(), midiSequenceModel.getFilename());
                    MidiEditor.this.base64_dialog.setVisible(true);
                }
            });
        }
        this.new_seq_dialog = new NewSequenceDialog(this);
        this.new_seq_dialog.setChannels(this.midi_device.getChannels());
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 2));
        jPanel2.add(this.total_time_label);
        jPanel2.add(Box.createRigidArea(new Dimension(10, 0)));
        jPanel2.add(this.add_new_sequence_button);
        jPanel2.add(Box.createRigidArea(new Dimension(5, 0)));
        jPanel2.add(this.add_midi_file_button);
        jPanel2.add(Box.createRigidArea(new Dimension(5, 0)));
        jPanel2.add(this.backward_button);
        jPanel2.add(Box.createRigidArea(new Dimension(5, 0)));
        jPanel2.add(this.play_pause_button);
        jPanel2.add(Box.createRigidArea(new Dimension(5, 0)));
        jPanel2.add(this.forward_button);
        jPanel2.add(Box.createRigidArea(new Dimension(5, 0)));
        jPanel2.add(this.jump_sequence_button);
        jPanel2.add(Box.createRigidArea(new Dimension(5, 0)));
        jPanel2.add(this.save_midi_file_button);
        if (this.base64_encode_button != null) {
            jPanel2.add(Box.createRigidArea(new Dimension(5, 0)));
            jPanel2.add(this.base64_encode_button);
        }
        jPanel2.add(Box.createRigidArea(new Dimension(5, 0)));
        jPanel2.add(this.delete_sequence_button);
        jPanel2.add(Box.createRigidArea(new Dimension(5, 0)));
        jPanel2.add(new SpeedSlider(midiDeviceManager.speed_slider_model));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 1));
        jPanel3.add(jScrollPane);
        jPanel3.add(Box.createRigidArea(new Dimension(0, 10)));
        jPanel3.add(jPanel2);
        jPanel3.add(Box.createRigidArea(new Dimension(0, 10)));
        this.sequenceSelectionChanged();
        this.total_time_label.setText(this.seq_list_model.getTotalLength());
        try {
            this.file_chooser = new JFileChooser();
            object = new FileNameExtensionFilter("MIDI sequence (*.mid)", "mid");
            this.file_chooser.setFileFilter((FileFilter)object);
        }
        catch (ExceptionInInitializerError exceptionInInitializerError) {
            this.file_chooser = null;
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            this.file_chooser = null;
        }
        catch (AccessControlException accessControlException) {
            this.file_chooser = null;
        }
        if (this.file_chooser == null) {
            this.add_midi_file_button.setVisible(false);
            this.save_midi_file_button.setVisible(false);
        } else {
            object = new DropTarget(this, 3, this, true);
        }
        object = new JPanel();
        ((Container)object).setLayout(new BoxLayout((Container)object, 3));
        ((Container)object).add(this.tracks_label);
        ((Container)object).add(Box.createRigidArea(new Dimension(0, 5)));
        ((Container)object).add(jScrollPane2);
        ((Container)object).add(Box.createRigidArea(new Dimension(0, 5)));
        ((Container)object).add(jPanel);
        JPanel jPanel4 = new JPanel();
        this.midi_events_label = new JLabel("No track selected");
        jPanel4.add(this.midi_events_label);
        jPanel4.add(this.scrollable_event_table_view);
        JPanel jPanel5 = new JPanel();
        jPanel5.add(this.pair_note_checkbox);
        jPanel5.add(this.jump_event_button);
        jPanel5.add(this.add_event_button);
        jPanel5.add(this.copy_event_button);
        jPanel5.add(this.cut_event_button);
        jPanel5.add(this.paste_event_button);
        jPanel5.add(this.remove_event_button);
        jPanel4.add(jPanel5);
        jPanel4.setLayout(new BoxLayout(jPanel4, 1));
        this.track_split_pane = new JSplitPane(1, (Component)object, jPanel4);
        this.track_split_pane.setDividerLocation(300);
        this.sequence_split_pane = new JSplitPane(0, jPanel3, this.track_split_pane);
        this.sequence_split_pane.setDividerLocation(160);
        Container container = this.getContentPane();
        container.setLayout(new BoxLayout(container, 1));
        container.add(Box.createVerticalStrut(2));
        container.add(this.sequence_split_pane);
        this.seq_selection_model.setSelectionInterval(0, 0);
        this.updateButtonStatus();
    }

    @Override
    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        dropTargetDragEvent.acceptDrag(3);
    }

    @Override
    public void dragExit(DropTargetEvent dropTargetEvent) {
    }

    @Override
    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
    }

    @Override
    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        dropTargetDropEvent.acceptDrop(3);
        try {
            if ((dropTargetDropEvent.getDropAction() & 3) != 0) {
                Transferable transferable = dropTargetDropEvent.getTransferable();
                List list = (List)transferable.getTransferData(DataFlavor.javaFileListFlavor);
                this.loadAndPlay(list);
                dropTargetDropEvent.dropComplete(true);
            } else {
                dropTargetDropEvent.dropComplete(false);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            dropTargetDropEvent.dropComplete(false);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        boolean bl = listSelectionEvent.getValueIsAdjusting();
        if (bl) {
            return;
        }
        Object object = listSelectionEvent.getSource();
        if (object == this.track_selection_model) {
            if (this.seq_list_model.getSequenceModel(this.seq_selection_model) == null || this.track_selection_model.isSelectionEmpty()) {
                this.midi_events_label.setText("MIDI Events (No track selected)");
                this.event_table_view.setModel(new MidiTrackModel());
            } else {
                int n = this.track_selection_model.getMinSelectionIndex();
                MidiTrackModel midiTrackModel = this.seq_list_model.getSequenceModel(this.seq_selection_model).getTrackModel(n);
                if (midiTrackModel == null) {
                    this.midi_events_label.setText("MIDI Events (No track selected)");
                    this.event_table_view.setModel(new MidiTrackModel());
                } else {
                    this.midi_events_label.setText(String.format("MIDI Events (in track No.%d)", n));
                    this.event_table_view.setModel(midiTrackModel);
                    TableColumnModel tableColumnModel = this.event_table_view.getColumnModel();
                    midiTrackModel.sizeColumnWidthToFit(tableColumnModel);
                    tableColumnModel.getColumn(5).setCellEditor(this.event_cell_editor);
                }
            }
            this.updateButtonStatus();
            this.event_selection_model.setSelectionInterval(0, 0);
        } else if (object == this.event_selection_model) {
            if (!this.event_selection_model.isSelectionEmpty()) {
                ShortMessage shortMessage;
                int n;
                MidiEvent midiEvent;
                MidiMessage midiMessage;
                MidiTrackModel midiTrackModel = (MidiTrackModel)this.event_table_view.getModel();
                int n2 = this.event_selection_model.getMinSelectionIndex();
                if (midiTrackModel.hasTrack() && (midiMessage = (midiEvent = midiTrackModel.getMidiEvent(n2)).getMessage()) instanceof ShortMessage && ((n = (shortMessage = (ShortMessage)midiMessage).getCommand()) == 128 || n == 144 || n == 160)) {
                    MidiChannel[] midiChannelArray = this.midi_device.getChannels();
                    int n3 = shortMessage.getChannel();
                    int n4 = shortMessage.getData1();
                    int n5 = shortMessage.getData2();
                    midiChannelArray[n3].noteOn(n4, n5);
                    midiChannelArray[n3].noteOff(n4, n5);
                }
                if (this.pair_note_checkbox.isSelected()) {
                    int n6 = this.event_selection_model.getMaxSelectionIndex();
                    for (int i = n2; i <= n6; ++i) {
                        int n7;
                        if (!this.event_selection_model.isSelectedIndex(i) || (n7 = midiTrackModel.getIndexOfPartnerFor(i)) < 0 || this.event_selection_model.isSelectedIndex(n7)) continue;
                        this.event_selection_model.addSelectionInterval(n7, n7);
                    }
                }
            }
            this.updateButtonStatus();
        }
    }

    private void showError(String string) {
        JOptionPane.showMessageDialog(this, string, "MIDI Chord Helper", 0);
    }

    private void showWarning(String string) {
        JOptionPane.showMessageDialog(this, string, "MIDI Chord Helper", 2);
    }

    private boolean confirm(String string) {
        return JOptionPane.showConfirmDialog(this, string, "MIDI Chord Helper", 0, 2) == 0;
    }

    @Override
    public void setVisible(boolean bl) {
        if (bl && this.isVisible()) {
            this.toFront();
        } else {
            super.setVisible(bl);
        }
    }

    public void sequenceSelectionChanged() {
        MidiSequenceModel midiSequenceModel = this.seq_list_model.getSequenceModel(this.seq_selection_model);
        this.jump_sequence_button.setEnabled(midiSequenceModel != null);
        this.save_midi_file_button.setEnabled(midiSequenceModel != null);
        this.add_track_button.setEnabled(midiSequenceModel != null);
        if (this.base64_encode_button != null) {
            this.base64_encode_button.setEnabled(midiSequenceModel != null);
        }
        if (midiSequenceModel != null) {
            int n = this.seq_selection_model.getMinSelectionIndex();
            this.delete_sequence_button.setEnabled(true);
            this.track_table_view.setModel(midiSequenceModel);
            TableColumnModel tableColumnModel = this.track_table_view.getColumnModel();
            midiSequenceModel.sizeColumnWidthToFit(tableColumnModel);
            tableColumnModel.getColumn(4).setCellEditor(new MidiSequenceModel.RecordChannelCellEditor(midiSequenceModel));
            this.track_selection_model.setSelectionInterval(0, 0);
            this.tracks_label.setText(String.format("Tracks (in MIDI file No.%d)", n));
        } else {
            this.delete_sequence_button.setEnabled(false);
            this.track_table_view.setModel(new MidiSequenceModel(this.seq_list_model));
            this.tracks_label.setText("Tracks (No MIDI file selected)");
        }
        this.updateButtonStatus();
    }

    public void updateButtonStatus() {
        boolean bl = !this.track_selection_model.isSelectionEmpty() && this.seq_list_model.getSequenceModel(this.seq_selection_model) != null && this.seq_list_model.getSequenceModel(this.seq_selection_model).getRowCount() > 0;
        this.remove_track_button.setEnabled(bl);
        TableModel tableModel = this.event_table_view.getModel();
        if (!(tableModel instanceof MidiTrackModel)) {
            return;
        }
        MidiTrackModel midiTrackModel = (MidiTrackModel)tableModel;
        this.jump_sequence_button.setEnabled(midiTrackModel != null && midiTrackModel.getRowCount() > 0);
        boolean bl2 = !this.event_selection_model.isSelectionEmpty() && midiTrackModel != null && midiTrackModel.getRowCount() != 0 && bl;
        this.copy_event_button.setEnabled(bl2);
        this.remove_event_button.setEnabled(bl2);
        this.cut_event_button.setEnabled(bl2);
        this.jump_event_button.setEnabled(midiTrackModel != null && bl);
        this.add_event_button.setEnabled(midiTrackModel != null && bl);
        this.paste_event_button.setEnabled(midiTrackModel != null && bl && this.copied_events != null && this.copied_events.length > 0);
    }

    public String getMIDIdataBase64() {
        this.base64_dialog.setMIDIData(this.device_manager.time_range_model.getSequenceModel().getMIDIdata());
        return this.base64_dialog.getBase64Data();
    }

    public int addSequence() {
        return this.addSequence(this.new_seq_dialog.getMidiSequence());
    }

    public int addSequence(Sequence sequence) {
        int n = this.seq_list_model.addSequence(sequence);
        this.total_time_label.setText(this.seq_list_model.getTotalLength());
        if (!this.device_manager.getSequencer().isRunning()) {
            this.loadAndPlay(n);
        }
        return n;
    }

    public int addSequenceFromBase64Text(String string, String string2) {
        this.base64_dialog.setBase64Data(string);
        return this.addSequenceFromMidiData(this.base64_dialog.getMIDIData(), string2);
    }

    public int addSequenceFromBase64Text() {
        return this.addSequenceFromMidiData(this.base64_dialog.getMIDIData(), null);
    }

    public int addSequenceFromMidiData(byte[] byArray, String string) {
        int n;
        try {
            n = this.seq_list_model.addSequence(byArray, string);
        }
        catch (InvalidMidiDataException invalidMidiDataException) {
            this.showWarning("MIDI data invalid");
            return -1;
        }
        this.total_time_label.setText(this.seq_list_model.getTotalLength());
        return n;
    }

    public int addSequenceFromMidiFile(File file) {
        int n;
        try {
            n = this.seq_list_model.addSequence(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.showWarning(file.getName() + " : not found");
            return -1;
        }
        catch (InvalidMidiDataException invalidMidiDataException) {
            this.showWarning(file.getName() + " : MIDI data invalid");
            return -1;
        }
        catch (AccessControlException accessControlException) {
            this.showError(file.getName() + ": Cannot access");
            accessControlException.printStackTrace();
            return -1;
        }
        this.total_time_label.setText(this.seq_list_model.getTotalLength());
        return n;
    }

    public int addSequenceFromURL(String string) {
        int n;
        try {
            n = this.seq_list_model.addSequence(string);
        }
        catch (InvalidMidiDataException invalidMidiDataException) {
            this.showWarning(string + " : MIDI data invalid");
            return -1;
        }
        catch (AccessControlException accessControlException) {
            this.showError(string + ": Cannot access");
            accessControlException.printStackTrace();
            return -1;
        }
        this.total_time_label.setText(this.seq_list_model.getTotalLength());
        return n;
    }

    public void load(int n) {
        this.seq_list_model.loadToSequencer(n);
        this.sequenceSelectionChanged();
    }

    public boolean loadNext(int n) {
        boolean bl = this.seq_list_model.loadNext(n);
        this.sequenceSelectionChanged();
        return bl;
    }

    public void loadAndPlay(int n) {
        this.load(n);
        this.device_manager.time_range_model.start();
    }

    public void loadAndPlay() {
        this.loadAndPlay(this.seq_selection_model.getMinSelectionIndex());
    }

    public void loadAndPlay(List list) {
        this.loadAndPlay(list.toArray());
    }

    public void loadAndPlay(Object[] objectArray) {
        int n = -1;
        int n2 = -1;
        for (Object object : objectArray) {
            File file = null;
            if (object instanceof File) {
                file = (File)object;
            } else {
                if (!(object instanceof String)) continue;
                file = new File((String)object);
            }
            n = this.addSequenceFromMidiFile(file);
            if (n2 != -1) continue;
            n2 = n;
        }
        if (this.device_manager.getSequencer().isRunning()) {
            this.setVisible(true);
        } else if (n2 >= 0) {
            this.loadAndPlay(n2);
        }
    }

    public boolean isModified() {
        return this.seq_list_model.isModified();
    }

    public boolean isRecordable() {
        MidiSequenceModel midiSequenceModel = this.seq_list_model.getSequenceModel(this.seq_selection_model);
        return midiSequenceModel == null ? false : midiSequenceModel.isRecordable();
    }

    public void scrollToEventAt(long l) {
        MidiTrackModel midiTrackModel = (MidiTrackModel)this.event_table_view.getModel();
        this.scrollToEventAt(midiTrackModel.tickToIndex(l));
    }

    public void scrollToEventAt(int n) {
        this.scrollable_event_table_view.getVerticalScrollBar().setValue(n * this.event_table_view.getRowHeight());
        this.event_selection_model.setSelectionInterval(n, n);
    }

    class MidiEventCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        MidiEvent[] midi_events_to_be_removed;
        MidiTrackModel midi_track_model;
        MidiSequenceModel seq_model;
        MidiEvent sel_midi_evt = null;
        int sel_index = -1;
        long current_tick = 0L;
        TickPositionModel tick_position_model = new TickPositionModel();
        JToggleButton.ToggleButtonModel pair_note_on_off_model = new JToggleButton.ToggleButtonModel();
        JButton edit_event_button = new JButton();
        Action cancel_action = new AbstractAction(){
            {
                this.putValue("Name", "Cancel");
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MidiEventCellEditor.this.fireEditingCanceled();
                MidiEditor.this.event_dialog.setVisible(false);
            }
        };
        Action query_jump_event_action = new AbstractAction(){
            {
                this.putValue("Name", "Jump to ...");
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MidiEventCellEditor.this.setSelectedEvent();
                MidiEditor.this.event_dialog.setTitle("Jump selection to");
                MidiEditor.this.event_dialog.ok_button.setAction(MidiEventCellEditor.this.jump_event_action);
                MidiEditor.this.event_dialog.openTickForm();
            }
        };
        Action jump_event_action = new AbstractAction(){
            {
                this.putValue("Name", "Jump");
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MidiEditor.this.scrollToEventAt(MidiEventCellEditor.this.tick_position_model.getTickPosition());
                MidiEditor.this.event_dialog.setVisible(false);
            }
        };
        Action query_paste_event_action = new AbstractAction(){
            {
                this.putValue("Name", "Paste to ...");
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MidiEventCellEditor.this.setSelectedEvent();
                MidiEditor.this.event_dialog.setTitle("Paste to");
                MidiEditor.this.event_dialog.ok_button.setAction(MidiEventCellEditor.this.paste_event_action);
                MidiEditor.this.event_dialog.openTickForm();
            }
        };
        Action paste_event_action = new AbstractAction(){
            {
                this.putValue("Name", "Paste");
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                long l = MidiEventCellEditor.this.tick_position_model.getTickPosition();
                ((MidiTrackModel)MidiEditor.this.event_table_view.getModel()).addMidiEvents(MidiEditor.this.copied_events, l, MidiEditor.this.copied_events_PPQ);
                MidiEditor.this.scrollToEventAt(l);
                MidiEditor.this.seq_list_model.fireSequenceChanged(MidiEditor.this.seq_selection_model);
                MidiEditor.this.event_dialog.setVisible(false);
            }
        };
        Action query_add_event_action = new AbstractAction(){
            {
                this.putValue("Name", "New");
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MidiEventCellEditor.this.setSelectedEvent();
                MidiEventCellEditor.this.midi_events_to_be_removed = null;
                MidiEditor.this.event_dialog.setTitle("Add a new MIDI event");
                MidiEditor.this.event_dialog.ok_button.setAction(MidiEventCellEditor.this.add_event_action);
                int n = MidiEventCellEditor.this.midi_track_model.getChannel();
                if (n >= 0) {
                    MidiEditor.this.event_dialog.midi_message_form.channel_text.setSelectedChannel(n);
                }
                MidiEditor.this.event_dialog.openEventForm();
            }
        };
        Action add_event_action = new AbstractAction(){
            {
                this.putValue("Name", "OK");
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                long l = MidiEventCellEditor.this.tick_position_model.getTickPosition();
                MidiMessage midiMessage = MidiEditor.this.event_dialog.midi_message_form.getMessage();
                MidiEvent midiEvent = new MidiEvent(midiMessage, l);
                if (MidiEventCellEditor.this.midi_events_to_be_removed != null) {
                    MidiEventCellEditor.this.midi_track_model.removeMidiEvents(MidiEventCellEditor.this.midi_events_to_be_removed);
                }
                if (!MidiEventCellEditor.this.midi_track_model.addMidiEvent(midiEvent)) {
                    System.out.println("addMidiEvent failure");
                    return;
                }
                if (MidiEventCellEditor.this.pair_note_on_off_model.isSelected() && MidiEditor.this.event_dialog.midi_message_form.isNote()) {
                    ShortMessage shortMessage = MidiEditor.this.event_dialog.midi_message_form.getPartnerMessage();
                    if (shortMessage == null) {
                        MidiEditor.this.scrollToEventAt(l);
                    } else {
                        MidiEvent midiEvent2;
                        long l2;
                        int n = MidiEditor.this.event_dialog.midi_message_form.duration_form.getDuration();
                        if (MidiEditor.this.event_dialog.midi_message_form.isNote(false)) {
                            n = -n;
                        }
                        if ((l2 = l + (long)n) < 0L) {
                            l2 = 0L;
                        }
                        if (!MidiEventCellEditor.this.midi_track_model.addMidiEvent(midiEvent2 = new MidiEvent(shortMessage, l2))) {
                            System.out.println("addMidiEvent failure (note on/off partner message)");
                        }
                        MidiEditor.this.scrollToEventAt(l2 > l ? l2 : l);
                    }
                }
                MidiEditor.this.seq_list_model.fireSequenceChanged(MidiEventCellEditor.this.seq_model);
                MidiEditor.this.event_dialog.setVisible(false);
                MidiEventCellEditor.this.fireEditingStopped();
            }
        };

        private void setSelectedEvent() {
            this.seq_model = MidiEditor.this.seq_list_model.getSequenceModel(MidiEditor.this.seq_selection_model);
            MidiEditor.this.event_dialog.midi_message_form.duration_form.setPPQ(this.seq_model.getSequence().getResolution());
            this.tick_position_model.setSequenceIndex(this.seq_model.getSequenceIndex());
            this.sel_index = -1;
            this.current_tick = 0L;
            this.sel_midi_evt = null;
            this.midi_track_model = (MidiTrackModel)MidiEditor.this.event_table_view.getModel();
            if (!MidiEditor.this.event_selection_model.isSelectionEmpty()) {
                this.sel_index = MidiEditor.this.event_selection_model.getMinSelectionIndex();
                this.sel_midi_evt = this.midi_track_model.getMidiEvent(this.sel_index);
                this.current_tick = this.sel_midi_evt.getTick();
                this.tick_position_model.setTickPosition(this.current_tick);
            }
        }

        public MidiEventCellEditor() {
            this.edit_event_button.setHorizontalAlignment(2);
            MidiEditor.this.event_dialog.cancel_button.setAction(this.cancel_action);
            MidiEditor.this.event_dialog.midi_message_form.setOutputMidiChannels(MidiEditor.this.midi_device.getChannels());
            MidiEditor.this.event_dialog.tick_position_form.setModel(this.tick_position_model);
            this.edit_event_button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    MidiEventCellEditor.this.setSelectedEvent();
                    if (MidiEventCellEditor.this.sel_midi_evt == null) {
                        return;
                    }
                    MidiEvent midiEvent = null;
                    MidiEditor.this.event_dialog.midi_message_form.setMessage(MidiEventCellEditor.this.sel_midi_evt.getMessage());
                    if (MidiEditor.this.event_dialog.midi_message_form.isNote()) {
                        int n = MidiEventCellEditor.this.midi_track_model.getIndexOfPartnerFor(MidiEventCellEditor.this.sel_index);
                        if (n < 0) {
                            MidiEditor.this.event_dialog.midi_message_form.duration_form.setDuration(0);
                        } else {
                            midiEvent = MidiEventCellEditor.this.midi_track_model.getMidiEvent(n);
                            long l = midiEvent.getTick();
                            long l2 = MidiEventCellEditor.this.current_tick > l ? MidiEventCellEditor.this.current_tick - l : l - MidiEventCellEditor.this.current_tick;
                            MidiEditor.this.event_dialog.midi_message_form.duration_form.setDuration((int)l2);
                        }
                    }
                    MidiEvent[] midiEventArray = midiEvent == null ? new MidiEvent[]{MidiEventCellEditor.this.sel_midi_evt} : new MidiEvent[]{MidiEventCellEditor.this.sel_midi_evt, midiEvent};
                    MidiEventCellEditor.this.midi_events_to_be_removed = midiEventArray;
                    MidiEditor.this.event_dialog.setTitle("Change MIDI event");
                    MidiEditor.this.event_dialog.ok_button.setAction(MidiEventCellEditor.this.add_event_action);
                    MidiEditor.this.event_dialog.openEventForm();
                }
            });
            this.pair_note_on_off_model.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    MidiEditor.this.event_dialog.midi_message_form.duration_form.setEnabled(MidiEventCellEditor.this.pair_note_on_off_model.isSelected());
                }
            });
            this.pair_note_on_off_model.setSelected(true);
        }

        @Override
        public boolean isCellEditable(EventObject eventObject) {
            return eventObject instanceof MouseEvent && ((MouseEvent)eventObject).getClickCount() == 2;
        }

        @Override
        public Object getCellEditorValue() {
            return "";
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            this.edit_event_button.setText((String)object);
            return this.edit_event_button;
        }
    }
}

