/*
 * Decompiled with CFR 0.152.
 */
import javax.swing.JComboBox;

class MidiProgramSelecter
extends JComboBox {
    private int family;
    private MidiProgramFamilySelecter family_selecter = null;

    public MidiProgramSelecter() {
        this.setFamily(-1);
    }

    public void setFamilySelecter(MidiProgramFamilySelecter midiProgramFamilySelecter) {
        this.family_selecter = midiProgramFamilySelecter;
    }

    public void setFamily(int n) {
        int n2 = this.getProgram();
        this.family = n;
        this.removeAllItems();
        if (n < 0) {
            this.setMaximumRowCount(16);
            for (int i = 0; i < MIDISpec.instrument_names.length; ++i) {
                this.addItem(i + ": " + MIDISpec.instrument_names[i]);
            }
            this.setSelectedIndex(n2);
        } else {
            this.setMaximumRowCount(8);
            for (int i = 0; i < 8; ++i) {
                n2 = i + n * 8;
                this.addItem(n2 + ": " + MIDISpec.instrument_names[n2]);
            }
            this.setSelectedIndex(0);
        }
    }

    public int getProgram() {
        int n = this.getSelectedIndex();
        if (this.family > 0 && n >= 0) {
            n += this.family * 8;
        }
        return n;
    }

    public String getProgramName() {
        return (String)this.getSelectedItem();
    }

    public void setProgram(int n) {
        if (this.getItemCount() == 0) {
            return;
        }
        if (this.family >= 0 && n >= 0 && this.family == n / 8) {
            this.setSelectedIndex(n % 8);
        } else {
            if (this.family >= 0) {
                this.setFamily(-1);
            }
            if (this.family_selecter != null) {
                this.family_selecter.setSelectedIndex(0);
            }
            if (n < this.getItemCount()) {
                this.setSelectedIndex(n);
            }
        }
    }
}

