/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.sound.midi.MidiChannel;
import javax.sound.midi.Sequence;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

class NewSequenceDialog
extends JDialog
implements ActionListener {
    Insets zero_insets = new Insets(0, 0, 0, 0);
    JTextArea chord_text;
    JTextField seq_name_text;
    PPQSelectionComboBox ppq_combo_box;
    TimeSignatureSelecter timesig_selecter;
    TempoSelecter tempo_selecter;
    MeasureSelecter measure_selecter;
    JButton add_new_button;
    JButton transpose_up_button;
    JButton transpose_down_button;
    JButton enharmonic_button;
    JButton random_chord_button;
    JButton toggle_major_minor_button;
    JPanel new_file_panel;
    TrackSpecPanel track_spec_panel;
    JTabbedPane tabbed_pane;
    MidiEditor midi_editor;

    public NewSequenceDialog(MidiEditor midiEditor) {
        this.midi_editor = midiEditor;
        this.setTitle("Generate new sequence - MIDI Chord Helper");
        this.tabbed_pane = new JTabbedPane();
        this.ppq_combo_box = new PPQSelectionComboBox();
        this.seq_name_text = new JTextField();
        this.timesig_selecter = new TimeSignatureSelecter();
        this.tempo_selecter = new TempoSelecter();
        this.measure_selecter = new MeasureSelecter();
        String string = "Key: C\nC G/B | Am Em/G | F C/E | Dm7 G7 C % | F G7 | Csus4 C\n";
        this.chord_text = new JTextArea(string, 18, 30);
        JScrollPane jScrollPane = new JScrollPane(this.chord_text);
        this.add_new_button = new JButton("Generate & Add to PlayList", new ButtonIcon(4));
        this.add_new_button.setMargin(this.zero_insets);
        this.add_new_button.addActionListener(this);
        this.transpose_up_button = new JButton(" + Up ");
        this.transpose_up_button.setMargin(this.zero_insets);
        this.transpose_up_button.addActionListener(this);
        this.transpose_down_button = new JButton(" - Down ");
        this.transpose_down_button.setMargin(this.zero_insets);
        this.transpose_down_button.addActionListener(this);
        this.enharmonic_button = new JButton(" Enharmonic ");
        this.enharmonic_button.setMargin(this.zero_insets);
        this.enharmonic_button.addActionListener(this);
        this.random_chord_button = new JButton("Randomize (Tempo, Time signature, Chord progression)");
        this.random_chord_button.setMargin(this.zero_insets);
        this.random_chord_button.addActionListener(this);
        this.toggle_major_minor_button = new JButton("Relative key");
        this.toggle_major_minor_button.setMargin(this.zero_insets);
        this.toggle_major_minor_button.addActionListener(this);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 2));
        jPanel.add(new JLabel("Sequence name:"));
        jPanel.add(this.seq_name_text);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 2));
        jPanel2.add(new JLabel("Resolution in PPQ ="));
        jPanel2.add(this.ppq_combo_box);
        jPanel2.add(this.measure_selecter);
        JPanel jPanel3 = new JPanel();
        jPanel3.add(new JLabel("Time signature ="));
        jPanel3.add(this.timesig_selecter);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BoxLayout(jPanel4, 2));
        jPanel4.add(this.tempo_selecter);
        jPanel4.add(jPanel3);
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new BoxLayout(jPanel5, 2));
        jPanel5.add(new JLabel("Chord progression :"));
        jPanel5.add(new JLabel("Transpose"));
        jPanel5.add(this.transpose_up_button);
        jPanel5.add(this.transpose_down_button);
        jPanel5.add(this.enharmonic_button);
        jPanel5.add(this.toggle_major_minor_button);
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new BoxLayout(jPanel6, 2));
        jPanel6.add(this.add_new_button);
        this.new_file_panel = new JPanel();
        this.new_file_panel.setLayout(new BoxLayout(this.new_file_panel, 3));
        this.new_file_panel.add(jPanel);
        this.new_file_panel.add(jPanel2);
        this.new_file_panel.add(this.random_chord_button);
        this.new_file_panel.add(jPanel4);
        this.new_file_panel.add(jPanel5);
        this.new_file_panel.add(jScrollPane);
        this.new_file_panel.add(jPanel6);
        this.track_spec_panel = new TrackSpecPanel();
        this.tabbed_pane.add("Sequence", this.new_file_panel);
        this.tabbed_pane.add("Track", this.track_spec_panel);
        this.add(this.tabbed_pane);
        this.setBounds(250, 200, 600, 540);
        Music.DrumTrackSpec drumTrackSpec = new Music.DrumTrackSpec(9, "Percussion track");
        drumTrackSpec.velocity = 127;
        this.track_spec_panel.addTrackSpec(drumTrackSpec);
        Music.MelodyTrackSpec melodyTrackSpec = new Music.MelodyTrackSpec(0, "Bass track", new Music.Range(36, 48));
        melodyTrackSpec.is_bass = true;
        melodyTrackSpec.velocity = 96;
        this.track_spec_panel.addTrackSpec(melodyTrackSpec);
        melodyTrackSpec = new Music.MelodyTrackSpec(1, "Chord track", new Music.Range(60, 72));
        this.track_spec_panel.addTrackSpec(melodyTrackSpec);
        melodyTrackSpec = new Music.MelodyTrackSpec(2, "Melody track", new Music.Range(60, 84));
        melodyTrackSpec.random_melody = true;
        melodyTrackSpec.beat_pattern = 65535;
        melodyTrackSpec.continuous_beat_pattern = 33290;
        this.track_spec_panel.addTrackSpec(melodyTrackSpec);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.add_new_button) {
            this.midi_editor.addSequence(this.getMidiSequence());
            this.setVisible(false);
        } else if (object == this.transpose_up_button) {
            this.transpose(1);
        } else if (object == this.transpose_down_button) {
            this.transpose(-1);
        } else if (object == this.enharmonic_button) {
            this.enharmonic();
        } else if (object == this.toggle_major_minor_button) {
            this.toggleKeyMajorMinor();
        } else if (object == this.random_chord_button) {
            this.setRandomChordProgression(this.measure_selecter.getMeasureDuration());
        }
    }

    public void setChannels(MidiChannel[] midiChannelArray) {
        this.track_spec_panel.setChannels(midiChannelArray);
    }

    public Music.ChordProgression getChordProgression() {
        return new Music.ChordProgression(this.chord_text.getText());
    }

    public Sequence getMidiSequence() {
        Music.FirstTrackSpec firstTrackSpec = new Music.FirstTrackSpec(this.seq_name_text.getText(), this.tempo_selecter.getTempoByteArray(), this.timesig_selecter.getByteArray());
        return this.getChordProgression().toMidiSequence(this.ppq_combo_box.getPPQ(), this.measure_selecter.getStartMeasurePosition(), this.measure_selecter.getEndMeasurePosition(), firstTrackSpec, this.track_spec_panel.getTrackSpecs());
    }

    public void setChordProgression(Music.ChordProgression chordProgression) {
        this.chord_text.setText(chordProgression.toString());
    }

    public void setRandomChordProgression(int n) {
        this.tempo_selecter.setTempo(80 + (int)(Math.random() * 100.0));
        int n2 = 4;
        int n3 = 2;
        switch ((int)(Math.random() * 10.0)) {
            case 0: {
                n2 = 3;
            }
        }
        this.timesig_selecter.setValue((byte)n2, (byte)n3);
        this.setChordProgression(new Music.ChordProgression(n, n2));
    }

    public void transpose(int n) {
        Music.ChordProgression chordProgression = this.getChordProgression();
        chordProgression.transpose(n);
        this.setChordProgression(chordProgression);
    }

    public void enharmonic() {
        Music.ChordProgression chordProgression = this.getChordProgression();
        chordProgression.toggleEnharmonically();
        this.setChordProgression(chordProgression);
    }

    public void toggleKeyMajorMinor() {
        Music.ChordProgression chordProgression = this.getChordProgression();
        chordProgression.toggleKeyMajorMinor();
        this.setChordProgression(chordProgression);
    }
}

