/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.AbstractSequentialList;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class ChordDiagramDisplay
extends JComponent
implements MouseListener,
MouseMotionListener {
    public static final int VISIBLE_FRETS = 4;
    public static final int MAX_FRETS = 16;
    public static final int MAX_STRINGS = 6;
    public static final int LEFT_MARGIN_WIDTH = 10;
    public static final int RIGHT_MARGIN_WIDTH = 10;
    public static final int UPPER_MARGIN_WIDTH = 5;
    public static final int LOWER_MARGIN_WIDTH = 5;
    int string_distance;
    int fret_distance;
    int point_size;
    int char_width;
    int char_height;
    DefaultBoundedRangeModel fret_range_model = new DefaultBoundedRangeModel(0, 4, 0, 16);
    int[] notes_when_open;
    int[] default_notes_when_open;
    Rectangle grid_rect;
    TuningButton[] tuning_buttons;
    ChordVariations chord_variations = new ChordVariations();

    public ChordDiagramDisplay(int[] nArray) {
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                ChordDiagramDisplay.this.tune();
            }
        });
        this.chord_variations.model.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                ChordDiagramDisplay.this.repaint();
            }
        });
        this.fret_range_model.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                ChordDiagramDisplay.this.setChord();
            }
        });
        this.setMinimumSize(new Dimension(100, 70));
        this.tune(nArray);
    }

    @Override
    public void paint(Graphics graphics) {
        PressingPoints[] pressingPointsArray;
        int n;
        int n2;
        Graphics2D graphics2D = (Graphics2D)graphics;
        Dimension dimension = this.getSize();
        Color color = Color.gray;
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        graphics2D.setBackground(this.getBackground());
        graphics2D.clearRect(0, 0, dimension.width, dimension.height);
        for (n2 = 1; n2 <= 4; ++n2) {
            graphics2D.setColor(color);
            n = this.grid_rect.x + (this.grid_rect.width - 2) * n2 / 4;
            graphics2D.drawLine(n, this.grid_rect.y, n, this.grid_rect.y + this.string_distance * (this.notes_when_open.length - 1));
            graphics2D.setColor(this.getForeground());
            String string = String.valueOf(n2 + this.fret_range_model.getValue());
            graphics2D.drawString(string, this.grid_rect.x + this.fret_distance / 2 - fontMetrics.stringWidth(string) / 2 + this.grid_rect.width * (n2 - 1) / 4, this.grid_rect.y + this.string_distance / 2 + fontMetrics.getHeight() + this.string_distance * (this.notes_when_open.length - 1) - 1);
        }
        for (n2 = 0; n2 < this.notes_when_open.length; ++n2) {
            n = this.grid_rect.y + this.grid_rect.height * n2 / 5;
            graphics2D.setColor(color);
            graphics2D.drawLine(this.grid_rect.x, n, this.grid_rect.x + (this.grid_rect.width - 2), n);
            if (this.notes_when_open[n2] != this.default_notes_when_open[n2]) {
                graphics2D.setColor(Color.yellow);
                graphics2D.fill(this.tuning_buttons[n2]);
            }
            graphics2D.setColor(this.getForeground());
            graphics2D.drawString(Music.noteNoToSymbol(this.notes_when_open[n2], 2), 10, n + (fontMetrics.getHeight() - fontMetrics.getDescent()) / 2);
            graphics2D.setColor(color);
            if (!this.tuning_buttons[n2].is_entered) continue;
            graphics2D.draw(this.tuning_buttons[n2]);
        }
        if (this.fret_range_model.getValue() == 0) {
            graphics2D.setColor(this.getForeground());
            graphics2D.fillRect(this.grid_rect.x - 1, this.grid_rect.y, 3, this.string_distance * (this.notes_when_open.length - 1) + 1);
        } else {
            graphics2D.setColor(color);
            graphics2D.drawLine(this.grid_rect.x, this.grid_rect.y, this.grid_rect.x, this.grid_rect.y + this.string_distance * (this.notes_when_open.length - 1));
        }
        if (this.chord_variations.chord == null) {
            return;
        }
        PressingPoint[] pressingPointArray = this.chord_variations.getCurrent();
        if (pressingPointArray != null) {
            for (PressingPoint pressingPoint : pressingPointArray) {
                this.drawIndicator(graphics2D, pressingPoint, false);
            }
        }
        if ((pressingPointsArray = this.chord_variations.getPossiblePoints()) != null) {
            for (PressingPoints pressingPoints : pressingPointsArray) {
                for (PressingPoint pressingPoint : pressingPoints) {
                    if (pressingPoint.is_entered) {
                        this.drawIndicator(graphics2D, pressingPoint, false);
                        if (pressingPointArray == null) continue;
                        return;
                    }
                    if (pressingPointArray != null) continue;
                    this.drawIndicator(graphics2D, pressingPoint, true);
                }
            }
        }
    }

    private void drawIndicator(Graphics2D graphics2D, PressingPoint pressingPoint, boolean bl) {
        int n = pressingPoint.index_of_chord_note;
        graphics2D.setColor(n < 0 ? this.getForeground() : Music.Chord.index_colors[n]);
        Rectangle rectangle = pressingPoint.rect;
        if (rectangle == null) {
            return;
        }
        int n2 = pressingPoint.fret_position;
        if (n2 < 0) {
            if (!bl) {
                graphics2D.drawLine(rectangle.x + 1, rectangle.y + 1, rectangle.x + rectangle.width - 1, rectangle.y + rectangle.height - 1);
                graphics2D.drawLine(rectangle.x + 1, rectangle.y + rectangle.height - 1, rectangle.x + rectangle.width - 1, rectangle.y + 1);
            }
        } else if (n2 == 0) {
            graphics2D.drawOval(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        } else {
            int n3 = rectangle.x - this.fret_range_model.getValue() * this.fret_distance;
            if (bl) {
                graphics2D.drawOval(n3, rectangle.y, rectangle.width, rectangle.height);
            } else {
                graphics2D.fillOval(n3, rectangle.y, rectangle.width, rectangle.height);
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        PressingPoints[] pressingPointsArray = this.chord_variations.getPossiblePoints();
        if (pressingPointsArray != null) {
            for (Cloneable cloneable : pressingPointsArray) {
                Iterator iterator = ((AbstractSequentialList)((Object)cloneable)).iterator();
                while (iterator.hasNext()) {
                    boolean bl;
                    int n;
                    PressingPoint pressingPoint = (PressingPoint)iterator.next();
                    if (pressingPoint.fret_position > 0) {
                        n = -this.fret_range_model.getValue() * this.fret_distance;
                        pressingPoint.rect.translate(n, 0);
                        bl = pressingPoint.rect.contains(point);
                        pressingPoint.rect.translate(-n, 0);
                    } else {
                        bl = pressingPoint.rect.contains(point);
                    }
                    if (!bl) continue;
                    n = 0;
                    for (PressingPoint[] pressingPointArray : this.chord_variations) {
                        if (pressingPointArray[pressingPoint.i_string].fret_position == pressingPoint.fret_position) {
                            this.chord_variations.setCurrent(n);
                            return;
                        }
                        ++n;
                    }
                }
            }
        }
        for (Cloneable cloneable : this.tuning_buttons) {
            if (!((Rectangle)cloneable).contains(point)) continue;
            int n = ((TuningButton)cloneable).i_string;
            this.notes_when_open[n] = this.notes_when_open[n] + (mouseEvent.getButton() == 3 ? 11 : 1);
            this.notes_when_open[((TuningButton)cloneable).i_string] = Music.mod12(this.notes_when_open[((TuningButton)cloneable).i_string]);
            this.setChord();
            return;
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        this.mouseMoved(mouseEvent);
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        this.mouseMoved(mouseEvent);
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        boolean bl;
        Point point = mouseEvent.getPoint();
        boolean bl2 = false;
        for (TuningButton tuningButton : this.tuning_buttons) {
            bl = tuningButton.contains(point);
            if (tuningButton.is_entered != bl) {
                bl2 = true;
            }
            tuningButton.is_entered = bl;
        }
        Cloneable[] cloneableArray = this.chord_variations.getPossiblePoints();
        if (cloneableArray != null) {
            for (Cloneable cloneable : cloneableArray) {
                Iterator iterator = ((AbstractSequentialList)((Object)cloneable)).iterator();
                while (iterator.hasNext()) {
                    PressingPoint pressingPoint = (PressingPoint)iterator.next();
                    if (pressingPoint.fret_position > 0) {
                        int n = -this.fret_range_model.getValue() * this.fret_distance;
                        pressingPoint.rect.translate(n, 0);
                        bl = pressingPoint.rect.contains(point);
                        pressingPoint.rect.translate(-n, 0);
                    } else {
                        bl = pressingPoint.rect.contains(point);
                    }
                    if (pressingPoint.is_entered != bl) {
                        bl2 = true;
                    }
                    pressingPoint.is_entered = bl;
                }
            }
        }
        if (bl2) {
            this.repaint();
        }
    }

    public void tune(int[] nArray) {
        this.default_notes_when_open = nArray;
        this.notes_when_open = new int[nArray.length];
        System.arraycopy(nArray, 0, this.notes_when_open, 0, nArray.length);
        this.tune();
    }

    public void tune() {
        Dimension dimension = this.getSize();
        this.char_width = 8;
        this.char_height = 16;
        this.string_distance = (dimension.height + 1 - 5 - 5 - this.char_height) / 6;
        this.point_size = this.string_distance * 4 / 5;
        this.fret_distance = (dimension.width + 1 - (20 + this.char_width + this.point_size + 8)) / 4;
        this.grid_rect = new Rectangle(10 + this.point_size + this.char_width + 8, 5 + this.string_distance / 2, this.fret_distance * 4, this.string_distance * 5);
        this.tuning_buttons = new TuningButton[this.notes_when_open.length];
        for (int i = 0; i < this.tuning_buttons.length; ++i) {
            this.tuning_buttons[i] = new TuningButton(i);
        }
        this.setChord();
    }

    public Music.Chord getChord() {
        return this.chord_variations.chord;
    }

    public void setChord() {
        this.setChord(this.getChord());
    }

    public void setChord(Music.Chord chord) {
        this.chord_variations.setChord(chord);
        this.repaint();
    }

    class ChordVariations
    extends LinkedList<PressingPoint[]> {
        public Music.Chord chord = null;
        public DefaultBoundedRangeModel model = new DefaultBoundedRangeModel(0, 0, 0, 0);
        private PressingPoints[] possible_points = null;
        private PressingPoint[] new_variation = null;
        private boolean fifth_omittable = false;
        private boolean root_omittable = false;
        private int check_bits_all_on = 0;

        ChordVariations() {
        }

        public PressingPoints[] getPossiblePoints() {
            return this.possible_points;
        }

        public PressingPoint[] getCurrent() {
            if (this.size() <= 0) {
                return null;
            }
            int n = this.model.getValue();
            if (n < 0) {
                return null;
            }
            return (PressingPoint[])this.get(n);
        }

        public void setCurrent(int n) {
            this.model.setValue(n);
        }

        public void setChord(Music.Chord chord) {
            this.clear();
            this.chord = chord;
            if (this.chord == null) {
                this.possible_points = null;
                this.model.setRangeProperties(0, 0, 0, 0, false);
                return;
            }
            int n = chord.numberOfNotes();
            this.root_omittable = n == 5;
            this.fifth_omittable = chord.symbolSuffix().equals("7") || this.root_omittable;
            this.check_bits_all_on = (1 << n) - 1;
            this.possible_points = new PressingPoints[ChordDiagramDisplay.this.notes_when_open.length];
            for (int i = 0; i < this.possible_points.length; ++i) {
                this.possible_points[i] = new PressingPoints();
                for (int j = 0; j <= ChordDiagramDisplay.this.fret_range_model.getValue() + ChordDiagramDisplay.this.fret_range_model.getExtent(); ++j) {
                    int n2;
                    if (j != 0 && j <= ChordDiagramDisplay.this.fret_range_model.getValue() || (n2 = chord.indexOf(ChordDiagramDisplay.this.notes_when_open[i] + j)) < 0) continue;
                    this.possible_points[i].add(new PressingPoint(j, n2, i));
                }
                this.possible_points[i].add(new PressingPoint(i));
            }
            this.new_variation = new PressingPoint[ChordDiagramDisplay.this.notes_when_open.length];
            this.scanFret(0);
            this.model.setRangeProperties(-1, 1, -1, this.size(), false);
        }

        private void scanFret(int n) {
            Iterator iterator = this.possible_points[n].iterator();
            while (iterator.hasNext()) {
                PressingPoint pressingPoint;
                this.new_variation[n] = pressingPoint = (PressingPoint)iterator.next();
                if (n < this.new_variation.length - 1) {
                    this.scanFret(n + 1);
                    continue;
                }
                if (!this.hasValidNewVariation()) continue;
                this.add(this.new_variation.clone());
            }
        }

        private boolean hasValidNewVariation() {
            int n = 0;
            for (PressingPoint pressingPoint : this.new_variation) {
                int n2 = pressingPoint.index_of_chord_note;
                if (n2 < 0) continue;
                n |= 1 << n2;
            }
            return n == this.check_bits_all_on || n == this.check_bits_all_on - 4 && this.fifth_omittable || (n & this.check_bits_all_on - 1 - 4) == this.check_bits_all_on - 1 - 4 && (n & 5) != 0 && this.root_omittable;
        }
    }

    class PressingPoints
    extends LinkedList<PressingPoint> {
        PressingPoints() {
        }
    }

    class PressingPoint {
        int i_string;
        int fret_position;
        int index_of_chord_note;
        Rectangle rect = null;
        boolean is_entered = false;

        public PressingPoint(int n) {
            this(-1, -1, n);
        }

        public PressingPoint(int n, int n2) {
            this.fret_position = n;
            this.index_of_chord_note = n2;
        }

        public PressingPoint(int n, int n2, int n3) {
            this(n, n2);
            this.rect = new Rectangle(chordDiagramDisplay.grid_rect.x + (n < 1 ? -(chordDiagramDisplay.point_size + 3) : n * chordDiagramDisplay.fret_distance - chordDiagramDisplay.point_size / 2 - chordDiagramDisplay.fret_distance / 2), chordDiagramDisplay.grid_rect.y - chordDiagramDisplay.point_size / 2 + n3 * chordDiagramDisplay.string_distance, chordDiagramDisplay.point_size, chordDiagramDisplay.point_size);
            this.i_string = n3;
        }
    }

    class TuningButton
    extends Rectangle {
        boolean is_entered;
        int i_string;

        public TuningButton(int n) {
            super(10, 5 + n * ChordDiagramDisplay.this.string_distance, ChordDiagramDisplay.this.char_width, ChordDiagramDisplay.this.string_distance);
            this.is_entered = false;
            this.i_string = n;
        }
    }
}

