/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.dnd.DropTarget;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Vector;
import javax.sound.midi.MetaEventListener;
import javax.sound.midi.MetaMessage;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JSplitPane;
import javax.swing.JToggleButton;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class ChordHelperApplet
extends JApplet
implements MetaEventListener {
    public ImageIcon image_icon = new ImageIcon(this.getClass().getResource("images/midichordhelper.png"));
    Insets zero_insets = new Insets(0, 0, 0, 0);
    JPanel keyboard_sequencer_panel;
    JPanel chord_guide;
    JPanel sequencer_panel;
    JPanel sequencer_upper_panel;
    JPanel sequencer_lower_panel;
    JPanel midi_io_panel;
    Color root_pane_default_bgcolor;
    Color lyric_display_default_bgcolor;
    Border lyric_display_default_border;
    Border dark_mode_toggle_border;
    AboutMessagePane about_message_pane = new AboutMessagePane();
    JSplitPane main_split_pane;
    JSplitPane keyboard_split_pane;
    ChordTextField lyric_display;
    MidiKeyboardPanel keyboard_panel;
    ChordMatrix chord_matrix;
    ChordButtonLabel enter_button_label;
    InversionAndOmissionLabel inversion_omission_button;
    JToggleButton dark_mode_toggle_button;
    MidiDeviceManager device_manager;
    MidiDeviceDialog midi_connection_dialog;
    MidiEditor editor_dialog;
    ChordDiagram chord_diagram;
    TempoSelecter tempo_selecter = new TempoSelecter();
    TimeSignatureSelecter timesig_selecter = new TimeSignatureSelecter();
    KeySignatureLabel keysig_label = new KeySignatureLabel();
    JLabel song_title_label = new JLabel();
    AnoGakkiLayeredPane ano_gakki_layered_pane;
    JToggleButton ano_gakki_toggle_button;
    int[] chord_on_notes = null;

    public boolean isModified() {
        return this.editor_dialog.isModified();
    }

    public int addRandomSongToPlaylist(int n) {
        this.editor_dialog.new_seq_dialog.setRandomChordProgression(n);
        return this.editor_dialog.addSequence();
    }

    public int addToPlaylist(String string) {
        return this.editor_dialog.addSequenceFromURL(string);
    }

    public int addToPlaylistBase64(String string) {
        return this.addToPlaylistBase64(string, null);
    }

    public int addToPlaylistBase64(String string, String string2) {
        return this.editor_dialog.addSequenceFromBase64Text(string, string2);
    }

    public void play() {
        this.editor_dialog.loadAndPlay();
    }

    public void play(int n) {
        this.editor_dialog.loadAndPlay(n);
    }

    public boolean isRunning() {
        return this.device_manager.getSequencer().isRunning();
    }

    public boolean isPlaying() {
        return this.isRunning();
    }

    public String getMidiDataBase64() {
        return this.editor_dialog.getMIDIdataBase64();
    }

    public String getMidiFilename() {
        MidiSequenceModel midiSequenceModel = this.device_manager.time_range_model.getSequenceModel();
        if (midiSequenceModel == null) {
            return null;
        }
        String string = midiSequenceModel.getFilename();
        return string == null ? "" : string;
    }

    public void setOctavePosition(int n) {
        this.keyboard_panel.keyboard_center_panel.keyboard.octave_range_model.setValue(n);
    }

    public void setChannel(int n) {
        this.keyboard_panel.keyboard_center_panel.keyboard.midi_ch_combobox_model.setSelectedChannel(n);
    }

    public int getChannel() {
        return this.keyboard_panel.keyboard_center_panel.keyboard.midi_ch_combobox_model.getSelectedChannel();
    }

    public void programChange(int n) {
        this.keyboard_panel.keyboard_center_panel.keyboard.getSelectedChannel().programChange(n);
    }

    public void setProgram(int n) {
        this.programChange(n);
    }

    public void setAutoInversion(boolean bl) {
        this.inversion_omission_button.setAutoInversion(bl);
    }

    public void setOmissionNoteIndex(int n) {
        this.inversion_omission_button.setOmissionNoteIndex(n);
    }

    public void setChordDiagramVisible(boolean bl) {
        this.keyboard_split_pane.resetToPreferredSizes();
        if (!bl) {
            this.keyboard_split_pane.setDividerLocation(1.0);
        }
    }

    public void setChordDiagramForGuitar() {
        this.chord_diagram.setGuitar(true);
    }

    public void setDarkMode(boolean bl) {
        this.dark_mode_toggle_button.setSelected(bl);
    }

    @Override
    public String getAppletInfo() {
        return VersionInfo.getInfo();
    }

    public boolean isConfirmedToExit() {
        return !this.isModified() || JOptionPane.showConfirmDialog(this, "MIDI file not saved, exit anyway ?\n\u4fdd\u5b58\u3055\u308c\u3066\u3044\u306a\u3044MIDI\u30d5\u30a1\u30a4\u30eb\u304c\u3042\u308a\u307e\u3059\u304c\u3001\u7d42\u4e86\u3057\u3066\u3088\u308d\u3057\u3044\u3067\u3059\u304b\uff1f", "MIDI Chord Helper", 0, 2) == 0;
    }

    @Override
    public void init() {
        this.root_pane_default_bgcolor = this.getContentPane().getBackground();
        JButton jButton = new JButton("Version info");
        jButton.setToolTipText("MIDI Chord Helper Ver.20091003.1");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ChordHelperApplet.this.about_message_pane.showMessage();
            }
        });
        this.chord_matrix = new ChordMatrix();
        this.chord_matrix.addChordMatrixListener(new ChordMatrixListener(){

            @Override
            public void keySignatureChanged() {
                Music.Key key = ChordHelperApplet.this.chord_matrix.getKeySignatureCapo();
                ChordHelperApplet.this.keyboard_panel.key_selecter.setKey(key);
                ChordHelperApplet.this.keyboard_panel.keyboard_center_panel.keyboard.setKeySignature(key);
            }

            @Override
            public void chordChanged() {
                ChordHelperApplet.this.chordOn();
            }
        });
        this.enter_button_label = new ChordButtonLabel("Enter", this.chord_matrix);
        this.enter_button_label.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if ((mouseEvent.getModifiersEx() & 0x1000) != 0) {
                    ChordHelperApplet.this.chord_matrix.setSelectedChord((Music.Chord)null);
                } else {
                    ChordHelperApplet.this.chord_matrix.setSelectedChord(ChordHelperApplet.this.lyric_display.getText());
                }
            }
        });
        this.chord_matrix.capo_selecter.checkbox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                ChordHelperApplet.this.chordOn();
                ChordHelperApplet.this.keyboard_panel.keyboard_center_panel.keyboard.chord_display.setNote(-1);
                ChordHelperApplet.this.chord_diagram.clear();
            }
        });
        this.chord_matrix.capo_selecter.value_selecter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ChordHelperApplet.this.chordOn();
                ChordHelperApplet.this.keyboard_panel.keyboard_center_panel.keyboard.chord_display.setNote(-1);
                ChordHelperApplet.this.chord_diagram.clear();
            }
        });
        this.keyboard_panel = new MidiKeyboardPanel(this.chord_matrix);
        this.keyboard_panel.keyboard_center_panel.keyboard.addPianoKeyboardListener(new PianoKeyboardAdapter(){

            @Override
            public void pianoKeyPressed(int n, InputEvent inputEvent) {
                ChordHelperApplet.this.chord_diagram.clear();
            }
        });
        this.keyboard_panel.key_selecter.keysig_combobox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Music.Key key = ChordHelperApplet.this.keyboard_panel.key_selecter.getKey();
                key.transpose(-ChordHelperApplet.this.chord_matrix.capo_selecter.getCapo());
                ChordHelperApplet.this.chord_matrix.setKeySignature(key);
            }
        });
        this.keyboard_panel.keyboard_center_panel.keyboard.setPreferredSize(new Dimension(571, 80));
        Vector<VirtualMidiDevice> vector = new Vector<VirtualMidiDevice>();
        vector.add(this.keyboard_panel.keyboard_center_panel.keyboard.midi_device);
        this.device_manager = new MidiDeviceManager(vector);
        this.editor_dialog = new MidiEditor(this.device_manager);
        this.editor_dialog.setIconImage(this.image_icon.getImage());
        JButton jButton2 = new JButton("Edit/Playlist/Speed", new ButtonIcon(14));
        jButton2.setMargin(this.zero_insets);
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ChordHelperApplet.this.editor_dialog.setVisible(true);
            }
        });
        DropTarget dropTarget = new DropTarget(this, 3, this.editor_dialog, true);
        this.device_manager.setMidiEditor(this.editor_dialog);
        this.keyboard_panel.event_dialog = this.editor_dialog.event_dialog;
        this.midi_connection_dialog = new MidiDeviceDialog(this.device_manager);
        this.midi_connection_dialog.setIconImage(this.image_icon.getImage());
        JButton jButton3 = new JButton("MIDI device connection", new ButtonIcon(12));
        jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ChordHelperApplet.this.midi_connection_dialog.setVisible(true);
            }
        });
        this.lyric_display = new ChordTextField();
        this.lyric_display.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ChordHelperApplet.this.chord_matrix.setSelectedChord(actionEvent.getActionCommand().trim().split("[ \t\r\n]")[0]);
            }
        });
        this.lyric_display_default_border = this.lyric_display.getBorder();
        this.lyric_display_default_bgcolor = this.lyric_display.getBackground();
        this.dark_mode_toggle_button = new JToggleButton(new ButtonIcon(9));
        this.dark_mode_toggle_button.setMargin(this.zero_insets);
        this.dark_mode_toggle_button.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                ChordHelperApplet.this.innerSetDarkMode(ChordHelperApplet.this.dark_mode_toggle_button.isSelected());
            }
        });
        this.dark_mode_toggle_button.setToolTipText("Light / Dark - \u660e\u304b\u308a\u3092\u70b9\u706f\uff0f\u6d88\u706f");
        this.dark_mode_toggle_border = this.dark_mode_toggle_button.getBorder();
        this.dark_mode_toggle_button.setBorder(null);
        this.inversion_omission_button = new InversionAndOmissionLabel();
        this.ano_gakki_toggle_button = new JToggleButton(new ButtonIcon(6));
        this.ano_gakki_toggle_button.setOpaque(false);
        this.ano_gakki_toggle_button.setMargin(this.zero_insets);
        this.ano_gakki_toggle_button.setBorder(null);
        this.ano_gakki_toggle_button.setToolTipText("\u3042\u306e\u697d\u5668");
        this.ano_gakki_toggle_button.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                ChordHelperApplet.this.keyboard_panel.keyboard_center_panel.keyboard.ano_gakki_layered_pane = ChordHelperApplet.this.ano_gakki_toggle_button.isSelected() ? ChordHelperApplet.this.ano_gakki_layered_pane : null;
            }
        });
        this.chord_diagram = new ChordDiagram(this);
        this.tempo_selecter.setEditable(false);
        this.timesig_selecter.setEditable(false);
        this.keysig_label.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                ChordHelperApplet.this.chord_matrix.setKeySignature(ChordHelperApplet.this.keysig_label.getKey());
            }
        });
        this.device_manager.getSequencer().addMetaEventListener(this);
        this.device_manager.time_range_model.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                MidiSequenceModel midiSequenceModel = ChordHelperApplet.this.device_manager.time_range_model.getSequenceModel();
                SequenceListModel sequenceListModel = ChordHelperApplet.this.editor_dialog.seq_list_model;
                int n = sequenceListModel.getLoadedIndex();
                ChordHelperApplet.this.song_title_label.setText("<html>" + (n < 0 ? "[No MIDI file loaded]" : "MIDI file " + n + ": " + (midiSequenceModel == null || midiSequenceModel.toString() == null || midiSequenceModel.toString().isEmpty() ? "[Untitled]" : "<font color=maroon>" + midiSequenceModel + "</font>")) + "</html>");
                ChordHelperApplet.this.chord_matrix.setPlaying(ChordHelperApplet.this.device_manager.time_range_model.timer.isRunning());
                long l = ChordHelperApplet.this.device_manager.getSequencer().getTickPosition();
                SequenceIndex sequenceIndex = null;
                if (midiSequenceModel != null) {
                    sequenceIndex = midiSequenceModel.getSequenceIndex();
                    sequenceIndex.tickToMeasure(l);
                    ChordHelperApplet.this.chord_matrix.setBeat((byte)sequenceIndex.last_beat, sequenceIndex.timesig_upper);
                    if (ChordHelperApplet.this.device_manager.time_range_model.getValueIsAdjusting() || !ChordHelperApplet.this.device_manager.getSequencer().isRunning() && !ChordHelperApplet.this.device_manager.getSequencer().isRecording()) {
                        MetaMessage metaMessage = sequenceIndex.lastTimeSignatureAt(l);
                        if (metaMessage == null) {
                            ChordHelperApplet.this.timesig_selecter.clear();
                        } else {
                            ChordHelperApplet.this.meta(metaMessage);
                        }
                        metaMessage = sequenceIndex.lastTempoAt(l);
                        if (metaMessage == null) {
                            ChordHelperApplet.this.tempo_selecter.clear();
                        } else {
                            ChordHelperApplet.this.meta(metaMessage);
                        }
                        metaMessage = sequenceIndex.lastKeySignatureAt(l);
                        if (metaMessage == null) {
                            ChordHelperApplet.this.keysig_label.clear();
                        } else {
                            ChordHelperApplet.this.meta(metaMessage);
                        }
                    }
                }
            }
        });
        this.device_manager.time_range_model.fireStateChanged();
        this.chord_guide = new JPanel();
        this.chord_guide.setLayout(new BoxLayout(this.chord_guide, 0));
        this.chord_guide.add(Box.createHorizontalStrut(2));
        this.chord_guide.add(this.chord_matrix.chord_guide);
        this.chord_guide.add(Box.createHorizontalStrut(2));
        this.chord_guide.add(this.lyric_display);
        this.chord_guide.add(Box.createHorizontalStrut(2));
        this.chord_guide.add(this.enter_button_label);
        this.chord_guide.add(Box.createHorizontalStrut(5));
        this.chord_guide.add(this.chord_matrix.chord_display);
        this.chord_guide.add(Box.createHorizontalStrut(5));
        this.chord_guide.add(this.dark_mode_toggle_button);
        this.chord_guide.add(Box.createHorizontalStrut(5));
        this.chord_guide.add(this.ano_gakki_toggle_button);
        this.chord_guide.add(Box.createHorizontalStrut(5));
        this.chord_guide.add(this.inversion_omission_button);
        this.chord_guide.add(Box.createHorizontalStrut(5));
        this.chord_guide.add(this.chord_matrix.capo_selecter);
        this.chord_guide.add(Box.createHorizontalStrut(2));
        this.sequencer_upper_panel = new JPanel();
        this.sequencer_upper_panel.setLayout(new BoxLayout(this.sequencer_upper_panel, 0));
        this.sequencer_upper_panel.add(Box.createHorizontalStrut(12));
        this.sequencer_upper_panel.add(this.keysig_label);
        this.sequencer_upper_panel.add(Box.createHorizontalStrut(12));
        this.sequencer_upper_panel.add(this.timesig_selecter);
        this.sequencer_upper_panel.add(Box.createHorizontalStrut(12));
        this.sequencer_upper_panel.add(this.tempo_selecter);
        this.sequencer_upper_panel.add(Box.createHorizontalStrut(12));
        this.sequencer_upper_panel.add(new MeasureIndicator(this.device_manager.time_range_model));
        this.sequencer_upper_panel.add(Box.createHorizontalStrut(12));
        this.sequencer_upper_panel.add(this.song_title_label);
        this.sequencer_upper_panel.add(Box.createHorizontalStrut(12));
        this.sequencer_upper_panel.add(jButton2);
        this.sequencer_lower_panel = new JPanel();
        this.sequencer_lower_panel.setLayout(new BoxLayout(this.sequencer_lower_panel, 0));
        this.sequencer_lower_panel.add(Box.createHorizontalStrut(10));
        this.sequencer_lower_panel.add(new JSlider(this.device_manager.time_range_model));
        this.sequencer_lower_panel.add(new TimeIndicator(this.device_manager.time_range_model));
        this.sequencer_lower_panel.add(Box.createHorizontalStrut(5));
        JButton jButton4 = new JButton(this.editor_dialog.move_to_top_action);
        this.sequencer_lower_panel.add(jButton4);
        JButton jButton5 = new JButton(this.device_manager.time_range_model.move_backward_action);
        this.sequencer_lower_panel.add(jButton5);
        this.sequencer_lower_panel.add(new JToggleButton(this.device_manager.time_range_model.start_stop_action));
        JButton jButton6 = new JButton(this.device_manager.time_range_model.move_forward_action);
        this.sequencer_lower_panel.add(jButton6);
        JButton jButton7 = new JButton(this.editor_dialog.move_to_bottom_action);
        this.sequencer_lower_panel.add(jButton7);
        JToggleButton jToggleButton = new JToggleButton(this.device_manager.time_range_model.toggle_repeat_action);
        this.sequencer_lower_panel.add(jToggleButton);
        this.sequencer_lower_panel.add(Box.createHorizontalStrut(10));
        jButton4.setMargin(this.zero_insets);
        jButton7.setMargin(this.zero_insets);
        jButton5.setMargin(this.zero_insets);
        jButton6.setMargin(this.zero_insets);
        jToggleButton.setMargin(this.zero_insets);
        this.midi_io_panel = new JPanel();
        this.midi_io_panel.add(jButton3);
        this.midi_io_panel.add(jButton);
        this.sequencer_panel = new JPanel();
        this.sequencer_panel.setLayout(new BoxLayout(this.sequencer_panel, 1));
        this.sequencer_panel.add(this.sequencer_upper_panel);
        this.sequencer_panel.add(this.sequencer_lower_panel);
        this.sequencer_panel.add(this.midi_io_panel);
        this.keyboard_split_pane = new JSplitPane(1, this.keyboard_panel, this.chord_diagram);
        this.keyboard_split_pane.setOneTouchExpandable(true);
        this.keyboard_split_pane.setResizeWeight(1.0);
        this.keyboard_split_pane.setAlignmentX(0.5f);
        this.keyboard_sequencer_panel = new JPanel();
        this.keyboard_sequencer_panel.setLayout(new BoxLayout(this.keyboard_sequencer_panel, 1));
        this.keyboard_sequencer_panel.add(this.chord_guide);
        this.keyboard_sequencer_panel.add(Box.createVerticalStrut(5));
        this.keyboard_sequencer_panel.add(this.keyboard_split_pane);
        this.keyboard_sequencer_panel.add(Box.createVerticalStrut(5));
        this.keyboard_sequencer_panel.add(this.sequencer_panel);
        this.main_split_pane = new JSplitPane(0, this.chord_matrix, this.keyboard_sequencer_panel);
        this.main_split_pane.setResizeWeight(0.5);
        this.main_split_pane.setAlignmentX(0.5f);
        this.main_split_pane.setDividerSize(5);
        this.ano_gakki_layered_pane = new AnoGakkiLayeredPane();
        this.ano_gakki_layered_pane.add(this.main_split_pane);
        this.setContentPane(this.ano_gakki_layered_pane);
        this.setPreferredSize(new Dimension(750, 470));
    }

    @Override
    public void start() {
        this.chord_matrix.fireKeySignatureChanged();
        String string = this.getParameter("midi_file");
        System.gc();
        if (string != null) {
            this.addToPlaylist(string);
            this.play();
        }
    }

    @Override
    public void stop() {
        this.device_manager.time_range_model.stop();
        System.gc();
    }

    @Override
    public void meta(MetaMessage metaMessage) {
        int n = metaMessage.getType();
        switch (n) {
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                this.lyric_display.addLyric(metaMessage.getData());
                break;
            }
            case 81: {
                this.tempo_selecter.setTempo(metaMessage.getData());
                break;
            }
            case 88: {
                this.timesig_selecter.setValue(metaMessage.getData());
                break;
            }
            case 89: {
                this.keysig_label.setKeySignature(new Music.Key(metaMessage.getData()));
                this.chord_matrix.setKeySignature(new Music.Key(metaMessage.getData()));
            }
        }
    }

    private void innerSetDarkMode(boolean bl) {
        Color color = bl ? Color.black : null;
        Color color2 = bl ? Color.pink : null;
        this.getContentPane().setBackground(bl ? Color.black : this.root_pane_default_bgcolor);
        this.main_split_pane.setBackground(color);
        this.keyboard_split_pane.setBackground(color);
        this.enter_button_label.setDarkMode(bl);
        this.chord_guide.setBackground(color);
        this.lyric_display.setBorder(bl ? null : this.lyric_display_default_border);
        this.lyric_display.setBackground(bl ? this.chord_matrix.dark_mode_colorset.backgrounds[2] : this.lyric_display_default_bgcolor);
        this.lyric_display.setForeground(bl ? Color.white : null);
        this.inversion_omission_button.setBackground(color);
        this.ano_gakki_toggle_button.setBackground(color);
        this.keyboard_sequencer_panel.setBackground(color);
        this.chord_diagram.setBackground(color);
        this.chord_diagram.title_label.setDarkMode(bl);
        this.chord_matrix.setDarkMode(bl);
        this.keyboard_panel.setDarkMode(bl);
    }

    public void chordOn() {
        Object object;
        Music.Chord chord = this.chord_matrix.getSelectedChord();
        if (!(this.chord_on_notes == null || this.chord_matrix.getNoteIndex() >= 0 || this.chord_matrix.isDragged() && chord != null)) {
            object = this.chord_on_notes;
            int n = ((int[])object).length;
            for (int i = 0; i < n; ++i) {
                int n2 = object[i];
                this.keyboard_panel.keyboard_center_panel.keyboard.noteOff(n2);
            }
            this.chord_on_notes = null;
        }
        if (chord == null) {
            if (this.lyric_display != null) {
                this.lyric_display.current_chord = null;
            }
            return;
        }
        if (this.keyboard_panel.keyboard_center_panel.keyboard.ano_gakki_layered_pane != null && (object = (Object)this.chord_matrix.getSelectedButton()) != null) {
            this.ano_gakki_layered_pane.start((Component)this.chord_matrix, (Component)object);
        }
        object = this.chord_matrix.getKeySignatureCapo();
        Music.Chord chord2 = chord.clone().transpose(this.chord_matrix.capo_selecter.getCapo(), this.chord_matrix.getKeySignature());
        this.keyboard_panel.keyboard_center_panel.keyboard.setChord(chord2);
        Music.Range range = new Music.Range(this.keyboard_panel.keyboard_center_panel.keyboard.getChromaticOffset() + 10 + this.keyboard_panel.keyboard_center_panel.keyboard.getOctaves() / 4 * 12, this.inversion_omission_button.isAutoInversionMode() ? this.keyboard_panel.keyboard_center_panel.keyboard.getChromaticOffset() + 21 : this.keyboard_panel.keyboard_center_panel.keyboard.getChromaticOffset() + 33, -2, this.inversion_omission_button.isAutoInversionMode());
        int[] nArray = chord2.toNoteArray(range, (Music.Key)object);
        int[] nArray2 = null;
        if (this.chord_matrix.isDragged() || this.chord_matrix.getNoteIndex() >= 0) {
            nArray2 = Arrays.copyOf(this.chord_on_notes, this.chord_on_notes.length);
        }
        this.chord_on_notes = new int[nArray.length];
        int n = 0;
        for (int n3 : nArray) {
            if (this.inversion_omission_button.getOmissionNoteIndex() == n) {
                ++n;
                continue;
            }
            this.chord_on_notes[n++] = n3;
            boolean bl = false;
            if (nArray2 != null) {
                for (int n4 : nArray2) {
                    if (n3 != n4) continue;
                    bl = true;
                    break;
                }
            }
            if (bl && this.chord_matrix.getNoteIndex() >= 0 && nArray[this.chord_matrix.getNoteIndex()] - n3 == 0) {
                this.keyboard_panel.keyboard_center_panel.keyboard.noteOff(n3);
                bl = false;
            }
            if (bl) continue;
            this.keyboard_panel.keyboard_center_panel.keyboard.noteOn(n3);
        }
        this.keyboard_panel.keyboard_center_panel.keyboard.setChord(chord2);
        this.chord_matrix.chord_display.setChord(chord);
        Object object2 = this.chord_diagram.getCapo() == this.chord_matrix.capo_selecter.getCapo() ? (Object)chord.clone() : (Object)chord2.clone().transpose(-this.chord_diagram.getCapo(), (Music.Key)object);
        this.chord_diagram.setChord((Music.Chord)object2);
        if (this.chord_diagram.record_text_button.isSelected()) {
            this.lyric_display.appendChord((Music.Chord)object2);
        }
    }

    class AboutMessagePane
    extends JEditorPane {
        URI uri;

        public AboutMessagePane() {
            this(true);
        }

        public AboutMessagePane(boolean bl) {
            String string;
            super("text/html", "");
            this.uri = null;
            String string2 = null;
            if (bl && Desktop.isDesktopSupported()) {
                string2 = "Click this URL to open with your web browser - URL\u3092\u30af\u30ea\u30c3\u30af\u3057\u3066Web\u30d6\u30e9\u30a6\u30b6\u3067\u958b\u304f";
                string = "<a href=\"http://www.yk.rim.or.jp/~kamide/music/chordhelper/\" title=\"" + string2 + "\">" + "http://www.yk.rim.or.jp/~kamide/music/chordhelper/" + "</a>";
            } else {
                bl = false;
                string = "http://www.yk.rim.or.jp/~kamide/music/chordhelper/";
            }
            this.setText("<html><center><font size=\"+1\">MIDI Chord Helper</font>  Ver.20091003.1<br/><br/>Copyright (C) 2004-2009 \uff20\u304d\u3088\u3057 - Akiyoshi Kamide<br/>" + string + "</center></html>");
            this.setToolTipText(string2);
            this.setOpaque(false);
            this.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
            this.setEditable(false);
            if (!bl) {
                return;
            }
            try {
                this.uri = new URI("http://www.yk.rim.or.jp/~kamide/music/chordhelper/");
            }
            catch (URISyntaxException uRISyntaxException) {
                uRISyntaxException.printStackTrace();
                return;
            }
            this.addHyperlinkListener(new HyperlinkListener(){

                @Override
                public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
                    if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                        try {
                            Desktop.getDesktop().browse(AboutMessagePane.this.uri);
                        }
                        catch (IOException iOException) {
                            iOException.printStackTrace();
                        }
                    }
                }
            });
        }

        public void showMessage() {
            JOptionPane.showMessageDialog(null, this, "Version info", 1, ChordHelperApplet.this.image_icon);
        }
    }

    public static class VersionInfo {
        public static final String NAME = "MIDI Chord Helper";
        public static final String VERSION = "Ver.20091003.1";
        public static final String COPYRIGHT = "Copyright (C) 2004-2009";
        public static final String AUTHER = "\uff20\u304d\u3088\u3057 - Akiyoshi Kamide";
        public static final String URL = "http://www.yk.rim.or.jp/~kamide/music/chordhelper/";

        public static String getInfo() {
            return "MIDI Chord Helper Ver.20091003.1 Copyright (C) 2004-2009 \uff20\u304d\u3088\u3057 - Akiyoshi Kamide http://www.yk.rim.or.jp/~kamide/music/chordhelper/";
        }
    }
}

