/*
 * Decompiled with CFR 0.152.
 */
import java.awt.FlowLayout;
import java.util.ArrayList;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

class HexSelecter
extends JPanel {
    private JComboBox combo_box;
    private JLabel title;

    public HexSelecter(String string) {
        if (string != null) {
            this.title = new JLabel(string);
            this.add(this.title);
        }
        this.combo_box = new JComboBox();
        this.add(this.combo_box);
        this.setLayout(new FlowLayout());
        this.combo_box.setEditable(true);
        this.combo_box.setMaximumRowCount(16);
    }

    public JComboBox getComboBox() {
        return this.combo_box;
    }

    public void setTitle(String string) {
        this.title.setText(string);
    }

    public String getString() {
        return (String)this.combo_box.getSelectedItem();
    }

    public int getValue() {
        ArrayList<Integer> arrayList = this.getIntegerList();
        return arrayList.size() == 0 ? -1 : arrayList.get(0);
    }

    public ArrayList<Integer> getIntegerList() {
        String string = this.getString();
        String[] stringArray = string == null ? new String[]{} : string.replaceAll(":.*$", "").trim().split(" +");
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (String string2 : stringArray) {
            int n;
            if (string2.length() == 0) continue;
            try {
                n = Integer.decode(string2);
            }
            catch (NumberFormatException numberFormatException) {
                JOptionPane.showMessageDialog(this, string2 + " : is not a number", "MIDI Chord Helper", 0);
                return null;
            }
            arrayList.add(n);
        }
        return arrayList;
    }

    public byte[] getBytes() {
        ArrayList<Integer> arrayList = this.getIntegerList();
        byte[] byArray = new byte[arrayList.size()];
        int n = 0;
        for (Integer n2 : arrayList) {
            byArray[n++] = (byte)(n2 & 0xFF);
        }
        return byArray;
    }

    public void setValue(int n) {
        this.setValue((byte)(n & 0xFF));
    }

    public void setValue(byte by) {
        int n = this.combo_box.getItemCount();
        for (int i = 0; i < n; ++i) {
            String string = (String)this.combo_box.getItemAt(i);
            if (Integer.decode(string.trim().split(" +")[0]).byteValue() != by) continue;
            this.combo_box.setSelectedIndex(i);
            return;
        }
        this.combo_box.setSelectedItem(String.format(" 0x%02X", by));
    }

    public void setValue(byte[] byArray) {
        String string = "";
        for (byte by : byArray) {
            string = string + String.format(" 0x%02X", by);
        }
        this.combo_box.setSelectedItem(string);
    }

    public void clear() {
        this.combo_box.setSelectedItem("");
    }
}

