/*
 * Decompiled with CFR 0.152.
 */
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MetaMessage;
import javax.sound.midi.MidiEvent;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.Sequence;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.Track;

public class MIDISpec {
    public static final int MAX_CHANNELS = 16;
    public static final int PITCH_BEND_NONE = 8192;
    public static final int MICROSECOND_PER_MINUTE = 60000000;
    private static final String[] meta_message_type_names = new String[]{"Seq Number", "Text", "Copyright", "Seq/Track Name", "Instrument Name", "Lyric", "Marker", "Cue Point", "Program Name", "Device Name", null, null, null, null, null, null};
    private static final String[] ch_msg_status_names = new String[]{"NoteOFF", "NoteON", "Polyphonic Key Pressure", "Ctrl/Mode", "Program", "Ch.Pressure", "Pitch Bend"};
    private static final String[] sys_msg_names = new String[]{"SysEx", "MIDI Time Code Quarter Frame", "Song Position Pointer", "Song Select", null, null, "Tune Request", "Special SysEx", "Timing Clock", null, "Start", "Continue", "Stop", null, "Active Sensing", "Meta / Sys.Reset"};
    private static final String[] controller_names_0 = new String[]{"Bank Select", "Modulation Depth", "Breath Controller", null, "Foot Controller", "Portamento Time", "Data Entry", "Volume", "Balance", null, "Pan", "Expression", "Effect Control 1", "Effect Control 2", null, null, "General Purpose 1", "General Purpose 2", "General Purpose 3", "General Purpose 4", null, null, null, null, null, null, null, null, null, null, null, null};
    private static final String[] controller_momentary_switch_names = new String[]{"Damper Pedal (Sustain)", "Portamento", "Sustenuto", "Soft Pedal", "Legato Footswitch", "Hold 2", "Sound Controller 1 (Sound Variation)", "Sound Controller 2 (Timbre/Harmonic Intens)", "Sound Controller 3 (Release Time)", "Sound Controller 4 (Attack Time)", "Sound Controller 5 (Brightness)", "Sound Controller 6 (Decay Time)", "Sound Controller 7 (Vibrato Rate)", "Sound Controller 8 (Vibrato Depth)", "Sound Controller 9 (Vibrato Delay)", "Sound Controller 10 (Undefined)", "General Purpose 5", "General Purpose 6 (Temp Change)", "General Purpose 7", "General Purpose 8", "Portamento Control", null, null, null, null, null, null, "Reverb (Ext.Effects Depth)", "Tremelo Depth", "Chorus Depth", "Celeste (Detune) Depth", "Phaser Depth", "Data Increment", "Data Decrement", "NRPN (LSB)", "NRPN (MSB)", "RPN (LSB)", "RPN (MSB)", null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null};
    private static final String[] controller_mode_message_names = new String[]{"All Sound OFF", "Reset All Controllers", "Local Control", "All Notes OFF", "Omni Mode OFF", "Omni Mode ON", "Mono Mode ON", "Poly Mode ON"};
    public static final int MAX_NOTE_NO = 127;
    public static final String[] instrument_family_names = new String[]{"Piano", "Chrom.Percussion", "Organ", "Guitar", "Bass", "Strings", "Ensemble", "Brass", "Reed", "Pipe", "Synth Lead", "Synth Pad", "Synth Effects", "Ethnic", "Percussive", "Sound Effects"};
    public static final String[] instrument_names = new String[]{"Acoustic Grand Piano", "Bright Acoustic Piano", "Electric Grand Piano", "Honky-tonk Piano", "Electric Piano 1", "Electric Piano 2", "Harpsichord", "Clavi", "Celesta", "Glockenspiel", "Music Box", "Vibraphone", "Marimba", "Xylophone", "Tubular Bells", "Dulcimer", "Drawbar Organ", "Percussive Organ", "Rock Organ", "Church Organ", "Reed Organ", "Accordion", "Harmonica", "Tango Accordion", "Acoustic Guitar (nylon)", "Acoustic Guitar (steel)", "Electric Guitar (jazz)", "Electric Guitar (clean)", "Electric Guitar (muted)", "Overdriven Guitar", "Distortion Guitar", "Guitar harmonics", "Acoustic Bass", "Electric Bass (finger)", "Electric Bass (pick)", "Fretless Bass", "Slap Bass 1", "Slap Bass 2", "Synth Bass 1", "Synth Bass 2", "Violin", "Viola", "Cello", "Contrabass", "Tremolo Strings", "Pizzicato Strings", "Orchestral Harp", "Timpani", "String Ensemble 1", "String Ensemble 2", "SynthStrings 1", "SynthStrings 2", "Choir Aahs", "Voice Oohs", "Synth Voice", "Orchestra Hit", "Trumpet", "Trombone", "Tuba", "Muted Trumpet", "French Horn", "Brass Section", "SynthBrass 1", "SynthBrass 2", "Soprano Sax", "Alto Sax", "Tenor Sax", "Baritone Sax", "Oboe", "English Horn", "Bassoon", "Clarinet", "Piccolo", "Flute", "Recorder", "Pan Flute", "Blown Bottle", "Shakuhachi", "Whistle", "Ocarina", "Lead 1 (square)", "Lead 2 (sawtooth)", "Lead 3 (calliope)", "Lead 4 (chiff)", "Lead 5 (charang)", "Lead 6 (voice)", "Lead 7 (fifths)", "Lead 8 (bass + lead)", "Pad 1 (new age)", "Pad 2 (warm)", "Pad 3 (polysynth)", "Pad 4 (choir)", "Pad 5 (bowed)", "Pad 6 (metallic)", "Pad 7 (halo)", "Pad 8 (sweep)", "FX 1 (rain)", "FX 2 (soundtrack)", "FX 3 (crystal)", "FX 4 (atmosphere)", "FX 5 (brightness)", "FX 6 (goblins)", "FX 7 (echoes)", "FX 8 (sci-fi)", "Sitar", "Banjo", "Shamisen", "Koto", "Kalimba", "Bag pipe", "Fiddle", "Shanai", "Tinkle Bell", "Agogo", "Steel Drums", "Woodblock", "Taiko Drum", "Melodic Tom", "Synth Drum", "Reverse Cymbal", "Guitar Fret Noise", "Breath Noise", "Seashore", "Bird Tweet", "Telephone Ring", "Helicopter", "Applause", "Gunshot"};
    public static final int MIN_PERCUSSION_NO = 35;
    public static final String[] percussion_names = new String[]{"Acoustic Bass Drum", "Bass Drum 1", "Side Stick", "Acoustic Snare", "Hand Clap", "Electric Snare", "Low Floor Tom", "Closed Hi Hat", "High Floor Tom", "Pedal Hi-Hat", "Low Tom", "Open Hi-Hat", "Low-Mid Tom", "Hi Mid Tom", "Crash Cymbal 1", "High Tom", "Ride Cymbal 1", "Chinese Cymbal", "Ride Bell", "Tambourine", "Splash Cymbal", "Cowbell", "Crash Cymbal 2", "Vibraslap", "Ride Cymbal 2", "Hi Bongo", "Low Bongo", "Mute Hi Conga", "Open Hi Conga", "Low Conga", "High Timbale", "Low Timbale", "High Agogo", "Low Agogo", "Cabasa", "Maracas", "Short Whistle", "Long Whistle", "Short Guiro", "Long Guiro", "Claves", "Hi Wood Block", "Low Wood Block", "Mute Cuica", "Open Cuica", "Mute Triangle", "Open Triangle"};

    public static String getMetaName(int n) {
        if (n < 16) {
            return meta_message_type_names[n];
        }
        switch (n) {
            case 32: {
                return "MIDI Ch.Prefix";
            }
            case 33: {
                return "MIDI Output Port";
            }
            case 47: {
                return "End Of Track";
            }
            case 81: {
                return "Tempo";
            }
            case 84: {
                return "SMPTE Offset";
            }
            case 88: {
                return "Time Signature";
            }
            case 89: {
                return "Key Signature";
            }
            case 127: {
                return "Sequencer Specific";
            }
        }
        return null;
    }

    public static boolean hasMetaText(int n) {
        return n > 0 && n < 10;
    }

    public static boolean isEOT(int n) {
        return n == 47;
    }

    public static boolean isEOT(MidiMessage midiMessage) {
        return midiMessage instanceof MetaMessage ? MIDISpec.isEOT(((MetaMessage)midiMessage).getType()) : false;
    }

    public static boolean isEOT(MidiEvent midiEvent) {
        return MIDISpec.isEOT(midiEvent.getMessage());
    }

    public static int byteArrayToQpmTempo(byte[] byArray) {
        int n = (byArray[0] & 0xFF) << 16 | (byArray[1] & 0xFF) << 8 | byArray[2] & 0xFF;
        return 60000000 / n;
    }

    public static byte[] qpmTempoToByteArray(int n) {
        int n2 = 60000000 / n;
        byte[] byArray = new byte[]{(byte)(n2 >> 16 & 0xFF), (byte)(n2 >> 8 & 0xFF), (byte)(n2 & 0xFF)};
        return byArray;
    }

    public static String getNameOf(Track track) {
        MidiEvent midiEvent;
        for (int i = 0; i < track.size() && (midiEvent = track.get(i)).getTick() <= 0L; ++i) {
            MetaMessage metaMessage;
            MidiMessage midiMessage = midiEvent.getMessage();
            if (!(midiMessage instanceof MetaMessage) || (metaMessage = (MetaMessage)midiMessage).getType() != 3) continue;
            return new String(metaMessage.getData());
        }
        return null;
    }

    public static boolean setNameOf(Track track, String string) {
        MidiEvent midiEvent = null;
        MidiMessage midiMessage = null;
        MetaMessage metaMessage = null;
        for (int i = 0; !(i >= track.size() || (midiEvent = track.get(i)).getTick() > 0L || (midiMessage = midiEvent.getMessage()) instanceof MetaMessage && (metaMessage = (MetaMessage)midiMessage).getType() == 3); ++i) {
            metaMessage = null;
        }
        if (metaMessage == null) {
            if (string.isEmpty()) {
                return false;
            }
            metaMessage = new MetaMessage();
            track.add(new MidiEvent(metaMessage, 0L));
        }
        byte[] byArray = string.getBytes();
        try {
            metaMessage.setMessage(3, byArray, byArray.length);
        }
        catch (InvalidMidiDataException invalidMidiDataException) {
            invalidMidiDataException.printStackTrace();
            return false;
        }
        return true;
    }

    public static String getNameOf(Sequence sequence) {
        Track[] trackArray;
        for (Track track : trackArray = sequence.getTracks()) {
            String string = MIDISpec.getNameOf(track);
            if (string == null) continue;
            return string;
        }
        return null;
    }

    public static boolean setNameOf(Sequence sequence, String string) {
        Track[] trackArray;
        for (Track track : trackArray = sequence.getTracks()) {
            if (!MIDISpec.setNameOf(track, string)) continue;
            return true;
        }
        return false;
    }

    public static String getStatusName(int n) {
        if (n < 128) {
            return null;
        }
        if (n < 240) {
            return ch_msg_status_names[(n >> 4) - 8];
        }
        if (n <= 255) {
            return sys_msg_names[n - 240];
        }
        return null;
    }

    public static boolean isChannelMessage(ShortMessage shortMessage) {
        return MIDISpec.isChannelMessage(shortMessage.getStatus());
    }

    public static boolean isChannelMessage(int n) {
        return n < 240 && n >= 128;
    }

    public static String getControllerName(int n) {
        if (n < 0) {
            return null;
        }
        if (n < 32) {
            String string = controller_names_0[n];
            if (string != null) {
                string = string + " (MSB)";
            }
            return string;
        }
        if (n < 64) {
            String string = controller_names_0[n - 32];
            if (string != null) {
                string = string + " (LSB)";
            }
            return string;
        }
        if (n < 120) {
            return controller_momentary_switch_names[n - 64];
        }
        if (n < 128) {
            return controller_mode_message_names[n - 120];
        }
        return null;
    }

    public static String getSysExManufacturerName(int n) {
        switch (n) {
            case 64: {
                return "KAWAI";
            }
            case 65: {
                return "Roland";
            }
            case 66: {
                return "KORG";
            }
            case 67: {
                return "YAMAHA";
            }
            case 68: {
                return "CASIO";
            }
            case 125: {
                return "Non-Commercial";
            }
            case 126: {
                return "Universal: Non-RealTime";
            }
            case 127: {
                return "Universal: RealTime";
            }
        }
        return null;
    }

    public static String getPercussionName(int n) {
        int n2 = n - 35;
        return n2 >= 0 && n2 < percussion_names.length ? percussion_names[n2] : "(Unknown)";
    }
}

