/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.Hashtable;
import java.util.List;
import javax.sound.midi.Receiver;
import javax.sound.midi.Transmitter;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JLayeredPane;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

class MidiCablePane
extends JComponent
implements ListDataListener,
ComponentListener,
InternalFrameListener {
    protected Stroke cable_stroke = new BasicStroke(3.0f, 1, 1);
    protected Color[] cable_colors = new Color[]{new Color(255, 0, 0, 191), new Color(0, 255, 0, 191), new Color(0, 0, 255, 191), new Color(191, 191, 0, 191), new Color(0, 191, 191, 191), new Color(191, 0, 191, 191)};
    protected int next_color_index = 0;
    protected Hashtable<Receiver, Color> color_map = new Hashtable();

    protected void removeReceiverOf(MidiDeviceFrame midiDeviceFrame) {
        MidiConnecterListModel midiConnecterListModel = midiDeviceFrame.list.getModel();
        if (!midiConnecterListModel.hasRx()) {
            return;
        }
        this.color_map.remove(midiConnecterListModel.device.getReceivers().get(0));
    }

    public MidiCablePane() {
        this.setOpaque(false);
        this.setVisible(true);
    }

    @Override
    public void internalFrameActivated(InternalFrameEvent internalFrameEvent) {
    }

    @Override
    public void internalFrameClosed(InternalFrameEvent internalFrameEvent) {
        this.repaint();
    }

    @Override
    public void internalFrameClosing(InternalFrameEvent internalFrameEvent) {
        JInternalFrame jInternalFrame = internalFrameEvent.getInternalFrame();
        if (!(jInternalFrame instanceof MidiDeviceFrame)) {
            return;
        }
        this.removeReceiverOf((MidiDeviceFrame)jInternalFrame);
        this.repaint();
    }

    @Override
    public void internalFrameDeactivated(InternalFrameEvent internalFrameEvent) {
        this.repaint();
    }

    @Override
    public void internalFrameDeiconified(InternalFrameEvent internalFrameEvent) {
    }

    @Override
    public void internalFrameIconified(InternalFrameEvent internalFrameEvent) {
    }

    @Override
    public void internalFrameOpened(InternalFrameEvent internalFrameEvent) {
    }

    @Override
    public void componentHidden(ComponentEvent componentEvent) {
    }

    @Override
    public void componentMoved(ComponentEvent componentEvent) {
        this.repaint();
    }

    @Override
    public void componentResized(ComponentEvent componentEvent) {
        this.repaint();
    }

    @Override
    public void componentShown(ComponentEvent componentEvent) {
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
        this.repaint();
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        this.repaint();
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        this.repaint();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void paint(Graphics graphics) {
        JInternalFrame[] jInternalFrameArray;
        super.paint(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setStroke(this.cable_stroke);
        for (JInternalFrame jInternalFrame : jInternalFrameArray = this.getFrames()) {
            if (!(jInternalFrame instanceof MidiDeviceFrame)) continue;
            MidiDeviceFrame midiDeviceFrame = (MidiDeviceFrame)jInternalFrame;
            MidiConnecterListModel midiConnecterListModel = midiDeviceFrame.list.getModel();
            List<Transmitter> list = midiConnecterListModel.device.getTransmitters();
            for (Transmitter transmitter : list) {
                void var16_20;
                Rectangle rectangle;
                Receiver receiver = transmitter.getReceiver();
                if (receiver == null || (rectangle = midiDeviceFrame.getListCellBounds(midiConnecterListModel.indexOf(transmitter))) == null) continue;
                rectangle.translate(midiDeviceFrame.getX(), midiDeviceFrame.getY());
                Rectangle rectangle2 = null;
                for (JInternalFrame jInternalFrame2 : jInternalFrameArray) {
                    MidiConnecterListModel midiConnecterListModel2;
                    MidiDeviceFrame midiDeviceFrame2;
                    if (!(jInternalFrame2 instanceof MidiDeviceFrame) || (rectangle2 = (midiDeviceFrame2 = (MidiDeviceFrame)jInternalFrame2).getListCellBounds((midiConnecterListModel2 = midiDeviceFrame2.list.getModel()).indexOf(receiver))) == null) continue;
                    rectangle2.translate(midiDeviceFrame2.getX(), midiDeviceFrame2.getY());
                    break;
                }
                if (rectangle2 == null) continue;
                Color color = this.color_map.get(receiver);
                if (color == null) {
                    Color color2 = this.cable_colors[this.next_color_index];
                    this.color_map.put(receiver, color2);
                    if (++this.next_color_index >= this.cable_colors.length) {
                        this.next_color_index = 0;
                    }
                }
                graphics2D.setColor((Color)var16_20);
                graphics2D.fillOval(rectangle.x, rectangle.y, rectangle.height - 1, rectangle.height - 1);
                int n = rectangle.x + rectangle.height / 2;
                int n2 = rectangle.y + rectangle.height / 2;
                int n3 = rectangle2.x + rectangle2.height / 2;
                int n4 = rectangle2.y + rectangle2.height / 2;
                graphics2D.drawLine(n, n2, n3, n4);
                int n5 = 15;
                double d = 0.5235987755982988;
                double d2 = Math.atan2(n4 - n2, n3 - n);
                graphics2D.drawLine(n3, n4, n3 - (int)((double)n5 * Math.cos(d2 - d)), n4 - (int)((double)n5 * Math.sin(d2 - d)));
                graphics2D.drawLine(n3, n4, n3 - (int)((double)n5 * Math.cos(d2 + d)), n4 - (int)((double)n5 * Math.sin(d2 + d)));
            }
        }
    }

    protected JInternalFrame[] getFrames() {
        Container container = this.getParent();
        if (!(container instanceof MidiDesktopPane)) {
            return new JInternalFrame[0];
        }
        return ((MidiDesktopPane)container).getAllFramesInLayer(JLayeredPane.DEFAULT_LAYER);
    }
}

